/*

 Ŀ
                                                                        
  File Name...: FIDODATE.PRG                                            
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 07-31-94           
  Time created: 09:28:17pm            Time updated: 00:40:52am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"




// convert a date to the "FidoNet Standard" ie: "Tue 19 Jun 90 07:28"
/* HYPERTEXT START
!short: basFidoDate()   Convert a date and time to the "FidoNet" standard
basFidoDate()   Convert a date and time to the "FidoNet" standard

^BDescription: ^B

   basFidoDate() will convert a date and time value to the "FidoNet"
   standard character date.  ie: "Tue 19 Jun 90 07:28"


^BSyntax:^B

   cFidoDate := basFidoDate( dDate, cTime )


^BPass:^B

   ^BdDate^B is a date expression that should contain the date you want
   converted.

   ^BcTime^B is a character expression that should contain the time() value
   of the time you want converted.  ie: hh:mm:ss format


^BReturns:^B

   ^BcFidoDate^B is a character expression that will contain the converted
   date and time.


^BSource:^B

   FIDODATE.PRG



HYPERTEXT END */
function basFidoDate( pdDate, pcTime )

   local cFidoDate := ""
   local nHour     := 0
   local nMin      := 0

   assume pdDate is date() if missing
   assume pcTime is time() if missing

   cFidoDate := left( cdow( pdDate ), 3 ) + " " + ;
      strzero( day( pdDate ), 2 ) + " " + ;
      left( cmonth( pdDate ), 3 ) + " " + ;
      right( str( year( pdDate )),2) + " "

   nhour := val(left(pcTime,2))

   nMin  := val(substr(pcTime,4,2))

   cFidoDate += strzero(nhour,2) + ":" + strzero(nMin,2)

   return cFidoDate

