/*

 Ŀ
                                                                        
  File Name...: COLOR.PRG                                               
  Author......: Vernon E. Six, Jr.                                      
  Date created: 09-20-94              Date updated: 09-20-94           
  Time created: 05:53:42pm            Time updated: 05:53:42pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

static saColors := { ;
   { "RG+/B",  "N/BG",  "N/W", "W+/B"   }, ; // normal
   { "B/BG",   "W+/RB", "N/W", "W+/BG"  }, ; // help
   { "W+/R",   "N/W",   "N/W", "W+/R"   }, ; // serious info
   { "BG+/RB", "N/W",   "N/W", "W+/RB"  }, ; // misc msgs
   { "B/W",    "W+/B",  "W/B", "W+/W"   }, ; // pick lists
   { "W+/RB",  "W+/BG", "N/W", "W+/RB"  }, ; // sub-pick lists
   { "RG+/RG", "N/BG",  "N/W", "W+/RG"  }  } // input panels

static snPalette := 1
static slMono    := .f.

/* HYPERTEXT START
!short: basPalette()    Get/Set current color palette
basPalette()    Get/Set current color palette

^BDescription: ^B

   basPalette() allows you Get/Set the current color palette.


^BSyntax:^B

   nCurrent := basPalette( [nNew] )


^BPass:^B

   ^BnNew^B is an optional numeric expression that should contain the desired
   color palette number.  This value must be within the range of one to seven.


^BReturns:^B

   ^BnCurrent^B is the current color palette number.


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basPalette( pnPalette )

   local nCurrent := snPalette

   if pcount() > 0
      snPalette := pnPalette
   endif

   return nCurrent




/* HYPERTEXT START
!short: basSetColor()   Set new colors (replacement for SetColor())
basPalette()    Set new colors (replacement for SetColor())

^BDescription: ^B

   basSetColor() is a replacement for Clipper's SetColor() function.


^BSyntax:^B

   cCurrent := basSetColor( [nPalette] )


^BPass:^B

   ^BnPalette^B is an optional numeric expression that should contain the
   desired color palette number.  This value must be within the range of one
   to seven.  The current color palette is assumed if you do not pass
   ^BnPalette^B.


^BReturns:^B

   ^BcCurrent^B is a character expression that will contain the current color
   settings as a string (identical to Clipper's SetColor() function).


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basSetColor( pnPalette )

   local cColor := ""

   assume pnPalette is snPalette if missing

   snPalette := pnPalette

   cColor := basStdColor(pnPalette) + [,]   + ;
      basEnhColor(pnPalette) + [,,,] + ;
      basUnsColor(pnPalette)

   return SetColor(cColor)



/* HYPERTEXT START
!short: basStdColor()   Returns the "standard" color as a character string
basStdColor()   Returns the "standard" color as a character string

^BDescription: ^B

   basStdColor() allows you to retrieve the "standard" color as a character
   string.


^BSyntax:^B

   cColor := basStdColor( [nPalette] )


^BPass:^B

   ^BnPalette^B is an optional numeric expression that should contain the
   desired color palette number.  This value must be within the range of one
   to seven.  The current color palette is assumed if you do not pass
   ^BnPalette^B.


^BReturns:^B

   ^BcColor^B is a character expression that will contain the current "standard"
   color setting as a string.


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basStdColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "W+/N", saColors[pnPalette,1] )


/* HYPERTEXT START
!short: basEnhColor()   Returns the "enhanced" color as a character string
basEnhColor()   Returns the "enhanced" color as a character string

^BDescription: ^B

   basEnhColor() allows you to retrieve the "enhanced" color as a character
   string.


^BSyntax:^B

   cColor := basEnhColor( [nPalette] )


^BPass:^B

   ^BnPalette^B is an optional numeric expression that should contain the
   desired color palette number.  This value must be within the range of one
   to seven.  The current color palette is assumed if you do not pass
   ^BnPalette^B.


^BReturns:^B

   ^BcColor^B is a character expression that will contain the current "enhanced"
   color setting as a string.


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basEnhColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "N/W", saColors[pnPalette,2] )




/* HYPERTEXT START
!short: basUnsColor()   Returns the "unselected" color as a character string
basUnsColor()   Returns the "unselected" color as a character string

^BDescription: ^B

   basUnsColor() allows you to retrieve the "unselected" color as a character
   string.


^BSyntax:^B

   cColor := basUnsColor( [nPalette] )


^BPass:^B

   ^BnPalette^B is an optional numeric expression that should contain the
   desired color palette number.  This value must be within the range of one
   to seven.  The current color palette is assumed if you do not pass
   ^BnPalette^B.


^BReturns:^B

   ^BcColor^B is a character expression that will contain the current
   "unselected" color setting as a string.


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basUnsColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "N/W", saColors[pnPalette,3] )


/* HYPERTEXT START
!short: basBoxColor()   Returns the "box" color as a character string
basBoxColor()   Returns the "box" color as a character string

^BDescription: ^B

   basBoxColor() allows you to retrieve the "box" color as a character string.


^BSyntax:^B

   cColor := basBoxColor( [nPalette] )


^BPass:^B

   ^BnPalette^B is an optional numeric expression that should contain the
   desired color palette number.  This value must be within the range of one
   to seven.  The current color palette is assumed if you do not pass
   ^BnPalette^B.


^BReturns:^B

   ^BcColor^B is a character expression that will contain the current "box"
   color setting as a string.


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basBoxColor( pnPalette )

   assume pnPalette is snPalette if missing

   return if( slMono, "W+/N", saColors[pnPalette,4] )





/* HYPERTEXT START
!short: basMono()       Get/Set the monochrome color setting
basMono()       Get/Set the monochrome color setting

^BDescription: ^B

   basMono() allows you to Get/Set the monochrome setting.  If "monochrome"
   is turned on, the colors returned by other color functions will be altered
   to be used on a monochrome monitor.


^BSyntax:^B

   lCurrent := basMono( [lNew] )


^BPass:^B

   ^BlNew^B is an optional logical expression that should be set to TRUE if
   you want the color functions to use monochrome color schemes, otherwise
   set this value to FALSE.


^BReturns:^B

   ^BlCurrent^B is a logical expression that will be set to TRUE if
   "monochrome" is turned on, otherwise it will be FALSE.


^BSource:^B

   COLOR.PRG

HYPERTEXT END */
function basMono( plMono )

   local lMono := slMono

   slMono := if( pcount() > 0, plMono, slMono )

   return lMono


