/*

  Program Ŀ
                                                                        
  File Name...: CMDLINE.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 02-20-94              Date updated: 07-31-94           
  Time created: 01:12:18pm            Time updated: 00:37:28am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

static saParams := {}


/* HYPERTEXT START
!short: basCmdLine()    Easily read command line arguments
basCmdLine()    Easily read command line arguments

^BDescription: ^B

   basCmdLine() is designed to allow your users to specify command line
   parameters to your application in any order they see fit.

   basCmdLine() when used in conjunction with basSaveParms() makes life much
   easier for your users and for you as well, by ignoring the position of
   command line parameters and focusing on the values themselves.


^BSyntax:^B

   cValue := basCmdLine( cParm )


^BPass:^B

   ^BcParm^B is a character expression representing the command line parameter
   you want to test for.


^BReturns:^B

   ^BcValue^B is a character expression representing the command line
   parameter's value specified by cParm


^BExample:^B

   Let's assume that your application is  called MYAPP.EXE and your user typed
   the following on the DOS command line...

         C:\> MYAPP USER:JOHN PASSWORD:WHATEVER SOMETHING

   If your application had a maximum of six command line parameters (options)
   then your main function could look something like this...

   function main( p1, p2, p3, p4, p5, p6 )
   *****
   * Sample Main function
   *****

   basSaveParms( { p1, p2, p3, p4, p5, p6 } )

   Qout( "Hello " + basCmdLine("USER") )        // prints: Hello John

   if basCmdLine("SOMETHING") == "Y"
      Qout("This is special!")
   endif

   ...

   return nil


^BSource:^B

   CMDLINE.PRG

HYPERTEXT END */
function basCmdLine( pcParam )
   // What was the command line parameter identified by pcParam?
   local nPos   := 0
   local cValue := ""

   nPos := aScan( saParams, {|x| upper( left(x,len(pcParam)) ) == upper(pcParam)} )

   if nPos > 0

      // If it's just there with no colon!
      if at(":",saParams[nPos]) = 0
         cValue := "Y"
      else
         cValue := substr( saParams[nPos], at(":",saParams[nPos]) + 1 )
      endif

   endif

   return cValue




/* HYPERTEXT START
!short: basSaveParms()  Save command line parameters for basCmdLine()
basSaveParms()  Save command line parameters for basCmdLine()

^BDescription: ^B

   basCmdLine() is designed to allow your users to specify command line
   parameters to your application in any order they see fit.

   basCmdLine() when used in conjunction with basSaveParms() makes life much
   easier for your users and for you as well, by ignoring the position of
   command line parameters and focusing on the values themselves.


^BSyntax:^B

   basSaveParms( aParms )


^BPass:^B

   ^BaParms^B is a array of the command line parameters to save


^BReturns:^B

   Nothing


^BExample:^B

   Let's assume that your application is  called MYAPP.EXE and your user typed
   the following on the DOS command line...

         C:\> MYAPP USER:JOHN PASSWORD:WHATEVER SOMETHING

   If your application had a maximum of six command line parameters (options)
   then your main function could look something like this...

   function main( p1, p2, p3, p4, p5, p6 )
   *****
   * Sample Main function
   *****

   basSaveParms( { p1, p2, p3, p4, p5, p6 } )

   Qout( "Hello " + basCmdLine("USER") )        // prints: Hello John

   if basCmdLine("SOMETHING") == "Y"
      Qout("This is special!")
   endif

   ...

   return nil


^BSource:^B

   CMDLINE.PRG



HYPERTEXT END */
function basSaveParms( paParams )
   // Save the command line parms for every function to see
   local nCntr  := 0
   local nLength := 0

   saParams  := {}

   nLength := len(paParams)

   for nCntr := 1 to nLength

      if paParams[nCntr] != nil

         aAdd( saParams, upper(paParams[nCntr]) )

      endif

   next nCntr

   return nil


