/*

  Program Ŀ
                                                                        
  File Name...: REMOTE.PRG                                              
  Author......: Vernon E. Six, Jr.                                      
  Date created: 10-19-93              Date updated: 10-06-94           
  Time created: 09:53:22pm            Time updated: 09:14:18am         
  CopyRight...: (c) 1993 by FrontLine Software                          
                                                                        
 
  

*/

#include "inkey.ch"
#include "setcurs.ch"
#include "BAS_VERN.CH"


static sacFiles := {}
static scPrompt := "Please hangup"



/* HYPERTEXT START
!short: remRemote()     Simple remote mode
remRemote()     Simple remote mode

^BDescription: ^B

   remRemote() is a simple remote mode function that will allow your
   applications to painlessly transfer files to a host system using hstHost().


^BSyntax:^B

   nError := remRemote( [cFileName] )


^BPass:^B

   ^BcFileName^B is an optional character expression that should contain
   the name of your MODEM.INI file.  If you don't pass ^BcFileName^B,
   "MODEM.INI" is assumed


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    no error                                       
                                                              
         -1    Unable to create or open R_FILES.DBF           
                                                              
         -2    Unable to load modem settings                  
                                                              
         -3    Unable to load REMOTE.INI settings             
                                                              
         -4    Unable to to connect                           
                                                              
       


^BNotes:^B

   Requires Telepathy from...

       Extrasensory Software
       4450 Murietta Ave., #8
       Sherman Oaks, CA  91423

       (818) 981-8367 Voice
       (818) 986-5411 Fax


   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   REMOTE.PRG


HYPERTEXT END */
function remRemote(pcFileName)

   local nRetVal     := 0
   local lExact      := set( _SET_EXACT,  .f. ) // Normal string comparison
   local lDeleted    := set( _SET_DELETED,.t. ) // No deleted records
   local aConnInfo   := {}

   assume pcFileName is "MODEM.INI" if missing

   begin sequence

      if .not. remOpenFile()
         nRetVal := -1
         break
      endif

      if .not. md_Load(pcFileName)
         nRetVal := -2
         break
      endif

      if .not. iniOpen("REMOTE.INI")
         nRetVal := -3
         break
      endif

      // make the call
      aConnInfo := md_Dial( { {iniGetStr("remote","host name"),;
         iniGetStr("remote","phone") } }  )

      if aConnInfo[1] == 0
         nRetVal := -4
         break
      endif

      ? "Connected at: ", aConnInfo[2]

      ? "Starting session"

      if .not. sSession()
         nRetVal := -5
         break
      endif

      ? "Session completed successfully"

      nRetVal := 0

   end sequence

   set( _SET_EXACT,  lExact   )
   set( _SET_DELETED,lDeleted )

   return nRetVal


/* HYPERTEXT START
!short: remOpenFile()   Opens the R_FILES.DBF file
remOpenFile()   Opens the R_FILES.DBF file

^BDescription: ^B

   remOpenFile() will attempt to open the R_FILES.DBF file.  This file is
   needed by remRemote() and a variety of other Remote functions.  Normally
   you will not call this function directly.


^BSyntax:^B

   lSuccess := remOpenFile()


^BPass:^B

   Nothing


^BReturns:^B

   ^BlSuccess^B is a logical expression that will be set to TRUE if
   hstOpenFile() is successful, otherwise it will be to FALSE.


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   REMOTE.PRG

HYPERTEXT END */
function remOpenFile()

   local lSuccess := .f.

   local aStruct  := {           ;
      {"LOGIN_ID  ","C",10,00}, ;
      {"FILENAME  ","C",70,00}, ;
      {"KILLSENT  ","L",01,00}    }

   local aTags    := { {"R_FILES", "LOGIN_ID + FILENAME", ""} }

   begin sequence

      basStruct( "R_FILES", aStruct, aTags )

      if .not. basOpenDbf("R_FILES") == 0
         break
      endif

      lSuccess := .t.

   end sequence

   return lSuccess



/* HYPERTEXT START
!short: remAddFile()    Add a file to the remote queue
remAddFile()    Add a file to the remote queue

^BDescription: ^B

   remAddFile() allows your programs to add a file to the remote queue file.
   When remRemote() makes a call to the host, the host will receive all the
   files listed in this queue.  NOTE: No checking is done to ensure the file
   exists.  It's your job to make sure the file does in fact exist.


^BSyntax:^B

   nError := remAddFile( cUserId, cFileName, [lKillSent] )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   that you want to receive this ^BcFileName^B.  This field can be up to
   ten characters in length.  NOTE: No checking is done to make sure this
   is a valid user.  It is your job to ensure this is a valid user as
   defined in HOST.INI on the Host side.

   ^BcFileName^B is a character expression that should contain the full
   path and filename of the file you want to send to ^BcUserId^B.

   ^BlKillSent^B is an optional logical expression that should be set to TRUE
   if you want ^BcFileName^B deleted once it has been sent to the Host.  The
   default is FALSE.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    No Error                                       
                                                              
         -1    Unable to open/create R_FILES.DBF              
                                                              
         -2    Unable to add/recycle record in R_FILES.DBF    
                                                              
       


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   REMOTE.PRG


HYPERTEXT END */
function remAddFile(pcUserId,pcFileName,plKillSent)

   local nError := 0

   assume plKillSent is .f. if missing

   begin sequence

      if .not. remOpenFile()
         nError := -1
         break
      endif

      if .not. r_files->( basAddRec() )
         nError := -2
         break
      endif

      r_files->login_id := upper(pcUserId)
      r_files->filename := upper(pcFileName)
      r_files->killsent := plKillSent

      r_files->( dbUnlock() )

   end sequence

   return nError


/* HYPERTEXT START
!short: remFiles()      Returns a list of a files for a specified user
remFiles()      Returns a list of a files for a specified user

^BDescription: ^B

   remFiles() allows your programs to see what files are currently in the
   remote queue file for a specified user.


^BSyntax:^B

   acFiles := remFiles( cUserId )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   you want a list for.  This field can be up to ten characters in length.
   NOTE: No checking is done to make sure this is a valid user.  It is your
   job to ensure this is a valid user as defined in HOST.INI on the Host
   side.


^BReturns:^B

   ^BacFiles^B is an array of character expressions.  Each element will
   contain a filename that is queued for ^BcUserId^B.


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   REMOTE.PRG

HYPERTEXT END */
function remFiles(pcUserId)

   local acFiles := {}

   begin sequence

      if .not. remOpenFile()
         break
      endif

      pcUserId := padr( upper(pcUserId), 10 )

      r_files->( dbSeek(pcUserId,.f.) )

      while .not. r_files->( eof() )

         if .not. r_files->login_id == pcUserId
            exit
         endif

         aAdd( acFiles, alltrim(r_files->filename) )

         r_files->( dbSkip() )

      enddo

   end sequence

   return acFiles


/* HYPERTEXT START
!short: remFileSent()   Remove a file from the remote queue file
remFileSent()   Remove a file from the remote queue file

^BDescription: ^B

   remFileSent() allows your programs to remove a file from the host queue
   file.  It assumes that the file has been sent to the Host successfully
   and will delete the physical file from your hard drive if the "kill sent"
   flag is set to TRUE.


^BSyntax:^B

   nError := remFileSent( cUserId, cFileName )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   as defined in HOST.INI on the Host side.  This field can be up to ten
   characters in length.  NOTE: No checking is done to make sure this is a
   valid user.  It is your job to ensure this is a valid user as defined
   in HOST.INI on the Host side.

   ^BcFileName^B is a character expression that should contain the full
   path and name of the file you want to mark as sent.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    No Error                                       
                                                              
         -1    Unable to open/create R_FILES.DBF              
                                                              
         -2    File not in remote queue file                  
                                                              
         -3    Unable to lock record in R_FILES.DBF           
                                                              
         -4    Unable to delete physical file from hard drive 
                                                              
         -5    Unable to delete record from R_FILES.DBF       
                                                              
       


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   REMOTE.PRG


HYPERTEXT END */
function remFileSent(pcUserId,pcFileName)

   local nError      := 0

   begin sequence

      if .not. remOpenFile()
         nError := -1
         break
      endif

      pcUserId    := padr( upper(pcUserId), 10 )
      pcFileName  := upper(pcFileName)

      if .not. r_files->( dbSeek(pcUserId+pcFileName,.f.) )
         nError := -2
         break
      endif

      if .not. r_files->( rlock() )
         nError := -3
         break
      endif

      if r_files->killsent

         fErase(pcFileName)

         if file(pcFileName)
            nError := -4
            break
         endif

      endif

      if .not. r_files->( basDelRec() )
         nError := -5
         break
      endif

   end sequence

   return nError



/* HYPERTEXT START
!short: remRemFile()    Remove a file from the remote queue file
remRemFile()    Remove a file from the remote queue file

^BDescription: ^B

   remRemFile() allows your programs to remove a file from the remote queue
   file.  remRemFile() does NOT delete the physical file from your hard
   drive even if the "kill sent" flag is set to TRUE.  All remRemFile()
   does is remove the file from the remote queue file.


^BSyntax:^B

   nError := remRemFile( cUserId, cFileName )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   as defined in HOST.INI on the Host side.  This field can be up to ten
   characters in length.  NOTE: No checking is done to make sure this is
   a valid user.  It is your job to ensure this is a valid user as defined
   in HOST.INI on the Host side.

   ^BcFileName^B is a character expression that should contain the full
   path and name of the file you want to remove from the queue.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    No Error                                       
                                                              
         -1    Unable to open/create R_FILES.DBF              
                                                              
         -2    File not in remote queue file                  
                                                              
         -3    Unable to delete record from R_FILES.DBF       
                                                              
       


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   REMOTE.PRG

HYPERTEXT END */
function remRemFile(pcUserId,pcFileName)

   local nError      := 0

   begin sequence

      if .not. remOpenFile()
         nError := -1
         break
      endif

      pcUserId    := padr( upper(pcUserId), 10 )
      pcFileName  := upper(pcFileName)

      if .not. r_files->( dbSeek(pcUserId+pcFileName,.f.) )
         nError := -2
         break
      endif

      if .not. r_files->( basDelRec() )
         nError := -3
         break
      endif

   end sequence

   return nError









static function sSession(plKillSent)

   local lSuccess := .f.

   begin sequence

      ? "Logging in"

      if .not. sLogin()
         break
      endif

      ? "preparing to send files"

      if .not. sSendFiles()
         break
      endif

      if .not. md_Dcd()
         break
      endif

      ? "preparing to receive files"

      sRecvFiles()

      ? "done receiving files"

      lSuccess := .t.

   end sequence

   md_HangUp()

   return lSuccess



static function sLogin()

   local lSuccess := .f.

   begin sequence

      if .not. tp_WaitFor( 1, 60, scPrompt ) = 1
         ? "Didn't receive login prompt"
         break
      endif

      md_Xmit( chr(254) )

      if .not. tp_WaitFor( 1, 15, "USER ID: ") = 1
         ? "Didn't receive user id prompt"
         break
      endif

      md_XmitLn( iniGetStr("remote","login") )
      ? "Sent user id"

      if .not. tp_WaitFor( 1, 15, "PASSWORD: ") = 1
         ? "Didn't receive password prompt"
         break
      endif

      md_XmitLn( iniGetStr("remote","password") )
      ? "Sent password"

      if .not. tp_WaitFor( 1, 60, "Login Successful!") = 1
         ? "Didn't receive login confirmation"
         break
      endif

      lSuccess := .t.

   end sequence

   return lSuccess



static function sSendFiles()

   local nError   := 0
   local acFiles  := {}
   local nFiles   := 0
   local nJ       := 0
   local nUsers   := 0
   local nI       := 0
   local acUsers  := {}
   local lSuccess := .f.

   begin sequence

      // build list of users that have files waiting
      r_files->( dbGoTop() )

      while .not. r_files->(eof())

         if r_files->login_id == replicate("",10)
            exit
         endif

         nI := aScan( acUsers, {|c|c==r_files->login_id} )

         if nI == 0
            aAdd(acUsers,r_files->login_id)
         endif

         r_files->( dbSkip() )

      enddo


      // walk through the list of users and send all the files
      nUsers := len(acUsers)

      ? "Sending files to " + alltrim(str(nUsers)) + " users."

      for nI := 1 to nUsers

         acFiles := remFiles(acUsers[nI])

         if .not. tp_WaitFor( 1, 60, "RECV CMD: " ) = 1
            break
         endif

         md_XmitLn(acUsers[nI])

         nError := md_sZmodem(acFiles)

         if nError == 0

            nFiles := len(acFiles)
            for nJ := 1 to nFiles
               remFileSent(acUsers[nI],acFiles[nJ])
            next nJ

         endif

      next nI

      md_XmitLn("DONE")
      ? "Done sending files"

      lSuccess := .t.

   end sequence

   return lSuccess



static function sRecvFiles()

   begin sequence

      if .not. tp_WaitFor(1,120,"B00") = 1   // wait for ZRINT
         ? "Didn't receive ZRINT"
         break
      endif

      md_rZmodem()

   end sequence

   return nil




/* HYPERTEXT START
!short: remPrompt()     Get/Set the login prompt used by host
remPrompt()     Get/Set the login prompt used by host

^BDescription: ^B

   Some host systems do not use the normal login prompt, this is how you can
   control what remRemote() will look for as a login prompt.


^BSyntax:^B

   cCurrent := remPrompt( [cNew] )


^BPass:^B

   ^BcNew^B is an optional character expression that should contain the
   new login prompt used by your host.


^BReturns:^B

   ^BcCurrent^B is a character expression that will contain the current
   login prompt.


^BSource:^B

   REMOTE.PRG

HYPERTEXT END */
function remPrompt( pcNew )

   local cCurrent := scPrompt

   if pcount() = 1
      scPrompt := pcNew
   endif

   return cCurrent





