 /*

  Program Ŀ
                                                                        
  File Name...: HOST.PRG                                                
  Author......: Vernon E. Six, Jr.                                      
  Date created: 10-19-93              Date updated: 09-30-94           
  Time created: 09:53:22pm            Time updated: 10:26:24am         
  CopyRight...: (c) 1993 by FrontLine Software                          
                                                                        
 
  

*/

#include "inkey.ch"
#include "setcurs.ch"
#include "BAS_VERN.CH"

static sacFiles := {}

static scPrompt := "This is NOT a BBS.  Please hangup!"




/* HYPERTEXT START
!short: hstHost()       Simple host mode
hstHost()       Simple host mode

^BDescription: ^B

   hstHost() is a simple host mode function that will allow your applications
   to painlessly transfer files to remote callers using remRemote().


^BSyntax:^B

   nError := hstHost( [cFileName], [lKillSent] )


^BPass:^B

   ^BcFileName^B is an optional character expression that should contain
   the name of your MODEM.INI file.  If you don't pass ^BcFileName^B,
   "MODEM.INI" is assumed

   ^BlKillSent^B is an optional logical expression that should be set to
   TRUE if you want the "kill sent" flag to be set on whenever hstHost()
   receives files from a remote caller addressed to another remote caller,
   otherwise set to FALSE.  ie: Caller #1 sends XYZ.WK1 addressed to Caller
   #2.  If you want XYZ.WK1 to be deleted once it has been sent to Caller #2,
   set this value to TRUE.  If you want to keep a copy of all the files
   you receive from Caller #1, set this value to FALSE.  The default is TRUE.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    Local user aborted host mode                   
                                                              
         -1    Unable to create or open H_FILES.DBF           
                                                              
         -2    Unable to load modem settings                  
                                                              
         -3    Unable to load user settings                   
                                                              
         -4    Unable to initialize modem                     
                                                              
       


^BNotes:^B

   Requires Telepathy from...

       Extrasensory Software
       4450 Murietta Ave., #8
       Sherman Oaks, CA  91423

       (818) 981-8367 Voice
       (818) 986-5411 Fax


   Requires Nanforum ToolKit available on CompuServe in the CLIPPER forum
   and on our BBS at 817-267-9768


^BSource:^B

   HOST.PRG


HYPERTEXT END */
function hstHost(pcFileName,plKillSent)

   local nRetVal     := 0
   local lExact      := set( _SET_EXACT,  .f. ) // Normal string comparison
   local lDeleted    := set( _SET_DELETED,.t. ) // No deleted records
   local nWait4Call  := 0

   assume pcFileName is "MODEM.INI" if missing
   assume plKillSent is .t.         if missing

   begin sequence

      // open the file
      if .not. hstOpenFile()
         nRetVal := -1
         break
      endif

      if .not. md_Load(pcFileName)
         nRetVal := -2
         break
      endif

      if .not. iniOpen("HOST.INI")
         nRetVal := -3
         break
      endif

      while .t.

         // wait for a call
         nWait4Call := md_Wait4Call(scPrompt)

         if nWait4Call == -1
            nRetVal := -4
            break
         endif

         if nWait4Call == 0
            nRetVal := 0
            break
         endif

         sSession(plKillSent)

      enddo

   end sequence

   set( _SET_EXACT,  lExact   )
   set( _SET_DELETED,lDeleted )

   return nRetVal


/* HYPERTEXT START
!short: hstOpenFile()   Opens the H_FILES.DBF file
hstOpenFile()   Opens the H_FILES.DBF file

^BDescription: ^B

   hstOpenFile() will attempt to open the H_FILES.DBF file.  This file is
   needed by hstHost() and a variety of other Host functions.  Normally you
   will not call this function directly.


^BSyntax:^B

   lSuccess := hstOpenFile()


^BPass:^B

   Nothing


^BReturns:^B

   ^BlSuccess^B is a logical expression that will be set to TRUE if
   hstOpenFile() is successful, otherwise it will be to FALSE.


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   HOST.PRG


HYPERTEXT END */
function hstOpenFile()

   local lSuccess := .f.

   local aStruct  := {           ;
      {"LOGIN_ID  ","C",10,00}, ;
      {"FILENAME  ","C",70,00}, ;
      {"KILLSENT  ","L",01,00}    }

   local aTags    := { { "H_FILES", "LOGIN_ID + FILENAME", "" } }

   begin sequence

      basStruct( "H_FILES", aStruct, aTags )

      if .not. basOpenDbf("H_FILES") == 0
         break
      endif

      lSuccess := .t.

   end sequence

   return lSuccess



/* HYPERTEXT START
!short: hstAddFile()    Add a file to the host queue
hstAddFile()    Add a file to the host queue

^BDescription: ^B

   hstAddFile() allows your programs to add a file to the host queue file.
   When the remote caller calls in, he/she will receive the file you added
   via this function.  NOTE: No checking is done to ensure the file exists.
   It's your job to make sure the file does in fact exist.


^BSyntax:^B

   nError := hstAddFile( cUserId, cFileName, [lKillSent] )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   as defined in HOST.INI.  This field can be up to ten characters in
   length.  NOTE: No checking is done to make sure this is a valid user.
   It is your job to ensure this is a valid user as defined in HOST.INI.

   ^BcFileName^B is a character expression that should contain the full
   path and filename of the file you want to send to ^BcUserId^B.

   ^BlKillSent^B is an optional logical expression that should be set to TRUE
   if you want ^BcFileName^B deleted once it has been sent to ^BcUserId^B.
   The default is FALSE.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    No Error                                       
                                                              
         -1    Unable to open/create H_FILES.DBF              
                                                              
         -2    Unable to add/recycle record in H_FILES.DBF    
                                                              
       


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   HOST.PRG

HYPERTEXT END */
function hstAddFile(pcUserId,pcFileName,plKillSent)

   local nError := 0

   assume plKillSent is .f. if missing

   begin sequence

      if .not. hstOpenFile()
         nError := -1
         break
      endif

      if .not. h_files->( basAddRec() )
         nError := -2
         break
      endif

      h_files->login_id := upper(pcUserId)
      h_files->filename := upper(pcFileName)
      h_files->killsent := plKillSent

      h_files->( dbUnlock() )

   end sequence

   return nError


/* HYPERTEXT START
!short: hstFiles()      Returns a list of a files for a specified user
hstFiles()      Returns a list of a files for a specified user

^BDescription: ^B

   hstFiles() allows your programs to see what files are currently in the
   host queue file for a specified caller.


^BSyntax:^B

   acFiles := hstFiles( cUserId )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   as defined in HOST.INI.  This field can be up to ten characters in
   length.  NOTE: No checking is done to make sure this is a valid user.
   It is your job to ensure this is a valid user as defined in HOST.INI.


^BReturns:^B

   ^BacFiles^B is an array of character expressions.  Each element will
   contain a filename that is queued for ^BcUserId^B.


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   HOST.PRG


HYPERTEXT END */
function hstFiles(pcUserId)

   local acFiles := {}

   begin sequence

      if .not. hstOpenFile()
         break
      endif

      pcUserId := padr( upper(pcUserId), 10 )

      h_files->( dbSeek(pcUserId,.f.) )

      while .not. h_files->( eof() )

         if .not. h_files->login_id == pcUserId
            exit
         endif

         aAdd( acFiles, alltrim(h_files->filename) )

         h_files->( dbSkip() )

      enddo

   end sequence

   return acFiles


/* HYPERTEXT START
!short: hstFileSent()   Remove a file from the host queue file
hstFileSent()   Remove a file from the host queue file

^BDescription: ^B

   hstFileSent() allows your programs to remove a file from the host queue
   file.  It assumes that the file has been sent to the remote caller
   successfully and will delete the physical file from your hard drive if
   the "kill sent" flag is set to TRUE.


^BSyntax:^B

   nError := hstFileSent( cUserId, cFileName )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   as defined in HOST.INI.  This field can be up to ten characters in
   length.  NOTE: No checking is done to make sure this is a valid user.
   It is your job to ensure this is a valid user as defined in HOST.INI.

   ^BcFileName^B is a character expression that should contain the full
   path and name of the file you want to mark as sent.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    No Error                                       
                                                              
         -1    Unable to open/create H_FILES.DBF              
                                                              
         -2    File not in host queue file                    
                                                              
         -3    Unable to lock record in H_FILES.DBF           
                                                              
         -4    Unable to delete physical file from hard drive 
                                                              
         -5    Unable to delete record from H_FILES.DBF       
                                                              
       


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   HOST.PRG

HYPERTEXT END */
function hstFileSent(pcUserId,pcFileName)

   local nError      := 0

   begin sequence

      if .not. hstOpenFile()
         nError := -1
         break
      endif

      pcUserId    := padr( upper(pcUserId), 10 )
      pcFileName  := upper(pcFileName)

      if .not. h_files->( dbSeek(pcUserId+pcFileName,.f.) )
         nError := -2
         break
      endif

      if .not. h_files->( basRLock() )
         nError := -3
         break
      endif

      if h_files->killsent

         fErase(pcFileName)

         if file(pcFileName)
            nError := -4
            break
         endif

      endif

      if .not. h_files->( basDelRec() )
         nError := -5
         break
      endif

      nError := 0

   end sequence

   return nError




/* HYPERTEXT START
!short: hstRemFile()    Remove a file from the host queue file
hstRemFile()    Remove a file from the host queue file

^BDescription: ^B

   hstRemFile() allows your programs to remove a file from the host queue
   file.  hstRemFile() does NOT delete the physical file from your hard
   drive even if the "kill sent" flag is set to TRUE.  All hstRemFile()
   does is remove the file from the host queue file.


^BSyntax:^B

   nError := hstRemFile( cUserId, cFileName )


^BPass:^B

   ^BcUserId^B is a character expression that should contain the user id
   as defined in HOST.INI.  This field can be up to ten characters in
   length.  NOTE: No checking is done to make sure this is a valid user.
   It is your job to ensure this is a valid user as defined in HOST.INI.

   ^BcFileName^B is a character expression that should contain the full
   path and name of the file you want to remove from the queue.


^BReturns:^B

   ^BnError^B is a numeric expression that will be set to one of the
   following values...

       Ŀ
        Value  Description                                    
       Ĵ
                                                              
          0    No Error                                       
                                                              
         -1    Unable to open/create H_FILES.DBF              
                                                              
         -2    File not in host queue file                    
                                                              
         -3    Unable to delete record from H_FILES.DBF       
                                                              
       


^BNotes:^B

   Requires Comix v3.x from...

       LoadStone Inc.
       215 Barmount Drive
       Columbia, SC 29210

       Fax:    803/731-9798
       Sales:  803/731-9128


^BSource:^B

   HOST.PRG

HYPERTEXT END */
function hstRemFile(pcUserId,pcFileName)

   local nError      := 0

   begin sequence

      if .not. hstOpenFile()
         nError := -1
         break
      endif

      pcUserId    := padr( upper(pcUserId), 10 )
      pcFileName  := upper(pcFileName)

      if .not. h_files->( dbSeek(pcUserId+pcFileName,.f.) )
         nError := -2
         break
      endif

      if .not. h_files->( basDelRec() )
         nError := -3
         break
      endif

   end sequence

   return nError




static function sSession(plKillSent)

   local cUserId := ""

   begin sequence

      cUserId := sLogin()

      if empty(cUserId)
         break
      endif

      sRecvFiles(plKillSent)

      if .not. md_Dcd()
         break
      endif

      sSendFiles(cUserId)

   end sequence

   md_HangUp()

   return nil



static function sLogin()

   local cUserId  := ""
   local cPwd     := ""

   begin sequence

      md_XmitLn( "" + chr(10) )

      md_Xmit( "USER ID: " )

      cUserId := tp_RecvLn(1,10,15)

      if empty(cUserId)
         break
      endif

      md_Xmit( "PASSWORD: " )

      cPwd := tp_RecvLn(1,10,15)

      if empty(cPwd)
         cUserId := ""
         break
      endif

      cUserId := upper(cUserId)
      cPwd    := upper( alltrim(cPwd) )

      if .not. cPwd == upper( iniGetStr(cUserId,"password") )
         cUserId := ""
         break
      endif

      md_XmitLn( "Login Successful!" + chr(10) )

   end sequence

   return cUserId



static function sRecvFiles(plKillSent)

   local nError   := 0
   local cUserId  := ""
   local acFiles  := {}
   local nLength  := 0
   local nI       := 0

   while .t.

      md_Xmit( "RECV CMD: " )

      cUserId := tp_RecvLn(1,10,15)

      if empty(cUserId)
         exit
      endif

      cUserId := upper( alltrim(cUserId) )

      if cUserId == "DONE"
         exit
      endif

      tp_WaitFor(1,120,"B00")// wait for ZRINT

      nError := md_rZmodem()

      if .not. nError == 0
         loop
      endif

      acFiles := md_Files()

      nLength := len(acFiles)

      for nI := 1 to nLength

         hstAddFile( cUserId, acFiles[nI], plKillSent )

      next nI

   enddo

   return nil




static function sSendFiles(pcUserId)

   local nError   := 0
   local acFiles  := hstFiles(pcUserId)
   local nLength  := len(acFiles)
   local nI       := 0

   nError := md_sZmodem(acFiles)

   if nError == 0

      for nI := 1 to nLength

         hstFileSent(pcUserId,acFiles[nI])

      next nI

   endif

   return nil



/* HYPERTEXT START
!short: hstPrompt()     Get/Set the login prompt used by hstHost()
hstPrompt()     Get/Set the login prompt used by hstHost()

^BDescription: ^B

   Some host systems do not use the normal login prompt, this is how you can
   control what remRemote() will see when it logs in.


^BSyntax:^B

   cCurrent := hstPrompt( [cNew] )


^BPass:^B

   ^BcNew^B is an optional character expression that should contain the
   new login prompt used by your host.


^BReturns:^B

   ^BcCurrent^B is a character expression that will contain the current
   login prompt.


^BSource:^B

   HOST.PRG

HYPERTEXT END */
function hstPrompt( pcNew )

   local cCurrent := scPrompt

   if pcount() = 1
      scPrompt := pcNew
   endif

   return cCurrent






