/*

 Ŀ
                                                                        
  File Name...: DBVSTUFF.PRG                                            
  Author......: Vernon E. Six, Jr.                                      
  Date created: 08-25-94              Date updated: 09-23-94           
  Time created: 07:56:22pm            Time updated: 01:42:11pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
  Notes.......: Requires FlexFile II                                    
                                                                        
 
  

*/

#include "flexfile.ch"

#define __NEWAREA .t.
#define __SHARED  .f.




/* HYPERTEXT START
!short: dbvOpen()       Open a DBV file
dbvOpen()       Open a DBV file

^BDescription: ^B

   dbvOpen() opens a DBV file.


^BSyntax:^B

   lSuccess := dbvOpen( cFileName, cAlias )


^BPass:^B

   ^BcFileName^B is a character expression that should contain the full
   path and filename (including extension) of the DBV file you want to
   open.

   ^BcAlias^B is a character expression that should contain the alias you
   want to use for this DBV file.


^BReturns:^B

   ^BlSuccess^B is a logical expression that will be set to TRUE if
   dbvOpen() was successful, otherwise it will be set to FALSE.


^BNotes:^B

   Requires FlexFile II from...

      Ganahl Software, Inc.
      6278 North Federal Hwy Suite 135
      Ft Lauderdale, FL 33308
      Support: (305) 942-5581
      BBS:     (305) 941-4517
      Fax:     (305) 942-2981


^BSource:^B

   DBVSTUFF.PRG

HYPERTEXT END */
function dbvOpen(pcFileName,pcAlias)

   local lSuccess := .f.
   local array    := nil

   begin sequence

      if .not. file(pcFileName)

         if .not. v_Create(pcFileName)
            break
         endif

      endif

      if v_use( pcFileName, pcAlias, __NEWAREA, __SHARED ) == -1
         break
      endif

      // make sure there is an array stored in this dude
      array := dbvRead(pcAlias)

      if .not. valtype(array) == "A"
         dbvWrite(pcAlias,{})
      endif

      lSuccess := .t.

   end sequence

   return lSuccess




/* HYPERTEXT START
!short: dbvRead()       Read an array from the specified DBV file
dbvRead()       Read an array from the specified DBV file

^BDescription: ^B

   dbvRead() allows you to read the array stored in the specified DBV file.


^BSyntax:^B

   aArray := dbvRead( cAlias )


^BPass:^B

   ^BcAlias^B is a character expression that should contain the alias you
   want to use for this DBV file.


^BReturns:^B

   ^BaArray^B is an array (of any deminsion) that was stored in the
   specified DBV file.


^BNotes:^B

   Requires FlexFile II from...

      Ganahl Software, Inc.
      6278 North Federal Hwy Suite 135
      Ft Lauderdale, FL 33308
      Support: (305) 942-5581
      BBS:     (305) 941-4517
      Fax:     (305) 942-2981


^BSource:^B

   DBVSTUFF.PRG


HYPERTEXT END */
function dbvRead(pcAlias)

   return v_Retrieve( v_TopPtr(nil,pcAlias), pcAlias )




/* HYPERTEXT START
!short: dbvWrite()      Write an array to the specified DBV file
dbvWrite()      Write an array to the specified DBV file

^BDescription: ^B

   dbvWrite() allows you to write an array to the specified DBV file.


^BSyntax:^B

   dbvWrite( cAlias, aArray )


^BPass:^B

   ^BcAlias^B is a character expression that should contain the alias you
   want to use for this DBV file.

   ^BaArray^B is an array (of any deminsion) that is to be stored in the
   specified DBV file.

^BReturns:^B

   nothing


^BNotes:^B

   Requires FlexFile II from...

      Ganahl Software, Inc.
      6278 North Federal Hwy Suite 135
      Ft Lauderdale, FL 33308
      Support: (305) 942-5581
      BBS:     (305) 941-4517
      Fax:     (305) 942-2981


^BSource:^B

   DBVSTUFF.PRG


HYPERTEXT END */
function dbvWrite(pcAlias,paValue)

   local cOldPtr := v_TopPtr(nil,pcAlias)
   local cNewPtr := v_Replace( paValue, cOldPtr, pcAlias, CMP_DEFAULT )

   while .not. v_TopLock(pcAlias)
   enddo

   v_TopPtr(cNewPtr,pcAlias)

   v_TopUnlock(pcAlias)

   return nil



