/*

 Ŀ
                                                                        
  File Name...: DBFLIST.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 09-23-94           
  Time created: 09:28:29pm            Time updated: 01:41:51pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"
#include "inkey.ch"
#include "setcurs.ch"

/* HYPERTEXT START
!short: basDbfList()    Browse a database
basDbfList()    Browse a database

^BDescription: ^B

   basDbfList() allows you to quickly create a "pick" list for any database.
   basDbfList() also allows you to branch from this "pick" list very easily.


^BSyntax:^B

   nLastKey := basDbfList( nTop, nLeft, nHeight, [cTitle], [cFootNote], ;
      [nPalette], [cHeading], bColumn, [aKeyList] )


^BPass:^B

   ^BnTop^B is a numeric expression that should contain the line number for
   the top most line of the "pick" list

   ^BnLeft^B is a numeric expression that should contain the column number
   for the left most column in the "pick" list

   ^BnHeight^B is a numeric expression that should contain the number of
   lines (rows) you want to display in the "pick" list

   ^BcTitle^B is an optional character expression that should contain the
   title for the box surrounding the "pick" list

   ^BcFootNote^B is an optional character expression that should contain
   the footnote for the box surrounding the "pick" list

   ^BnPalette^B is an optional numeric expression that should contain the
   color palette number.  If you don't pass ^BnPalette^B, the current
   color palette is used.

   ^BcHeading^B is an optional character expression that should contain
   the heading for the "pick" list.  This heading will appear within the
   box above ^BbColumn^B

   ^BbColumn^B is a code block that should return the value you want
   display in the "pick" list.  ie: { || cust->last + " - " + cust->frst }

   ^BaKeyList^B is an optional array of hotkeys to branch from the "pick"
   list.  ^BaKeyList^B has the following structure...

      { { nKey, bAction }, ... }

      ^BnKey^B is a numeric expression that should contain the INKEY()
      value for the key associated with ^BbAction^B

      ^BbAction^B is a code block that will be evaluated (executed) when
      the user pressed the ^BnKey^B key


^BReturns:^B

   ^BnLastKey^B is a numeric expression that will contain the last key
   the user pressed while in the "pick" list.  If the key was in
   ^BaKeyList^B, basDbfList() will not terminate and therefore not return
   ^BnLastKey^B.


^BSource:^B

   DBFLIST.PRG


HYPERTEXT END */
function basDbfList( pnTop, pnLeft, pnHeight, pcTitle, pcFooter, ;
      pnPalette, pcHeading, pbColumn, paKeyList )

   local nKey    := 0
   local nWidth  := len( eval(pbColumn) )
   local oBrowse := nil
   local nPos    := 0

   assume pcTitle   is "" if missing
   assume pcFooter  is "" if missing
   assume pnPalette is basPalette() if missing

   oBrowse := tBrowseDb( pnTop+1, pnLeft+2, pnTop+pnHeight, pnLeft+nWidth+1 )

   oBrowse:AddColumn( tbColumnNew(pcHeading,pbColumn) )

   if .not. empty(pcHeading)
      oBrowse:HeadSep := ""
   endif

   basSaveScrn()

   SetCursor(SC_NONE)

   basWind( pnTop, pnLeft, pnTop+pnHeight+1, pnLeft+nWidth+3, pcTitle, ;
      pcFooter, pnPalette )

   oBrowse:ColorSpec := setcolor()

   while .t.

      DispBegin()
      while .not. oBrowse:Stabilize()
      enddo
      DispEnd()

      nKey := basInkeyZero()

      nPos := aScan( paKeyList, {|x|x[1]==nKey} )

      if nPos > 0
         eval( paKeyList[nPos,2], oBrowse )
         oBrowse:refreshall()
         loop
      endif

      do case
         case nKey = K_UP        ; oBrowse:up()
         case nKey = K_DOWN      ; oBrowse:down()
         case nKey = K_PGDN      ; oBrowse:PageDown()
         case nKey = K_PGUP      ; oBrowse:PageUp()
         case nKey = K_CTRL_PGDN ; oBrowse:goBottom()
         case nKey = K_CTRL_PGUP ; oBrowse:goTop()
         otherwise               ; exit
      endcase

   enddo

   basRestScrn()

   return nKey

