/*

Program Name : Ball.prg
Author       : Jeff Winters
Created      : Thursday  June 24, 1993 at  4:23:34 pm

Version      : 1.0
Revision     : 

Description  : 

*/

static ballRay := {}

#include "setcurs.ch"

#define BALL_ROW  01        // Row element of ballRay 
#define BALL_COL  02        // Column element of ballRay
#define BALL_CHAR 03        // Ball character
#define BALL_DIR  04        // Direction ball is travelling ( UP or DOWN )
#define BALL_BOX  05        // Saved screen segment
#define BALL_MIN  06        // Top row of ball path
#define BALL_MAX  07        // Bottom row of ball path
#define BALL_HAND 08        // Ball handle

#define DOWN 0
#define UP   1

#ifdef DEBUG
function bDriver()
   /*
   Driver function to test and demonstrate the bouncing ball
   function set.
   */

   local bHand1 := createBall(  00, 09, ''  )
   local bHand2 := createBall(  14, 23, ''  )
   local bHand3 := createBall(  00, 24, ''  )
   local bHand4 := createBall(  03, 21, ''  )
   local bHand5 := createBall(  06, 14, ''  )
   local bHand6 := createBall(  02, 17, ''  )
   initer()
   showMsg()

   while inkey() == 0
      /*
      Bounce the balls...
      */
      bounceBall( bHand1 )
      bounceBall( bHand2 )
      bounceBall( bHand3 )
      bounceBall( bHand4)
      bounceBall( bHand5)
      bounceBall( bHand6)
   enddo
   /*
   Kill all of the balls.
   */
   killBall( bHand1 )
   killBall( bHand2 )
   killBall( bHand3 )
   killBall( bHand4)
   killBall( bHand5)
   killBall( bHand6)

   deinit()
return( NIL )
* -------------------------------------------------------------------------- *
* 
* -------------------------------------------------------------------------- *
static function initer()
   set( _SET_SCOREBOARD, .F. )
   set( _SET_CURSOR, SC_NONE )
   if isColor()
      setColor( 'w/b' )
   endif
   scroll()
return( NIL )
* -------------------------------------------------------------------------- *
* 
* -------------------------------------------------------------------------- *
static function deInit()
   set( _SET_CURSOR, SC_NORMAL )
   scroll()
return( NIL )
#endif
* -------------------------------------------------------------------------- *
* 
* -------------------------------------------------------------------------- *
function bounceBall(bHand)
   /*
   bounceBall( int )

   Purpose    : Moves the specified ball one step along it's bouncing path.

   Parameters : bHand  - integer value that represents a ball handle
                returned by function createBall ( see it below ).

   
   Returns    : NIL
   */
   local cRow  := 0        
   local cCol  := 0        
   local rOne  := 0
   local bIncr := 0        

   * --- Determine which ball they want to bounce.
   bIncr := aScan( ballRay, {|x| x[BALL_HAND] == bHand } )

   if bIncr > 0

      * --- If it was a valid ball, bounce it.
      if len( ballRay[bIncr][ BALL_BOX ] ) > 0

         * --- If this is at least the second iteration, restore
         * --- the underlying screen.  This has the effect of 
         * --- erasing the existing ball.
         restScreen( ballRay[bIncr][ BALL_ROW ],;
                     ballRay[bIncr][ BALL_COL ],;
                     ballRay[bIncr][ BALL_ROW ],;
                     ballRay[bIncr][ BALL_COL ],;
                     ballRay[bIncr][ BALL_BOX ])
      endif

      * --- Save the current ball row and column.  We will calculate
      * --- the new coordinates using these saved variables.
      cRow := ballRay[bIncr][ BALL_ROW ]
      cCol := ballRay[bIncr][ BALL_COL ]

      * --- Determine the new row coordinate.
      if ballRay[bIncr][BALL_DIR] == DOWN
         * --- If the ball is currently moving down, make sure it is
         * --- not at the bottom of it's range.  If it is, set the
         * --- direction to UP.
         if cRow >= ballRay[bIncr][ BALL_MAX ]
            ballRay[bIncr][BALL_DIR] := UP
         endif
      else
         * --- If the ball is currently moving up, make sure it is
         * --- not at the top of it's range.  If it is, set the
         * --- direction to DOWN.
         if cRow <= ballRay[bIncr][ BALL_MIN ]
            ballRay[bIncr][BALL_DIR] := DOWN
         endif
      endif
   
      * --- Set the ball row, based on current ball direction.
      cRow += if( ballRay[bIncr][BALL_DIR] == DOWN, 1, -1 )
   
      * --- Increment the ball column.  If it is greater than 79, ( the
      * --- right side of the screen), re-set it to 0.
      cCol++
      if cCol > 79
         cCol := 0
      endif
   
      /*
      This block of code determines if another ball already is sitting on
      the current location.  If there is another ball, we don't want to
      save the screen because it will be that other ball.  This would have
      the effect of leaving a ball on the screen at points where balls
      hit each other.
      */

      rOne :=  aScan( ballRay, { |x| x[BALL_ROW] == cRow .and. x[BALL_COL] == cCol } )

      ballRay[bIncr][ BALL_ROW ] := cRow
      ballRay[bIncr][ BALL_COL ] := cCol

      if rOne > 0
         /* 
         Already a ball at this spot, so set this balls saved box image
         equal to the other ball's saved image.  Otherwise we are saving
         the image of the ball already there.
         */
         ballRay[bIncr][ BALL_BOX ] := ballRay[rOne][ BALL_BOX ]
      else
         /*
         Save the screen image of the new ball position. 
         */
         ballRay[bIncr][ BALL_BOX ] := saveScreen( ballRay[bIncr][ BALL_ROW ],;
                                                   ballRay[bIncr][ BALL_COL ],;
                                                   ballRay[bIncr][ BALL_ROW ],;
                                                   ballRay[bIncr][ BALL_COL ] )
      endif      
      * --- Display the ball.
      @ ballRay[bIncr][ BALL_ROW ],ballRay[bIncr][ BALL_COL ] say ballRay[bIncr][ BALL_CHAR ]
   endif
return( NIL )
* -------------------------------------------------------------------------- *
*
* -------------------------------------------------------------------------- *
function createBall( minRow, maxRow, iChar )
   /*
   bounceBall( int )

   Purpose    : Creates a ball.  Adds the definition to the ballRay array.

   Parameters : minRow  - integer  [ Top row of bouncing ball range ]
                maxRow  - integer  [ Bottom row of ball range ]
                iChar   - character [ Ball character ]
   
   Returns    : box handle ( integer )
   */
   local bHand := len( ballRay ) + 1
   aadd( ballRay, { minRow - 1, maxRow - 1, iChar, 0, '',minRow, maxRow, bHand } )
return( bHand )
* -------------------------------------------------------------------------- *
*
* -------------------------------------------------------------------------- *
function killBall( bHand )
   /*
   killBall( int )

   Purpose    : Deletes a ball.

   Parameters : bHand  - integer value that represents a ball handle
                returned by function createBall ( see it above ).

   
   Returns    : NIL

   */
   local bIncr := aScan( ballRay, {|x| x[BALL_HAND] == bHand } )

   if bIncr > 0
      * --- It was a valid ball...

      if len( ballRay[bIncr][ BALL_BOX ] ) > 0
         * --- If there is an associated screen segment, restore it.
         restScreen( ballRay[bIncr][ BALL_ROW ],;
                     ballRay[bIncr][ BALL_COL ],;
                     ballRay[bIncr][ BALL_ROW ],;
                     ballRay[bIncr][ BALL_COL ],;
                     ballRay[bIncr][ BALL_BOX ])

      endif

      * --- Delete the ball from the ballRay array.
      aDel( ballRay, bIncr )

      * --- Re-size the ballRay array.
      aSize( ballRay, len( ballRay ) - 1 )
   endif
return( NIL )
* -------------------------------------------------------------------------- *
* 
* -------------------------------------------------------------------------- *
function showMsg()
   qout( 'This is kind of a stupid little utility which puts up' )
   qout( 'bouncing balls on the screen.  The idea comes from' )
   qout( 'an old memory resident shareware program called ')
   qout( 'faces.com which I always thought was kind of neat.')
   qout( '' )
   qout( 'This could be used as a diversion for your users while' )
   qout( 'your program is doing any sort of iterative task, such')
   qout( 'as printing, sorting, or even indexing.' )
   qout( '' )
   qout( 'Feel free to use or modify this anyway you see fit.' )
   qout( 'One possible extension would be to add a color' )
   qout( 'parameter to the createBall function.' )
   qout( '' )
   qout( 'You could also modify this to accept and bounce strings' )
   qout( "longer than 1 character.  You could bounce the client's" )
   qout( 'company name, or your name ( if you are vain ).' )
   qout( '' )
   qout( 'I hope it provides you with hours of enjoyment.  However,' )
   qout( 'if it does, you need to get out more...' )
   qout( 'Press any key to see this dazzling function in action...' )
   inkey(0)
   scroll()
return( NIL )
* -------------------------------------------------------------------------- *
* Eof Ball.prg
* -------------------------------------------------------------------------- *

