
//=============================================================
//====================[ SYSTEM : Automem ]=====================
//=============================================================

/*  
    AUTHOR: Kim Taulbee  [CS: 71021,3340]
    Copyright (c) 1992, Intelligent Software Solutions, All Rights Reserved.


    AutoClear( <Array> )  
	 Populate array with empty variables identical to field list of
	 currently selected work area.

    AutoStore( <Array> )
	 Populate array with contents of current record in current work area.

    AutoReplace( <Array> )
	 Replace fields in current record with contents of Array.

    AutoAppend( <Array> )
	 Append new record and populate with contents of Array.  AutoAppend
	 will try to find a blank record to use before appending a blank.

    AutoBlank()
	 Clear the contents of current record.

    AutoPack()
	 Clear the contents of each record marked for deletion in SELECTed
	 database.  Cleared records are then RECALLed.  This provides an
	 easy way to avoid using PACK.  You can clear and re-use deleted
	 records instead of PACKing the database.

*/



//-------------------------------------   
FUNCTION AutoClear( aM )
   // Create blank aMemvars from open dbf   
   LOCAL i 
   LOCAL nSaveRec := RECNO()   
   DBGOTO(0)
   ASIZE( aM, FCOUNT() )
   FOR i := 1 TO LEN( aM )
      aM[i] := FIELDGET(i)    
   NEXT
   DBGOTO( nSaveRec )    
   RETURN( NIL )
 
//-------------------------------------    
FUNCTION AutoStore( aM )
   // Store field data to amemvars   
   LOCAL i 
   ASIZE( aM, FCOUNT() )
   FOR i := 1 TO LEN( aM )
      aM[i] := FIELDGET(i)    
   NEXT
   RETURN( NIL )

//-------------------------------------     
FUNCTION AutoReplace( aM )     
   // Replace fields in current record with automemvars.
   LOCAL i := 0
   ASIZE( aM, FCOUNT() )
   FOR i := 1 TO LEN( aM )
      FIELDPUT(i, aM[i] )    
   NEXT   
   RETURN( NIL )
 
//-------------------------------------
FUNCTION AutoAppend( aM )
   // Append blank and Replace fields with automemvars  
   // Use empty records if they exist
   LOCAL i
   LOCAL lAppend := .F.
   DBGOTOP()  
   FOR i := 1 TO FCOUNT()
      IF ! EMPTY( FIELDGET(i) )    
	 lAppend := .T.
	 EXIT
      ENDIF
   NEXT    
   IF lAppend .OR. EOF() .OR. BOF() 
      DBAPPEND()
   ENDIF
   AutoReplace( aM )
   RETURN( NIL )

//-------------------------------------
FUNCTION AutoBlank()
   LOCAL aTemp := {}
   AutoClear( @aTemp )
   AutoReplace( aTemp )
   RETURN( NIL )

//-------------------------------------
FUNCTION AutoPack()
   /* Pseudo-pack function. Finds records marked for deletion,
      clears all fields, then recalls record.  This makes records 
      available for reuse by AutoAppend() and avoids using PACK. 
      It tends to be a little slow, I'm open to suggestions. */  

   LOCAL aTemp := {}
   AutoClear( @aTemp )
   DBGOTOP()
   WHILE !EOF()
      IF DELETED()
	 AutoReplace( aTemp )
	 RECALL
      ENDIF
      DBSKIP(1)
   ENDDO
   RETURN( NIL )


//==========================================================
//================[ END SYSTEM : Automem ]==================
//==========================================================


