/*	mplx.c	Copyright 1991 Code Craft Software - All rights reserved
 * A multiplex isr for Clipper summer '87
 * This is used to get the status of Clipper's internal typeahead key buffer.
 * It will return 0 if typeahead buffer is empty, 1 if not.
 *
 * To use from Clipper application:
	hk2f()	&& to hook the int 2Fh handler
	*	do the rest of your application
	terminate()

	FUNCTION TERMINATE	
	unhk2f()	&& to unhook the int 2Fh handler
	quit
 	* end function terminate
	If you have more than one exit point in your application, have them all
	call terminate().  If you don't unhook your machine will lock up!	*/

#include "nandef.h"
#include "extend.h"
#define _CDECL
void (_CDECL interrupt far * _CDECL _dos_getvect(unsigned))();
void _CDECL _dos_setvect(unsigned, void (_CDECL interrupt far *)());
typedef struct {unsigned char hregs[1];} HREGS;

static void interrupt newint2f(HREGS);
static void (_CDECL interrupt far *oldint2f)(void);
extern int _ikey;
static int far *onptr, *offptr;

CLIPPER HK2F()
{
	oldint2f = _dos_getvect(0x2F);
	_dos_setvect(0x2F, newint2f);
	*onptr = &_ikey + 0x14;
	*offptr = &_ikey + 0x16;
}

CLIPPER UNHK2F()
{
	_dos_setvect(0x2f, oldint2f);
}

static void interrupt far newint2f(HREGS h)
{
#define _AL	h.hregs[18]
#define _AH	h.hregs[19]

	unsigned char ah, al;

	ah = _AH;
	al = _AL;
	if (ah == 0xCF)	{		/*	our id?				*/
		if (al == 0)         /*	id check request	*/
			al = 0xFF;        /*	say we're here		*/
		else	{
			if (al == 1)		{	/*	keyboard status request	*/
				if (*onptr+1 == *offptr)
					al = 0;
				else
					al = 1;
			}
			else
				al = 0xEE;			/*	unknown request			*/
		}
	}
	_AL = al;
}
