***********************************************************************
*  Scrolbar.prg
*  Implements a scroll bar that can be updated as the cursor moves down
*  in a TBrowse object, ACHOICE(), DBEDIT(), or MEMOEDIT().
*
*  Copyright (c) 1990, Nantucket Corp.  All rights reserved.
*  David R. Allison
*
* UPDATED BY: KRAIG KRIST/T BEAR COMPUTER SERVICES
*       WHEN: APRIL 1993
*        WHY: ADD COMMENTS AND ENHANCE.
***********************************************************************
#INCLUDE "FILEMAN.CH"
***********************************************************************
*  Create a new scroll bar array with the specified coordinates
***********************************************************************
FUNCTION SCROLLBARNEW(nTOPROW,nTOPCOLUMN,nBOTTOMROW,cCOLORSTRING,;
                      nINITPOSITION)
  MEMVAR aSCROLLBAR
  aSCROLLBAR := ARRAY(TB_ELEMENTS)
  aSCROLLBAR[TB_ROWTOP] := nTOPROW
  aSCROLLBAR[TB_COLTOP] := nTOPCOLUMN
  aSCROLLBAR[TB_ROWBOTTOM] := nBOTTOMROW
  aSCROLLBAR[TB_COLBOTTOM] := nTOPCOLUMN
***********************************************************************
*  Set the default color to White on Black if none specified
***********************************************************************
  IF cCOLORSTRING == NIL
    cCOLORSTRING := "W/N"
  ENDIF
  aSCROLLBAR[TB_COLOR] := cCOLORSTRING
***********************************************************************
*  Set the starting position
***********************************************************************
  IF nINITPOSITION == NIL
    nINITPOSITION := 1
  ENDIF
  aSCROLLBAR[TB_POSITION] := nINITPOSITION
RETURN(NIL)
***********************************************************************
*  FUNCTION SCROLLBARDISPLAY
***********************************************************************
FUNCTION SCROLLBARDISPLAY()
  MEMVAR aSCROLLBAR
  LOCAL cOLDCOLOR, nROW
  cOLDCOLOR := SETCOLOR(aSCROLLBAR[TB_COLOR])
***********************************************************************
*  Draw the background
***********************************************************************
  FOR nROW := (aSCROLLBAR[TB_ROWTOP]+1) TO (aSCROLLBAR[TB_ROWBOTTOM]-1)
    @ nROW, aSCROLLBAR[TB_COLTOP] SAY TB_BACKGROUND
  NEXT
  SETCOLOR(cOLDCOLOR)
RETURN(NIL)
***********************************************************************
*  FUNCTION SCROLLBARUPDATE
***********************************************************************
*  Update scroll bar array with new tab position and redisplay tab
***********************************************************************
FUNCTION SCROLLBARUPDATE(nCURRENT,nTOTAL,lFORCEUPDATE)
  MEMVAR aSCROLLBAR
  LOCAL cOLDCOLOR, nNEWPOSITION
  LOCAL nSCROLLHEIGHT := (aSCROLLBAR[TB_ROWBOTTOM]-1) -;
        (aSCROLLBAR[TB_ROWTOP])
  IF nTOTAL < 1
    nTOTAL := 1
  ENDIF
  IF nCURRENT < 1
    nCURRENT := 1
  ENDIF
  IF nCURRENT > nTOTAL
    nCURRENT := nTOTAL
  ENDIF
  IF lFORCEUPDATE == NIL
    lFORCEUPDATE := .F.
  ENDIF
  cOLDCOLOR := SETCOLOR(aSCROLLBAR[TB_COLOR])
***********************************************************************
*  Determine the new position
***********************************************************************
  nNEWPOSITION := ROUND((nCURRENT/nTOTAL) * nSCROLLHEIGHT,0)
***********************************************************************
*  Resolve algorythm oversights
***********************************************************************
  nNEWPOSITION := IF(nNEWPOSITION < 1,1,nNEWPOSITION)
  nNEWPOSITION := IF(nCURRENT == 1,1,nNEWPOSITION)
  nNEWPOSITION := IF(nCURRENT >= nTOTAL,nSCROLLHEIGHT,nNEWPOSITION)
***********************************************************************
*  Overwrite the old position (if different), then draw in the new one
***********************************************************************
  IF nNEWPOSITION <> aSCROLLBAR[TB_POSITION] .OR. lFORCEUPDATE
    @ (aSCROLLBAR[TB_POSITION] + aSCROLLBAR[TB_ROWTOP]), ;
       aSCROLLBAR[TB_COLTOP] SAY TB_BACKGROUND
    @ (nNEWPOSITION+aSCROLLBAR[TB_ROWTOP]),aSCROLLBAR[TB_COLTOP] SAY;
      TB_HIGHLIGHT
    aSCROLLBAR[TB_POSITION] := nNEWPOSITION
  ENDIF
  SETCOLOR(cOLDCOLOR)
RETURN(NIL)
