/*
	DEMO30.PRG
    Demonstration of the ADLIB's UI Functions.
    COPYRIGHT Angelito Dizon, 1992.  All Rights Reserved 

    To compile and link this example, run either of these batch files:

        CB demo30 if you use BLINKER
        CR demo30 if you use RTLINK

    Make sure your environmental LIB and INCLUDE variables are
    properly set, and CLIPPER.EXE, BLINKER.EXE and RTLINK.EXE are in your
    DOS path.
*/

#include "adlib.ch"


//---------
func main()
local aMainMenu := { "GetRead", "Picklist", "Taglist", "AlertBox", "DbfBrowser", "ProgInfo", "Quit"  }
local aMainBlocks := {;
                        {|e,c,p,nRow,nCol| Xgetread( nRow, nCol ) },;
                        {|e,c,p,nRow,nCol| Xpicklist( nRow, nCol ) },;
                        {|e,c,p,nRow,nCol| Xtagfiles( nRow, nCol ) },;
                        {|e,c,p,nRow,nCol| Xalertbox( nRow, nCol ) },;
                        {|e,c,p,nRow,nCol| Xbrowse( nRow, nCol ) },;
                        {|e,c,p,nRow,nCol| Xproginfo( nRow, nCol ) },;
                        {|e,c,p,nRow,nCol| if( ADpd_yesno( nRow, nCol, "QUIT" ), Xmsg_exit(), .f. ) };
                     }

ADset_help( "DEMO" )
ADcls( "" )
Xmsg_entry()
ADpdmenu( aMainMenu, aMainBlocks, { 1,2,3,4,5,6,7 }, { 1,1,1,1,1,5,1 }, "MAIN" )
return nil


//--------------------------
func Xgetread( nRow, nCol )
static pd
local aMenu := { "READ Replacement", "Generic One-Get", "Generic Many-Gets" }
local aBlock := {;
                    {|e,c,p| Xread(), .f.},;
                    {|e,c,p| Xget1(), .f.},;
                    {|e,c,p| Xgetm(), .f.};
                }
if pd = nil
    pd = ADpd_create()
    ADvm_init( pd, aMenu, nRow, nCol, { 1, 9, 9}, "GETREAD" )
endif

ADvm_go( pd, aBlock )
return .f.


//---------
func Xread()
local getlist[0], aScn, aScn2
local aLButtons   // array of user-defined mouse left button hot spots
local bLBHandler  // user-defined mouse left button handler
local aUserConfig // array of user-defined configurations
local cFuncName := "ADread()"
local cDescribe := "Mouseable and configurable replacement of " +;
                   "the READ command or READMODAL() function. " +;
                   "Automatically expands long character and memo " +;
                   "Gets to MEMOEDITs."
local lMouse := .t.

aScn = ADbox( 9,8,13,53 )
aScn2 = ADbox( maxrow()-1, 0, maxrow(), maxcol(),, "      ", .f., .f. )
ADsay( 9, 10, "[-][?][]" )     // mouse icons
@10,10 say "Function name" adget cFuncname
@11,10 say "Description" adget cDescribe picture "@S30"
@12,10 say "Mouseable?" adget lMouse picture "Y"
aLButtons = { { 9,10,9,18 } }   // corresponds to the mouse icons
bLBhandler = {|e,c,p,nth,mRow,mCol| Xlbhandler(e,mRow,mCol,"READ" )}
aUserConfig = {;
                { R_LBUTTONS, aLButtons },;
                { R_LBHANDLER, bLBHandler },;
                { R_MOVEBLOCK, {|e,c,p| Xmove(p)} },;
                { R_EXITBLOCK, {|e,c,p| Xexit(e,p)} };
              }
ADread( getlist, { "READ", "READ:EXPAND" },, aUserConfig )
ADrestscn( aScn )
ADrestscn( aScn2 )
return nil


//-------------------------------------
func Xlbhandler( e,mRow,mCol, cHelpId )
ADm_rwait()     // waits for mouse button to be released

if mCol >= 10 .and. mCol <= 12      // [-]
    ADr_save()
    return EXIT_READ    // #defined in ADLIB.CH as .T.
elseif mCol >= 13 .and. mCol <= 15  // [?]
    ADhelp( cHelpId )
elseif mCol >= 16 .and. mCol <= 18  // []
    ADr_expand()
endif
return CONTINUE_READ    // #defined in ADLIB.CH as .F.


//-------------
func Xmove( p )
local nCursor := setcursor(0)
local nRow := row(), nCol := col()
local nthGet := p[PKREAD_NTHGET]

ADsay( maxrow(), 0, space( maxcol() + 1 ) )

if nthGet = 1
    ADcsay( maxrow(), 0, maxcol(), "This is the function name." )
elseif nthGet = 2
    ADcsay( maxrow(), 0, maxcol(), "Here are some of ADread()'s features." )
elseif nthGet = 3
    ADcsay( maxrow(), 0, maxcol(), "Yes, ADread() is mouseable!" )
endif

setpos( nRow, nCol )
setcursor( nCursor )
return nil


//------------
func Xexit(e,p)
local lUpdated := ascan( p[PKREAD_UPDATED], .t. ) > 0

if ADr_abandoned(e)
    if lUpdated
        return ADboxmenu( "Abandon changes?", { "No", "Yes" } ) = 2
    endif
else
    if !lUpdated
        return ADboxmenu( "Nothing was done yet!", { "Return", "Abandon" } ) = 2
    endif
endif

return .t.


//-----------
func Xget1()
local cVar := "ADLIB Clipper 5.01 Library"

ADget1( "Label", @cVar,,,,, { "GET1" } )
return nil


//-----------
func Xgetm()
local cOne := "one"
local cTwo := "two"
local cThree := "three"
local cFour := "four"
local cFive := "five"
local cSix := "six"
local cSeven := "seven"
local cEight := "eight"
local cNine := "nine"
local cTen := "ten"
local aLabels := { "Uno", "Dos", "Tres", "Quatro", "Cinco", "Seis", "Siete", "Otso", "Nueve", "Diez" }
local aVars := { cOne, cTwo, cThree, cFour, cFive, cSix, cSeven, cEight, cNine, cTen }

ADgetm2( aLabels, aVars,,,,,, { "GETM" }, "Sample Editor" )
return nil



//--------------------------
func Xpicklist( nRow, nCol )
#define ROW p[PKVM_ROW] + 1
#define COL p[PKVM_LEFT] + 3
static pd
local aMenu := { "Files", "Directories", "driVes" }
local aBlock := {;
                    {|e,c,p| Xpickfiles(e,c,p,ROW,COL)},;
                    {|e,c,p,_x| ADpl_dir( @_x,ROW,COL, "PL_FILE/DIR/DRIVE" ), ADvm_kill( _x ), .f.},;
                    {|e,c,p,_x| ADpl_drive( @_x,ROW,COL, "PL_FILE/DIR/DRIVE" ), ADvm_kill( _x ), .f.};
                }

if pd = nil
    pd = ADpd_create()
    ADvm_init( pd, aMenu, nRow, nCol, {1,1,4}, "PICKLIST" )
endif

ADvm_go( pd, aBlock )
#undef ROW
#undef COL
return .f.


//--------------------------------
func Xpickfiles(e,c,p, nRow, nCol)
local nVMEngine
local aSpecs
local bNoMatch := {|| ADmessage( { "NO " + alltrim( aSpecs[1] ) + alltrim( aSpecs[2] ) + " Files" } )}

do while .t.
    aSpecs := Xfilespec()

    if aSpecs = nil
        exit
    else
        ADpl_file( @nVMEngine, nRow, nCol, "PL_FILE/DIR/DRIVE", alltrim( aSpecs[1] ), alltrim( aSpecs[2] ),, aSpecs[3], at( aSpecs[4], "NBSD" ), bNoMatch )
        ADvm_kill( nVMEngine )
        nVMEngine = nil
    endif
enddo
return .f.


//--------------
func Xfilespec()
static aGets
local aLabels := {;
                    "Directory",;
                    "File Pattern",;
                    "Format",;
                    "Sort Order";
                 }
local aPics := { "@!", "@!", "@!", "!" }
local aValids := { ,,, {|e,c,p|ADr_varget() $ "NBSD" } }
local lAgain := .t.

if aGets = nil
    aGets = { space(60), "       *.DOC", "SDTB", "N" }
endif

if ADgetm2( aLabels, aGets, aPics, aValids,,,, { "FILESPEC", "FILESPEC:EXP" }, "File Specs" ) = ERX_ABORT
    return nil
endif
return aGets


//-------------------------
func Xtagfiles( nRow, nCol )
static pd
local aMenu := { "Mark any number of files",;
                 "Mark exactly 3 files using [1], [2], and [3]" }
local aBlock := {;
                    {|e,c,p| Xtf(e,c,p)},;
                    {|e,c,p| Xtf(e,c,p)};
                }
if pd = nil
    pd = ADpd_create()
    ADvm_init( pd, aMenu, nRow, nCol, {1,1,4}, "TAGLIST" )
endif

ADvm_go( pd, aBlock )
return .f.


//-------------
func Xtf(e,c,p)
local nVMEngine, aConfig := ADvm_defaults()
#define SEL p[PKVM_CURRENT]
#define ROW p[PKVM_ROW] + 1
#define COL p[PKVM_LEFT] + 3

aConfig[VM_MULTI] = .t.

if SEL = 1
    ADpl_file( @nVMEngine, ROW, COL, "TAGLIST:MANY",,,,,,, aConfig )
else
    aConfig[VM_TAGMARK] = "123"
    aConfig[VM_SELBLOCK] = {|e,c,p| Xtf_exit(e,c,p)}
    ADpl_file( @nVMEngine, ROW, COL, "TAGLIST:123",,,,,,, aConfig )
endif


ADvm_kill( nVMEngine )
#undef SEL
#undef ROW
#undef COL
return .f.


//---------------------
func Xtf_exit( e, c, p )
#define TAGGED p[PKVM_ATAGGED]

if .not. ( ( ADamatch( TAGGED, "1" ) == 1 ) .and.;
           ( ADamatch( TAGGED, "2" ) == 1 ) .and.;
           ( ADamatch( TAGGED, "3" ) == 1 ) )
    ADmessage( { "Exactly 3 files must be marked using '1', '2' and '3'", ;
                  "with no mark duplication" } )
    return .f.
endif

#undef TAGGED
return .t.


//--------------------------
func Xalertbox( nRow, nCol )
static pd
local aMenu := { "1-Option" , "2-Options", "3-Options", "6-Options" }
local aBlock := {;
                    {|e,c,p| ADboxmenu( "ALERT", { "OK" },,,, "ALERTBOX:OPTION" ), .f.},;
                    {|e,c,p| ADboxmenu( "Yes or No", { "Yes", "No" },,,, "ALERTBOX:OPTION" ), .f.},;
                    {|e,c,p| X3option(e,c,p), .f.},;
                    {|e,c,p| ADboxmenu( "Select One", { "1", "2", "3", "4", "5", "6" },,,, "ALERTBOX:OPTION" ), .f.};
                }

if pd = nil
    pd = ADpd_create()
    ADvm_init( pd, aMenu, nRow, nCol,,"ALERTBOX" )
endif

ADvm_go( pd, aBlock )
return .f.


//------------------
func X3option(e,c,p)
local aConfig := ADbm_defaults()

aConfig[BM_SELBLOCK] = {|e,c,p| X3sel(e,c,p)}
ADboxmenu( "Exit This Menu?", { "Yes", "No", "Maybe" },,,, "ALERTBOX:OPTION", aConfig )
return nil


//--------------
func X3sel(e,c,p)
#define SEL p[PKBM_CURRENT]

if SEL = 1
    return .t.
elseif SEL = 3
    ADmessage( { "You have to make up your mind!",;
                 "Actually, 'Yes' is the only choice you have (grin!)" } )
endif    

#undef SEL
return .f.


//------------------------
func Xbrowse( nRow, nCol )
static aDbf, nEngine
local aConfig := ADvm_defaults()

if aDbf = nil
    aDbf = array( len( directory( "*.DBF" ) ) )
    afill( aDbf, {,} )  // { alias(), nEVEngine }
endif

if nEngine = nil
    aConfig[VM_LREXIT] = .t.
    aConfig[VM_FRAME] = PDFRAME21
    aConfig[VM_SELBLOCK] = {|e,c,p|Xbrdbf(e,c,p, aDbf)}
    ADpl_file( @nEngine, nRow, nCol, "DBFBROWSER",, "*.DBF",, "B",,, aConfig )
else
    ADplfil_again( nEngine )
endif
return .f.

//---------------------
func Xbrdbf(e,c,p, aDbf)
#define DBF ADvm_menu( e )[p[PKVM_CURRENT]]
local nthEngine, dv

dbusearea( .t.,, DBF, )
nthEngine = ascan( aDbf, {|x| x[1] == alias()} )

if nthEngine = 0
    dv = ADbrowse( { "BROWSE", "BROWSE:EXPAND", "BROWSE:EDIT", "BROWSE:EDIT:EXPAND", "BROWSE:ADD", "BROWSE:ADD:EXPAND" } )
    aadd( aDbf, { alias(), dv } )
else
    ADb_again( aDbf[nthEngine][2] )
endif

dbclosearea()
#undef DBF
return .f.

//------------------------
func Xproginfo( nRow, nCol )
static pd
local aMenu := { "Memory", "File Handles", "Command Line" }
local aBlock := {;
                    {|e,c,p| ADmemory(),.f.},;
                    {|e,c,p| ADmessage( { "Available Dos File Handles: " + ADn2s( ADnHandles() ) } ), .f.},;
                    {|e,c,p| Xcommline(e,c,p), .f.};
                }
if pd = nil
    pd = ADpd_create()
    ADvm_init( pd, aMenu, nRow, nCol,, "PROGINFO" )
endif

ADvm_go( pd, aBlock )
return .f.

//------------------
func Xcommline(e,c,p)
local n := ADpcount()
local xx, a := { "Command Path:        " + ADprogpath(),;
                 "Command Name:        " + ADprogname(),;
                 "Number of Arguments: " + ADn2s( n ) }

for xx = 1 to n
    aadd( a, "                   : " + ADpname(xx) )
next

ADmessage( a )
return nil




//---------------
func Xmsg_entry()
ADmessage( {;
                "ADLIB Mouseable and Configurable User Interface Functions",;
                "  COPYRIGHT Angelito Dizon, 1992.  All Rights Reserved.",; 
                "",;
                "All the ADLIB UI functions are mouseable.  Generally, the",;
                "left button is used to select from a group of mouse icons,",;
                "while the right button is used to abort.  [?] is the Help",;
                "icon, similar to the [F1] key.",;
                "",;
                "This demo is supplied with context-sensitive Help.  Use this",;
                "feature to give you more insight on the ADLIB modules that",;
                "were used to bring this Demo about.",;
                "";
           } ) 
return nil


//--------------
func Xmsg_exit()
ADmessage( {;
                "If you were impressed with the demonstration, you might want",;
                "to examine the source code, DEMO30.PRG.  You may also want to",;
                "study the numerous ready to compile/link/run examples in the",;
                "various *.DOC files included in this package.",;
                "",;
                "ADLIB is copyrighted material and I reserve all rights to",;
                "myself.  But you may freely use the contents of this package",;
                "in any way you want, except make any changes on any part of it.",;
                "",;
                "I will appreciate any comments from you.  I may be contacted",;
                "through (703)569-4680, or leave a message in the BBS you got",;
                "this from.",;
                "";
           } ) 
return .t.

