/***
* TEST.PRG file
* First Class' classes collection
*
* (c) 1994 Grupo EIDOS
*
* Helio Yago
*/

/***
*  @..FCGET
*
* Adding new features to GET class with First Class
*
*  RIGHT -> To right read.
*  LEFT  -> To left read.
*  TO    -> To specify a self defined filling character.
*           If not, uses the default one ( look at FcGet source ).
*  FIX   -> Filling characters are not removed after the READ operation.
*
*/

#command @ <row>, <col> FCGET       <var>                               ;
                        [PICTURE    <pic>     ]                         ;
                        [VALID      <valid>   ]                         ;
                        [WHEN       <when>    ]                         ;
                        [SEND       <msg>     ]                         ;
                        [COLOR      <color>   ]                         ;
                        [<lright:   RIGHT>    ]                         ;
                        [<lleft:    LEFT>     ]                         ;
                        [TO         <chr>     ]                         ;
                        [<fix:      FIX>      ]                         ;
    => AAdd( GetList                                                  , ;
             FcGet():New( <row> , <col>                               , ;
             { | x | IIF( pCount() == 0 , <var> , <var> := x ) }      , ;
             <(var)> , <pic> , <color> , <{valid}> , <{when}> , .T.   , ;
             <.lright.> , <.lleft.> , <chr> , <.fix.> ) )      ;
             [; ATail(GetList):<msg>]

/***
*   @..SAY..FCGET
*/

#command @ <row>, <col> SAY <sayxpr>                                    ;
                        [<sayClauses,...>]                              ;
                        FCGET <var>                                     ;
                        [<getClauses,...>]                              ;
                                                                        ;
      => @ <row>, <col> SAY <sayxpr> [<sayClauses>]                     ;
       ; @ Row(), Col()+1 FCGET <var> [<getClauses>]



/***
*   Fancy FCGETs...
*/

// @..FCGET..RANGE (preprocessed to @..GET..VALID)

#command @ <row>, <col> FCGET <var>                                     ;
                        [<clauses,...>]                                 ;
                        RANGE <lo>, <hi>                                ;
                        [<moreClauses,...>]                             ;
                                                                        ;
      => @ <row>, <col> FCGET <var>                                     ;
                        [<clauses>]                                     ;
                        VALID {|_1| RangeCheck(_1,, <lo>, <hi>)}        ;
                        [<moreClauses>]

/***
*  FCREAD
*
* FCGET uses an internal buffer variable in way to allow direct edition
* of fields ( for example ).
*
* The new method added to FCGET class is called Update(). This function
* updates the variable/field edited with the result of edition and
* vice versa.
*
* FCREAD allows the execution of the Update() method of all gets in
* GetList depending on the result of an UDF.
*
*/

#command FCREAD CONFIRM WITH <func>                                     ;
      => ReadModal(GetList)                                             ;
            ;WHILE .T.                                                  ;
                ;IF <func>                                              ;
                   ;AEval( GetList , { | x | x:Update( .T. ) } )        ;
                   ;EXIT                                                ;
                ;ELSE                                                   ;
                   ;AEval( GetList , { | x | x:Update( .F. ) } )        ;
                   ;ReadModal(GetList)                                  ;
                   ;LOOP                                                ;
                ;END IF                                                 ;
            ;END WHILE                                                  ;
            ;GetList := {}                                              ;
