	name	scroll
;
; scroll.asm - routine to scroll a window up or down a specified number
;              of lines.
;
; void scroll(shiftwin *win, int num);
; where window is a structure defined as:
;   typedef struct {
;       int x1, y1, x2, y2;
;       char attr;
;   } shiftwin;
;
; coordinates are 1-relative
; and num is a positive number to scroll up,
; or a negative number to scroll down.
;
; NOTES:  calling this routine with any of the parameters outside legal values
;	  for your type of display will cause unpredictable results.
;	  This routine uses the PC BIOS call to do the scrolling.
;
	dosseg

ifdef	__COMPACT__
	.model	compact
endif
ifdef	__HUGE__
	.model	huge
endif
ifdef	__LARGE__
	.model	large
endif
ifdef	__MEDIUM__
	.model	medium
endif
ifdef	__SMALL__
	.model	small
endif
	.code

_scroll	proc
	push	si
	push	di
	push	bp
	mov	bp,sp

	mov	di,word ptr [bp+8]	;di holds address of window spec
					;[di+0] = x1
					;[di+2] = y1
					;[di+4] = x2
					;[di+6] = y2
					;[di+8] = attr
	mov	ch,byte ptr [di+2]
	dec	ch
	mov	cl,byte ptr [di+0]
	dec	cl
	mov	dh,byte ptr [di+6]
	dec	dh
	mov	dl,byte ptr [di+4]
	dec	dl
	mov	bh,byte ptr [di+8]	;attribute in bh
	mov	ax,word ptr [bp+10]	;count in AX
	cmp	ah,80h
	jc	scroll_up		;negative count is scroll down
scroll_down:
	neg	ax
	mov	ah,07h
	jmp	short do_scroll
scroll_up:
	mov	ah,06
do_scroll:
	int	10h			;do the scroll
	mov	sp,bp
	pop	bp
	pop	di
	pop	si
	ret
_scroll	endp
	public	_scroll
	end
