; Sample of useing a  user_defined_font.  When this program is run "as is", it
;  will  change  every  instance  of  "T"  (capital only) to my name,,, "Tim". 
;  If   you   change   the   code   that  reads  "mov bp,  offset figure2"  to  
;  "mov bp, offset figure1"  below, it  will  make  a "happy face" in place of 
;  every  instance  of  the  letter "T". Don't worry about this affecting your 
;  computer. If you (for example) have a program called "Time", and you have 
;  changed to the new font (the happy face for example), and start the program 
;  at the command line (which will now have the new font in place of the "T"), 
;  your program will still launch as it always had. I didn't add any 
;  original_font check routine to this file, to keep it short, so you will have 
;  to reboot to return to your normal font style. It is possibble  however to 
;  add a routine to save your "original"  font  style  prior  to  running this 
;  program, or..... you can just go into "Windows" if you have it,  and  then  
;  exit  it which will return your font table to it's normal settings.
;-----------------------------------------------------------------------------
;             ** Any questions -> Tim Van Dusen, #73171,261 **
;-----------------------------------------------------------------------------

; The prelimiaries
.model tiny     ; This program only 587 bytes long (I think), so it's "tiny"
.stack 0ffh     ; Lots of "stack"
.code           ; Start the code

; Make sure you are in video mode 3 (text mode)
mov ah,0
mov al,3
int 10h

; BIOS routine to load user defined character font
push cs         ; Address ds and es to code segment
pop ds          ; Tedious, but necessary
push cs
pop es          ; This register "is" used in this routine.
mov ax,1100h    ; BIOS function to load user_specified font 
mov bh,14       ; number of bytes_per_character in table (below)
mov bl,0        ; character generator RAM block 
mov cx,1        ; number of character we are going to change
mov dx,'T'      ; first (only) character we are changeing
push bp         ; address character generation table 
mov bp,offset figure2   ; choose figure1 or figure2, or define own.
jmp over                ; jump over this "data", to not confuse compiler.
;----- Below, is the table that defines the new font. I put it here to help to
;       better relate where the table actually fit into the code. Notice it is 
;       8bits wide, and is 14 bytes  tall. This  translates to one letter that 
;       is 8 pixels wide and 14 pixels tall. If you  make  all  the bits below 
;       into "1" then you will end up with a solid sqaure block which will re-
;       place the letter "T" everytime it's typed. You can experiment, by al-
;       tering 1's and 0's. If you look at the table as a "whole" you can see
;       what the finished font will look like, the ones of course are the for-
;       ground (white) color and the 0's are the background (black).
figure1 db        00000000b     ; A HAPPY FACE replaces normal "T"
        db        00000000b
        db        11100111b
        db        11100111b
        db        00000000b
        db        00111100b
        db        00111100b
        db        00000000b
        db        10000001b
        db        11000011b
        db        01100110b
        db        00111100b
        db        00000000b
        db        00000000b

figure2 db        11111111b     ; MY NAME "Tim" replaces normal "T"
        db        00001000b
        db        00001000b
        db        00001000b
        db        00000000b
        db        00001000b
        db        00001000b
        db        00001000b
        db        00001000b
        db        00000000b
        db        11000011b
        db        10100101b
        db        10011001b
        db        10011001b

over:           ; The above data_in_code is pretty unorthodox but sometimes
                ;  easier for me to read that way..... :)
int 10h
pop bp          ; ANYTIME bp is changed, always push_and_pop it.

; DOS routine to send character to screen
mov dl,'T'      ; Our newly defined font
mov ah,2
int 21h

; pause screen so you can see what the new font will look like
xor ax, ax      ; zero the whole register, though only 'ah' is used here.
int 16h

mov ah,04ch
int 21h
end

; Good Luck !!!!
