%TITLE  "Terminal Emulator with control-code debugging"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	1024

;--------- from AYSNCH.obj
	EXTRN	ComPort:abs

cr		EQU 	13
lf		EQU	10
bd9600		EQU	0e3h
ExitKey		EQU	100

	DATASEG

exitCode	db	0
welcome		db	cr,lf,'Terminal Emulator by Tom Swan',cr,lf
		db	cr,lf,'Configured for 9600 baud.'
		db	cr,lf,'Displays control codes in brackets for debugging'
		db	cr,lf,'an RS232 serial line.'
		db	cr,lf,'>>>>  Press F10 to exit <<<<',cr,lf,lf,0
string		db	80 DUP (?)

	CODESEG

;--------- from ASYNCH.obj
	EXTRN	AsynchInit:proc, AsynchStop:proc, AsynchStat:proc
	EXTRN	AsynchOut:proc, AsynchIn:proc, AsynchInStat:proc
;--------- from KEYBOARD.obj
	EXTRN	KeyWaiting:proc, GetCh:proc
;--------- from BINASC.obj
	EXTRN	BinToAscDec:proc
;--------- from STRIO.obj
	EXTRN	StrWrite:proc

Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax
	mov	di, offset welcome
	call	StrWrite
	mov	ah,0
	mov	al,bd9600
	mov	dx,ComPort
	int	14h
	call	AsynchInit
Emulate:
	call	AsynchInStat
	or	dx,dx
	jz	@@10
	call	AsynchIn
	call	DispChar
	jmp	Emulate
@@10:
	call	KeyWaiting
	jz	Emulate
	call	GetCh
	jnz	@@20
	cmp	al,ExitKey
	je	Exit
@@20:
	call	AsynchOut
	jmp	Emulate
Exit:
	call	AsynchStop
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h

%NEWPAGE
;------------------------------------------------------------------------
; DispChar/OneChar  - display any ASCII value
;------------------------------------------------------------------------
;	Input:   al = ASCII value (0...255)
;	Output:  none
;		NOTE:  control codes are displayed as [13], [10], etc
;			for debugging a serial I/O line.
;       Registers:  ax,cx,dl,di
;------------------------------------------------------------------------
PROC	DispChar
	cmp	al,32
	jae     OneChar
	xor	ah,ah
	mov	cx,1
	mov	di, offset string
	call	BinToAscDec
	mov	al, '['
	call	OneChar
	call	StrWrite
	mov	al, ']'
PROC	OneChar
	mov	dl,al
	mov	ah,2
	int	21h
	ret
ENDP	OneChar

ENDP	DispChar

	END	Start
