%TITLE  "String Input/Output Routines"

	IDEAL
	DOSSEG
	MODEL	small

;----- Equates
BufSize		EQU	255
ASCnull		EQU	0
ASCcr		EQU	13
ASClf		EQU	10

STRUC	StrBuffer
 maxlen		db BufSize
 strlen		db 0
 chars		db BufSize DUP (?)
ENDS strBuffer


	DATASEG

buffer  StrBuffer <>


	CODESEG

;-----  From: STRINGS.OBJ

	EXTRN	StrLength:proc, StrCopy:proc

	PUBLIC	StrRead, StrWrite,StrWrite2,NewLine

%NEWPAGE
;--------------------------------------------------------------------
;  StrRead		Read string with editing keys
;--------------------------------------------------------------------
;	Input:
;		di = address of dest string
;		cl = max string length EXCLUDING null terminator
;		Note: if cl = 0, StrRead does nothing
;		Note: actual variable must be cl + 1 bytes long
;		Note: string length is limited to 255 characters
;	Output:
;		String copied from standard input into your buffer
;	Registers:
;		None
;-------------------------------------------------------------------
PROC	StrRead
	or	cl,cl
	jz	@@99

	push	ax
	push	bx
	push	dx
	push	si

	mov	[buffer.maxlen],cl
	mov	ah,0ah
	mov	dx,OFFSET buffer.maxlen
	int 	21h
	xor	bh,bh
	mov	bl,[buffer.strlen]
	mov	[bx + buffer.chars],ASCnull
	mov	si,OFFSET buffer.chars
	call	StrCopy

	pop	si
	pop	dx
	pop	bx
	pop	ax
@@99:
	ret
ENDP	StrRead
%NEWPAGE
;----------------------------------------------------------------------
;  StrWrite/StrWrite2	Write string to standard output
;----------------------------------------------------------------------
;	Input:
;		di = address of string (s)
;		cx = number of chars to write (StrWrite2 only)
:	Output:
;		string (s) copied to standard output
;
;	Registers:
;		cx (StrWrite only)
;----------------------------------------------------------------------
PROC	StrWrite
	call	StrLength

PROC	StrWrite2
	push	ax
	push	bx
	push	dx

	mov	bx,1
	mov	dx,di
	mov	ah,40h
	int	21h

	pop	dx
	pop	bx
	pop	ax
	ret
ENDP	StrWrite2
ENDP	StrWrite

%NEWPAGE
;----------------------------------------------------------------------
;  Newline	Start new line on standard output file
;----------------------------------------------------------------------
;	Input:
;		none
:	Output:
;		carriage return, line feed sent to standard output
;	Registers:
;		ah,dl
;----------------------------------------------------------------------
PROC	NewLine
	mov	ah,2
	mov	dl,ASCcr
	int	21h
	mov	dl,ASClf
	int	21h
	ret
ENDP	NewLine

	END
