%TITLE "Test Turbo Pascal external *.OBJ module"

	IDEAL
;-------- Data segment combines with Turbo Pascal's global data segment
SEGMENT	DATA 	word 	public

;-------- Import typed constants and variables from Turbo Pascal
	EXTRN	value : WORD, cr : BYTE, lf : BYTE

asmCount	dw	?
ENDS	DATA

;-------- Code segment combines with Turbo Pascal's main program
SEGMENT	CODE	byte	public

ASSUME	cs:CODE, ds:DATA

;--------- Export PUBLIC procedures to Turbo Pascal
	PUBLIC	AsmProc, CountPtr

;--------- Import procedures and functions from Turbo Pascal
	EXTRN	PasProc : NEAR, PasFunc : NEAR

%NEWPAGE
;------------------------------------------------------------------------
;  PROCEDURE asmProc
;------------------------------------------------------------------------
;------------ PreInitialized variables must go in Code segment
testString	db	'asmProc: Should be a "hatch mark" --> ', '$'

PROC	asmProc		NEAR
;------- call a Turbo Pascal procedure
	call	PasProc		; pasProc is in PASDEMO.pas

;------- use local data stored in the code segment
	push	ds
	push	cs
	pop	ds
ASSUME	ds : CODE
	mov	dx,offset testString
	mov	ah,09h
	int	21h
	pop	ds
ASSUME	ds : DATA
;-------- get typed-constants from Turbo Pascal and use local static variables
	mov	ax,[value]
	mov	[asmCount],ax
;-------- call a Turbo Pascal function for a character value
	call	PasFunc
	mov	dl,al
	mov	ah,2
	int	21h
;-------- get variables from Pascal
	mov	ah,2
	mov	dl,[cr]
	int	21h
	mov	dl,[lf]
	int	21h
	ret
ENDP	AsmProc

%NEWPAGE
;------------------------------------------------------------------------
;  FUNCTION CountPtr : intPtr
;------------------------------------------------------------------------
PROC	CountPtr	NEAR
	mov	dx, SEG asmCount
	mov	ax, OFFSET asmCount
	ret
ENDP	CountPtr

ENDS	CODE

	END
