%TITLE "Disk-error Handler"

	IDEAL
	DOSSEG
	MODEL	small

	DATASEG

errString	db	'** ERROR: ',0

err00	db	'Unknown cause',0
err01	db	'Bad function number',0
err02	db	'File not found',0
err03	db	'Path not found',0
err04	db	'TOO many open files',0
err05	db	'Access denied',0
err06	db	'File handle invalid',0
err07	db	'Memory control blocks destroyed',0
err08	db	'Not enough memory for operation',0
err09	db	'Bad memory block address',0
err0A	db	'Bad environment',0
err0B	db	'Bad format',0
err0C	db	'Bad access code',0
err0D	db	'Bad data',0
err0E	db	'Unknown cause, even I dont know everything',0
err0F	db	'Bad disk drive letter',0
err10	db	'Removing current directory is not allowed you fool',0
err11	db	'Device is not the same',0
err12	db	'No more files available',0
err13	db	'Disk is write-protected',0
err14	db	'Unknown unit',0
err15	db	'Disk drive is not ready',0
err16	db	'Unknown command',0
err17	db	'Data (CRC) error',0
err18	db	'Bad structure length',0
err19	db	'Seek error',0
err1A	db	'Unknown type of medium',0
err1B	db	'Sector not found',0
err1C	db	'Printer is out of paper bonehead',0
err1D	db	'Disk write error',0
err1E	db	'Disk read error',0
err1F	db	'General failure',0

errors	DW	err00, err01, err,02, err03, err04, err05, err06, err07
	DW	err08, err09, err,0A, err0B, err0C, err0D, err0E, err0F
	DW	err10, err11, err,12, err13, err14, err15, err16, err17
	DW	err18, err19, err,1A, err1B, err1C, err1D, err1E, err1F


	CODESEG

;----------from STRIO.obj
	EXTRN	NewLine:proc, StrWrite:proc

	PUBLIC	DiskErr

%NEWPAGE
;------------------------------------------------------------------------
;  DiskErr - write disk error message to standard output
;------------------------------------------------------------------------
;	Input: none   (cf = 1  following a DOS file operation)
;       Output: none  (error message displayed)
;       Registers:  ax,bp,bx,cx,dx,di,si changed
;------------------------------------------------------------------------
PROC	DiskErr
	push	ds
	push	es
	mov 	ah,59h
	xor	bx,bx
	int 	21h
	pop	es
	pop	ds
	cmp	ax,1Fh
	jbe	@@10
	xor	ax,ax
@@10:
	shl	ax,1
	mov	bx,ax
	mov	di,[errors + bx]
	push	di
	call	NewLine
	mov	di,offset errString
	call	StrWrite
	pop	di
	call	StrWrite
	call	NewLine
	ret
ENDP	DiskErr

	END
