%TITLE  "Display Character/Attribute Reference"

	IDEAL
	DOSSEG
	MODEL	small
	STACK	256

cr		EQU	13
lf		EQU	10
ChartRow	EQU	7


	DATASEG

exitCode	db	0
welcome		db	'Character attributes -- by Tom Swan',cr,lf
		db	'Rows = background, Columns = foreground',cr,lf
		db	'First char is dim, second char is bright',0
template	db	'    00 01 02 03 04 05 06 07',cr,lf
		db	'00',cr,lf,'01',cr,lf,'02',cr,lf,'03',cr,lf
		db	'04',cr,lf,'05',cr,lf,'06',cr,lf,'07',0
blinkString	db	'This line should be blinking.',0

	CODESEG
;--------- from STRINGS.OBJ & STRIO.OBJ
	EXTRN	StrLength:proc, StrWrite:proc
;--------- from SCREEN.OBJ
	EXTRN	ScInit:proc, ScGotoXY:proc, ScClrRect:proc
	EXTRN	ScPokeChar:proc, ScSetBack:proc, ScSetFore:proc
	EXTRN	ScPokeStr:proc, ScDim:proc, ScBright:proc
	EXTRN	ScBlink:proc, ScNoBlink:proc

Start:
	mov	ax,@data
	mov	ds,ax
	mov	es,ax

	call	ScInit
	call	Setup
	call	Attributes
	call	Blinking

	mov	dh,23
	mov	dl,0
	call	ScGotoXY
Exit:
	mov	ah,04Ch
	mov	al,[exitCode]
	int	21h

PROC	Setup
	mov	ch,0
	mov	cl,0
	mov	dh,24
	mov	dl,79
	call	ScClrRect
	mov	dh,1
	mov	dl,0
	call	ScGotoXY
	mov	di, offset welcome
	call	StrWrite
	mov	dh,ChartRow
	mov	dl,0
	call	ScGotoXY
	mov	di, offset template
	call	StrWrite
	ret
ENDP	Setup

UDATASEG
row		db	?
column	 	db	?
background	db	?
foreground	db	?

CODESEG
PROC	Attributes
	mov	[row], ChartRow
	mov	[background],0
@@10:
	inc	[row]
	mov	al,[background]
	call	ScSetBack
	mov	[column],1
	mov	[foreground],0
@@20:
	add	[column],3
	mov	al,[foreground]
	call	ScSetFore
	call	ScDim
	call	OneChar
	inc	[column]
	call	ScBright
	call	OneChar
	inc	[foreground]
	cmp	[foreground],7
	jbe	@@20
	inc	[background]
	cmp	[background],7
	jbe	@@10
@@99:
	ret
ENDP	Attributes

Proc	OneChar
	mov	dh,[row]
	mov	dl,[column]
	mov	al,'A'
	call	ScPokeChar
	ret
ENDP	OneChar
Proc	Blinking
	mov	al,0
	call	ScSetBack
	mov	al,7
	call	ScSetFore
	call	ScBright
	call	ScBlink
	mov	di,offset blinkString
	call	StrLength
	mov	dh,19
	mov	dl,0
	mov	si, offset blinkString
	call	ScPokeStr
	call	ScNoBlink
	ret
ENDP	Blinking

	END	Start
