;
stdlib		segment	para public 'slcode'
		assume	cs:stdlib
		extrn	sl_malloc:far
;
; Local variables for these routines:
;
astr		db	8 dup (?)
aindex		dw	0
;
; ITOA-	Converts the signed integer value in AX to a string of characters.
;	Returns a pointer to the string in ES:DI.
;	Carry indicates error (set if insufficient room in heap).
;
		public	sl_itoa
sl_itoa		proc	far
		push	ax bx cx dx
		mov	cs:aindex, 0
		cmp	ax, 0
		jge	Doit
		push	ax
		mov	al, '-'
		call	PutIt
		pop	ax
		neg	ax
;
DoIt:		call	puti2
;
; Move the digit string out onto the heap and return a pointer to it in
; es:di.
;
		mov	cx, cs:aindex
		mov	bx, cx			;Save for later.
		inc	cx
		call	sl_malloc               ;Allocate storage for string.
		jc	BadITOA
CopyStrLp:	mov	al, cs:astr[bx]
		mov	es:[di][bx], al
		dec	bx
		jns	CopyStrLp
		clc
		pop	dx cx bx ax
		ret
;
BadITOA:	stc
		pop	dx cx bx ax
		ret
sl_itoa		endp
;
;
; UTOA-	Converts the unsigned integer value in AX to a string of digits
;	and returns a pointer to this string in ES:DI.
;	Carry=0 if no error, 1 if insufficient room on heap.
;
		public	sl_utoa
sl_utoa		proc	far
		push	ax bx cx dx
		mov	cs:aindex, 0
		call	PutI2
;
; Move the digit string out onto the heap and return a pointer to it in
; es:si.
;
		mov	cx, cs:aindex
		mov	bx, cx			;Save for later.
		inc	cx
		call	sl_malloc               ;Allocate storage for string.
		jc	BadUTOA
CopyStrLp2:	mov	al, cs:astr[bx]
		mov	es:[di][bx], al
		dec	bx
		jns	CopyStrLp2
		clc
		pop	dx cx bx ax
		ret
;
BadUTOA:	stc
		pop	dx cx bx ax
		ret
sl_utoa		endp
;
; PutI2- Recursive routine to actually print the value in AX as an integer.
;
Puti2		proc	near
		mov	bx, 10
		xor	dx, dx
		div	bx
		or	ax, ax		;See if ax=0
		jz	Done
		push	dx
		call	Puti2
		pop	dx
Done:		mov	al, dl
		or	al, '0'
		call	PutIt
		ret
PutI2		endp
;
;
; PutIt- Writes the character in AL to the "astr" buffer.  Also zero
; terminates the string and increments aindex.  Note: no need to preserve
; DI here because no one else uses it.
;
PutIt		proc	near
		mov	di, cs:aindex
		mov	cs:astr[di], al
		mov	byte ptr cs:astr+1[di], 0
		inc     cs:aindex
		ret
PutIt		endp
stdlib		ends
		end
