Title  SPEEDER: change system speed by modifying the memory refresh rate

comment !
   SPEEDER v1.0 for the Public Domain
   based on information in Micro Cornucopia, Sept/Oct 1987

         Thomas G Hanlin III
         1712 Maple Hill Pl.
         Alexandria VA 22152

!


Sseg           segment byte stack 'prog'    ; dummy stack segment
Sseg           ends


Cseg           segment byte public 'prog'
               assume         cs:Cseg, ds:Cseg, ss:Sseg

               org            80h
  CMDLEN       db  ?
  CMDINFO      db 127 dup(?)

               org            100h

MAIN           proc           far
               xor            ch,ch
               mov            cl,CMDLEN     ; get parm length
               cmp            cl,2          ; is there a parm?
               jb             Inform        ;   no, give 'em info
               mov            si,offset CMDINFO
               cld
ScanParms:     lodsb                        ; get a command-line char
               cmp            al," "        ; is it a space?
               je             ScanLoop2     ;   yes, ignore it
               cmp            al,"-"        ; slow down?
               je             SlowDown      ;   yes, do it
               cmp            al,"+"        ; speed up?
               je             SpeedUp       ;   yes, do it

Inform:        mov            dx,offset SPEEDERINFO
               mov            ah,9
               int            21h
               int            20h

ScanLoop2:     loop           ScanParms     ;   keep looking for parms
               jmp            Inform        ;   give 'em info

SlowDown:      mov            al,74h        ; access DMA
               out            43h,al
               mov            al,12h        ; lsb of refresh rate
               out            41h,al
               mov            al,0          ; msb of refresh rate
               out            41h,al
               int            20h

SpeedUp:       mov            al,74h        ; access DMA
               out            43h,al
               mov            al,40h        ; lsb of refresh rate
               out            41h,al
               mov            al,0          ; msb of refresh rate
               out            41h,al
               int            20h
MAIN           endp


SPEEDERINFO    db "SPEEDER 1.0 by Tom Hanlin for the Public Domain",13,10
               db "  Purpose: change PC speed by modifying refresh rate.",13,10
               db "  Faster : SPEEDER +",13,10
               db "  Slower : SPEEDER -",13,10,"$"


Cseg           ends
               end            MAIN
