page 60,132
title	SETTEST.ASM  1.00
;--------------------------------------------------------------
;  Program 	: Sets module test program
;  Version	: 1.00
;  System  	: IBM PC-DOS 2.00+
;  Language	: IBM 8088 Macro Assembler
;  Author  	: (C) 1985 by Tom Swan
;  Address	: Swan Software  P.O. Box 206  Lititz PA  17543
;--------------------------------------------------------------
true	equ	-1
false	equ	0
host	equ	true

;----------------------------------------
;	Code, data, stack groups
;----------------------------------------
dgroup	group	dseg
cgroup	group	cseg
sgroup	group	sseg
	assume	cs:cgroup, ds:dgroup, es:dgroup, ss:sgroup

;----------------------------------------
;	Equates
;----------------------------------------
cr	equ	13			;ASCII carriage return
lf	equ	10			;ASCII line feed

;----------------------------------------
;	Macro definitions
;----------------------------------------

; Call dos function p1

dosfn	macro	p1			;;"dosfn 2" calls dos function #2
	mov	ah,p1			;;pass function number in ah
	int	21h			;;call dos via interrupt 21 hex
	endm

; Call sets function

setfn	macro	n			;;"setfn 8" calls sets function #8
	mov	ah,n			;;elect function n
	call	sets			;;call sets package (near)
	endm

;----------------------------------------
;	Data segment
;----------------------------------------
dseg	segment byte public 'data'
progid	db	'Set Test Program 1.00',cr,lf
	db	'(C) 1985 by Tom Swan',cr,lf
crlf	db	cr,lf,'$'
donemsg db	cr,lf,'Test completed',cr,lf,'$'

;----- Test strings.  First byte = length.

s1	db	36,'1234567890abcdefghijklmnopqrstuvwxyz'
s2	db	13,'ACEGIKMOQSUWY'
s3	db	13,'BDFHJLNPRTVXZ'

dseg	ends

;----------------------------------------
;	Stack segment
;----------------------------------------
sseg	segment para stack 'stack'
	db	8 dup('**Stack*')
sseg	ends

;----------------------------------------
;	Code segment
;----------------------------------------
cseg	segment byte public 'code'

	include	sets.ext		;include global declarations

settest	proc	far
	push	ds			;set up far return address on stack
	xor	ax,ax			; equal to ds:0000.
	push	ax
	push	ds			;save value of segment
                                        ; registers ds,es 
	push	es
	mov	ax,dseg			;prepare to load ds,es via ax
	mov	ds,ax			;set ds=data segment address
	mov	es,ax			;set es=data segment address
	lea	dx,progid		;dx=address program id message
	dosfn	9			;print string
	lea	si,s1			;test string 1
	call	test
	lea	si,s2			;test string 2
	call	test
	lea	si,s3			;test string 3
	call	test
	lea	dx,donemsg		;dx=address done message
	dosfn	9			;print string
	pop	es			;restore segment registers es,ds
	pop	ds
	ret				;execute far return to dos
settest endp
page
;----------------------------------------------------------
; PRINT / NEWLINE
;----------------------------------------------------------
; Purpose	-- display test string
;
; Called by	-- test
;
; Calls		-- none
;
; Arguments	-- (ds:si) = address of string at len byte
;
; Registers	-- ax,cx,dx destroyed, si preserved
;----------------------------------------------------------
print	proc	near
	push	si
	cld				;clear df for auto increments
	lodsb				;al <- [ds:si]; si <- si + 1
	xor	cx,cx			;zero cx
	mov	cl,al			;cx = string length 0 .. 255
	jcxz	print2			;exit if length = 0
print1:
	lodsb				;al <- next character from string
	mov	dl,al			;transfer al to dl
	dosfn	2			;print char in dl
	loop	print1			;loop on cx
print2:
	pop	si			;restore si register

;----- Print crlf and return.  Can be called as separate subroutine.
newline:
	lea	dx,crlf			;dx = address cr lf ASCII$ string
	dosfn	9			;print string
	ret				;return to caller
print	endp
page
;----------------------------------------------------------
; TEST
;----------------------------------------------------------
; Purpose	-- perform test -- enter characters until
;		   set of characters typed equals expected
;		   set of characters.  Repeat test if any
;		   extra characters are accidentally typed.
;
; Called by	-- main program
;
; Calls		-- sets
;		   print
;		   report
;
; Arguments	-- (ds:si) = address of test string
;
; Registers	-- ax,cx,dx,di destroyed
;----------------------------------------------------------
dseg	segment byte public 'data'
chset	set<>			;set of characters entered
doneset set<>			;set of characters expected
dseg	ends

test	proc	near
	push	si			;save si in case test repeats
	call	print			;print test string
	lea	di,doneset		;di = address of doneset variable
	setfn	4			;doneset <- set of chars in string
	lea	di,chset		;di = address of chset variable
	setfn	10			;make chset = null set []
	lea	si,doneset		;preset si = address of doneset
test1:
	dosfn	1			;get and echo char (ch in al)
	mov	dl,al			;transfer char to dl
	setfn	8			;insert dl into chset at (di)
	xchg	si,di			;si=chset, di=doneset
	setfn	6			;test for doneset <= chset
	xchg	si,di			;si=doneset, di=chset
	jne	test1			;jump if doneset
                                        ; not a subset of chset

;----- Report results of test, and repeat same test on any errors
	call	report			;check and report results
	pop	si			;restore si register
	jz	test			;repeat test on any errors
	ret				;else end test
test	endp
page
;----------------------------------------------------------
; REPORT
;----------------------------------------------------------
; Purpose	-- report results of test.
;
; Called by	-- test
;
; Calls		-- newline
;		   sets
;
; Arguments	-- doneset (in test dseg) = expected char set
;		   chset (in test dseg) = chars entered
;
; Registers	-- ax,dx,di,si destroyed
;		   zf = 1 if extra chars entered (use jz)
;		   zf = 0 if entry was perfect (use jnz)
;----------------------------------------------------------
dseg	segment byte public 'data'
repmsg	db	'Extra chars = ','$'
noerr	db	'none',cr,lf,'$'
error	db	?
dseg	ends

report	proc	near
	mov	error,false		;error flag = false
	call	newline			;write a blank line
	lea	dx,repmsg		;prepare to print report message
	dosfn	9			;print string
	lea	di,doneset		;di = address of doneset
	lea	si,chset		;si = address of chset
	setfn	2			;doneset <- chset - doneset
	mov	dl,32			;dl = ASCII first char to check
rep1:
	setfn	0			;set membership for value in dl
	jz	rep2			;jump if dl not a member of doneset
	mov	error,true		; else flag the error
	dosfn	2			; and print the extra character
rep2:
	inc	dl			;next char to test
	cmp	dl,128			;loop while dl < 128
	jb	rep1
	lea	dx,noerr		;prepare to print "none" message
	cmp	error,true		;check error flag
	jne	rep3			;jump if no errors detected
	lea	dx,crlf			;print crlf if errors found
rep3:
	dosfn	9			;print ASCII$ string at dx
	call	newline			;write two blank lines
	call	newline
	cmp	error,true		;set flags before returning
	ret				;end test / report
report	endp
cseg	ends				;end of segment
	end	settest			;end program
