; SetVideoMode320x200x256x4

; Sets the VGA video hardware to a 320 pixel wide by 200
; pixel tall graphics mode with 256 colors and 4 pages.

; This is written in Turbo Assembler 2.0's Ideal mode, and may require
; slight changes in order to compile under a different assembler.

Ideal

Model Small, C

CodeSeg

    Public SetVideoMode320x200x256x4

    Proc SetVideoMode320x200x256x4

        mov ax, 0013h                   ; Allow BIOS to set 320x200x256x1
        int 10h                         ;

        mov dx, 3CEh                    ; Tell the Graphics Controller
        mov al, 5                       ; to change the graphics mode
        out dx, al                      ; (register 5) to use linear
        inc dx                          ; addresses instead of seperating
        in al, dx                       ; the odd and even addresses.
        and al, 11101111b               ;
        out dx, al                      ;
        dec dx                          ;

        mov al, 6                       ; Tell the Graphics Controller
        out dx, al                      ; to change the misc. register
        inc dx                          ; (register 6) to use linear
        in al, dx                       ; addresses instead of seperating
        and al, 11111101b               ; the odd and even addresses.
        out dx, al                      ;

        mov dx, 3C4h                    ; Tell the Sequencer Controller
        mov al, 4                       ; to change the memory mode
        out dx, al                      ; (register 4) to disable chain4
        inc dx                          ; mode, and allow linear
        in al, dx                       ; processing on a bitplane.
        and al, 11110111b               ;
        or al, 4                        ;
        out dx, al                      ;

        mov ax, 0A000h                  ; Clear the screen.
        mov es, ax                      ;
        xor di, di                      ;
        mov ax, di                      ;
        mov cx, 8000h                   ;
        rep stosw                       ;

        mov dx, 3D4h                    ; Tell the CRT Controller to
        mov al, 14h                     ; change the underline location
        out dx, al                      ; (register 14h) to turn off
        inc dx                          ; the double word mode.
        in al, dx                       ;
        and al, 10111111b               ;
        out dx, al                      ;
        dec dx                          ;

        mov al, 17h                     ; Tell the CRT Controller to
        out dx, al                      ; change the mode control
        inc dx                          ; (register 17h) to switch
        in al, dx                       ; to byte mode.
        or al, 01000000b                ;
        out dx, al                      ;

        ret

    EndP

EndS

End
