/*
** ioctl types that the driver understands
*/
#define I_FORMAT	'F'
#define I_ERASE		'E'
#define I_REWIND	'R'
#define I_LOAD		'L'
#define I_NOLOAD	'N'
#define I_SPACE		'S'
#define I_FILEMARK	'M'
#define I_REASSIGN	'A'

/*
** definition of the structure to pass to the SCSI driver
**
** This should agree with the 'ioc' struct in 'struct.inc'
*/
struct cmd {
	short command;		/* command type */
	short arg1;			/* command args */
	short arg2;			/* command args */
	short buf_seg;		/* command buffer segment */
	short buf_ofs;		/* command buffer offset */
	short buf_len;		/* command buffer length */
};

/*
** Format Command options types
*/
#define FORMAT_NORMAL (0x00)
#define FORMAT_ADDLBA (0x10)
#define FORMAT_ORIG (0x18)
#define FORMAT_ADDCHI (0x1C)

/*
** Defect List types
*/
#define DEFECT_LBA (1)
#define DEFECT_CHI (2)

#define MAX_DEFECTS (64)

/*
** defect list header
*/
struct defect_header {
	char reserved;		/* reserved */
	char options;		/* format options */
	char dll_msb;		/* defect list length MSB */
	char dll_lsb;		/* defect list length LSB */
};

/*
** defect list entry / block number
*/
struct defect_entry_lba {
	char defect_lba3;	/* defect block address MSB */
	char defect_lba2;
	char defect_lba1;
	char defect_lba0;	/* defect block address LSB */
};

/*
** defect list / block number
*/
struct defects_lba {
	struct defect_header header;
	struct defect_entry_lba list[MAX_DEFECTS];
};

/*
** defect list entry / cyl-head-index
*/
struct defect_entry_chi {
	char defect_cyl2;	/* defect cylinder MSB */
	char defect_cyl1;
	char defect_cyl0;	/* defect cylinder LSB */
	char defect_head;
	char defect_idx3;	/* defect index MSB */
	char defect_idx2;
	char defect_idx1;
	char defect_idx0;	/* defect index LSB */
};

/*
** defect list / chl-head-index
*/
struct defects_chi {
	struct defect_header header;
	struct defect_entry_chi list[MAX_DEFECTS];
};

/*
** remap list header
*/
struct remap_header {
	char reserved;		/* reserved */
	char reserved2;		/* reserved */
	char rll_msb;		/* remap list length MSB */
	char rll_lsb;		/* remap list length LSB */
};

/*
** remap list entry
*/
struct remap_entry {
	char remap_lba3;	/* remap block address MSB */
	char remap_lba2;
	char remap_lba1;
	char remap_lba0;	/* remap block address LSB */
};

/*
** remap list
*/
struct remaps {
	struct remap_header header;
	struct remap_entry list[MAX_DEFECTS];
};
