        TITLE   'For - RxDOS Command Shell For Function'
        PAGE 59, 132
        .LALL

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell For                                      ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This material  was created as a published version  of a DOS  ;
        ;  equivalent product.   This program  logically  functions in  ;
        ;  the same way as  MSDOS functions and it  is  internal  data  ;
        ;  structure compliant with MSDOS 5.0                           ;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1992. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;  508/ 454-4961.                                               ;
        ;                                                               ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Programmer's Notes:                                          ;
        ;                                                               ;
        ;  Command Shell consists of  two parts bound  together into a  ;
        ;  single executable load.  There  exists  a  single  resident  ;
        ;  command shell which is accessible by an Int 2Eh.             ;
        ;                                                               ;
        ;...............................................................;

        include rxdosmac.asm
        include rxdosdef.asm
        include rxdoscin.asm

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell                                          ;
        ;...............................................................;

RxDOSCMD SEGMENT PUBLIC 'CODE'
         assume cs:RxDOSCMD, ds:RxDOSCMD, es:RxDOSCMD, ss:RxDOSCMD

        public _For

        extrn CheckOptOneArg                            : near
        extrn CountArgs                                 : near
        extrn CmndLookup                                : near
        extrn CmndError_SyntaxError                     : near
        extrn CRLF                                      : near
        extrn DisplayErrorMessage                       : near
        extrn DisplayLine                               : near
        extrn DisplayPrompt                             : near
        extrn _CopyString                               : near
        extrn ReplaceForVariables                       : near
        extrn _InternalCommandParser                    : far

        extrn RxDOS_DTA                                 : near
        extrn RxDOS_ForArgs                             : near
        extrn RxDOS_WorkArea                            : near
        extrn _lowerCase                                : near
        extrn _lowerCaseString                          : near

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  FOR %variable IN (set) DO command [command-parameters]       ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Replace %var in command.                                     ;
        ;                                                               ;
        ;...............................................................;

_For:

        Entry
        def __argarray, di
        def __arg
        def __cmdline
        def __endrepeatArg
        def _letter
        def _nArgs
        def _pathSep
        def  _ArgAlloc

        defbytes _commandLine, 128
        defbytes _replacement, 128

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  get variable arg letter 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        call CountArgs                                  ; must have min of 8 args
        cmp ax, 8                                       ; min args 
        jge _For_08                                     ; if at leats 8 -->
        jmp _ForError                                   ; else if less, syntax error -->

_For_08:
        mov si, word ptr [ forVarIdent ][ di ]          ; point to arg
        cmp byte ptr [ si ], '%'                        ; is arg a % variable ?
        ifnz _ForError                                  ; if not, then syntax error -->

        mov al, byte ptr [ si + 1 ]                     ; get letter
        call _lowerCase
        cbw
        storarg _letter, ax

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  check for 'in' argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov si, word ptr [ forInArg ][ di ]             ; point to next arg
        mov di, offset RxDOS_ForArgs
        call CmndLookup                                 ; lookup command
        ifc _ForError                                   ; if not, then syntax error -->

        cmp bx, _IN                                     ; 'in' returns a zero
        ifnz _ForError                                  ; if not 'in', then syntax error -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  check for ( argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        getarg di, __argarray
        add di, forInStartParen + 2
        mov si, word ptr [ di - 2 ]                     ; point to next arg
        cmp byte ptr [ si ], '('                        ; is arg a ( variable ?
        ifnz _ForError                                  ; if not, then syntax error -->

        storarg __arg, di                               ; di points to an argument

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  search for ) do ...
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        dec di
        dec di

_ForSearchForParen:
        inc di
        inc di
        mov si, word ptr [ di ]                         ; point to next arg
        or si, si                                       ; end of args ?
        ifz _ForError                                   ; if not, then syntax error -->

        cmp byte ptr [ si ], ')'                        ; is arg a ) variable ?
        jnz _ForSearchForParen                          ; keep looking -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  search for last ) in case ))) ...
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_ForSearchForDoLastParen:
        inc di
        inc di
        mov si, word ptr [ di ]                         ; point to next arg
        or si, si                                       ; end of args ?
        ifz _ForError                                   ; if not, then syntax error -->

        cmp byte ptr [ si ], ')'                        ; is arg a ) variable ?
        jz _ForSearchForDoLastParen                     ; keep looking -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  test for a 'do' argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_ForSearchForDo:
        push di
        mov di, offset RxDOS_ForArgs
        call CmndLookup                                 ; lookup command
        pop di                                          ; restore arg pointer
        ifc _ForError                                   ; if not legit, syntax error -->

        cmp bx, _DO                                     ; 'do' returns a 1
        ifnz _ForError                                  ; if not found -->

        inc di
        inc di
        storarg __cmdline, di                           ; where command line is

        sub di, 4
        storarg __endrepeatArg, di                      ; end repeat arg

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  sequentially walk through each arg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_ForNext:
        getarg bx, __arg                                ; point to arg list
        cmp bx, word ptr [ __endrepeatArg ][ bp ]       ; end repeat arg ?
        jz _ForReturn                                   ; if at end, exit -->

        mov cx, word ptr [ bx + 2 ]
        sub cx, word ptr [ bx ]                         ; distance to copy
        mov si, word ptr [ bx ]
        lea di, offset [ _replacement ][ bp ]
        call _buildForArgList                           ; build arg list

        storarg _nArgs, cx                              ; how many args in curr element list
        storarg _pathSep, dx                            ; fixed portion of argument
        mov word ptr [ _ArgAlloc ][ bp ], offset RxDOS_WorkArea

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  redefine command line
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_ForNext_22:
        getarg di, __cmdline                            ; ptr->arg array where command line begins
        mov si, word ptr [ di ]                         ; ptr-> text
        lea di, offset [ _commandLine ][ bp ]
        call _CopyString                                ; get command line

        cmp word ptr [ _nArgs ][ bp ], 0000             ; no special args ?
        jz _ForNext_26                                  ; no, use arg as available -->

        mov si, word ptr [ _ArgAlloc ][ bp ]
        getarg di, _pathSep
        call _CopyString                                ; get arg ...

        mov word ptr [ _ArgAlloc ][ bp ], si
        dec word ptr [ _nArgs ][ bp ]                   ; how many remaining ?

_ForNext_26:
        mov al, byte ptr [ _letter ][ bp ]
        lea bx, offset [ _replacement ][ bp ]
        lea si, offset [ _commandLine ][ bp ]
        call ReplaceForVariables                        ; replace variable letter

        call DisplayPrompt                              ; display prompt

        lea dx, offset [ _commandLine ][ bp ]
        call DisplayLine                                ; echo line
        call CRLF

        lea si, offset [ _commandLine ][ bp ]
        call _InternalCommandParser                     ; reparse remainder of line

        cmp word ptr [ _nArgs ][ bp ], 0000             ; arg list ?
        jnz _ForNext_22                                 ; yes, continue using args -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  get next argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_ForNext_36:
        add word ptr [ __arg ][ bp ], 2                 ; point to next arg
        jmp _ForNext

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  error
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_ForError:
        mov dx, offset CmndError_SyntaxError
        call DisplayErrorMessage

_ForReturn:
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Build For Arg List                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This routine tries to determine how many arguments will be   ;
        ;  fed to a 'for' statement loop.  A list is built              ;
        ;                                                               ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   si     pointer to argument                                  ;
        ;   di     pointer to where to return first arg                 ;
        ;   cx     length of argument                                   ;
        ;                                                               ;
        ;  Return:                                                      ;
        ;   di     first arg is returned at [di]                        ;
        ;   dx     constant part of arg (if more than one arg )         ;
        ;   cx     # arg pointers that follow in arg list               ;
        ;                                                               ;
        ;...............................................................;

_buildForArgList:

        Entry
        def  _firstArg, di
        def  _pathSep, di
        def  _nArgs, 0000
        def  _ArgAlloc

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  copy argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        rep movsb
        storarg _pathSep, di

        xor ax, ax
        stosb                                           ; null terminate

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  if arg contains wild cards, try to expand arg name
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        getarg si, _firstArg

_buildForArgList_04:
        lodsb
        cmp al, '?'
        jz _buildForArgList_06
        cmp al, '*'
        jz _buildForArgList_06
        or al, al                                       ; end of string ?
        jnz _buildForArgList_04                         ; keep searching -->

        jmp _buildForArgList_36                         ; exit with argument -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  break up name into path\filename
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_buildForArgList_06:
        dec si
        cmp si, word ptr [ _firstArg ][ bp ]
        jz _buildForArgList_10
        cmp byte ptr [ si ], '\'
        jz _buildForArgList_08
        cmp byte ptr [ si ], ':'
        jnz _buildForArgList_06

_buildForArgList_08:
        inc si

_buildForArgList_10:
        storarg _pathSep, si

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  find first
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov word ptr [ _ArgAlloc ][ bp ], offset RxDOS_WorkArea

        getarg dx, _firstArg
        Int21 FindFirstFile                             ; any found ?
        jc _buildForArgList_36                          ; if none -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  save argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_buildForArgList_22:
        mov si, offset [ RxDOS_DTA. findFileName ]
        getarg di, _ArgAlloc
        call _CopyString

        storarg _ArgAlloc, di
        inc word ptr [ _nArgs ][ bp ]

        Int21 FindNextFile                              ; next ?
        jnc _buildForArgList_22                         ; if next found -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  get first arg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        getarg di, _ArgAlloc
        mov word ptr [ di ], 0000                       ; save terminator

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_buildForArgList_36:
        getarg si, _firstArg
        getarg dx, _pathSep
        getarg cx, _nArgs
        or cx, cx
        Return

RxDOSCMD                        ENDS
                                END
