		Page	60,132			;LM0RM80 Assembled with TASM 2.0
Version		Equ	<'1.50d '>		; for bottom line (6 chars)
; Path Miser Shell by Jerry Rebold and Howard Flank

;ShowFilesList displays the files
;GetTheDir fills the files buffer with the directory.
;EntryToList puts them in the files list in order seen on the screen.
;Ap menu stuff at GoAp adds about 3100 bytes to the code.
;Structure of a file/dir entry:  each is 23d bytes long
;[+0]=byte=attrib (10h=dir, 1=R-O, 2=hiddn)  [+1]=word=time [+3]=word=date
;[+5]=file size lo word  [+7]=file size hi word
;[+9]=13 bytes=name.ext,0  [+22]=last=indent/pip byte, hi 2 bits=pip flags.
;Run, App's & CmndDOS return - search for INT 2Eh
		.sAll
		%Bin	16
		%Trunc
BS		Equ	08h		;ASCII Codes
CR		Equ	0Dh
EOF		Equ	1Ah
Esc_		Equ	1Bh
LF		Equ	0Ah
Tab		Equ	09h

CSEG		Segment	Word Public
		Assume	CS:CSEG ,DS:CSEG, ES:CSEG, SS:CSEG
		Org	100h
Start:		Jmp	Begin

ALIGN 2						;align stack on WORD boundary
		DB	32 dup('Stack   ')
EndSTAK		DB	0

NoRAM$		DB	'Not enough memory to load program',CR,LF,'$'
DOS3str		DB	'(DOS 3+ Required)',0
ParasToReq	DW	0
EditBufSeg	DW	0
WorkingSeg	DW	0		;changes to EditBufSeg for FCD
OrigWkSeg	DW	0
MenuSeg		DW	0
ValidFlag	DB	0
IndexPointer	DW	0
PrevPointer	DW	0
ItemLines	DB	0
ItemFlag	DB	0
EscBP		DW	0		;points previous Ap menu for <Esc>
INprevBP	DW	0		;prev item => don't clear IN entry
INescBP		DW	0		;points curr. Ap menu for <Esc> from IN
ApFlag		DB	0		;signals we are in the Ap menu
MenuTooBigMsg	DB	'.MNU file exceeds 40,000 bytes',0
MenuNotFoundMsg	DB	'PMS.MNU file not found',0
NoRoomMenuMsg	DB	'Not enough memory for .MNU file',0
NFGmnuFlag	DB	0
WaitFlag	DB	0		;signals Ap wait after run
DirFlag		DB	0		;signal Ap use Dir of hilited target
ApBufPtr	DW	0		;points start of squiggly item
MsgPtr		DW	0		;points start of IN msg to show

Old24hSeg	DW	0
Old24hOfs	DW	0
Old23hSeg	DW	0
Old23hOfs	DW	0
NoClsTop2Flag	DB	0

WrProtMsg	DB	'Floppy is write-protected',0
UnknUnitMsg	DB	' Invalid Drive ',0	    ;also for invalid vol label
NotReadyMsg	DB	'Drive not ready',0
UnknCmdMsg	DB	'Unknown command',0
DataErrMsg	DB	'Data error',0
StrucLenMsg	DB	'Bad structure length',0
SeekErrMsg	DB	'Seek error',0
UnknMediaMsg	DB	'Unknown media type',0
SecNFndMsg	DB	'Sector not found',0
NoPaperMsg	DB	'Printer out of paper',0
WrFaultMsg	DB	'Write fault',0
RdFaultMsg	DB	'Read fault',0
GenFailMsg	DB	'General failure',0
PathTooLongMsg	DB	'Path name too long',0
CritErrMsgs	DW	WrProtMsg,UnknUnitMsg,NotReadyMsg,UnknCmdMsg	;0-3
		DW	DataErrMsg,StrucLenMsg,SeekErrMsg,UnknMediaMsg	;4-7
		DW	SecNFndMsg,NoPaperMsg,WrFaultMsg,RdFaultMsg	;8-11
		DW	GenFailMsg					;12
MonthStrs	DB	'Jan',0,'Feb',0,'Mar',0,'Apr',0,'May',0,'Jun',0
		DB	'Jul',0,'Aug',0,'Sep',0,'Oct',0,'Nov',0,'Dec',0
Year		DW	0FFh
Month		DB	0FFh
Day		DB	0FFh
Hour		DB	0FFh
Minutes		DB	0FFh
Seconds		DB	0FFh
TimeDisplStr	DB	'                         hh:mm:ssp ',0
VolName		DB	16 dup(0)
NoVolStr	DB	'   No Vol Label',0
TotalStorage	DB	12 dup(0)
UsedStorage	DB	12 dup(0)
FreeStorage	DB	12 dup(0)
ClusterSize	DB	12 dup(0)
TotalRAM	DB	12 dup(0)
UsedRAM		DB	12 dup(0)
FreeRAM		DB	12 dup(0)
RAMdrvSize	DB	12 dup(0)
NoEMSflag	DB	0
TotalEMS	DB	'  No Driver',0
FreeEMS		DB	'          0',0
RAMsize		DW	0
ParasAvail	DW	0
Cluster		DW	0			;curr drive cluster size
FreeSpace	DW	0			;free space on curr drive
TotalExt	DB	'       None',0
SysIdPtr	DW	0FFFEh,0F000h		;ptr to sytem ID byte
FreeXMS		DB	'  No Driver',0
XMSdriver	DW	0,0
RDLtr		DB	'x:',0
EMSstring	DB	'EMMXXXX0'
PathFlag	DB	0			;0=file Get, 1=InsertPath
GoEntryFlag	DB	0
ScreenBottomLn	DB	0D3h,39 dup(0C4h),0D0h,38 dup(0C4h),0BDh,0
	;single space required between items, menu must start in 11th col
BottomLine	DB	'PMS ',Version,' ',5,'Home',1,'=Top ',5,'End',1
		DB	'=Bottom ',5,'Plus',1,'=NextDir ',5,'Minus',1
		DB	'=PrevDir ',5,'F3',1,'=Status ',5,'F4',1,'=Date/Attr',0
	;F4, F3, Gray -, Gray +, End, Home
BottomCodes	DW	3E00h,3D00h,4A2Dh,4E2Bh,4F00h,4700h
DblHorLine	DB	50h dup(0CDh),0
EditorBotLine	DB	'    ',5,'F3',2,'Del  ',5,'F4',2,'Ins  '
		DB	5,'F5',2,'Copy  ',5,'F6',2,'Mark   '
		DB	5,'F7',2,'Replace   ',5,'F8',2,'Find   '
		DB	5,'F9',2,'Update   ',5,'F10',2,'Esc   ',0
FnameHeader	DB	'  Filename               Ext      Size ',0
PressKeyMsg	DB	'Press any old key to continue...',0

PathChars	DB	'abcdefghijklmnopqrstuvwxyz.\:/'
FnameChars	DB	'ABCDEFGHIJKLMNOPQRSTUVWXYZ$&#@!%()-_{}^',7Eh,7Fh
DecChars	DB	'0123456789',0			;7Eh=126d=7E, 7Fh=
ComExeBat	DB	'COM EXE BAT'
FNameBuf	DB	25 dup(0)
CurrWindowLocn	DW	0,0		;used by InputBHchars
CharsToInput	DW	0
ShowCrsrFlag	DB	0
CCbuf		DB	'1',0,0		;for CopiesToPrint
CurrDrvNo	DB	2		;drive C:
OldDrvNo	DB	0	;used in PaintMainScrn, <>CurrDrvNo => use xPath
ErrDrvNo	DB	0	;used for crit error in GetOut
OldEntryEnd	DW	0
OldHilited	DW	0
NFGdriveFlag	DB	0
EditingFlag	DB	0
PipChar		DB	0FEh		;''
ViewFlag	DB	0		;0=Status, 1=Date/Time screen
TabsSetting	DW	8		;not used now (must be 8)
PMmenu		DB	'PMS.MNU',0

;=====  WORKING CONFIGURATION  =================================
WorkingCNF	Equ	$
TextAttrib	DB	07h
MenuAttrib	DB	0Fh
FileAttrib	DB	17h
DirAttrib	DB	1Fh
InverseAttrib	DB	47h
BlockAttrib	DB	1Fh
InvMenuAttrib	DB	1Fh
HilitFileAttrib	DB	47h
HilitDirAttrib	DB	4Fh
ErrorAttrib	DB	0Eh
BeepFlag	DB	1
NoviceFlag	DB	1
AttribToShow	DB	15h		;for hide/show option, 17h shows hidden
InsertFlag	DB	1
AutoIndentFlag	DB	1
AutoUpdateFlag	DB	0
PrinterStr	DB	1Bh,'@',1Bh,'P',1Bh,'t2',1Bh,'k1',3 Dup(0) ;13d bytes
RunCmdFlag	DB	0		;1=>Run w/ command line entry
;=====  AS-LOADED CONFIGURATION  ===============================
; A copy of the working configuration to check for changes
SavedCNF	DB	07h,0Fh,17h,1Fh,47h,1Fh   ;Text,Menu,File,Dir,Inv,Block
		DB	1Fh,47h,4Fh,0Eh	      ;InvMenu,HilitFile,HilitDir,Error
SavedBeep	DB	1,1,15h		      ;BeepFlag,NoviceFlag,AttribToShow
		DB	1,1,0		 ;InsertFlg,AutoIndentFlg,AutoUpdateFlg
		DB	1Bh,'@',1Bh,'P',1Bh,'t2',1Bh,'k1',3 Dup(0)  ;PrinterStr
		DB	0					    ;RunCmdFlag
;=====  DEFAULT COLORS  =======================================
ColorAttrib	DB	07h,0Fh,17h,1Fh,47h,1Fh   ;Text,Menu,File,Dir,Inv,Block
		DB	1Fh,47h,4Fh,0Eh	      ;InvMenu,HilitFile,HilitDir,Error

MonoAttrib	DB	7,3,6,15,70h,70h      ;Text,Menu,File,Dir,Inverse,Block
		DB	70h,70h,78h,0Fh	      ;InvMenu,HilitFile,HilitDir,Error

;=====  MENUS, ITEMS AND PROMPT LINES  ====================

;------ MAIN MENU ------
MainMenu	DB	0,'Run',0,'Run the highlighted File,'
		DB	' <Ctrl-Alt-End> exits hung programs',0
		DB	'File',0,'Copy, Print, Rename, Move, Erase, Attrib',0
		DB	'Directory',0,'Open, Close, Make, Erase, Rename, Sort',0
		DB	'Edit',0,'Edit the highlighted file or create a '
		DB	'file in the highlighted directory',0
		DB	'Options',0,'Drive, Beep, Colors, User, '
		DB	'Hidden, Status, PrinterSetup, RunCmdLine',0
		DB	'Application-Menu',0
ApMenuPrompt	DB	'PMS.MNU not found',63 dup (' '),0
		DB	'Cmd-to-DOS',0,'Enter a command directly to DOS',0
		DB	'eXit',0,'Terminate PMS, Exit to DOS',0,0FFh
MainSubList	DW	RunPgm,GoFile,GoDirectory,GoEdit,GoOptions,GoAp
		DW	RunDOS,ExitPMS

;----- FILE MENUS -----
FileMenu 	DB	0
CopyStr	 	DB	'Copy',0
		DB	'Copy marked files to another drive or directory.'
		DB	' <Esc> stops copying.',0
		DB	'Print',0,'Send highlighted file to PRN.'
		DB	  ' <Esc> stops immediately.',0
		DB	'Rename',0,'Rename highlighted file',0
MoveStr	 	DB	'Move',0,'Move marked files to a different directory '
	 	DB	  'on the same disk',0
EraseStr 	DB	'Erase',0,'Erase marked files',0
	 	DB	'Attrib',0,'Change hidden, read-only, or archive status'
		DB	  ' of marked files',0
		DB	'Bak',0,'Make backup copy of highlighted file',0
		DB	'Quit',0,'To main menu <Esc>',0,0FFh

CopyMenu	DB	0
		DB	'Subdirectory',0,'Copy to a subdirectory on the same '
		DB	  'drive',0
		DB	'Drive',0,'Copy to anywhere on another drive',0
		DB	'Root',0,'Copy to the ROOT dir of another drive '
		DB	  '(faster)',0
		DB	'Quit',0,'To File menu',0,0FFh

FAttribMenu	DB	0
HideStr		DB	'Hide',0,'Make files Hidden',0
RevStr		DB	'Reveal',0,'Unhide files.  '
		DB	'Use <O><H><S> first to see hidden files',0
ProtStr		DB	'Protect',0,'Make files Read-Only',0
DeprStr		DB	'Deprotect',0,'Remove Read-Only status',0
ArcStr		DB	'Archive',0,'Mark file as unchanged',0
UnarStr		DB	'Unarchive',0,'Mark file as changed',0
		DB	'Quit',0,'To File menu',0,0FFh

;----- DIRECTORY MENUS -----
DirMenu		DB	0,'Open',0,'Open the highlighted directory <Ins>',0
		DB	'Close',0,'Close current directory <Del>',0
		DB	'Make',0,'Make a new directory in the highlighted '
		DB	  'directory',0
		DB	'Erase',0,'Directory must be empty',0
		DB	'Rename',0,'...can have an .Ext, too',0
		DB	'Sort',0,'Name, .Ext, Date, Unsorted',0
		DB	'Quit',0,'To main menu <Esc>',0,0FFh

SortMenu	DB	0,'Name',0,'Sort the files list by name, then .ext',0
		DB	'Extension',0,'By .Ext only, names unsorted',0
		DB	'Date',0,'By date and time',0
		DB	'Unsorted',0,'REVERSE DOS order, last entry first',0
		DB	'Quit',0,'To main menu <Esc>',0,0FFh

;----- EDITOR MENUS -----
EditorMenu	DB     0,'Put',0,'Write marked block to specified file or PRN',0
		DB	'Get',0,'Read in a file at cursor position',0
		DB	'Block',0,'Insert, Delete, Copy',0
		DB	'Mark',0,'Mark a block of text',0
		DB	'Jump',0,'Begin, End, First, Last',0
		DB	'Search',0,'Find, Replace',0
		DB	'Options',0,'Update, Auto-Indent, Status',0
		DB	'InsertPath',0,'Put d:\path\name of a file at cursor',0
		DB	'Quit',0,'To main menu',0
		DB	'Alt-chars',0,'ALT-key inserts character:   '
		DB	'`    2 ',0FDh,'   3 ',0E3h
		DB	'   4 ',09Bh,'   - ',0C4h,'   =    d ',0F8h
		DB	'   p ',0F1h,0,0FFh

EdPutMenu	DB	0,'File',0,'Write marked block to a file',0
		DB	'Printer',0,'Print marked block',0
		DB	'Quit',0,'To text entry',0,0FFh

EdBlockMenu	DB	0,'Insert',0,'Insert block buffer at cursor <F4>',0
		DB     'Delete',0,'Delete marked block into block buffer <F3>',0
		DB	'Copy',0,'Copy marked block into block buffer <F5>',0
		DB	'Quit',0,'To text entry',0,0FFh

EdJmpMenu	DB	0,'Begin',0,'Beginning of file <Ctrl-PgUp>',0
		DB	'End',0,'End of file <Ctrl-PgDn>',0
		DB	'First',0,'First line on the screen <Ctrl-Home>',0
		DB	'Last',0,'Last line on the screen <Ctrl-End>',0
		DB	'Quit',0,'To text entry',0,0FFh

EdSearchMenu	DB	0,'Find',0,'Find case-sensitive string <Ctrl-S>',0
		DB	'Replace',0,'Replace case-sensitive string <Ctrl-R>',0
		DB	'Quit',0,'To text entry',0,0FFh

EdOptionMenu	DB	0,'Update',0,'Toggle automatic update on exit',0
		DB	'Auto-Indent',0,'Toggle auto-indent',0
		DB	'Status',0,'Show status of Editor options',0
		DB	'Quit',0,'To text entry',0,0FFh

EdOpUpdateMenu	DB	0,'Automatic',0,'Auto update upon quitting editor',0
		DB	'Manual',0,'Ask, if file has been changed',0
		DB	'Quit',0,'To text entry',0,0FFh

EdOpIndentMenu	DB	0,'Set',0,'New line indented like the one above it',0
		DB	'Reset',0,'Auto-indent off',0
		DB	'Quit',0,'To text entry',0,0FFh

EdQuitMenu	DB	0,'Update',0,'Update file and return to main menu',0
		DB	'Return',0,'Return to text entry',0
		DB	'Exit',0,'Return to main menu without updating',0,0FFh

EdHiddenMenu	DB	0,'Update',0
		DB	'File is Hidden or Read-Only, update anyway',0
		DB	'No',0,'Oops - do not update',0,0FFh

;----- OPTION MENUS -----
OptionsMenu	DB	0
		DB	'Drive',0,'Change disk drive (or use <Ctrl>-Letter)',0
		DB	'Beep',0,'Toggle error beeps',0
		DB	'Colors',0,'Change colors (not on Monochrome)',0
		DB	'User',0,'Turn ''Yes/No'' prompts on or off',0
		DB	'Hidden',0,'Show/Hide Hidden files',0
		DB	'Status',0,'Display settings of the options',0
		DB	'PrinterSetup',0,'String sent before printing',0
		DB	'RunCmdLine',0,'Whether command line is requested '
		DB	  'before Run',0
		DB	'Quit',0,'To main menu <Esc>',0,0FFh

SelDriveMenu	DB	0		;each must be DLength bytes. See CopyEm
DrivesList	DB	'A',0,0,  'B',0,0,  'C',0,0,  'D',0,0,  'E',0,0
		DB	'F',0,0,  'G',0,0,  'H',0,0,  'I',0,0,  'J',0,0
		DB	'K',0,0,  'L',0,0,  'M',0,0,  'N',0,0,  'O',0,0
		DB	'P',0,0,  'Q',0,0,  'R',0,0,  'S',0,0,  'T',0,0
		DB	'U',0,0,  'V',0,0,  'W',0,0,  'X',0,0,  'Y',0,0
		DB	'Z',0,0,  0FFh
DLength		DB	3

ColorsMenu	DB	0
		DB	'Text',0
		DB	'Text in Editor and bottom line of this screen',0
		DB	'Menu',0,'Menus at top of screen and Border',0
		DB	'File',0,'Files and Item names on the Status screen',0
		DB	'Dir',0,'Directories and Data on the Status screen',0
		DB	'Inverse',0,'Titles and Data entry windows',0
		DB	'Block',0,'Marked text in the Editor',0
		DB	'menUbar',0,'Selected Menu Item',0
		DB      'fiLleBar',0,'File line highlight bar',0
		DB      'dirbAr',0,'Directory line highlight bar',0
		DB	'Error',0,'Error and Informational Messages',0
		DB	'Reset',0,'Start over with default colors',0,0FFh

OptUserMenu	DB	0
Novice		DB	'Novice',0,'Ask ''Yes/No?'' on most commands',0
Expert		DB	'Expert',0,'Do not ask on most commands',0
		DB	'Quit',0,'To Options menu without changes <Esc>',0,0FFh

OptHidMenu	DB	0
		DB	'Show',0,'Show as (HIDDEN  FIL), warn if updating',0
		DB	'Hide',0,'Leave them hidden',0
		DB	'Quit',0,'To Options menu without changes <Esc>',0,0FFh

OptRCLmenu	DB	0
		DB	'Immediate',0,'Run programs without a command line',0
		DB	'CommandLine',0,'Request program command line before '
		DB	  'Running',0
		DB	'Quit',0,'To main menu without changes <Esc>',0,0FFh

;------ CONFIRMATION AND ERROR OPTION MENUS ------
MoveSameMenu	DB	0
		DB	'Overwrite',0
		DB	'Destination has file with same name, move anyway',0
		DB	'No',0,'Oops - do not move',0,0FFh

SaveOptMenu	DB	0
SavedYes	DB	'Yes',0,'Save changes (update the .COM file)',0
SavedNo		DB	'No ',0,'Quit to main menu, changes are temporary',0
		DB	0FFh

ConfirmMenu	DB	0,'No',0,'Are you sure?',0
		DB	'Yes',0,'Are you sure?',0,0FFh

ErrorMenu	DB	0,'Yes',0,'Try again ?',0
		DB	'No',0,'Try again ?',0,0FFh

CNFlength	DW	Offset SavedCNF-Offset WorkingCNF
PUcursor	DW	0		;used by InputBHchars (BlockPut)
APath		DB	51h dup(0)
BPath		DB	51h dup(0)
CPath		DB	51h dup(0)
DPath		DB	51h dup(0)
EPath		DB	51h dup(0)
OrigPath	DB	51h dup(0)	;CD\OrigPath upon eXit from this pgm
CurrentPath	DB	51h dup(0)
WritePath	DB	51h dup(0)	;used by File Move, Ren, Copy,
					; LoadMenu, Dir-to-be-in for Ap runs,
					; and name of .BAT file to run
StatsAndCopyPath DB	51h dup(0)	;used in InputBHchars, show Status,
					; Editor Status & top line, file Move &
					; Copy (dest), CmdDOS entry.
FileLineBuf	DB	51h dup(0)
ApBuf		DB	149 dup(0)	;max DOS cmd line = 148 chars
MenuBuf		DB	51h dup(0)
Line2Buf	DB	51h dup(0)	;for Ap menu 2nd line
Line2Ptrs	DW	27 dup(0)
DestBkslashName	DW	0
VideoSeg	DW	0
EntryCrsrPosn	DW	0
ChkAllKeysFlag	DB	0		;ShowMenu - no file list keys in Editor
EndPtr		DW	0
MenuItemCount	DB	0
BufPointers	DW	27 dup(0)
INcursor	DW	0		;used by InputBHchars
ThreeBlanks	DB	'   ',0
OpenErrMsg	DB	'Error opening file',0
TooLgMsg	DB	'File too large (64K max)',0,0
HiliteGetStr	DB	2,'Highlight file to Get, ',5,'Enter',2,' accepts',0

AutoUpdateStr	DB	'Auto Update '
TabsStr		DB	' (Tabs=8) '
AutoIndentStr	DB	'  Auto Indent                   '
FreeMemStr	DB	' Free Memory '
ONstr		DB	'ON '
OFFstr		DB	'OFF'

;---- List of Editor Codes: Extended, Function, and Control Keys --------------
KeyList		DB	48h,50h,4Bh,4Dh		;Extended codes: Up,Dn,Left,Rght
		DB	49h,51h,47h,4Fh,74h	;  PgUp,PgDn,Home,End,Ctl-Right
		DB	73h,77h,75h,84h		;  C-Left,C-Home,C-End,C-PgUp
		DB	76h,52h,53h		;  Ctl-PgDn,Insert,Delete
		DB	3DH,3Eh,3Fh,40H,41h,42h,43h,44h	;F3-F10
		DB	0E8h,LF+224,CR+224,0FAh	;Ctrl Keys: Bsp,LF,CR,EOF
		DB	0F3h,0F2h,0FFh,0E5h	;Ctrl-S,Ctrl-R,Ctrl-Bsp,Ctrl-E
		DB	79h,7Ah,7Bh,82h,83h,20h	;ALT-2, 3, 4, -, =, d
		DB	19h			; p
KeyListLen	Equ	$-KeyList
;---- Edit Subroutines to be called for each Key in the previous list ---------
SubList		DW	CrsrUp,CrsrDn,LeftArrow,RightArrow	;Extended
		DW	PageUp,PageDn,Home,EndKey,CtrlRight
		DW	CtrlLeft,CtrlHome,CtrlEnd,CtrlPgUp
		DW	CtrlPgDn,ToggleInsert,DeleteChar
		DW	BlockDel,BlockInsert,F5,BlockToggle,F7	;Function Keys
		DW	F8,FileUpdate,F10
		DW	BackSpace,NewLine,NewLine,Ignore	;Ctrl Keys
		DW	ReSearch,ReReplace,DeleteLine,DeleteEOL
		DW	Square,Pi,Cent,HorizBar,Approx,Degree	;Alt Keys
		DW	PlsMinus

;- - - - Editor variables - - - - - -
FwdFlag		DB	0		;used copying block to buffer
ApproxFlag	DB	0
TotalInverse	DW	0
TempBytesInBuf	DW	0		;tried elim, screws up block marking
BytesInBuf	DW	0
OrigUprLeft	DW	0
OrigScrnLine	DB	0
OrigScrnCol	DB	0
OrigEditLnNo	DW	0
OrigColOffset	DW	0
CurrAttrib	DB	0
BlockAttribFlag	DB	0
BlockPaintPtr	DW	0
DocLineNo	DW	0
ColumnShown	DW	0
CursorLine	DB	0		;top line is 0, last is 19d
CursorCol	DB	0
UpToCursorPtr	DW	0		;end of 1st half of doc
CursorUpPointer	DW	0		;start of 2nd half of doc
BlockStart	DW	0
UpperLeft	DW	0		;points to byte at upper left corner of
					; screen, regardless of ColumnOffset
FileLength	DW	0		;current editor file length
OrigFileLen	DW	0		;original file length
ColumnOffset	DW	0		;multiples of 10d
EOFpointer	DW	0		;points end of edit buffer
EditBytesToRead	DW	0
TopLineNo	DB	0		;always 3
BlockFlag	DB	0
FileChangedFlag	DB	0
HidROattrib	DB	0		;holds orig attrib of hidden or R-O file
GetLength	DW	0
PutPrinterFlag	DB	0

TooLgForBufMsg	DB	'Marked block too large for Block buffer',0
TooLgToInsMsg	DB	'Block buffer too large to insert',0
BufferEmptyMsg	DB	'Block buffer is empty',0
InsertStr	DB	'  Insert  ',0
OvrtypeStr	DB	' Overtype ',0
LineStr		DB	'Line ',0
ColumnStr	DB	'  Column ',0
PositionStr	DB	'  Position ',0
OfStr		DB	'  Of ',0
TextBufFullStr	DB	'Text Buffer is full',0
TypeFname	DB	'Enter filename, <Esc> exits.',0
ErrCreatingMsg	DB	'Error creating file',0
ErrWritingMsg	DB	'Error writing file',0
ErrReadingMsg	DB	'Error reading file',0
AlreadyExMsg	DB	'File already exists',0
NotExMsg	DB	'File does not exist',0
TooLgToReadMsg	DB	'File too large to read in',0
NoBlockStr	DB	'No block marked',0
SBcursor	DW	0
SearchBuf	DB	27 dup(0)
RBcursor	DW	0
ReplBuf		DB	27 dup(0)
CursorLocn	DW	0		;for InputBHchars, 0=1st
PScursor	DW	0		;for PrinterSetup string entry

AllCharsFlag	DB	0
AllChars	DB	CR,LF,EOF,0FFh,0	;INvalid chars

TypeTextStr	DB	'Enter text to replace',0
WithStr		DB	'With',0
TypeToSearchStr	DB	'Enter text to search for',0
NotFoundStr	DB	'Not found',0
NoMemReplStr	DB	'Not enough memory for replacement',0
ReplNSpecStr	DB	'Replacement text not specified',0
FindCharCount	DW	0
var002		DW	0
LinesSearched	DW	0
FoundPointer	DW	0

RootDirStr	DB	'Root Dir',0
NotaDirStr	DB	'Not on a directory',0
AlreadyOpenMsg	DB	'Directory already open',0
EmptyDirStr	DB	'Directory is empty',0
OpeningStr	DB	'Opening the directory',0
ClosingStr	DB	'Closing the directory',0
DirectoryStr	DB	' Directory',0
MakeShowFlag	DB	0
FilesCount	DW	0
DirIndent	DB	0
NewEntryAttrib	DB	0
EightySpaces	DB	'  '
FullBlankLine	DB	'                                       '
HalfBlankLine	DB	'                        '
Spaces15	DB	'               ',0
BufDest		DW	0		;dest for DwordToBuf
FileSizeFlag	DB	0		;so file sizes in list have no commas

;Constants:
Nine		DW	9
Ten		DB	10
EntryLen23	DW	23
LastLine23	DB	23
TimeLocn	DW	36h
BIOSseg		DW	40h

;the Find First/Next DTA, 43d bytes, for func 4Eh & 4Fh
DirDTA		DB	21 dup(0)	;holds 'fname   ext' for next find
AttributeByte	DB	22 dup(0)	;DOS returns File Attrib here
DTA_Indent	DB	0

BkSlash		DB	'\',0		;in case Switchar is changed ?
CurrDrvLtr	DB	'C:\'
StarDotStar	DB	'*.*',0
DirFileAttrib	DB	10h
HilitedEntry	DW	17h
SourceHilitedEntry DW	0
PastLastEntry	DW	0
SourceEntEnd	DW	0
WorkSegLength	DW	0
SortType	DB	1		;1=name, 2=ext, 3=date, 4=none
MarkEntriesStr	DB	'Mark entries to ',0
NoneMarkedStr	DB	'No files marked',0
bufBX		DW	0
bufBP		DW	0
BytesMarkedHi	DW	0
BytesMarkedLo	DW	0
NumberMarked	DW	0
MarkedInfoBuf	DB	'sssssssssss bytes in'			;20 chars
MarkedNumber	DB	'nnnnnnnnnnn marked files            '	;57 chars
		DB	'                        ',0
DestFree	DB	'            free on Dest  ',0
IsaDirMsg	DB	'This is a directory, not a file',0
UseFileEraseMsg	DB	'This is a file, use File Erase to remove it',0
NotEmptyMsg	DB	'Subdirectory not empty, cannot be erased',0
NotaSubDirMsg	DB	'Not a subdirectory',0
AccessOrPathMsg	DB	'Access Denied, bad path, or file with same name as'
		DB	 ' Dir',0
EntNewDirMsg	DB	'Enter name of new directory',0
EscExitsStr	DB	'<Esc> exits',0

CopySizeLo	DW	0
CopySizeHi	DW	0
EntryPtr3	DW	0
ErasingStr	DB	'Erasing',0
FileIsROmsg	DB	'File is Read-Only or other DOS error',0
MovMorIndented	DB	0
PrevHilitEntry	DW	0
HiliteDestStr	DB	'Use Spacebar to mark files, '
HilDestDirStr	DB	2,'Highlight destination directory, ',5,'Enter'
		DB	  2,' accepts',0
HasSameNameStr	DB	'Destination has a file or directory with same name',0
DestNotDirStr	DB	'Destination is not a subdirectory',0
MovingStr	DB	'Moving files',0
MarkedEntryPtr	DW	0
EntryPtr2	DW	0

SpaceMarkStr	DB	2,'Use Spacebar to mark files, ',5,'Enter'
		DB	  2,' accepts',0
CopyingStr	DB	'Copying marked files',0

FAttribFunc	DW	0
ChangingStr	DB	'Changing marked files',0
NoSpaceDestStr	DB	'Not enough space on destination for this file',0
UseFCSameMsg	DB	'Use File Copy Subdirectory to copy to same drive',0
NoCopyItselfMsg	DB	'Cannot copy or move a file to itself',0
DestDirPtr	DW	0
TempHilitEntry	DW	0
Sub1Drv2Root3	DB	0
ReadHandle	DW	0
WriteHandle	DW	0
CopyBytesRead	DW	0,0
CopiesToPrint	DB	1
CCmsg		DB	'Enter no. of copies',0
NewNameStr	DB	'Enter new name, <Right> for current name char',0
RenDirMsg	DB	'Use Directory Rename',0
Mouse		DB	0		;0=NoMouse, 2 or 3 = #Buttons
MouseCol	DW	0		;Mouse cursor column (text 0-79)
MouseRow	DW	0		;Mouse cursor row (text 0-24)
MouseMBStr	DW	5,11Bh,11Bh,11Bh,184Fh,2044h
WaitKeyFlg	DB	0 ;saves AH in WaitKey  1=Flush Kbd Bufr, +2=check mouse
CtrlFlag	DB	0		;using CTRL-letter to change drives
BreakState	DB	0		;Break= at entry, 0=OFF, 1=ON
WhichAttrib	DW	0
WhichColor	DW	0		;Adr of color option to change
UseArrowMsg	DB	'//Left Button does foreground, '
		DB	27,'/',26,'/Middle Button does background of',0

PrintSetStr	DB	'Enter string.  <F10> inserts an <Esc> (027d)',0
NoDrvBmsg	DB	'Drive B: does not exist',0
LastDrvPlus1	DB	0
SysStatus	DB	'             Date and Time            ',0
DrvStatus	DB	'             Drive  : Status          ',0
VolLbl		DB	'Volume Label',0
StorgTotal	DB	'Total Space',0
StorgUsed	DB	'Space Used',0
StorgFree	DB	'Available Space',0
SizeCluster	DB      'Cluster Size',0
MemStatusStr	DB	'             Memory Status            ',0
RAMtotlStr	DB	'System Memory Total',0
RAMusedStr	DB	'System Memory Used',0
RAMfreeStr	DB	'System Memory Free',0
ExtTotStr	DB	'Extended Memory',0
XMSfreeStr	DB	'XMS Memory Free '
XMSver		DB	'     ',0
EMStotStr	DB	'EMS Memory '
EMSver		DB	'    ',0
EMSfreeStr	DB	'EMS Memory Free',0
RAMdrvStr	DB	'RAM Drive',0

ShownStr	DB	'Shown '
HidStr		DB	'Hidden'
StatusHeader	DB	'Hidden     Sound      User        Saved?'
		DB	'     Printer String',0

HideOrShow	DB	'xxxxxx       '
SoundOnOff	DB	'xxx     '
NovOrExp	DB	'xxxxxx        '
SavedYesNo	DB	'xxx                     ',0

ULcor		DB	201,0			;''
URcor		DB	187,0			;''
HorBar		DB	0C4h,0			;''
TopTee		DB	203,0			;''
BottomTee	DB	0D0h,0			;''
VertBar		DB	0BAh,0			;''
UpArrow		DB	24,0			;''
DnArrow		DB	25,0			;''
DateTimeHeader	DB	'     Date       Time     Attributes    ',0

OnlyEXEmsg	DB	'You can only run .COM, .EXE, & .BAT files',0
InsufMem$	DB	'Insufficient memory for program',CR,LF,'$'
NameToRunEnd	DW	0
NameToRunPtr	DW	0
RunCmdMsg	DB	'Enter command line parameters. <Esc> exits',0
BufferSP	DW	Offset EndSTAK

RunFlag		DB	0		;Run, not CmdDOS
CmdDOS_EndPtr	DW	0

CmdDOSbuf1	DB	82 dup(0)
CmdDOSbuf2	DB	82 dup(0)
CmdDOSbuf3	DB	82 dup(0)
CDcursor1	DW	0		;cursor locn's for CmdDOS entry
CDcursor2	DW	0
CDcursor3	DW	0
InputFlag	DB	0	;1 => InputBHchars respond to up, dn keys
				;2 => F10 inserts Esc (1Bh), accept any char
				;3 => 1st valid char overwrites (File Print #)
WhichCmd	DB	1
CmdPtr		DW	0

TypeCmdMsg 	DB	'Type DOS command.  keys change lines, <Esc> exits, '
		DB	'<Enter> Runs current line',0
WaitMsg	   	DB	' Wait. ',0
DiskChgMsg 	DB	'Disk changed or other DOS error',0
;-------------------------------------------
VectorsBuf	DB	400h dup (?)		;1K buffer for INT vector table
OldINT9		DW	0
OldInt9seg	DW	0
ParaPastPgm	DW	0
VMode		DB	0
HdwByte		DB	0
HOTparas	DW	0
RunningFlag	DB	0
HotFlag		DB	0
EscFlag		DB	0

NewINT9:	Push	AX
		In	AL,60h
		And	AL,7Fh
		Cmp	AL,52h			; Ins key ?
		JZ	ChkHot
		Cmp	AL,4Fh			; End key ?
		JZ	ChkHot			;  (Ins resets XCMOS on 386's)
		Cmp	AL,1			; Esc key ?
		JNZ	Exit
		Mov	CS:EscFlag,1
Exit:		Pop	AX
		Jmp	CS:DWord Ptr OldINT9

ChkHot:		Push	DS
		Mov	AX,40h
		Mov	DS,AX
		Mov	AL,DS:Byte Ptr 17h
		Pop	DS
		And	AL,0Ch
		Cmp	AL,0Ch			; <Ctrl-Alt> keys?
		JNZ	Exit
	;'eat' the keystroke (reset the keyboard)
		In	AL,61h
		Mov	AH,AL
		Or	AL,80h
		Out	61h,AL
		Xchg	AH,AL
		Out	61h,AL
		Mov	AL,20h			; End-Of-Interrupt for 8259
		Out	20h,AL
	;do the HOTBOOT
		Pop	AX
		Cmp	CS:RunningFlag,0
		JNZ	ExPgm
		Mov	AX,Offset EndStak	;-- We are at the PMS screen,
		Mov	SP,AX			;    or 'Press a Key...'
		Mov	AX,CS
		Mov	SS,AX
		Mov	DS,AX
		Mov	ES,AX
		Call	HotBoot
		Call	AllocRAM
		Jmp	HotExit

ExPgm:		Mov	CS:HotFlag,1
		Pop	AX			;the INT 9 rtn adr and flags
		Pop	AX			; are pushed on the running
		Pop	AX			; pgm's stack
		Mov	AX,4C01h		;exit the running pgm
		Int	21h

HotBoot:	Push	AX
		Push	DS
		Push	ES
		Push	DI
; change next MCB, marking all RAM past our code seg as unused
		Push	CS
		Pop	DS
		Mov	ES,ParaPastPgm
		Xor	DI,DI			;ES:DI points to next MCB
		CLD
		Mov	AL,'Z'			;mark as last MCB
		StosB
		Xor	AX,AX			;block is not 'owned'
		StosW
		Mov	AX,HOTparas		;size of the block
		StosW
		Xor	AX,AX			;-- restore entire vector table
		Mov	ES,AX
		Mov	SI,Offset VectorsBuf
		Xor	DI,DI			;ES:DI = 0:0
		Mov	CX,200h
		CLI				;not automatic for 8088
		Rep	MovsW
		STI
		Mov	Byte Ptr ES:[417h],0	;-- turn off 'lock' keys
		Mov	AL,HdwByte
		Mov	ES:[410h],AL		;BIOS Video hardware byte

	;restore 8253/4 timer 0 to 64K counts/tick (1.1938 MHz)
		Mov	AL,00110110b		;control word
		Out	43h,AL
		Xor	AL,AL			;zero gives 10000h counts/tick
		Out	40h,AL			;lo byte
		NOP				;delay
		Out	40h,AL			;hi byte

		Push	BX			;-- reset Typematic rate & delay
		Mov	AH,3			;Set Delays
		Mov	AL,5			;subfunction
		Mov	BH,1			;500 mS delay
		Mov	BL,0Ch			;10.0 cps, slightly faster than
		Int	16h			;   the default
		Mov	AL,VMode		;-- restore Video mode --
		Xor	AH,AH			;set mode (clears screen)
		Int	10h
		Pop	BX
		Call	ResetPrinter
		Pop	DI
		Pop	ES
		Pop	DS
		Pop	AX
		Ret

ResetPrinter:	Push	DX
		Mov	AH,1			;reset printer
		Xor	DX,DX			;printer no.
		Int	17h
		Inc	DX			;to LPT 2
		Int	17h
		Inc	DX			;to LPT 3
		Int	17h
		Pop	DX
		Ret

; - - -  - - - - - - - - - - -
Begin:		CLI
		Mov	AX,Offset EndSTAK
		Mov	SP,AX
		STI
		Call	AllocCode
		Call	AllocRAM		;alloc for Editor & Menu seg's
		Cmp	AX,1
		JNZ	SetBoot
		Jmp	InitExit
SetBoot:	Call	SetNewINT23and24h	;also turns Break Off
		Push	ES			;set up for HOTBOOT
		Mov	AX,3509h		;get int 9
		Int	21h
		Mov	OldINT9,BX
		Mov	OldINT9seg,ES
		Pop	ES
		Mov	AX,2509h		;set new int 9
		Mov	DX,Offset NewINT9
		Int	21h
		Push	DS
		Xor	AX,AX
		Mov	DS,AX
		Mov	SI,AX			;DS:SI = 0:0
		Mov	CX,200h			;200h words = 1Kbyte
		CLD
		Mov	DI,Offset VectorsBuf
		Rep	MovsW			;save vectr tbl, set INT 9 here
		Mov	AH,0Fh			;-- save current Video mode --
		Int	10h			;get mode
		Mov	CS:VMode,AL
		Mov	AL,DS:[410h]		;get hardware byte
		Pop	DS
		Mov	HdwByte,AL
		Call	InitMouse
		Call	GetPathAndCrsr		;only call
HotExit:	Call	SetCrsrAndVideoSeg
		Call	Cls
		Call	LoadMenu
CritExit:	Call	PaintMainScrn
		Call	PaintBlankScreen
		Call	PaintStatusOrDateScrn
		Call	MainRoutine
		Call	RestoreCrsrAnd23and24	;only call
;change to Path when this program was run, unless from a floppy
;****ought to check for floppy, some have 3 floppies !
		Mov	DL,OrigPath		;drive letter
		Sub	DL,41h			;drive number
		Cmp	DL,2
		JB	NoOrig
		Mov	AH,0Eh			;select drive
		Int	21h
		Mov	DX,Offset OrigPath
		Mov	AH,3Bh			;change dir
		Int	21h
NoOrig:		Mov	AX,2509h		;restore INT 9 (keyboard)
		Mov	DX,OldINT9
		Mov	DS,OldInt9seg
		Int	21h
InitExit:	Mov	AX,4C02h		;exit w/Errorlevel 2
		Int	21h

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
InitMouse:	Push	AX
		Push	CX
		Push	DX
		Mov	Mouse,0			;;--- Initialize the Mouse ---
		Xor	AX,AX			; Check if mouse available
		Int	33h
		Or	AX,AX
		JZ	NoMouse			; If no mouse
		Mov	Mouse,BL		; Else save no. of buttons
		Mov	CX,144			; Init mouse cursor position
		Mov	DX,48			;  to Row 7, Col 21
		Mov	AX,4
		Int	33h
		Mov	AX,0Ah			;set text cursor
		Xor	BX,BX			;use software cursor
		Mov	CX,7700h		;AND mask
		Mov	DX,77B1h		;XOR mask for ''
		Int	33h
	;make RB set EscFlag
		Push	ES
		Mov	AX,0Ch			;set mouse event handler
		Mov	CX,00001000b		;when RB pressed
		Push	CS
		Pop	ES
		Mov	DX,Offset RightButtonRtn
		Int	33h
		Pop	ES
NoMouse:	Pop	DX
		Pop	CX
		Pop	AX
		Ret

RightButtonRtn:	Mov	CS:EscFlag,1
		RetF				;NOT Ret Far !!
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
GetPathAndCrsr:	Push	AX
		Mov	AH,19h			;get current Drive
		Int	21h
		Mov	CurrDrvNo,AL		;0 => A:, etc.
		Mov	OldDrvNo,AL
		Mov	ErrDrvNo,AL
		Add	AL,'A'
		Mov	DI,Offset OrigPath
		StosB
		Mov	AX,'\:'
		StosW
		Mov	SI,DI			;get current Path
		Mov	AH,47h
		Mov	DL,CurrDrvNo
		Inc	DL			;for this func, 1 => A:, etc
		Int	21h
;------- Get initial Path and Filename (if on command line) -------
;****ought to skip spaces, etc and not assume 1 space
		Cmp	Byte Ptr CS:80h,2	;initial path\filename?
		JB	GetCrsr
		Mov	SI,82h			;pointr to path\filename
		Mov	AX,Word Ptr OrigPath	;get default drive
		Cmp	Byte Ptr 1[SI],':'	;drive specified?
		JNE	$+3			;if not
		LodSW				;Yes: get specified drive:
		Push	AX			;Save "Drive:"
		And	AL,1Fh			;conv to drive no.
		Dec	AL
		JB	ParmErr			;if not a letter
		Cmp	AL,4			;must be A: thru E:
		JG	ParmErr
		Cmp	AL,CurrDrvNo		;is it the current drive?
		JE	CalcBfrPtr		;yes
		Mov	CurrDrvNo,AL		;no: set new drive
		Mov	ErrDrvNo,AL
		Mov	DL,AL			;switch drives
		Mov	AH,0Eh
		Int	21h
CalcBfrPtr:	Mov	AL,CurrDrvNo		;--calc xPath buffer offset--
		Xor	AH,AH
		Mov	DX,81
		Mul	DX
		Mov	DI,Offset APath
		Add	DI,AX
		Pop	AX			;get back "Drive:"
		StosW				;put "Drive:" in xPath bufr
		Mov	AL,"\"			;and a "\"
		StosB
		Cmp	Byte Ptr [SI],"\"	;skip initial "\" in spec
		JNE	$+3
		Inc	SI
		Mov	OldDrvNo,0FFh		;set for "path restore"
		Mov	GoEntryFlag,1
MovFileUC:	LodsB				;-- move filename as u/c --
		Cmp	AL,"a"
		JB	$+4
		Sub	AL,20h
		Cmp	AL,20h			;end at <CR> or <NUL>
		JB	GetCrsr
		StosB
		Jmp	MovFileUC
ParmErr:	Pop	AX

GetCrsr:	Mov	AH,3			;read cursor position
		Mov	BH,0
		Int	10h
		Mov	EntryCrsrPosn,DX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RestoreCrsrAnd23and24:
		Mov	AH,2			;set cursor position
		Mov	DX,CS:EntryCrsrPosn	;row & col
		Xor	BH,BH
		Int	10h
		Call	Cls
		Call	RestoreOldINT23and24
		Ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - -
AllocCode:	Push	BX			;used only when 1st run
		Push	CX
		Mov	BX,Offset EndPgm	;last word in pgm
		Mov	CL,4
		ShR	BX,CL
		Inc	BX			;BX = len pgm, paras
		Push	CS
		Pop	ES			;ES=CS => set our block
		Mov	AH,4Ah			;Set size of Block
		Int	21h
		Mov	CX,CS
		Add	BX,CX
		Mov	ParaPastPgm,BX		;for HOTBOOT
		Mov	AH,48h			;allocate RAM
		Mov	BX,0FFFFh		;request impossibly much
		Int	21h
		Mov	HOTparas,BX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - - - - - -
AllocRAM:	Push	BX
		Push	CX
		Mov	AH,48h			;allocate RAM
		Mov	BX,0FFFFh		;request impossibly much
		Int	21h
		Cmp	BX,3000h		;is there (192K) available ?
		JNB	Over192K
		Cmp	BX,400h			;how 'bout 16 kb ?
		JNB	Over16K
		Mov	AH,9
		Mov	DX,Offset NoRAM$	;only ref
		Int	21h
		Mov	AX,1			;signal not enough RAM
		Jmp	Short AllocExit

Over16K:	Xor	DX,DX
		Xchg	AX,BX
		Mov	BX,3
		Div	BX			;request 1/3 of remaining RAM
		Xchg	AX,BX
		Dec	BX
		Mov	ParasToReq,BX
		Jmp	Short pms000

Over192K:	Mov	ParasToReq,0FFFh	;request 63K
pms000:		Mov	BX,ParasToReq
		Mov	AH,48h			;allocate RAM
		Int	21h
		Mov	WorkingSeg,AX		;seg of allocated block of RAM
		Mov	OrigWkSeg,AX		;save again for FCD
		Mov	CX,10h
		Mov	AX,ParasToReq
		Mul	CX
		Mov	WorkSegLength,AX
		Mov	AX,EntryLen23
		Sub	WorkSegLength,AX
	; allocate a second block for the Editor, same size
		Mov	BX,ParasToReq
		Mov	AH,48h			;allocate RAM
		Int	21h
		Mov	EditBufSeg,AX
		Mov	CX,10h
		Mov	AX,ParasToReq
		Dec	AX			;next MCB takes up the last para
		Mul	CX
		Mov	EditBytesToRead,AX
		Mov	EOFpointer,AX
	; allocate a third block for Menus, same size
		Mov	BX,ParasToReq
		Mov	AH,48h			;allocate RAM
		Int	21h
		Mov	MenuSeg,AX
		Xor	AX,AX			;signal no problems
AllocExit:	Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - - - - - -
SetNewINT23and24h:
		Push	AX
		Push	BX
		Push	DX
		Push	ES
		Mov	AL,24h			;Critical Error
		Mov	AH,35h			;get INT vector
		Int	21h
		Mov	Old24hSeg,ES
		Mov	Old24hOfs,BX
		Mov	AH,25h			;set INT vector
		Mov	AL,24h
		Mov	DX,Offset NewINT24h
		Int	21h
		Mov	AH,35h			;get INT vector
		Mov	AL,23h			;Ctrl-Break
		Int	21h
		Mov	Old23hSeg,ES
		Mov	Old23hOfs,BX
		Mov	AH,25h			;set INT vector
		Mov	AL,23h
		Mov	DX,Offset NewINT23h
		Int	21h
		Mov	AX,3302h		;set <Break> / <Ctrl-C> checking
		Mov	DL,0			; OFF for <Ctrl-Letr> drv change
		Int	21h
		Mov	CS:BreakState,DL
		Pop	ES
		Pop	DX
		Pop	BX
		Pop	AX
		Ret

RestoreOldINT23and24:
		Push	AX
		Push	DX
		Push	DS
		Mov	AH,25h			;set INT vector
		Mov	AL,24h			;for INT 24h
		Mov	DX,Old24hOfs
		Mov	DS,Old24hSeg
		Int	21h
		Mov	AH,25h			;set INT vector
		Mov	AL,23h			;for INT 23h
		Mov	DX,Old23hOfs
		Mov	DS,Old23hSeg
		Int	21h
		Mov	AH,33h			;set CTRL-Brk & CTRL-C checking
		Mov	AL,2			;xchg with DL
		Mov	DL,CS:BreakState
		Int	21h
		Pop	DS
		Pop	DX
		Pop	AX
		Ret

NewINT23h:	iRet				;the CTRL-BRK/CTRL-C interrupt

;--- critical error.  See MicroSoft PC Sourcebook, P. 257 ---
;An INT 24h handler must not use any DOS call higher than 12h, and a DOS call
; higher than 12h MUST be used before 12h or lower is used again.
NewINT24h:	Push	BP
		Push	BX
		Push	CX
		Push	DI
		Push	DS
		Push	DX
		Push	ES
		Push	SI
		Mov	AX,CS
		Mov	DS,AX
		Mov	ES,AX
		Mov	ApFlag,0		;so MenuToBuf shows correct menu
		Call	ClsTop2
		Mov	BX,DI			;low byte returns error code
		Xor	BH,BH
		ShL	BX,1
		Mov	DX,CritErrMsgs[BX]	;Get err msg adr
		Mov	CX,28h			;Row 0, Col 28
		Mov	BL,ErrorAttrib
		Call	DisplayZ
pms015:		Mov	BP,Offset ErrorMenu
		Mov	BX,1
pms016:		Mov	NoClsTop2Flag,1		;don't clear the error msg
		Call	ShowMenuAndWaitKey
		Mov	NoClsTop2Flag,0		;so time will show
		Cmp	CX,1			;Yes, retry (any-other-key=No)
		JNZ	NotRetry
		Mov	AL,1			;tell INT 24h to retry
		Call	ClsTop2			;saves AX
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DS
		Pop	DI
		Pop	CX
		Pop	BX
		Pop	BP
		iRet				;return to DOS for retry

NotRetry:	Cmp	CX,2			;Get out of %@*!! INT 24h
		JZ	GetOut
		Cmp	AL,Esc_
		JNZ	pms016
;--- Shortcut back to screen display. Telling DOS 'ignore' (AL=0) is NFG ---
GetOut:		Cli
		Mov	AX,Offset EndStak
		Mov	SP,AX
		Mov	AX,CS
		Mov	SS,AX
		Mov	DS,AX
		Mov	ES,AX
		Sti
		Mov	AX,OrigWkSeg
		Mov	WorkingSeg, AX
		Mov	InputFlag,0
		Mov	EscFlag,0
		Mov	PutPrinterFlag,0
		Cmp	Sub1Drv2Root3,2
		JNZ	SubOrRoot
;File Copy Drive only
		Mov	AX,OldEntryEnd
		Mov	PastLastEntry,AX
		Mov	AX,OldHilited
		Mov	HilitedEntry,AX
SubOrRoot:	Mov	DL,ErrDrvNo
		Cmp	DL,CurrDrvNo
		JNZ	Diffo
;Crit error on same drive as last changed to.  Probably removed floppy
; before exiting editor or copy routine.  Return to drive PMS was run from.
		Mov	DL,OrigPath		;drive letter
		Sub	DL,41h			;drive number
Diffo:		Mov	CurrDrvNo,DL
		Mov	AH,0Eh			;select drive
		Int	21h
		Call	PipsOff
		Mov	CTRLflag,0
		Mov	Sub1Drv2Root3,0
		Mov	GoEntryFlag,1
		Jmp	CritExit
; - - - - - - - - - - - - - - - - -
MainRoutine:	Mov	BX,1
MainRoutine2:	Mov	BP,Offset MainMenu
		Mov	ChkAllKeysFlag,1
		Call	ShowMenuAndWaitKey
		Cmp	AL,Esc_	
		JE	MainRoutine
		JCXZ	MainRoutine2
		Mov	DI,CX			;Calc SubList offset
		Dec	DI
		ShL	DI,1
		Call	[MainSubList+DI]	;Call the proper subroutine
		Jmp	Short MainRoutine2

ExitPMS:	Cmp	NoviceFlag,1		;if expert user,
		JNZ	SetExit			; skip yes/no check
		Call	YesNo
		Or	AL,AL
		JZ	ExitReturn		;back to main menu
SetExit:	Pop	AX			;Pop stack to Exit PMS
ExitReturn:	Ret

	; - - - - - - - - - - - - - - - - -
ShowClockTime:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	SI
		Push	DI
		Push	BP
		Push	DS
		Push	ES
		Push	CS
		Pop	DS
		Mov	AH,2Ch			;get Time
		Int	21h
		Cmp	DH,Seconds
		JNZ	pms025
		Jmp	TimeExit

pms025:		Mov	BP,Offset TimeDisplStr
		Mov	Seconds,DH
		Push	AX
		Mov	AL,DH
		Xor	AH,AH
		Mov	DI,31			;col
		Call	AXtoBPplusDIwithZeros
		Pop	AX
		Mov	Minutes,CL
		Push	AX
		Mov	AL,CL
		Xor	AH,AH
		Mov	DI,28
		Call	AXtoBPplusDIwithZeros
		Pop	AX
		Mov	Hour,CH
		Mov	DI,33
		Mov	Byte Ptr DS:[BP+DI],'a'
		Cmp	CH,12
		JB	ItsAM
		Sub	CH,12
		Mov	Byte Ptr DS:[BP+DI],'p'
ItsAM:		Or	CH,CH
		JNZ	pms029
		Add	CH,12
pms029:		Push	AX
		Mov	AL,CH
		Xor	AH,AH
		Mov	DI,25			;col
		Call	AXtoNosAtBPplusDI
		Pop	AX
SameTime:	Mov	AH,2Ah			;get Date
		Int	21h
		Mov	Day,DL
		Mov	Month,DH
		Mov	Year,CX
		Mov	AL,Day
		Xor	AH,AH
		Mov	DI,7			;column for date
		Call	AXtoNosAtBPplusDI
		Mov	AL,Month
		Dec	AL
		Xor	AH,AH
		ShL	AX,1
		ShL	AX,1
		Mov	BX,Offset MonthStrs
		Mov	SI,AX
		Add	SI,BX
		Inc	DI			;dest for Month
		Add	DI,BP
		Mov	CX,3
		Push	ES
		Push	DS
		Pop	ES
		Rep	MovsB
		Pop	ES
		Mov	AX,Year			;it's in DECIMAL
		Mov	DI,14			;dest for year
		Sub	AX,1900
		Cmp	AX,100			;plan for next century !
		JB	pms030
		Sub	AX,100
pms030:		Call	AXtoBPplusDIwithZeros
pms031:		Cmp	ViewFlag,0		;0 is Status screen
		JNZ	TimeExit
		Cmp	EditingFlag,0
		JNZ	TimeExit
		Mov	CX,52Ah			;Row 5, Col 42
		Mov	BL,DirAttrib
		Mov	DX,Offset TimeDisplStr
		Call	DisplayZ
TimeExit:	Pop	ES
		Pop	DX
		Pop	BP
		Pop	DI
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - -
PaintStatusData:PUSH	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Mov	AH,ViewFlag
		Or	AH,AH			;Status screen ?
		JZ	pms032
		Jmp	NoStats

pms032:		Mov	CX,52Ah			;Row 5, Col 42, date/time bfr
		Mov	BL,DirAttrib
		Mov	DX,Offset TimeDisplStr
		Call	DisplayZ
		Mov	AH,CurrDrvNo
		Add	AH,'A'
		Mov	SI,Offset StatsAndCopyPath
		Mov	[SI],AH
		Inc	SI
		Mov	Byte Ptr [SI],0
		Mov	DX,Offset StatsAndCopyPath
		Mov	BL,InverseAttrib
		Mov	CX,73Ch			;Row 7, Col 60
		Call	DisplayZ
		Mov	DX,Offset Spaces15
		Mov	CX,83Fh			;Row 8, Col 63
		Mov	BL,DirAttrib
		Call	DisplayZ

		Mov	DX,Offset VolName
		Call	GetStrLenPerDXtoAX
		Mov	CL,4Eh			;max col 78
		Sub	CL,AL			;less length of Vol Label
		Call	DisplayZ
		Mov	DX,Offset TotalStorage
		Mov	CX,943h			;Row 9, Col 67
		Call	DisplayZ
		Mov	DX,Offset UsedStorage
		Inc	CH			;row 10
		Call	DisplayZ
		Mov	DX,Offset FreeStorage
		Inc	CH			;row 11
		Call	DisplayZ
		Mov	DX,Offset ClusterSize
		Inc	CH			;row 12
		Call	DisplayZ

		Mov	DX,Offset TotalRAM	;-- System Memory Status --
		Mov	CH,14			;row
		Call	DisplayZ
		Mov	DX,Offset UsedRAM
		Inc	CH			;row 15
		Call	DisplayZ
		Mov	DX,Offset FreeRAM
		Inc	CH
		Call	DisplayZ

		Mov	DX,Offset TotalExt
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset FreeXMS
		Inc	CH
		Call	DisplayZ

		Mov	DX,Offset TotalEMS	;-- EMS Memory Status --
		Mov	CX,1343h		;Row 19, Col 67
		Call	DisplayZ
		Inc	CH
		Mov	DX,Offset FreeEMS
		Call	DisplayZ

		Mov	DX,Offset DOS3str	;-- Display RAM Drive Size --
		Mov	CX,1534h		;Row 21, Col 52
		Mov	SI,Offset RDltr
		Cmp	Byte Ptr [SI],0FFh	;DOS 2.x, can't find RAM drive
		JE	ShowRD
		Mov	DX,Offset RDltr
		Call	DisplayZ
		Mov	CL,67
		Mov	DX,Offset RAMdrvSize
ShowRD:		Call	DisplayZ

NoStats:	Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
GetAvailAndUsedRAM:
		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Push	DS
		Mov	AX,40h
		Mov	DS,AX
		Mov	AX,WORD PTR DS:13h	;memory size, 0280h => 640K
		Pop	DS
		Mov	RAMsize,AX
		Mov	CX,400h
		Mul	CX		;280h * 400h = A0000h, 1st unavail RAM
		Mov	BufDest,Offset TotalRAM
		Call	DX_AXtoBuf		;adds final 0
		Mov	ES,MenuSeg		;last seg allocated
		Mov	AH,4Ah			;allocate RAM
		Mov	BX,0FFFFh		;request infinite amount
		Int	21h			;  BX will return avail
		Add	BX,ParasToReq		;add two other blocks allocated
		Add	BX,ParasToReq		;  will be avail when pgm runs
		Mov	ParasAvail,BX
		Mov	AX,10h
		Mul	BX
		Mov	BufDest,Offset FreeRAM
		Call	DX_AXtoBuf
		Mov	AX,RAMsize
		Mov	BX,40h
		Mul	BX
		Mov	BX,ParasAvail
		Sub	AX,BX
		Mov	BX,10h
		Mul	BX
		Mov	BufDest,Offset UsedRAM
		Call	DX_AXtoBuf

;-- get RAM disk letter & size --
		Mov	AH,30h			;get DOS ver
		Int	21h
		Cmp	AL,3
		JAE	RDDOSok
		Mov	RDltr,0FFh
		Jmp	EMSstats
RDDOSok:	Push	DS
		Push	ES
		Mov	AH,52h
		Int	21h
;****		Mov	AL,ES:[BX+20h]	;no. of Blk Devs, use for drives shown ?
		Mov	SI,ES:[BX+16h]
		Mov	DS,ES:[BX+18h]		;DS:SI points to Drive Table
		Xor	CX,CX			;drive count
RAMdrvLoop:	Cmp	Byte Ptr DS:[SI+44h],0
		JZ	NoRAMdrive
		Cmp	Byte Ptr DS:[SI+44h],40h
		JNZ	NextDrive
		Mov	DI,DS:[SI+45h]
		Mov	ES,DS:[SI+47h]		;ES:DI is this drive Disk Block
		Cmp	Byte Ptr ES:[DI+8],1	;no of FATs. Insuff for net drvs
		JNZ	NextDrive
		Mov	DL,CL			;This is a RAM disk
		Inc	DL			;RAM drv no for func 36h below
		Add	CL,'A'			;RAM drive letter
		Mov	CS:RDltr,CL
		Jmp	Short RDsize
NextDrive:	Add	SI,51h
NextLoop:	Cmp	WORD PTR DS:[SI+1],'\:'	;DOS 4.0 spacing is 58h bytes
		JZ	GotNext
		Inc	SI
		Jmp	Short NextLoop
GotNext:	Inc	CL
		Jmp	Short RAMdrvLoop

GetCMOS:	Out	70h,AL			;-- Read CMOS in to AL --
		Jmp	$+2
		Jmp	$+2
		In	AL,71h
		Jmp	$+2
		Jmp	$+2
		Ret

NoRAMdrive:	Pop	ES
		Pop	DS
		Mov	WORD PTR RDltr,'oN'
		Xor	AX,AX
		Xor	DX,DX
		Jmp	Short PutSize

RDsize:		Pop	ES
		Pop	DS
		Mov	AH,36h			;get Drv free space, drv# in DL
		Int	21h
		Mul	DX
		Mul	CX			;total storage
PutSize:	Mov	BufDest,Offset RAMdrvSize
		Call	DX_AXtoBuf

EMSstats:	Mov	NoEMSflag,0		;-- Get EMS Status --
		Mov	AX,3567h		;get INT 67h vector to ES:BX
		Int	21h			; it will be in the EMS Dev Drvr
		Mov	SI,Offset EMSstring
		Mov	DI,0Ah			;ptr to name in Device Driver
		Mov	CX,8
		RepZ	CmpsB
		JNZ	GetXMS
		Mov	AH,42h			;Page stats, DX=16K-pgs, BX=free
		Int	67h			;the LIM/EMS int
		Push	DS
		Pop	ES
		Or	AH,AH
		JNZ	GetXMS
		Push	BX
		Mov	AX,16384
		Mul	DX			;result to DX:AX
		Mov	BufDest,Offset TotalEMS
		Call	DX_AXtoBuf
		Mov	AX,16384
		Pop	BX
		Mul	BX
		Mov	BufDest,Offset FreeEMS
		Call	DX_AXtoBuf
		Mov	AH,46h			;get Version to AL
		Int	67h
		Or	AH,AH
		JNZ	GetXMS
		Mov	DI,Offset EMSver
		Mov	BL,AL			;save EMS ver in BL
		Mov	AL,'v'
		StosB
		Mov	AL,BL
		Mov	CL,4
		ShR	AL,CL			;move hi nibble to lo
		Add	AL,30h			;make ASCII
		StosB
		Mov	AL,'.'
		StosB
		Mov	AL,BL			;get Version again
		And	AL,00001111b		;keep only the lo nibble
		Add	AL,30h
		StosB

GetXMS:		Mov	AX,4300h		;-- XMS Memory Status --
		Int	2Fh
		Xor	DX,DX
		Cmp	AL,80h
		JNE 	GetExt
		Mov	AX,4310h		;Get XMS driver Adr
		Int	2Fh
		Mov	XMSdriver,BX
		Mov	XMSdriver+2,ES
		Xor	AX,AX			;Get XMS ver
		Call	DWord Ptr XMSdriver
		Push	DS
		Pop	ES
		Mov	DI,Offset XMSver
		Xchg	AX,BX			;save XMS ver in BX
		Mov	AL,'v'
		StosB
		Mov	AL,BH			;get major ver
		Add	AL,30h			;make ASCII
		StosB
		Mov	AL,'.'
		StosB
		Xor	AX,AX
		Mov	AL,BL			;get minor ver
		Div	Ten
		Add	AL,30h			;make digit 1 ASCII
		StosB
		Mov	AL,AH
		Add	AL,30h			;make digit 2 ASCII
		StosB
		Mov	AX,800h			;Get free XMS
		Call	DWord Ptr XMSdriver
CalcXMS:	Mov	AX,1024
		Mul	DX
		Mov	BufDest,Offset FreeXMS
		Call	DX_AXtoBuf

GetExt:		Push	DS			;-- Extended Memory Status --
		LDS	SI,DWord Ptr SysIdPtr	; ptr to system ID
		LodsB				; get system ID
		Pop	DS
		Cmp	AL,0FCh			; Check if PC or XT
		JA	GetRAMrtn		; No extended mem if it is
		Cmp	FreeXMS,'r'		; If XMS driver is loaded,
		JNE	FromCMOS		;  try CMOS, INT 15h won't work
		Mov	AH,88h			; Else use Int 15h
		Int	15h
		Jmp	GotExt
FromCMOS:	Mov	AL,18h
		Call	GetCMOS			; Get hi byte
		Xchg	AH,AL
		Mov	AL,17h			; Get lo byte
		Call	GetCMOS
GotExt:		Mov	DX,1024
		Mul	DX
		Mov	BufDest,Offset TotalExt
		Call	DX_AXtoBuf

GetRAMrtn:	Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
GetVolAndFreeSpace:
		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	NFGdriveFlag,0
		Mov	AH,36h			;get Drive free/total space
		Mov	DL,CurrDrvNo
		Inc	DL
		Int	21h
		Cmp	AX,0FFFFh		; invalid drive ?
		JNZ	ValidDrive
		Mov	NFGdriveFlag,1
ValidDrive:	Push	AX			; sectors/cluster
		Push	BX			; available clusters
		Push	CX			; bytes/sector (usually 512)
		Push	DX			; total clusters
		Mov	FreeSpace,BX
		Mul	CX
		Mov	Cluster,AX
		Mul	BX
		Mov	BufDest,Offset FreeStorage
		Call	DX_AXtoBuf
		Pop	BX			; was DX
		Pop	CX
		Pop	DX
		Pop	AX
		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Mul	CX
		Mul	BX
		Mov	BufDest,Offset TotalStorage
		Call	DX_AXtoBuf
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Push	AX
		Push	CX
		Sub	BX,DX
		Mul	CX
		Mul	BX
		Mov	BufDest,Offset UsedStorage
		Call	DX_AXtoBuf
		Pop	CX			; Calc Cluster Size
		Pop	AX
		Mul	CX
		Mov	BufDest,Offset ClusterSize
		Call	DX_AXtoBuf
GetVol:		Push	DS
		Pop	ES
		Mov	DX,Offset DirDTA	;DS:DX points new DTA
		Mov	AH,1Ah			;set DTA
		Int	21h
		Mov	AH,CurrDrvNo
		Add	AH,'A'
		Mov	CurrDrvLtr,AH
		Mov	DX,Offset CurrDrvLtr	;'d:\*.*',0
		Mov	AH,4Eh			;find first file
		Mov	CX,8			;attrib = Volume name
		Int	21h			;here's where Crit Error occurrs
		JNC	ChkIfVol
		Cmp	NFGdriveFlag,1
		JNZ	ShowNoVol
		Mov	SI,Offset UnknUnitMsg
		Jmp	Short ShowBadVol
ShowNoVol:	Mov	SI,Offset NoVolStr
ShowBadVol:	Mov	DI,Offset VolName
		Mov	CX,10h			;len of string, includes final 0
		Rep	MovsB
		Jmp	Short VandSdone

ChkIfVol:	Mov	SI,Offset AttributeByte
		LodsB
		And	AL,8
		Cmp	AL,8			;is this a Vol Label ?
		JNZ	ShowNoVol
		Mov	SI,Offset AttributeByte
		Add	SI,Nine			;to 1st char of name
		Mov	DI,Offset VolName
		Mov	CX,0Dh
VolLoop:	Mov	AH,[SI]
		Inc	SI
		Cmp	AH,'.'
		JZ	SkpDot
		Mov	[DI],AH
		Inc	DI
SkpDot:		Loop	VolLoop

VandSdone:	Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
PaintBlankScreen:
		Push	BX
		Push	CX
		Push	DX
		Call	Cls3rdLine
		Mov	DX,Offset ULcor
		Mov	CX,300h			;row 3, col 0
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,Offset URcor
		Mov	CL,79
		Call	DisplayZ
		Mov	CH,3
VertBarLoop:	Mov	DX,Offset VertBar
		Xor	CL,CL			;col 0
		Inc	CH			;start with row 4
		Cmp	CH,23
		JZ	pms038
		Cmp	CH,13
		JNZ	SameChar
		Mov	BL,HilitDirAttrib
		Mov	DX,Offset UpArrow
		Call	DisplayZ
		Mov	CL,40
		Mov	DX,Offset DnArrow
		Call	DisplayZ
		Mov	CL,79
		Call	DisplayZ
		Mov	BL,MenuAttrib
		Jmp	Short VertBarLoop

SameChar:	Call	DisplayZ
		Mov	CL,40
		Call	DisplayZ
		Mov	CL,79
		Call	DisplayZ
		Jmp	Short VertBarLoop

pms038:		Mov	DX,Offset ScreenBottomLn
		Call	DisplayZ		;CH & CL already set
		Call	ShowBottomLine
		Pop	DX
		Pop	CX
		Pop	BX
		Ret

ShowBottomLine:	Mov	DX,Offset BottomLine
		Mov	BL,TextAttrib
		Mov	CH,18h			;row
		Xor	CL,CL
		Jmp	DisplayZ
; - - - - - - - - - - - - - - -
PaintEditScreen:Push	BX
		Push	CX
		Push	DX
		Mov	DX,Offset DblHorLine
		Mov	CX,200h			;Row 2, Col 0
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,Offset EightySpaces
BlankLineLoop:	Inc	CH
		Cmp	CH,17h
		JZ	pms039
		Call	DisplayZ
		Jmp	Short BlankLineLoop

pms039:		Mov	DX,Offset DblHorLine
		Mov	CX,1700h		;Row 23, Col 0
		Call	DisplayZ
		Push	AX
		Mov	DX,Offset EditorBotLine
		Mov	BL,MenuAttrib
		Mov	CX,1800h		;Row 24, Col 0
		Call	DisplayZ
		Pop	AX
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - -
PaintStatusOrDateScrn:
		Push	BX
		Push	CX
		Push	DX
		Mov	DX,Offset FnameHeader
		Mov	CX,301h			;Row 3,Col 1
		Mov	BL,InverseAttrib
		Call	DisplayZ
		Cmp	ViewFlag,1		;Date/Time screen ?
		JZ	pms040
		Call	ShowStatusScreen
		Jmp	Short pms041

pms040:		Call	ShowDateScreen
pms041:		Pop	DX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - -
GetStrLenPerDXtoAX:
		Push	DI
		Xor	AX,AX			;initialize counter
		Mov	DI,DX
pms042:		Cmp	Byte Ptr [DI],0
		JZ	pms043
		Inc	AX
		Inc	DI
		Jmp	Short pms042

pms043:		Pop	DI
		Ret
; - - - - - - - - - - - - - - - -
CopyUpTo0:	PushF
CopyUpLoop:	Cmp	Byte Ptr [SI],0
		JZ	CopyUpExit
		MovsB
		Jmp	Short CopyUpLoop
CopyUpExit:	PopF
		Ret
; - - - - - - - - - - - - - - - -
;Used for: SearchBuf, ReplBuf, ApBuf, 7EINstring,
; PrintSetup, CCbuf (File Print), WritePath (BlockPut) and CmdDOSbuf.
;Enter w/BH=chars to input=window size, SI>list of OK chars, DX>dest,
; CL=col, CH=row for window, and CursorLocn holding xxCursor
;The end of the string is the 1st 0.  DI points to the cursor.
;Returns AL=1 if <Esc> hit or no chars entered, AH=0FFh if <Esc> hit

InputBHchars:	Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	DS
		Push	ES
		Mov	AX,CS
		Mov	ES,AX
		Mov	DS,AX
		Mov	CurrWindowLocn,CX
		Mov	BL,BH
		Xor	BH,BH
		Mov	CharsToInput,BX
		Mov	BP,DX			;save dest pointer
	;clear a buffer to show the whole window
		Mov	CX,CharsToInput
		Mov	DI,Offset StatsAndCopyPath
		Mov	AL,' '
		Rep	StosB
		Mov	Byte Ptr [DI],''	;mark last space as unusable
		Inc	DI
		Mov	Byte Ptr [DI],0
		Mov	DI,CursorLocn		;old cursor pointer
GetEntryChar:	Mov	ShowCrsrFlag,1		; Show the window ...
		Mov	CX,CurrWindowLocn
		Mov	BL,InverseAttrib
		Mov	DX,Offset StatsAndCopyPath  ;all blanks
		Call	DisplayZ
		Mov	DX,BP			; Show the buffer ...
		Call	DisplayZ
		Mov	ShowCrsrFlag,0		;for time update while entering
		Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey
		Cmp	AH,0FFh			; 0FFh is a mouse click
		JNZ	pms046			; If not a click
		Mov	AL,CR			; Simulate CR if LB or MB
pms046:		Or	AL,AL			;special key ?
		JZ	TryLA
		Jmp	pms047

TryLA:		Cmp	AH,4Bh			;Left Arrow
		JNZ	TryERt
		Or	DI,DI
		JBE	BadEKey
		Dec	DI			;not at start
		Jmp	Short GetEntryChar

TryERt:		Cmp	AH,4Dh			;Right Arrow
		JNZ	TryEHm
		Cmp	Byte Ptr DS:[BP+DI],0
		JNZ	NotRtEnd
BadEKey:	Call	MakeBeepIf
		Jmp	Short GetEntryChar

NotRtEnd:	Inc	DI
		Jmp	Short GetEntryChar

TryEHm:		Cmp	AH,47h			;Home
		JNZ	TryEEn
		Mov	DI,0
		Jmp	GetEntryChar

TryEEn:		Cmp	AH,4Fh			;End
		JNZ	TryEDl
FindEndLoop:	Cmp	Byte Ptr DS:[BP+DI],0
		JZ	GetEntryChar
		Inc	DI
		Jmp	Short FindEndLoop

TryEDl:		Cmp	AH,53h			;Del
		JNZ	ChkPrintSetup
		Cmp	Byte Ptr DS:[BP+DI],0
		JZ	BadEKey
		Call	EDelete
		Jmp	Short GetEntryChar

ChkPrintSetup:	Cmp	CS:InputFlag,2
		JNZ	ChkCmdDOS
		Cmp	AH,44h			;F10
		JNZ	BadEKey
		Mov	AL,Esc_
		Cmp	DI,CharsToInput
		JNB	BadEKey
		Jmp	PGoodChar		;don't check for valid char

ChkCmdDOS:	Cmp	CS:InputFlag,1
		JNZ	BadEkey
		Cmp	AH,50h			;Down arrow
		Mov	AL,2
		JNZ	TryEup
		Jmp	EntryDone

TryEup:		Cmp	AH,48h			;Up arrow
		JNZ	BadEkey
		Mov	AL,3
		Jmp	EntryDone

; . . . . . . . . . . . . . . .
EDelete:	Push	DI
DelLoop:	Mov	AL,DS:[BP+DI+1]
		Mov	DS:[BP+DI],AL
		Or	AL,AL
		JNZ	NxtDown
		Pop	DI
		Ret

NxtDown:	Inc	DI
		Jmp	Short DelLoop
; . . . . . . . . . . . . . . .
pms047:		Cmp	AL,Esc_
		JNZ	pms048
		Mov	AX,0FF01h
		Jmp	Short ToEntryDone

pms048:		Cmp	AL,CR
		JNZ	pms049
		Cmp	Byte Ptr DS:[BP],0	;1st char must be non-zero
		JNZ	ToEntryDone
		Mov	AX,1			;no chars in the window to enter
ToEntryDone:	Jmp	EntryDone

pms049:		Cmp	AL,8			;bksp
		JNZ	pms051
		Or	DI,DI
		JA	pms050
		Jmp	BadEKey

pms050:		Dec	DI
		Call	EDelete
		Jmp	GetEntryChar

pms051:		Cmp	AL,7Fh			;CTRL-bksp
		JNZ	ItsAchar
		Mov	CX,CharsToInput
		Mov	AL,0
		Mov	DI,BP
		Rep	StosB
		Mov	DI,0
		Jmp	GetEntryChar

ItsAchar:	Cmp	DI,CharsToInput
		JB	ChkValidChar
		Jmp	BadEKey

ChkValidChar:	Push	SI
		Cmp	AllCharsFlag,0
		JZ	ValidLoop
		Mov	SI,Offset AllChars	;reject CR, LF, EOF, 0
InvalidLoop:	Cmp	Byte Ptr [SI],0
		JZ	GoodChar
		Cmp	AL,[SI]
		JZ	pms052
		Inc	SI
		Jmp	Short InvalidLoop

ValidLoop:	Cmp	Byte Ptr [SI],0
		JZ	pms052
		Cmp	AL,[SI]
		JZ	GoodChar
		Inc	SI
		Jmp	Short ValidLoop

pms052:		Pop	SI
		Jmp	BadEKey

GoodChar:	Pop	SI
		Cmp	InputFlag,3		;getting # copies to Print ?
		JNZ	PGoodChar
		Mov	InputFlag,0		;overwrite 1st char only
		Mov	DS:[BP+DI-1],AL
		Jmp	GetEntryChar

PGoodChar:	Mov	CX,CharsToInput
		Sub	CX,DI			;no. of chars to move up
		Dec	CX
		Mov	DI,CharsToInput
		Dec	DI			;point to last possible char loc
		Cmp	Byte Ptr DS:[BP+DI],0
		JZ	PullUpLoop
		Inc	DI			;keep cursor at same location,
		Jmp	BadEKey			;  the buffer is full

PullUpLoop:	Or	CX,CX
		JZ	NoLoop			;to prevent looping 64K times!
		Mov	BL,DS:[BP+DI-1]
		Mov	DS:[BP+DI],BL
		Dec	DI
		Loop	PullUpLoop
NoLoop:		Mov	DS:[BP+DI],AL
		Inc	DI
		Jmp	GetEntryChar

EntryDone:	Mov	CursorLocn,DI
		Mov	AllCharsFlag,0
		Pop	ES
		Pop	DS
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - -
;call with DI > dest
EnterFName:	Mov	CX,100h			;CX=Row,Col
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Mov	BP,DI			;BP+DI=dest
		Mov	CurrWindowLocn,CX
		Push	ES
		Push	DS
		Pop	ES
		Mov	BX,Offset FNameBuf	;Clear FileName display bufr
		Mov	DI,BX
		Mov	AL,' '
		Mov	CX,12
		Rep	StosB
		Sub	DI,4
		Mov	Byte Ptr [DI],'.'
		Mov	SI,BP			;Fmt current FileName
		Add	DI,5
		Mov	CX,9
FnFmt:		LodsB
		Or	AL,AL
		JZ	FnFmtDone
		Cmp	AL,'.'
		JNE	FnFmtChar
		Dec	CX
		JCXZ	FnFmtChar
		Rep	StosB
		Mov	CX,4
FnFmtChar:	StosB
		Loop	FnFmt
FnFmtDone:	Pop	ES
		Xor	DI,DI			;DS:BP+DI = FileName in bfr
		Xor	SI,SI			;BX+SI = FileName to display
NxtFNkey:	Cmp	SI,12
		JZ	pms053
		Cmp	SI,8
		JZ	pms053
		Mov	Byte Ptr [BX+SI],''	;the cursor
pms053:		Push	BX
		Mov	CX,CurrWindowLocn
		Mov	DX,Offset FNameBuf
		Mov	BL,InverseAttrib
		Call	DisplayZ
		Pop	BX
		Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey
		Cmp	AH,0FFh			; 0FFh is a mouse click
		JNZ	FnNotClick		; If its not a click
		Mov	AL,CR			; Simulate CR if LB or MB
FnNotClick:	Or	AL,AL
		JNZ	pms054			;If not extended key
		Cmp	AH,4Bh			;Check for <Left>
		JZ	pms060a			;Treat as a <BackSpace>
		Cmp	AH,4Dh			;Check for <Right>
		JNZ	FnInvalid
		Push	BX			;Get char from current name
		Add	BX,13			;ptr to current file name
		Mov	AL,DS:[BX+SI]
		Pop	BX
		Jmp	Short CheckExt
FnInvalid:	Call	MakeBeepIf
NxtFNkey$:	Jmp	Short NxtFNkey

pms054:		Cmp	AL,Esc_
		JNZ	pms055
		STC
		Jmp	Short pms057

pms055:		Cmp	AL,CR
		JNZ	CheckExt
		Cmp	SI,1			;any characters entered ?
		JNB	pms056
		Jmp	Short pms057		;Carry is set
pms056:		Mov	Byte Ptr DS:[BP+DI],0
		Or	AL,AL			;clear Carry
pms057:		Jmp	FNameDone

CheckExt:	Cmp	AL,'.'
		JNZ	pms060
		Cmp	SI,1
		JB	pms065
		Cmp	SI,9
		JNB	pms065
pms058:		Mov	DS:[BP+DI],AL
		Inc	DI
		Cmp	SI,8
		JZ	pms059
		Mov	Byte Ptr [BX+SI],' '
pms059:		Mov	SI,9
		Jmp	Short NxtFNkey$

pms060:		Cmp	AL,8			;<BackSpace>
		JNZ	pms064
pms060a:	Cmp	SI,9
		JZ	pms063
		Cmp	SI,1
		JB	pms065

pms061:		Dec	DI
		Cmp	SI,0Ch
		JZ	pms062
		Cmp	Byte Ptr [BX+SI],'.'
		JZ	pms062
		Mov	Byte Ptr [BX+SI],' '
pms062:		Dec	SI
		Jmp	Short NxtFNkey$

pms063:		Mov	Byte Ptr [BX+SI],' '
		Dec	DI
		Mov	SI,DI
		Jmp	Short NxtFNkey$

pms064:		Cmp	SI,0Ch
		JZ	pms065
		Cmp	SI,8
		JNZ	pms066

pms065:		Call	MakeBeepIf
		Jmp	Short NxtFNkey$

pms066:		Cmp	AL,'a'
		JB	pms067
		Cmp	AL,'z'
		JA	pms067
		And	AL,0DFh			;make Upper-case
pms067:		Push	SI
		Mov	SI,Offset FnameChars	;only ref
pms068:		Cmp	Byte Ptr [SI],0
		JZ	pms069
		Cmp	AL,[SI]
		JZ	pms070
		Inc	SI
		Jmp	Short pms068
pms069:		Pop	SI
		Jmp	Short pms065

pms070:		Pop	SI
		Mov	DS:[BP+DI],AL
		Inc	DI
		Mov	[BX+SI],AL
		Inc	SI
		Jmp	NxtFNkey

FNameDone:	Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Ret				;C set if <Esc> or no chars
; - - - - - - - - - - - - - - - - - -
ErrIfNovice:	Cmp	NoviceFlag,1
		JNZ	ShowErrRet
		Xor	AX,AX
ShowErrMsg:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Call	ClsTop2
		Call	GetStrLenPerDXtoAX	;center the message
		Mov	CX,50h
		Sub	CX,AX
		ShR	CX,1
		Xor	CH,CH
		Mov	BL,ErrorAttrib
		Call	DisplayZ
		Call	MakeBeepIf
		Inc	CH			;row
		Mov	CL,27			;column
		Mov	DX,Offset PressKeyMsg
		Call	DisplayZ
		Mov	AH,3			;Flush Kbd bfr, use mouse
		Call	WaitKey			;wait for any key
		Call	ClsTop2
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
ShowErrRet:	Ret
; - - - - - - - - - - - - - - - - - -
DisplayZ:	Push	AX			; Text ptr in DS:DX, Attr in BL
		Push	CX			; Row in CH, Col in CL
		Push	DX			; DI=Cursor-pos, If ShowCrsrFlag
		Push	ES			; Note: chars <= 0Ah will change
		Push	SI			;   to that rel. color attrib.
		Push	DI
		Mov	SI,DX			;points to text to display
		Mov	ES,CS:VideoSeg
		Xor	AX,AX			;--Calc AX = (Row*80 + Col)*2--
		Xchg	AL,CH
		Mov	DX,80
		Mul	DX
		Add	AX,CX
		ShL	AX,1
		Mov	CX,CS			; Is DS same as CS?
		Mov	DX,DS
		Xor	CX,DX
		Not	CX			; CX=FFFFh if so, 0 if not
		Mov	DX,DI			; Cursor pos to DX
		Add	DX,SI
		Inc	DX
		Mov	DI,AX			; Offset into VideoSeg
		Cmp	CS:ShowCrsrFlag,1	; Cursor required?
		JZ	DisplayNext		; Yes:
		Xor	DX,DX			; No: clear cursor ptr
DisplayNext:	LodsB				; Get next char
		Or	AL,AL			; Check for ASCII 00
		JZ	DisplayRtn
		Cmp	AL,10			; Attribute change?
		JA	DisplayCursor
		JCXZ	DisplayCursor		; Not if DS is other than CS
		Cmp	AllCharsFlag,0
		JNZ	DisplayCursor		; or if must show all chars
		Xor	BX,BX
		Mov	BL,AL			; Index to new attribute
		Mov	BL,CS:TextAttrib-1[BX]	; Get new attribute
		Jmp	Short DisplayNext
DisplayCursor:	Mov	AH,BL			; Color attribute
		Cmp	SI,DX			; Cursor required here?
		JNE	DisplayWrite		; No:
		Mov	CX,4			; Yes: invert attribute
		RoR	AH,CL
		And	AH,01110111b		; Strip blink & intensity bits
DisplayWrite:	StosW				; Display next char & attr
		Jmp	Short DisplayNext

DisplayRtn:	Pop	DI
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	CX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - -
SetCrsrAndVideoSeg:
		Push	ES
		Push	AX
		Push	SI
		Push	DI
		Push	CX
		Mov	ES,BIOSseg		;40h
		Mov	AL,ES:10h
		And	AL,30h
		Cmp	AL,30h
		Mov	AX,0B000h		;Mono: set seg & mono colors
		Mov	CX,(Offset BeepFlag-Offset TextAttrib)
		Mov	SI,Offset MonoAttrib
		Mov	DI,Offset TextAttrib
		JZ	SetSeg
		Mov	AX,0B800h		;CGA: set seg & working colors
		Mov	SI,Offset SavedCNF	;for switch to CGA from Mono
SetSeg:		Mov	VideoSeg,AX
		Push	CS
		Pop	ES
		Rep	MovsB
		Mov	AL,3			;80 X 25 text on CGA
		Cmp	VideoSeg,0B800h		;CGA ?
		JZ	SetBios
		Mov	AL,7			;Mono
SetBios:	Xor	AH,AH			;set Video Mode
		Int	10h
		Mov	AH,2			;set cursor position
		Mov	BH,0
		Mov	DH,25			;off the screen
		Mov	DL,1			;col 1
		Int	10h
		Pop	CX
		Pop	DI
		Pop	SI
		Pop	AX
		Pop	ES
		Ret
; - - - - - - - - - - - - - - - - - -
MakeBeepIf:	Push	AX
		Push	BX
		Cmp	BeepFlag,1
		JNZ	BeepRtn
		Xor	BX,BX			;Beep using BIOS
		Mov	AX,0E07h		;Write Char (07h)
		Int	10h
BeepRtn:	Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - -
;Stuff Scan/ASCII codes into the Keyboard buffer.  DS:SI=Codes, CX=Len
StuffKeys:	Push	DI
		Push	ES
		And	CX,15			;15 chars max
		JCXZ	StuffRet
		Mov	ES,BIOSseg
		Mov	DI,1Eh			;Start of Kbd bfr
		Mov	ES:[1Ah],DI		;Set Kbd bfr head ptr
		Rep	MovsW			;Put codes ito Kbd bfr
		Mov	ES:[1Ch],DI		;Set Kbd bfr tail ptr
StuffRet:	Pop	ES
		Pop	DI
		Ret
; - - - - - - - - - - - - - - - - - -
WaitKey:	Push	DX
		Push	CX
		Push	BX
		Mov	EscFlag,0
		Test	AH,1			;1=Flush Kbd bfr, +2=Chk Mouse
		JZ	MCursorOn
		Mov	AH,0Ch			;console I/O, flushes kbd buffer
		Mov	AL,6
		Mov	DL,0FFh			;do input
		Int	21h
MCursorOn:	Mov	WaitKeyFlg,AH		;; Save the WaitKey option flag
		Cmp	AH,2			; Was mouse input requested?
		JL	UpdateTime		; If not, don't turn on cursor
		Mov	AX,1			; Turn mouse cursor On
		Int	33h			; (every time except in Editor)
UpdateTime:	Cmp	NoClsTop2Flag,1
		JNB	CheckRB
		Call	ShowClockTime		;ONLY call
CheckRB:	Cmp	Mouse,0			; Check if mouse available
		JE	CheckKbd		; If no mouse
		Mov	AX,5			; Check right mouse button
		Mov	BX,1
		Int	33h
		Or	BL,BL			; Was right button clicked?
		JZ	CheckLB			; No: check left button
		Mov	AX,011Bh		; Yes: set <Esc> keycode
		Jmp	Short SaveMousePos
CheckLB:	Cmp	WaitKeyFlg,2		; Should we check LB and MB?
		JL	CheckKbd
		Mov	AX,5			; Check left mouse button
		Xor	BX,BX
		Int	33h
		Or	BL,BL			; Was left button clicked?
		JZ	CheckMB
		Mov	AX,0FF01h		; Set pseudo-code for LB
		Jmp	Short SaveMousePos
CheckMB:	Cmp	Mouse,3			; Does mouse have a 3rd button?
		JNE	CheckKbd
		Mov	AX,5			; Check middle mouse button
		Mov	BX,2
		Int	33h
		Or	BL,BL			; Was middle button clicked?
		JZ	CheckKbd		; No: go check for a char
		Mov	AX,0FF02h		; Yes: Set pseudo-code for MB
SaveMousePos:	Mov	BX,CX			; Mouse Col to BX
		Mov	CL,3
		ShR	BX,CL          		; Divide by 8 to give text Col
		ShR	DX,CL			; and Row
		Mov	MouseCol,BX		; Save Col (0-79)
		Mov	MouseRow,DX		; Save Row (0-24)
		Jmp	Short MCursorOff	;only ref

CheckKbd:
;All this to make ALT-` type '' (scan code 29h hit, 0A9h release)
		Cmp	ApproxFlag,1		;did we just type ''?
		JZ	WaitRelease
		Push	DS
		Xor	AX,AX
		Mov	DS,AX
		Test	BYTE PTR DS:0417h,00001000b	;is ALT depressed ?
		Pop	DS
		JZ	RegInp
		In	AL,60h
		Cmp	AL,29h			;scan code for the ` key
		JNZ	RegInp
		Mov	AL,0F7h			;''
		Mov	ApproxFlag,1
		Jmp	SHORT WaitKeyRet

RegInp:		Mov	AH,1			; check if kbd char avail
		Int	16h
		JNZ	GetChar
		Jmp	UpdateTime

GetChar:	Xor	AH,AH			; get the char
		Int	16h
MCursorOff:	Cmp	WaitKeyFlg,2		; Was mouse input requested?
		JL	WaitKeyRet		; No: skip cursor off
		Push	AX
		Mov	AX,2			; Turn mouse cursor Off
		Int	33h
		Pop	AX
WaitKeyRet:	Pop	BX
		Pop	CX
		Pop	DX
		Ret				;w/AH=0FFh if LB or MB click

WaitRelease:	In	AL,60h
		Cmp	AL,0A9h
		JNZ	WaitRelease
		Mov	ApproxFlag,0
		Jmp	Short CheckKbd
; - - - - - - - - - - - - - - - - - -
ClsRightHalf:	Push	AX
		Push	CX
		Push	DI
		Push	ES
		Mov	ES,VideoSeg
		Mov	AL,' '
		Mov	AH,FileAttrib
		Mov	DI,0232h	;562d, 281st char, halfway thru 4th line
HalfLine:	Mov	CX,26h		;38d, the width of the right screen
		Rep	StosW
		Add	DI,54h			;84d
		Cmp	DI,0EAAh		;3754d
		JB	HalfLine
		Pop	ES
		Pop	DI
		Pop	CX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - -
ClsTop2:	Push	CX
		Push	DI
		Xor	DI,DI
		Mov	CX,160			;words (2 rows)
		Jmp	ClsEnd
; - - - - - - - - - - - - - - - - - -
Cls3rdLine:	Push	CX
		Push	DI
		Mov	DI,320
		Mov	CX,80
		Jmp	ClsEnd
; - - - - - - - - - - - - - - - - - -
Cls2ndLine:	Push	CX
		Push	DI
		Mov	DI,160			;start of 2nd row
		Mov	CX,80
ClsEnd:		Push	AX
		Push	ES
		Push	DS
		Push	CS
		Pop	DS
		Mov	ES,VideoSeg
		Mov	AL,' '
		Mov	AH,MenuAttrib
		Rep	StosW
		Pop	DS
		Pop	ES
		Pop	AX
		Pop	DI
		Pop	CX
		Ret
; - - - - - - - - - - - - - - - - - -
Cls:		Push	AX
		Push	CX
		Push	DI
		Push	ES
		Mov	ES,VideoSeg
		Xor	DI,DI
		Mov	AH,7			;standard wht on blk
		Mov	AL,' '
		Mov	CX,2000
		Rep	StosW
		Pop	ES
		Pop	DI
		Pop	CX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - -
;On entry, BX=item to hilight, BP points to menu to display.
;For Ap menus, BP points 1st item on current menu in the Index.
ShowMenuAndWaitKey:
		Push	ES
		Push	DS
		Push	BP
		Push	DI
		Push	SI
		Push	DX
		Mov	CX,CS
		Mov	DS,CX
		Mov	ES,CX
		Add	BX,BX
		Mov	SI,BX			;item to hilite, X 2
		Call	MenuToBuffer		;also fills in Ap prompt line
ClearTop:	Cmp	NoClsTop2Flag,1
		JZ	ShowTheMenu
		Call	ClsTop2
ShowTheMenu:	Mov	DX,Offset MenuBuf
		Xor	CX,CX			;row 0, col 0
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Call	InverseInMenu		;only call
		Call	Cls2ndLine		;only call
		Cmp	ApFlag,0
		JZ	NormalKind
		Mov	ApFlag,3
		Call	MenuToBuffer		;get the prompt line to Line2Buf
		Mov	ApFlag,1
		Mov	DX,Offset Line2Buf
		Jmp	Short BothKinds
NormalKind:	Mov	DX,[SI+Line2Ptrs]
		Add	DX,BP
BothKinds:	Mov	CX,100h			;Row 1, Col 0
		Mov	BL,MenuAttrib
		Call	DisplayZ
AwaitMenuKey:	Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey
		Cmp	AH,0FFh			; 0FFh is a mouse click
		JNZ	NotMouseClick
		Call	MouseClick
		Or	AX,AX			; Ignore this click ?
		JZ	AwaitMenuKey		; Yes
		Cmp	AL,1			; Clicked on a menu item?
		JNE	NotMouseClick		; No, simulated keypress
		Jmp	MenuEnter		; Yes, do that menu item
NotMouseClick:	Cmp	ChkAllKeysFlag,1	;in Editor ?
		JE	NotEditing
		Jmp	ChkArrowKeys

NotEditing:	Cmp	AX,5202h		; Mouse click on Directory?
		JE	TryInsKey
		Or	AL,AL			;special key ?
		JZ	TryInsKey
		Jmp	NotSpecial

TryInsKey:	Cmp	AH,52h			;<Ins> = Open Dir or Edit File
		JNZ	TryDel
		Cmp	BP,Offset MainMenu
		JNZ	DoOpnDir		;If Root Directory
		Push	ES
		Push	BP
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Mov	DI,BP
		Test	Byte Ptr ES:[BP],10h
		Pop	BP
		Pop	ES
		JNZ	DoOpnDir		;If its a subdirectory
		Call	GoEdit
pms082:		Mov	BX,1
		Xor	CX,CX			;no valid key
		Jmp	ShowMenuExit

DoOpnDir:	Call	OpenDir
		Cmp	AX,5302h
		JNE	ClearTop$
TryDel:		Cmp	AH,53h
		JNZ	TryUp
		Call	CloseDir
ClearTop$:	Jmp	ClearTop

TryUp:		Cmp	AH,48h			;Up Arrow
		JNZ	TryDown
		Call	FilesDown
		Jmp	Short AwaitMenuKey$

TryDown:	Cmp	AH,50h			;Down Arrow
		JNZ	pms086
		Call	FilesUp
		Jmp	Short AwaitMenuKey$

pms086:		Cmp	AH,49h			;PgUp
		JNZ	pms087
		Call	FilesPgUp
		Jmp	Short AwaitMenuKey$

pms087:		Cmp	AH,51h			;PgDn
		JNZ	pms088
		Call	FilesPgDn
		Jmp	Short AwaitMenuKey$

pms088:		Cmp	AH,47h			;Home
		JNZ	pms089
		Call	FilesHome
AwaitMenuKey$:	Jmp	AwaitMenuKey

pms089:		Cmp	AH,4Fh			;End
		JNZ	ChkF3
		Call	FilesEnd
		Jmp	Short AwaitMenuKey$

ChkF3:		Cmp	AH,3Dh			;F3
		JNZ	ChkF4
		Call	ShowStatusScreen
		Jmp	Short AwaitMenuKey$

ChkF4:		Cmp	AH,3Eh			;F4
		JNZ	NotSpecial
		Call	ShowDateScreen
		Jmp	Short AwaitMenuKey$

NotSpecial:	Push	AX			;Can't test for <Ctrl-C> if
		Push	ES			; Break is On! It is unreliable
		Xor	AX,AX
		Mov	ES,AX
		Test	Byte Ptr ES:[417h],4	;bit 2, CTRL
		Pop	ES
		Pop	AX
		JZ	TryMinus
		Or	AL,AL			;CTRL is hit
		JZ	TryMinus
		Cmp	AL,26			;allows up to 'Z'
		JA	TryMinus
		Dec	AL			;CTRL-letter hit
		Mov	AH,AL
		Mov	CtrlFlag,1		;signal don't ask for drive
		Call	GoDrive
		Mov	AH,CurrDrvNo
		Mov	ErrDrvNo,AH
		Mov	CtrlFlag,0
		Jmp	Short AwaitMenuKey$

TryMinus:	Cmp	AL,"-"			;<Minus> or <Gray-Minus>
		JNE	TryPlus
		Call	PrevDir
		Jmp	AwaitMenuKey

TryPlus:	Cmp	AL,"+"			;<Plus> or <Gray-Plus>
		JNE	ChkArrowKeys
		Call	NextDir
		Jmp	AwaitMenuKey

ChkArrowKeys:	Cmp	AH,4Bh			;Left Arrow
		JNZ	pms090
		Jmp	MenuLeft

pms090:		Cmp	AH,4Dh			;Right Arrow
		JNZ	ChkCr
		Jmp	MenuRight

ChkCr:		Cmp	AL,CR
		JNZ	MTryEsc
		Jmp	MenuEnter

MTryEsc:	Cmp	AL,Esc_
		JNZ	LetterHit
		Jmp	ESCexit

LetterHit:	Push	SI
		Cmp	AL,'a'
		JB	NotLowerCase
		Cmp	AL,'z'
		JA	NotLowerCase
		And	AL,0DFh			;make Upper-case
NotLowerCase:	Mov	AH,AL
		Mov	DI,2
		Mov	CX,1			;no. of items checked
		Mov	DH,0
		Mov	DL,MenuItemCount
CompareLoop:	Mov	SI,[DI+BufPointers]
CompCharLoop:	LodsB				;get item's letters from MenuBuf
		Cmp	AL,' '
		JZ	CompNextItem
		Or	AL,AL
		JZ	CompExit
		Cmp	AL,'a'
		JB	NLC
		Cmp	AL,'z'
		JBE	CompCharLoop
NLC:		Cmp	AL,AH
		JZ	CharacterMatch
CompNextItem:	Cmp	CX,DX
		JZ	CompExit
		Inc	CX
		Inc	DI
		Inc	DI			;point to start of next item
		Jmp	Short CompareLoop

CompExit:	Pop	SI
ESCexit:	Xor	CX,CX			;signal meaningless char
		Jmp	pms093

CharacterMatch:	Pop	SI
		Mov	BX,CX
		Jmp	Short ShowMenuExit

MenuRight:	Inc	SI
		Inc	SI
		Xor	AH,AH
		Mov	AL,MenuItemCount
		Add	AX,AX
		Cmp	SI,AX
		JBE	pms091
		Mov	SI,2
pms091:		Jmp	ShowTheMenu

MenuLeft:	Dec	SI
		Dec	SI
		Or	SI,SI
		JZ	pms092
		Jmp	ShowTheMenu

pms092:		Xor	AH,AH
		Mov	AL,MenuItemCount
		Add	AX,AX
		Mov	SI,AX
		Jmp	ShowTheMenu

MenuEnter:	Xor	AH,AH
		Mov	CX,SI
		ShR	CX,1			;item number
pms093:		Mov	BX,SI
		ShR	BX,1			;hilite the same item next time
ShowMenuExit:	Pop	DX
		Pop	SI
		Pop	DI
		Pop	BP
		Pop	DS
		Pop	ES			; AH=letter hit, AL=Esc_ if hit
		Ret				; CX=item no or 0 if invalid

; - - - - - - - - - - - - - - - - - -
MouseClick:	Push	DI			;-- Process the Mouse Click --
		Push	ES			; AH: 0=menu,1=mark; AL=button
		Push	DX			; Returns SI > menu item
		Push	CX
		Push	BX
		Cmp	AL,2			; Check if MB
		JNE	MouseLB			; No: must be the LB
		Cmp	ChkAllKeysFlag,0	; In the Editor?
		JE	MouseIgnore$		; Yes: ignore the mouse click
		Mov	CX,MouseMBstr		; Yes: stuff MouseMBstr into the
		Push	SI			;   Keyboard buffer
		Mov	SI,Offset MouseMBstr+2
		Call	StuffKeys
		Pop	SI
		Jmp	MouseClickRet

MouseLB:	Mov	BX,MouseRow		; Get mouse cursor row
		Mov	BH,AH			; Put marking mode flg in BH
		Or	BL,BL			; On menu row?
		JZ	MouseMenu		; Yes: get item no.
		Cmp	BL,2			; Above top border?
		JA	NotMBlock
		Jmp	MouseBlock		; Yes: check for action block

NotMBlock:	Mov	AX,4900h		; Set <PgUp> key code
		Cmp	BL,3			; On top border?
		JLE	MouseClickRet$		; Yes: simulate <PageUp>
		Cmp	BL,24			; On the bottom line?
		JE	MouseBottom		; Yes: check item clicked
		Mov	AX,5100h		; Set <PgDn> key code
		Cmp	BL,23			; On bottom border?
		JGE	MouseClickRet$		; Yes: simulate <PageDown>
		Cmp	ChkAllKeysFlag,0	; In the Editor?
		JE	MouseIgnore$		; Yes: ignore the mouse click
		Cmp	MouseRow,13		;-check for prev/nxt dir arrows-
		JNZ	NotPlsMns
		Mov	AX,4A2Dh		; set for prev dir
		Cmp	MouseCol,0
		JZ	MouseClickRet$
		Mov	AX,4E2Bh		; set for next dir
		Cmp	MouseCol,79
		JZ	MouseClickRet$
		Cmp	ViewFlag,0		; Files only on left half?
		JNE	NotPlsMns		; No: don't chk center arrow
		Cmp	MouseCol,40
		JZ	MouseClickRet$
NotPlsMns:	Cmp	ViewFlag,0		; Files only on left half?
		JNE	MouseFile		; No: any col is OK
		Cmp	MouseCol,40		; Else click must be left side
		JG	MouseIgnore$		; Ignore if on right half
		Jmp	MouseFile

MouseIgnore$:	Jmp	MouseIgnore

MouseMenu:	Cmp	BH,1			; In marking mode ?
		JZ	MouseIgnore$		; Yes: ignore top row click
		Mov	CX,MouseCol		; Mouse cursor col
		Inc	CX
		Mov	SI,Offset MenuBuf	; Start of menu line bfr
		Mov	DI,2			; Scan menu line for item no.
MouseItem:	LodsB				;  get next char of menu line
		Cmp	AL," "			;  if its not a blank,
		JNE	MouseLoop		;  keep scanning;
		Inc	DI			;  if it is a blank, inc countr
MouseLoop:	Loop	MouseItem		;  loop up to mouse cursor
		Cmp	AL," "			; Is mouse cursor on an item?
		JE	MouseIgnore$		; If not, ignore the click
		Mov	SI,DI			; Put item no. (*2) in SI
		Mov	AX,101h			; Set menu item select code
MouseClickRet$:	Jmp	MouseClickRet

MouseBottom:	Push	SI
		Mov	SI,24*80		; At bottom line, MouseCol: read
		Call	MouseRdScrn		;  screen char & Inc MouseCol
		Pop	SI
		Cmp	AL,' '			; Check if between key/names
		JZ	MouseIgnore$
		Xor	BX,BX			;clear spaces count
MBLoop:		Cmp	MouseCol,80
		JAE	GetBottomCode
		Push	SI
		Mov	SI,24*80		; At bottom line, MouseCol: read
		Call	MouseRdScrn		;  screen char & Inc MouseCol
		Pop	SI
		Cmp	AL,' '			; count items to end of line
		JNZ	MBLoop
		Inc	BX
		Jmp	Short MBLoop

GetBottomCode:	Cmp	BX,5
		JA	MouseIgnore$		; Weeds out click on Version
		ShL	BX,1			; Get Key Code (reverse order)
		Mov	AX,BottomCodes[BX]
		Jmp	Short MouseClickRet$

MouseBlock:	Mov	SI,80			; Set to row 1 (2nd line)
		Call	MouseRdScrn		; Get Char/Attr
		Cmp	AH,InverseAttrib	; Inverse?
		JNE	MouseIgnore		; No: Ignore it
		Mov	AX,1C0Dh		; Yes: must mean <Enter>
		Jmp	Short MouseClickRet

MouseFile:	Mov	AX,MouseRow		; Else must be in the file area
		Sub	AX,13			; Entries to move up
		JNZ	MouseFile2		; If not on the hilited file
		Cmp	BH,1			; Or in marking mode,
		JZ	MouseFile2		;   Go to file/dir mark routine
		Mov	AX,5202h		; Else: Set <Ins> key code & 2
		Jmp	Short MouseClickRet

MouseFile2:	Mul	EntryLen23		; Offset to move in files list
		Add	AX,HilitedEntry		; New pos in files list
		JLE	MouseIgnore		; Above any file
		Cmp	AX,PastLastEntry	; Is it too far down?
		JGE	MouseIgnore		; Yes: ignore it
		Cmp	BH,1			; In marking mode?
		JNZ	NotMMark
MouseMark:	Pop	BX			; Pop off orig BX
		Push	AX			; Substitute files list pointr
		Mov	AL,2			; Set file mark code
		Jmp	Short MouseClickRet

NotMMark:	Mov	HilitedEntry,AX		; Else: set new files list pos
		Call	ShowFilesList		; Redisplay files
		Mov	DX,MouseCol		; Put mouse cursor on Bar
		Mov	CL,3			;  Use current column, row 14
		ShL	DX,CL
		Mov	CX,DX
		Mov	DX,104
		Mov	AX,4			;set cursor position
		Int	33h
MouseIgnore:	Xor	AX,AX
MouseClickRet:	Pop	BX
		Pop	CX
		Pop	DX
		Pop	ES
		Pop	DI
		Ret	;AL=1 => clicked on menu item, SI points to it
			;AL=2 => marking files
			;AX=0 => ignore click

MouseRdScrn:	Add	SI,MouseCol	;direct read screen char & inc MouseCol
		ShL	SI,1			; must preset SI to Row*80
		Push	DS
		Mov	DS,VideoSeg
		LodsW
		Pop	DS
		Inc	MouseCol
		Ret				; w/Attr & Char in AX

; - - - - - - - - - - - - - - - - - -
InverseInMenu:	Push	AX
		Push	SI
		Push	ES
		Push	DI
		Mov	ES,VideoSeg
		Mov	SI,[SI+BufPointers]	;points start of item in MenuBuf
		Mov	DI,SI
		Sub	DI,Offset MenuBuf
		Add	DI,DI
		Mov	AH,InvMenuAttrib
NxInvChar:	LodsB
		Cmp	AL,' '
		JZ	InvDone
		Or	AL,AL
		JZ	InvDone
		StosW
		Jmp	Short NxInvChar

InvDone:	Pop	DI
		Pop	ES
		Pop	SI
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - -
;BP points to 1st item on current menu, in the index at 60000d
GoAp:		Cmp	NFGmnuFlag,0
		JZ	MnuOK
		Push	CS
		Pop	DS
		Mov	DX,Offset ApMenuPrompt
		Call	ShowErrMsg
		Ret

MnuOK:		Push	BX
		Push	CX
		Push	ES
		Push	DS
		Push	SI
		Push	BP
		Mov	ApFlag,1		;signal MenuToBuffer: Ap menu
		Mov	ChkAllKeysFlag,1
		Mov	NoClsTop2Flag,0
		Mov	DS,MenuSeg
MainAp:		Mov	BP,60000		;point to Ap menu index
ShowAp:		Mov	BX,1			;hilite 1st item on menu
ShowOldAp:	Call	ShowMenuAndWaitKey	;calls MenuToBuffer
		Or	CX,CX
		JNZ	VectorCX
		Cmp	AL,Esc_
		JNZ	ShowAp
	;<Esc> hit, find 1st of prev menu in the index
		Mov	DL,DS:[BP+1]		;get indent level for this menu
		Sub	DL,1			;(DEC doesn't affect C flag !)
		JC	ToApplicExit
		JZ	MainAp
EscLoop:	Cmp	Byte Ptr DS:[BP-3],DL	;prev item indent = 1 level up?
		JL	ShowAp
		Sub	BP,4
		Jmp	Short EscLoop

ToApplicExit:	Jmp	ApplicExit

	;1st item is CX=1
VectorCX:	Mov	CS:INescBP,BP		;in case <Esc> from IN entry
		Dec	CX
	;find this item in the index
		JCXZ	FoundThis
		Mov	DL,DS:[BP+1]		;get indent level for this menu
FindThis:	Add	BP,4
		Cmp	DS:[BP+1],DL
		JNZ	FindThis
		Loop	FindThis
FoundThis:	Cmp	Byte Ptr DS:[BP],'M'
		JNZ	NotMenu
		Add	BP,4			;1st item on menu in index
		Jmp	ShowAp

;process the 3 lines in the Menu file for this Ap
NotMenu:	Mov	CS:WaitFlag,0
		Mov	CS:DirFlag,0
		Mov	CL,DS:[BP+1]		;indent level
		Mov	CH,0
		Mov	SI,DS:[BP+2]		;ptr to Ap's 1st line, in menu
;first, check for 'w' after the Ap's name in the 1st line
		LODSW
		Xchg	AX,DX			;pointer to 2nd line
		Add	SI,CX
NameEndLoop:	Cmp	SI,DX			;up to pointer to next line ?
		JAE	NameEnd
		LodsB
		Cmp	AL,' '
		JZ	NameEnd
		Cmp	AL,Tab
		JZ	NameEnd
		Cmp	AL,';'
		JZ	WaitSet
		Cmp	AL,CR
		JZ	WaitSet
		Jmp	Short NameEndLoop

NameEnd:	Cmp	SI,DX			;up to pointer to next line ?
		JAE	WaitSet
		LodsB
		Cmp	AL,';'
		JZ	WaitSet
		Cmp	AL,CR
		JZ	WaitSet
		Cmp	AL,' '
		JZ	NameEnd
		Cmp	AL,Tab
		JZ	NameEnd
		And	AL,0DFh			;make Upper-case
		Cmp	AL,'W'
		JNZ	WaitSet
		Mov	CS:WaitFlag,1
WaitSet:	Mov	SI,DX			;points 2nd line
		LODSW
		Xchg	AX,DX			;pointer to 3rd line
		Add	SI,CX			;point 1st char of dir-to-be-in
		Push	CS
		Pop	ES
		Cmp	Byte Ptr [SI],7Eh	;'7E' goes to target's dir
		JZ	DirSet
		Mov	CS:DirFlag,1
		Mov	DI,Offset WritePath
FillWritePath:	Cmp	SI,DX			;up to pointer to next line ?
		JAE	MarkDirEnd
		LodsB
		Cmp	AL,' '
		JZ	MarkDirEnd
		Cmp	AL,';'
		JZ	MarkDirEnd
		Cmp	AL,CR
		JZ	MarkDirEnd
		Cmp	AL,Tab
		JZ	MarkDirEnd
		StosB
		Jmp	Short FillWritePath

MarkDirEnd:	Mov	Byte Ptr ES:[DI],0
		Cmp	DI,Offset WritePath
		JNZ	DirSet
		Mov	DirFlag,2		;signal use path from 3rd line
DirSet:		Mov	SI,DX			;points 3nd line
		LODSW
		Xchg	AX,DX			;pointer to next line
		Add	SI,CX			;1st char of pgm, CX=indent
		Mov	DI,Offset ApBuf+1
CmdLineLoop:	Or	DX,DX
		JZ	LastItem
		Cmp	SI,DX			;up to pointer to next line?
		JAE	CmdLineDone
LastItem:	LodsB
		Cmp	AL,';'
		JZ	CmdLineDone
		Cmp	AL,CR
		JZ	CmdLineDone
		Cmp	AL,EOF
		JZ	CmdLineDone
		Cmp	AL,7Eh			;'7E'
		JNZ	PutCmdLine
		Call	ExpandSquigglies
		Cmp	AL,1			;<Esc> hit in 7EIN entry window ?
		JNZ	CmdLineLoop
		Mov	BP,CS:INescBP
		Jmp	ShowOldAp

PutCmdLine:	StosB
		Jmp	Short CmdLineLoop

CmdLineDone:	Cmp	BP,CS:INprevBP
		JZ	SameItem
		Mov	CS:INprevBP,0		;trash INstring on any new Ap
SameItem:	Mov	Byte Ptr ES:[DI],0
		Cmp	DirFlag,2
		JNZ	AllSet
;get path from 3rd line into WritePath.  Find the 1st space, tab, or the end.
		Mov	DI,Offset WritePath
		Mov	SI,Offset ApBuf+1
		Push	DS
		Push	CS
		Pop	DS
ApEndLoop:	LodsB
		Cmp	AL,' '
		JZ	PathEndLoop
		Cmp	AL,Tab
		JZ	PathEndLoop
		Or	AL,AL
		JNZ	ApEndLoop
PathEndLoop:	STD
		LodsB
		Cmp	SI,Offset ApBuf
		JZ	ApPathDone		;there is no path entered
		Cmp	AL,'\'
		JZ	CopyApPath
		Cmp	AL,':'
		JNZ	PathEndLoop
CopyApPath:	CLD				;.
		Mov	CX,SI
		Mov	SI,Offset ApBuf+1
		Sub	CX,SI
		Inc	CX
		Rep	MovsB
ApPathDone:	CLD
		Mov	Byte Ptr [DI],0
		Pop	DS
AllSet:		Call	RunDOS			;Do the CmdDOS routine,
ApplicExit:	Pop	BP			;  WritePath has dir to be in
 		Pop	SI			;  if present and ApBuf has
		Pop	DS			;  command line
		Mov	DirFlag,0
		Mov	WaitFlag,0
		Mov	ApFlag,0
		Pop	ES
		Pop	CX
		Pop	BX
		Ret
; . . . . . . . . . . . . . . . .
ExpandSquigglies:
		LodsB				;get 1st letter
		And	AL,0DFh			;make Upper-case
		Cmp	AL,'I'
		JNZ	NotIN
		Jmp	InString

NotIN:		Push	BP
		Mov	BP,CS:HilitedEntry
		Call	CopyAsFullPath		;to CurrentPath (loses AX)
		LodsB
		And	AL,0DFh			;make Upper-case
		Push	DS
		Push	SI
		Push	CX
		Mov	SI,Offset CurrentPath
		Push	CS
		Pop	DS
		Cmp	AL,'S'
		JNZ	TryFD
	;it's 7EFS, the full filespec
		Call	CopyUpTo0
		Jmp	Short Fret

TryFD:		Cmp	AL,'D'
		JNZ	TryFP
		LodsB
		StosB
		Mov	AL,':'
		StosB
		Jmp	Fret

TryFP:		Cmp	AL,'P'
		JNZ	TryFNandE
		Mov	SI,Offset CurrentPath
		Call	CopyUpTo0
		Push	ES
		Mov	ES,WorkingSeg
		Test	Byte Ptr ES:[BP],10h	;NZ if on a Dir
		Pop	ES
		JNZ	Fret
		Dec	DI			;to last of name.ext
	;go back to the last backslash
BkLoop:		Cmp	Byte Ptr [DI],'\'
		JZ	Fret
		Dec	DI
		Jmp	Short BkLoop

TryFNandE:	Push	ES
		Mov	ES,WorkingSeg
		Test	Byte Ptr ES:[BP],10h	;NZ if on a Dir
		Pop	ES
		JNZ	Fret			;a dir has no file name or .ext
		Mov	ApBufPtr,DI		;points start of item
		Call	FileOrDirToDI		;all after last \ in CurrentPath
		Mov	SI,DI			;save pointer past name.ext
	;go back to just past the name.  DI > 1 past end.
BackPastExt:	Dec	DI
		Cmp	Byte Ptr ES:[DI],'.'
		JZ	ChkWhich
		Cmp	DI,ApBufPtr
		JNZ	BackPastExt
	;there is no .EXT
		Cmp	AL,'N'
		JNZ	Fret			;can't do FE, so done
		Mov	DI,SI			;restore DI, past end of name
		Jmp	Short Fret

	;there IS an .EXT
ChkWhich:	Sub	SI,DI			;now DI > '.', SI >past name.ext
		Mov	CX,SI			;bytes to move down
		Mov	SI,ApBufPtr		;SI > start of name.ext
		Cmp	AL,'E'
		JNZ	Fret
		Xchg	SI,DI
		Rep	MovsB
Fret:		Mov	AL,0			;signal <Esc> not hit
		Pop	CX
		Pop	SI
		Pop	DS
		Pop	BP
		Ret

INstring:	Inc	SI
		Inc	SI			;past the 'N"'
		Mov	CS:MsgPtr,SI
	;look for the " or ' after the msg
INloop:		Cmp	SI,DX			;up to pointer to next line ?
		JAE	ShoMsg
		LodsB
		Cmp	AL,'"'
		JZ	ShoMsg
		Cmp	AL,''''
		JZ	ShoMsg
		Or	AL,AL			;check for 0 from previous use
		JNZ	INloop
ShoMsg:		Mov	Byte Ptr [SI-1],0	;make msg displayable ASCIIZ
ShowCmdLn:	Push	DI
		Push	DX
		Push	BX
		Cmp	CS:ApFlag,0		;Run w/cmd line can't save entry
		JZ	TrashINstring
		Cmp	BP,CS:INprevBP		;rtn to same IN item preserves
		JZ	NoClear
TrashINstring:	Mov	CS:INprevBP,BP
		Mov	CS:INcursor,0
		Mov	CX,Offset ApBuf+148	;end of ApBuf
		Sub	CX,DI			;bytes to end of ApBuf
		JCXZ	NoClear
		Push	DI
		Xor	AX,AX
		Rep	StosB
		Pop	DI
NoClear:	Call	ClsTop2
		Mov	DX,CS:MsgPtr		;ptr msg in MenuSeg or RunCmdMsg
		Xor	CX,CX			;1st row, 1st col
		Mov	BL,CS:TextAttrib
		Call	DisplayZ
		Cmp	CS:ApFlag,0
		JNZ	JustAp
		Mov	DX,Offset RunCmdMsg
		Mov	CL,20
		Call	DisplayZ
JustAp:		Mov	DX,CS:INcursor
		Mov	CS:CursorLocn,DX
		Inc	CH			;to 2nd row
		Mov	CL,0
		Mov	BH,79
		Mov	DX,DI			;dest is current locn in ApBuf
		Push	SI
		Mov	CS:AllCharsFlag,1
		Call	InputBHchars		;rtns AL=1 if <Esc> or no entry
		Pop	SI
		Mov	DI,CS:CursorLocn
		Mov	CS:INcursor,DI
		Pop	BX
		Pop	DX
		Pop	DI
	;InputBHchars leaves a 0 to mark end of its input
FindEndInp:	Cmp	Byte Ptr ES:[DI],0
		JZ	INstrRet
		Inc	DI
		Jmp	Short FindEndInp

INstrRet:	Ret
; - - - - - - - - - - - - - - - - - -
	;find our path, last in the Environment
FindEnvPath:	Mov	ES,WORD PTR CS:[2Ch]	;in the PSP, Env seg
		Xor	DI,DI
		Xor	AL,AL			;find 1st 0
		Xor	CX,CX			;so it won't stop
		Dec	CX			;  the ScasB operation
NextZero:	RepNZ	ScasB			;now DI points 1 past match
		Cmp	Byte Ptr ES:[DI],0	;0,0,1,0 marks path\name start
		JNZ	NextZero
		Inc	DI			;past the 0,1
		Inc	DI
		Inc	DI			;to start of our d:\path\name,0
		Push	ES
		Pop	DS
		Ret
; - - - - - - - - - - - - - - - - - -
LoadMenu:	Push	ES
		Push	DS
		Push	CX
		Cmp	ParasToReq,0FFFh	;enough room ?
		JAE	IsRoom
		Mov	SI,Offset NoRoomMenuMsg
		Jmp	Short LoadNFG

IsRoom:		Call	FindEnvPath	;if being run from another dir
		Mov	SI,DI
		Push	CS
		Pop	ES
		Mov	DI,Offset WritePath
MenuPathLoop:	LodsB
		StosB
		Or	AL,AL
		JZ	PathCopied
		Jmp	Short MenuPathLoop

	;find the last '\' in, or start of WritePath
PathCopied:	Mov	AL,'\'
BksOrStLoop:	Cmp	DI,Offset WritePath
		JB	StartFound
		STD
		ScasB
		CLD
		JZ	BkslshFound
		Jmp	Short BksOrStLoop
BkslshFound:	Inc	DI			;past the '\'
StartFound:	Inc	DI			;SCAS goes 1 past match
		Push	CS
		Pop	DS			;now CS=DS=ES
		Mov	SI,Offset PMmenu
		Mov	CX,10
		Rep	MovsB
		Mov	DX,Offset WritePath	;DS:DX points filespec
		Mov	AH,3Dh			;open file
		Mov	AL,0			;read-only access
		Int	21h
		JNC	MenuOpenOK
		Mov	SI,Offset MenuNotFoundMsg
LoadNFG:	Mov	DI,Offset ApMenuPrompt
		Call	CopyUpTo0
		Mov	NFGmnuFlag,1
		Jmp	LoadDone

MenuOpenOK:	Xchg	AX,BX			;handle
		Mov	AX,CS:MenuSeg
		Mov	DS,AX
		Mov	ES,AX
		Mov	DX,4			;DS:DX points 5th byte of buffer
		Push	BX
		Mov	CX,40002		;bytes to read, more than max
		Mov	AH,3Fh			;read from file
		Int	21h
		Pop	BX			;handle
		Push	AX			;save bytes read
		Mov	AH,3Eh			;close file
		Int	21h
		Pop	AX
		Cmp	AX,40000
		JNA	MenuLenOK
		Mov	AX,CS
		Mov	DS,AX
		Mov	ES,AX
		Mov	DX,Offset MenuTooBigMsg
		Call	ShowErrMsg
		Mov	SI,Offset MenuTooBigMsg
		Jmp	Short LoadNFG

	;DS=ES=MenuSeg, ref's need CS:
MenuLenOK:	Mov	DI,AX			;bytes read
		Mov	Byte Ptr [DI+4],EOF	;editor doesn't add EOF to files
		Call	LinePointers	;pointers to next valid line replace the
					;CR,LF and build Index at 60000d
	;fill in the 2nd line for Main Menu
		Push	CS
		Pop	ES
		Mov	AX,'  '
		Mov	DI,Offset ApMenuPrompt
		Mov	CX,40
		Rep	StosW
		Mov	BP,60000		;point to the index
		Push	CS
		Pop	DS
		Mov	ApFlag,2	;jmp to ApToBuf, dest is ApMenuPrompt
		Call	MenuToBuffer
		Mov	ApFlag,0
		Xor	AX,AX
LoadDone:	Pop	CX
		Pop	DS
		Pop	ES
		Ret
; - - - - - - - - - - - - - - - - - -
;Go thru the menu file - each valid line gets a pointer to the next, replacing
; the CR,LF before it.  The file starts with the pointer to the 1st valid
; line's pointer.  The pointer preceding the last valid line is 0.
LinePointers:	Push	DI
		Push	SI
		Push	DS
		Push	ES
		Push	BX			;temp ptr while line is scanned
		Push	CX
		Mov	AX,CS:MenuSeg
		Mov	DS,AX
		Mov	ES,AX
		Mov	CS:ValidFlag,0
		Mov	CS:ItemLines,1
		Mov	BX,2			;1st possible valid line's ptr
		Mov	SI,4			;source, 1st char of file
		Xor	DI,DI			;dest, 1st pointer
		Xor	CX,CX			;CL=indent, CH=prev indent
EachChar:	LodsB
		Cmp	AL,' '
		JNZ	ChkMnuTab
		Inc	CL
		Jmp	Short EachChar

ChkMnuTab:	Cmp	AL,Tab
		JZ	GoEnd
		Cmp	AL,';'
		JZ	GoEnd
		Cmp	AL,EOF
		JZ	PointersDone
		Cmp	AL,CR
		JZ	EndEachLine
		Mov	CS:ValidFlag,1
GoEnd:		LodsB
		Cmp	AL,EOF
		JZ	PointersDone
		Cmp	AL,CR
		JNZ	GoEnd
EndEachLine:	Dec	SI			;back to the CR
		Cmp	CL,CH
		JZ	Try2
		Mov	CS:ItemLines,1		;new item if indent differs
Try2:		Cmp	CS:ItemLines,2
		JZ	GoodLine
		Cmp	CS:ValidFlag,0
		JZ	TryNextLin
GoodLine:	Mov	[DI],BX
		Mov	DI,BX
		Inc	CS:ItemLines
		Cmp	CS:ItemLines,3
		JNA	TryNextLin
		Mov	CS:ItemLines,1
TryNextLin:	Mov	BX,SI			;point to CR,LF before each line
		Inc	SI
		Inc	SI			;past the LF to 1st char
		Mov	CS:ValidFlag,0
		Mov	CH,CL
		Xor	CL,CL
		Jmp	EachChar

PointersDone:	Mov	WORD PTR [DI],0
;Now build an index for CX pointing at MenuSeg:60000+.
; Each 4-byte entry is M(enu) or any (Applic), indent, addr in MenuSeg of item.
	; First, clear the area
		Mov	DI,60000
		Xor	AX,AX
		Mov	CX,2760			;words, up to MCB for next Seg
		Rep	StosW
		Xor	CX,CX			;CL is curr indent lvl, CH prev
		Mov	CS:ItemLines,0FFh	;simulate 1 line back
		Mov	DI,60000
		Xor	SI,SI
		LODSW				;get pointer to 1st valid line
		Mov	CS:PrevPointer,AX
LineLoop:	Mov	SI,AX
		Push	AX
		LODSW				;get pointer to next valid line
		Mov	BX,AX			;save it
		Mov	CL,0
IndentLoop:	LodsB
		Cmp	AL,' '
		JNZ	ChkIndent
		Inc	CL
		Jmp	Short IndentLoop

ChkIndent:	Cmp	CL,CH			;indent - prev
		JA	PrevIsMenu
		JB	PrevIsAp
		Inc	CS:ItemLines		;same indent
		Cmp	CS:ItemLines,3
		JZ	PrevIsAp
		Pop	AX			;start of line, not needed
		Jmp	Short NextLine

PrevIsMenu:	Mov	Byte Ptr [DI],'M'
PrevIsAp:	Inc	DI
		Mov	Byte Ptr [DI],CH	;indent
		Inc	DI
		Mov	AX,CS:PrevPointer
		StosW
		Pop	AX			;start of this line
		Mov	CS:PrevPointer,AX
		Mov	CS:ItemLines,0
		Mov	CH,CL			;CH is prev indent level
NextLine:	Mov	AX,BX			;pointer to next valid line
		Or	AX,AX
		JNZ	LineLoop
IndexDone:	Inc	DI			;the last item must be an Ap
		Mov	Byte Ptr [DI],CL	;indent of last item
		Inc	DI
		Mov	AX,CS:PrevPointer
		StosW
		Pop	CX
		Pop	BX
		Pop	ES
		Pop	DS
		Pop	SI
		Pop	DI
		Ret
; - - - - - - - - - - - - - - - - - -
;used for normal menus, Ap menus, and Ap and Main Menu prompt lines.
MenuToBuffer:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	SI
		Push	DI
		Push	BP
		Push	ES
		Push	DS
		Mov	BX,BP			;BX points to menu to display
		Mov	AX,CS
		Mov	ES,AX
		Mov	DS,AX
		Mov	DI,Offset MenuBuf
		Xor	BP,BP
		Cmp	ApFlag,0
		JZ	NormMenu
		Jmp	ApToBuf

NormMenu:	Mov	MenuItemCount,0
		Xor	SI,SI
	;this skips the 1st and all odd no. items (i.e., skips the prompt lines)
LookZero:	Cmp	Byte Ptr [BX+SI],0
		JZ	pms095
		Inc	SI
		Jmp	Short LookZero

pms095:		Inc	SI
		Cmp	Byte Ptr [BX+SI],0FFh	;0,0FFh marks end of menu
		JZ	M2BufDone
		Inc	BP
		Inc	BP			;1st time, to 2
		Inc	MenuItemCount
		Mov	CS:[BP+BufPointers],DI
CopyTheItem:	Mov	AL,[BX+SI]
		Inc	SI
		Or	AL,AL
		JZ	EndOfItem
		StosB
		Jmp	Short CopyTheItem

EndOfItem:	Mov	AX,'  '
		StosW				;the 2 spaces between items
		Mov	CS:[BP+Line2Ptrs],SI
		Jmp	Short LookZero

M2BufDone:	Cmp	CS:ApFlag,2		;in prompt line main menu?
		JZ	NoZero
		Dec	DI
		Dec	DI
No2ndLine:	Mov	Byte Ptr ES:[DI],0
NoZero:		Pop	DS
		Pop	ES
		Pop	BP
		Pop	DI
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

;BX points to 1st item in index, for this menu, SI=item to hilite X 2 (1st=1)
	;now DS=ES=CS
ApToBuf:	Cmp	ApFlag,1
		JZ	DestSet
		Mov	DI,Offset ApMenuPrompt
		Cmp	ApFlag,2		;fill main menu Ap prompt line
		JZ	DestSet
		Mov	DI,Offset Line2Buf	;ApFlag = 3
		Jmp	Short Only3
DestSet:	Mov	MenuItemCount,0
Only3:		Mov	EndPtr,DI		;so as not to overrun the buffer
		Add	EndPtr,79
		Mov	DS,MenuSeg
		Mov	CL,[BX+1]		;indent for this menu
		Cmp	CS:ApFlag,3		;doing Ap prompt line ?
		JNZ	ItemLoop
		ShR	SI,1
		Mov	BP,SI			;item hilighted, 1st=1
FindItemLoop:	Or	BP,BP
		JZ	ItemFound
		Mov	SI,BX
		Inc	SI			;to indent byte
		LodsB
		Cmp	AL,CL
		JG	FindNxItem
		Dec	BP
FindNxItem:	Add	BX,4
		Jmp	Short FindItemLoop

ItemFound:	Cmp	[SI+3],CL		;any sub-items ?
		JZ	No2ndLine
		Inc	CL			;indent of items on this menu
ItemLoop:	Mov	SI,BX
		Inc	SI			;to indent byte
		LodsB
		Cmp	AL,CL
		JG	NxItem
		JL	M2BufDone
		LODSW				;pointer to this item, in index
		Or	AX,AX
		JZ	M2BufDone
		Cmp	CS:ApFlag,3		;doing Ap prompt line ?
		JZ	LeavePtrs
		Inc	BP
		Inc	BP			;1st time, to 2
		Inc	CS:MenuItemCount
		Mov	CS:[BP+BufPointers],DI
LeavePtrs:	Xchg	AX,SI			;pointer to this line, in menu
		LODSW
		Mov	DX,AX			;pointer to next line
		Mov	CH,0
		Add	SI,CX			;point to 1st char
CopyApItemLoop:	Cmp	DI,CS:EndPtr
		JB	NotEndPtr
		Jmp	M2BufDone
NotEndPtr:	Cmp	SI,DX			;up to pointer to next line ?
		JZ	ItemEnd
		LodsB
		Cmp	AL,' '
		JZ	ItemEnd
		Cmp	AL,';'
		JZ	ItemEnd
		Cmp	AL,Tab
		JZ	ItemEnd
		Cmp	AL,CR
		JZ	ItemEnd
		Cmp	AL,EOF
		JZ	ItemEnd
		StosB
		Jmp	Short CopyApItemLoop

ItemEnd:	Mov	AX,'  '
		StosW
NxItem:		Add	BX,4			;point to next item in index
		Jmp	ItemLoop

; - - - - - - - - - - - - - - - - - - - -
GoEdit:		Push	AX			;--Entry point for the Editor--
		Push	BP
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Mov	BytesInBuf,0
		Mov	ChkAllKeysFlag,0
		Mov	ColumnOffset,0
		Mov	BlockFlag,0
		Mov	EditingFlag,1
		Mov	TopLineNo,3
		Mov	HidROattrib,0
		Mov	ES,WorkingSeg
		Mov	DI,HilitedEntry
		Test	Byte Ptr ES:[DI],10h	;attribute byte
		JZ	ExistingDoc
	;the cursor bar is on a directory
		Call	GetNameAndOpenFile	;only call
		Cmp	AX,1
		JZ	ExitEditor
		Mov	GoEntryFlag,1
		Jmp	Short StartEditing

ExistingDoc:	Mov	BP,HilitedEntry
		Call	CopyAsFullPath
		Cmp	AX,1			;path too long ?
		JZ	ExitEditor
		Xor	AX,AX
		Call	LoadTheDoc		;only call
		Cmp	AX,1			;error opening file ?
		JZ	ExitEditor
StartEditing:	Mov	AX,FileLength
		Mov	OrigFileLen,AX
		Mov	InsertFlag,1
		Mov	FileChangedFlag,0
		Call	TheEditor		;only call
ExitEditor:	Mov	ChkAllKeysFlag,1
		Mov	EditingFlag,0
		Call	PaintBlankScreen
		Call	GetVolAndFreeSpace
		Call	PaintStatusOrDateScrn
		Cmp	GoEntryFlag,1	;ret hilit if new file or Get used
		JNZ	QuickExit
		Call	PaintMainScrn		;updates files list
		Jmp	Short LastExit

QuickExit:	Call	ShowFilesList
LastExit:	Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	BP
		Pop	AX
		Ret

LoadTheDoc:	Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	BP
		Push	ES
		Call	ShowWait
		Mov	DocLineNo,0
		Mov	ColumnShown,0
		Mov	AX,EditBytesToRead
		Mov	EOFpointer,AX
		Call	OpenCurrPath
		Cmp	AX,1
		JNZ	pms096
		Jmp	OpenExit

pms096:		Mov	ReadHandle,AX
		Xchg	AX,BX
		Mov	CX,EditBytesToRead	;bytes to read
		Mov	DS,EditBufSeg
		Mov	AH,3Fh			;read from file
		Xor	DX,DX			;DS:DX points read buffer
		Int	21h
		Push	CS
		Pop	DS
		Mov	FileLength,AX		;bytes read or error code
		Cmp	AX,EditBytesToRead
		JNZ	pms097
		Mov	DX,Offset TooLgMsg
		Call	ShowErrMsg
		Mov	BX,ReadHandle
		Mov	AH,3Eh			;close file
		Int	21h
		Mov	AX,1
		Jmp	OpenExit

pms097:		Mov	UpperLeft,0
		Mov	CursorLine,0
		Mov	CursorCol,0
		Mov	BX,ReadHandle
		Mov	AH,3Eh			;close file
		Int	21h
	;move the doc up to the end of the EditBuf
		Mov	ES,EditBufSeg		;DS=ES=EditBufSeg
		Mov	DI,EditBytesToRead	;64K unless very little RAM
		Sub	DI,FileLength
		Mov	CursorUpPointer,DI
		Mov	UpToCursorPtr,0
		Mov	SI,FileLength
		Dec	SI			;SI points last byte of file
		Mov	DI,EditBytesToRead
		Dec	DI			;DI points last byte of EditBuf
		Mov	CX,FileLength
pms098:		Or	CX,CX
		JZ	AddEOF
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Dec	DI
		Dec	SI
		Dec	CX
		Jmp	Short pms098

AddEOF:		Mov	DI,EditBytesToRead
		Mov	Byte Ptr ES:[DI],EOF
OpenExit:	Pop	ES
		Pop	BP
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Ret

OpenCurrPath:	Mov	AH,3Dh			;open file
		Mov	AL,0			;read-only access, in case R-O
		Mov	DX,Offset CurrentPath
		Int	21h
		JNC	CurOpenOK
		Mov	DX,Offset OpenErrMsg
		Call	ShowErrMsg
		Mov	AX,1
CurOpenOK:	Ret

; - - - - - - - - - - - - - - -
TheEditor:	Push	AX
		Push	BX
		Push	CX
		Push	BP
ToTextEntry:	Call	TextEntry
		Mov	BX,1
		Mov	BP,Offset EditorMenu
ShowEditorMenu:	Call	ShowMenuAndWaitKey
		Cmp	AL,Esc_
		JZ	ToTextEntry
		Cmp	CX,1			;Put
		JNZ	pms106
		Call	ShowPutMenu
		Jmp	Short ToTextEntry

pms106:		Cmp	CX,2			;Get
		JNZ	pms107
		Mov	PathFlag,0		;do file Get, not InsertPath
		Call	GetAndPath
		Jmp	Short ToTextEntry

pms107:		Cmp	CX,3			;Block
		JNZ	pms099
		Call	GoEdBlock
		Jmp	Short ToTextEntry

pms099:		Cmp	CX,4			;Mark
		JNZ	pms100
		Call	BlockToggle
		Jmp	Short ToTextEntry

pms100:		Cmp	CX,5			;Jump
		JNZ	pms101
		Call	GoEdJump
		Jmp	Short ToTextEntry

pms101:		Cmp	CX,6			;Search
		JNZ	pms102
		Call	SearchAndRepl
		Jmp	ToTextEntry

pms102:		Cmp	CX,7			;Options
		JNZ	TryPath
		Call	pms129
		Jmp	ToTextEntry

TryPath:	Cmp	CX,8			;InsertPath
		JNZ	pms103
		Mov	PathFlag,1
		Call	GetAndPath
		Jmp	ToTextEntry

pms103:		Cmp	CX,9			;Quit to Main menu
		JNZ	ShowEditorMenu
		Cmp	FileChangedFlag,1
		JNZ	RestoreAndExit
		Cmp	AutoUpdateFlag,1
		JNZ	pms104
		Call	FileUpdate
		Cmp	FileChangedFlag,0
		JE	RestoreAndExit
		Jmp	ToTextEntry

pms104:		Call	QuitChangedFile		;only call
		Cmp	AL,Esc_
		JNZ	RestoreAndExit
		Jmp	ToTextEntry

RestoreAndExit:	Test	HidROattrib,3		;restore orig file attrib
		JZ	NoFix			; if it was changed
		Mov	CH,0
		Or	HidROattrib,20h		;set un-archived
		Mov	CL,HidROattrib
		Mov	AX,4301h		;set file attrib
		Mov	DX,Offset CurrentPath
		Int	21h
		Mov	HidROattrib,0
NoFix:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
ShowPutMenu:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdPutMenu
pms108:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;File
		JZ	DoBlockPut
		Cmp	CX,2			;Printer
		JNZ	TryPutQuit
DoBlockPut:	Call	BlockPut
		Jmp	Short pms110

TryPutQuit:	Cmp	CX,3			;Quit
		JZ	pms110
pms109:		Cmp	AL,Esc_
		JNZ	pms108
pms110:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

GoEdBlock:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdBlockMenu
pms111:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Insert (F4)
		JNZ	pms112
		Call	BlockInsert
		Jmp	Short pms116

pms112:		Cmp	CX,2			;Delete (F3)
		JNZ	pms113
		Call	BlockDel
		Jmp	Short pms116

pms113:		Cmp	CX,3			;Copy (F5)
		JNZ	pms114
		Call	BlockCopy
		Jmp	Short pms116

pms114:		Cmp	CX,4			;Quit
		JZ	pms116
pms115:		Cmp	AL,Esc_
		JNZ	pms111
pms116:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

GoEdJump:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdJmpMenu
pms117:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Begin (Ctrl-PgUp)
		JNZ	pms118
		Call	CtrlPgUp
		Jmp	Short pms123

pms118:		Cmp	CX,2			;End (Ctrl-PgDn)
		JNZ	pms119
		Call	CtrlPgDn
		Jmp	Short pms123

pms119:		Cmp	CX,3			;First (Ctrl-Home)
		JNZ	pms120
		Call	CtrlHome
		Jmp	Short pms123

pms120:		Cmp	CX,4			;Last (Ctrl-End)
		JNZ	pms121
		Mov	ES,EditBufSeg
		Call	CtrlEnd
		Jmp	Short pms123

pms121:		Cmp	CX,5			;Quit
		JZ	pms123
pms122:		Cmp	AL,Esc_
		JNZ	pms117
pms123:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

SearchAndRepl:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdSearchMenu
pms124:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Find
		JNZ	pms125
		Call	DoFind
		Jmp	Short pms128

pms125:		Cmp	CX,2			;Replace
		JNZ	pms126
		Call	DoReplace
		Jmp	Short pms128

pms126:		Cmp	CX,3			;Quit
		JZ	pms128
pms127:		Cmp	AL,Esc_
		JNZ	pms124
pms128:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
pms129:		Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdOptionMenu	;menu to show
ShowEdOptMenu:	Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Update
		JNZ	pms130
		Call	GoEditorUpdate
		Jmp	Short ExitEdOpt

pms130:		Cmp	CX,2			;Auto-Indent
		JNZ	pms131
		Call	GoEditorIndent
		Jmp	Short ExitEdOpt

pms131:		Cmp	CX,3			;Status
		JNZ	pms132
		Call	GoEditorStatus
		Jmp	Short ExitEdOpt

pms132:		Cmp	CX,4			;Quit
		JZ	ExitEdOpt
pms133:		Cmp	AL,Esc_
		JNZ	ShowEdOptMenu
ExitEdOpt:	Call	AskWriteIf
		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - -
GoEditorUpdate:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdOpUpdateMenu
pms134:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Automatic
		JNZ	pms135
		Mov	AutoUpdateFlag,1
		Jmp	Short pms138

pms135:		Cmp	CX,2			;Manual
		JNZ	pms136
		Mov	AutoUpdateFlag,0
		Jmp	Short pms138

pms136:		Cmp	CX,3			;Quit
		JZ	pms138
pms137:		Cmp	AL,Esc_
		JNZ	pms134
pms138:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

GoEditorIndent:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdOpIndentMenu
pms139:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Set
		JNZ	pms140
		Mov	AutoIndentFlag,1
		Jmp	Short pms143

pms140:		Cmp	CX,2			;Reset
		JNZ	pms141
		Mov	AutoIndentFlag,0
		Jmp	Short pms143

pms141:		Cmp	CX,3			;Quit
		JZ	pms143
pms142:		Cmp	AL,Esc_
		JNZ	pms139
pms143:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
QuitChangedFile:Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset EdQuitMenu
pms144:		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Update
		JNZ	pms145
		Call	FileUpdate
		Cmp	FileChangedFlag,0	;Return to Edit if error
		JE	pms148
pms145:		Cmp	CX,2			;Return
		JNZ	pms146
		Mov	AL,Esc_
		Jmp	Short pms148

pms146:		Cmp	CX,3			;Exit
		JNZ	pms147
		Xor	AL,AL
		Jmp	Short pms148

pms147:		Cmp	AL,Esc_
		JNZ	pms144
pms148:		Pop	BP
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - -
GoEditorStatus:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	SI
		Push	ES
		Call	ClsTop2
		Push	CS
		Pop	ES
		Mov	DI,Offset StatsAndCopyPath
		Mov	CX,50h
		Mov	AL,' '
		RepZ	StosB
		Mov	DI,Offset StatsAndCopyPath
		Mov	SI,Offset AutoUpdateStr
		Mov	CX,0Ch
		RepZ	MovsB
		Mov	AL,AutoUpdateFlag
		Call	pms149
		Mov	SI,Offset TabsStr
		Mov	CX,10
		RepZ	MovsB
		Inc	DI
		Mov	SI,Offset AutoIndentStr
		Mov	CX,0Eh
		RepZ	MovsB
		Mov	AL,AutoIndentFlag
		Call	pms149
		Add	DI,12h
		Mov	SI,Offset FreeMemStr
		Mov	CX,0Dh
		RepZ	MovsB
		Mov	AX,CursorUpPointer
		Sub	AX,UpToCursorPtr
		Call	ShowAXatDI
		Add	DI,5
		Mov	Byte Ptr [DI],0
		Xor	CX,CX			;row 0, col 0
		Mov	BL,TextAttrib
		Mov	DX,Offset StatsAndCopyPath
		Call	DisplayZ
		Mov	CX,11Bh			;Row 1, Col 27
		Mov	BL,TextAttrib
		Mov	DX,Offset PressKeyMsg
		Call	DisplayZ
		Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey			;wait for any key
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

pms149:		Cmp	AL,1
		JNZ	pms150
		Mov	SI,Offset ONstr
		Jmp	Short pms151

pms150:		Mov	SI,Offset OFFstr
pms151:		Mov	CX,3
		Rep	MovsB
		Ret
; - - - - - - - - - - - - - - -
PageDn:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Push	SI
		Call	Un_Cursor
		Mov	ES,EditBufSeg
	;don't page down if EOF is on the screen.
		Mov	CH,CursorLine		;CH is line w/cursor, 0 to 19
		Mov	SI,CursorUpPointer
		Mov	CL,19
		Sub	CL,CH			;lines to bottom, do it if >
OffScrnLoop:	Mov	AL,ES:[SI]
		Cmp	AL,EOF
		JNZ	TestLF
		Jmp	PgDnExit

TestLF:		Cmp	AL,LF
		JNZ	KeepGoing
		Sub	CL,1			;DEC doesn't affect Carry
		JC	DoPageDn
KeepGoing:	Inc	SI
		Jmp	Short OffScrnLoop

;screen moves down 19 lines, cursor moves Home, stays at same line
;move the cursor 19 lines ahead or until EOF line
DoPageDn:	Mov	DI,UpToCursorPtr
		Mov	SI,CursorUpPointer
		Mov	CH,19
EachPgDnLine:	Cmp	Byte Ptr ES:[SI],EOF
		JZ	EOFlineLoop
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Inc	SI
		Inc	DI
		Cmp	AL,LF
		JZ	EndPgDnLine
		Inc	CursorUpPointer
		Inc	UpToCursorPtr
		Jmp	Short EachPgDnLine

EndPgDnLine:	Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Inc	DocLineNo
		Dec	CH
		JNZ	EachPgDnLine
		Jmp	Short PgDnDone

;cursor now at EOF, move pointers back to start of last line
EOFlineLoop:	Dec	DI
		Cmp	Byte Ptr ES:[DI],LF
		JZ	pms152
		Dec	SI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[DI]
		Mov	ES:[SI],AL
		Jmp	Short EOFlineLoop

pms152:		Inc	DI
		Sub	CursorLine,CH
;move UpperLeft ahead 19 LF's
; (not affected by ColumnOffset, always 1 past a LF except at start of file)
PgDnDone:	Mov	CX,19
		Mov	DI,UpperLeft
ULLoop:		Inc	DI
		Cmp	Byte Ptr ES:[DI],LF
		JNZ	ULLoop
		Dec	CX
		JNZ	ULLoop
		Inc	DI
		Mov	UpperLeft,DI
		Mov	ColumnOffset,0
		Mov	CursorCol,0
PgDnExit:	Call	PaintUnlessBlock
		Pop	SI
		Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
PageUp:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Push	SI
		Call	Un_Cursor
		Mov	ES,EditBufSeg
		Mov	CH,20			;starts 1 past a LF
		Mov	DI,UpperLeft
		Or	DI,DI
		JNZ	ULlp
		Jmp	PgUpExit

	;try to move UpperLeft up 19 lines
ULlp:		Or	DI,DI
		JZ	AtTop
		Dec	DI
		Cmp	Byte Ptr ES:[DI],LF
		JNZ	ULlp
		Dec	CH
		JNZ	ULlp
		Inc	DI
AtTop:		Mov	UpperLeft,DI
	;try to move the cursor up 19 lines
		Mov	CL,20
		Mov	SI,UpToCursorPtr
		Mov	DI,CursorUpPointer
EachPgUpLine:	Or	SI,SI
		JNZ	PUctu
		Mov	CursorLine,0
		Jmp	PgUpDone

PUctu:		Dec	SI
		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	AL,LF
		JNZ	EachPgUpLine

EndPgUpLine:	Dec	DocLineNo
		Dec	CL
		JNZ	EachPgUpLine
		Or	CH,CH
		JZ	Went19
		Dec	CH
		Sub	CursorLine,CH
Went19:		Inc	CursorUpPointer
		Inc	UpToCursorPtr
		Inc	DocLineNo
PgUpDone:	Mov	ColumnOffset,0
		Mov	CursorCol,0
PgUpExit:	Call	PaintUnlessBlock
		Pop	SI
		Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
CtrlHome:	Push	CX			;2 calls
		Call	Home
pms153:		Cmp	CursorLine,0
		JZ	pms154
		Call	CrsrUp
		Jmp	Short pms153
pms154:		Pop	CX
		Ret

CtrlEnd:	Push	CX
		Call	Home
		Mov	CH,23
		Sub	CH,TopLineNo
		Dec	CH
pms155:		Cmp	CH,CursorLine
		JZ	pms156
		Mov	CL,CursorLine
		Call	CrsrDn
		Cmp	CL,CursorLine
		JZ	pms156
		Jmp	Short pms155

pms156:		Pop	CX
		Ret

CtrlPgDn:	Push	CX			;2 calls
		Push	AX
		Push	DI
		Push	ES
		Push	SI
		Mov	ES,EditBufSeg
	;if file is less than a full screen, do nothing
		Xor	AX,AX
		Mov	DI,EOFpointer
		Inc	DI
LFloop:		Dec	DI
		Cmp	DI,CursorUpPointer
		JZ	CountLines
		Cmp	Byte Ptr ES:[DI],LF
		JNZ	LFloop
		Inc	AX
		Cmp	AX,19
		JA	DoCtlPgDn		;w/DI>lf at top of last page
		Jmp	Short LFloop

CountLines:	Mov	CX,AX			;LF's from end back to crsr
		Add	CX,DocLineNo		;+ crsr line = total lines
		Cmp	CX,19
		JA	FinishCount
		Jmp	CPDret

FinishCount:	Mov	SI,DI			;SI has pointer 'count'
		Mov	DI,UpToCursorPtr
		Inc	DI
		Inc	SI
FinishLoop:	Dec	DI
		Dec	SI
		Cmp	Byte Ptr ES:[DI],LF
		JNZ	FinishLoop
		Inc	AX			;LF's from end back to crsr
		Cmp	AX,19
		JBE	FinishLoop
		Mov	DI,SI
;Put cursor & EOF in last line of screen by moving crsr to EOF,
; put UpperLeft at 19th LF back.
DoCtlPgDn:	Mov	CX,EOFpointer		;EOF, DI=bytes to top last page
		Sub	CX,DI			;save distance back in CX
		Mov	DI,UpToCursorPtr
		Mov	SI,CursorUpPointer
DownToEOF:	Cmp	SI,EOFpointer		;will go past an EOF char
		JZ	FindUpperL
		Cmp	Byte Ptr ES:[SI],LF
		JNZ	pms157
		Inc	DocLineNo
pms157:		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Inc	DI
		Inc	SI
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Jmp	Short DownToEOF

FindUpperL:	Sub	DI,CX			;UpToCursorPtr - bytes back
		Inc	DI
		Mov	UpperLeft,DI
		Mov	CursorLine,19
		Mov	ColumnOffset,0
		Call	Home
		Call	EndKey
		Call	PaintUnlessBlock
CPDret:		Pop	SI
		Pop	ES
		Pop	DI
		Pop	AX
		Pop	CX
		Ret

CtrlPgUp:	Push	AX			;2 calls
		Push	DI
		Push	ES
		Push	SI
		Call	ShowWait
		Mov	ES,EditBufSeg
		Mov	DI,CursorUpPointer
		Mov	SI,UpToCursorPtr
pms158:		Or	SI,SI
		JZ	pms159
		Dec	SI
		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	Byte Ptr ES:[SI],LF
		JNZ	pms158
		Dec	DocLineNo
		Jmp	Short pms158

pms159:		Mov	UpperLeft,0
		Mov	ColumnOffset,0
		Mov	CursorCol,0
		Mov	CursorLine,0
		Call	PaintUnlessBlock
		Call	ShowInsOvrtype
		Pop	SI
		Pop	ES
		Pop	DI
		Pop	AX
		Ret

RightArrow:	Push	AX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Push	SI
		Call	Un_Cursor
		Mov	ES,EditBufSeg
		Mov	SI,CursorUpPointer
		Mov	DI,UpToCursorPtr
		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms160
		Jmp	pms165

pms160:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms163
	;cursor right at CR LF
		Mov	AL,ES:[SI]		;CursorUpPointer
		Mov	ES:[DI],AL		;UpToCursorPtr
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Inc	SI
		Inc	DI
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Inc	SI
		Inc	DI
		Inc	DocLineNo
		Push	DX
		Mov	DH,23
		Mov	DL,TopLineNo
		Sub	DH,DL
		Dec	DH
		Mov	DL,CursorLine
		Cmp	DH,DL
		Pop	DX
		JNZ	pms161
pms168:		Call	pms169
		Jmp	Short pms162

pms161:		Inc	CursorLine
pms162:		Mov	CursorCol,0
		Mov	ColumnOffset,0
		Call	PaintUnlessBlock
		Jmp	Short pms165

pms163:		Cmp	Byte Ptr ES:[SI],Tab
		JNZ	NormalRtArrow
	;cursor right at tab
		Xor	AH,AH
		Mov	AL,CursorCol
		Add	AX,ColumnOffset
		CWD
		Mov	CX,TabsSetting		;always 8
		IDIV	CX
		Sub	CX,DX
		Add	CursorCol,CL
		Call	ChkOffScrn
		Or	AX,AX
		JZ	pms164
		Add	ColumnOffset,0Ah
		Sub	CursorCol,0Ah
		Call	PaintUnlessBlock
		Jmp	Short pms164

NormalRtArrow:	Inc	CursorCol
		Call	ChkOffScrn
		Or	AX,AX
		JZ	pms164
	;cursor is off screen, scroll right 10d spaces
		Add	ColumnOffset,0Ah
		Sub	CursorCol,0Ah
		Call	PaintUnlessBlock
pms164:		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
pms165:		Call	ShowCursor
		Pop	SI
		Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	AX
		Ret

ChkOffScrn:	Push	DX
		Mov	DH,80
		Mov	DL,CursorCol
		Cmp	DL,DH
		JNB	pms166
		Xor	AX,AX
		Jmp	Short pms167

pms166:		Mov	AX,1			;signal off screen
pms167:		Pop	DX
		Ret

pms169:		Push	AX
		Push	ES
		Push	DI
		Mov	ES,EditBufSeg
		Mov	DI,UpperLeft
pms170:		Cmp	Byte Ptr ES:[DI],LF
		JZ	pms171
		Inc	DI
		Cmp	Byte Ptr ES:[DI],EOF
		JZ	pms172
		Jmp	Short pms170

pms171:		Inc	DI
		Mov	UpperLeft,DI
pms172:		Pop	DI
		Pop	ES
		Pop	AX
		Ret

LeftArrow:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Push	SI
		Call	Un_Cursor
		Mov	ES,EditBufSeg
		Mov	SI,UpToCursorPtr
		Or	SI,SI
		JNZ	pms173
		Jmp	pms196

pms173:		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	DI,CursorUpPointer
		Dec	SI
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms174
		Jmp	pms184

pms174:		Dec	SI
		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Dec	DocLineNo
		Mov	DI,SI
pms175:		Or	DI,DI
		JZ	pms177
		Cmp	Byte Ptr ES:[DI],LF
		JZ	pms176
		Dec	DI
		Jmp	Short pms175

pms176:		Inc	DI
pms177:		Xor	CX,CX
pms178:		Cmp	Byte Ptr ES:[DI],CR
		JZ	pms180
		Cmp	Byte Ptr ES:[DI],Tab
		JNZ	pms179
		Call	CXupToTab
		Inc	DI
		Jmp	Short pms178

CXupToTab:	Push	CX
		Xchg	AX,CX			;no of blanks
		CWD				;hi bit of AX fills DX
		Mov	CX,TabsSetting
		IDIV	CX			;AX=DXAX/CX, DX=remainder
		Sub	CX,DX
		Mov	DX,CX			;no. of spaces < integral tabs
		Pop	CX
		Add	CX,DX
		Ret

pms179:		Inc	CX
		Inc	DI
		Jmp	Short pms178

pms180:		Mov	DL,80
		Xor	DH,DH
		Sub	DL,DH
		Mov	DH,0
		Cmp	CX,DX
		JB	pms181
		Push	CX
		Xchg	AX,CX
		Sub	AX,DX
		CWD
		Mov	CX,0Ah
		IDIV	CX
		Inc	AX
		Mul	CX
		Mov	ColumnOffset,AX
		Pop	CX
		Sub	CX,AX
pms181:		Mov	CursorCol,CL
		Cmp	CursorLine,0
		JNZ	pms182
		Call	pms197
		Jmp	Short pms183

pms182:		Dec	CursorLine
pms183:		Call	PaintUnlessBlock
		Jmp	pms196

pms184:		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms185
		Jmp	Short pms193

pms185:		Mov	DI,SI
pms186:		Or	DI,DI
		JZ	pms188
		Cmp	Byte Ptr ES:[DI],LF
		JZ	pms187
		Dec	DI
		Jmp	Short pms186

pms187:		Inc	DI
pms188:		Xor	CX,CX
pms189:		Cmp	Byte Ptr ES:[DI],Tab
		JNZ	pms190
		Mov	BX,CX
		Call	CXupToTab
		Mov	AL,CursorCol
		Xor	AH,AH
		Add	AX,ColumnOffset
		Cmp	CX,AX
		JZ	pms191
		Inc	DI
		Jmp	Short pms189

pms190:		Inc	CX
		Inc	DI
		Jmp	Short pms189

pms191:		Cmp	BX,ColumnOffset
		JNB	pms192
		Sub	ColumnOffset,0Ah
		Sub	BX,ColumnOffset
		Mov	CursorCol,BL
		Call	PaintUnlessBlock
		Jmp	Short pms196

pms192:		Sub	BX,ColumnOffset
		Mov	CursorCol,BL
		Jmp	Short pms196

pms193:		Cmp	ColumnOffset,0
		JNZ	pms194
		Dec	CursorCol
		Jmp	Short pms196

pms194:		Cmp	CursorCol,0
		JNZ	pms195
		Sub	ColumnOffset,0Ah
		Add	CursorCol,9
		Call	PaintUnlessBlock
		Jmp	Short pms196

pms195:		Dec	CursorCol
pms196:		Call	ShowCursor
		Pop	SI
		Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

pms197:		Push	AX
		Push	ES
		Push	DI
		Mov	ES,EditBufSeg
		Mov	DI,UpperLeft
		Or	DI,DI
		JZ	pms201
		Dec	DI
		Dec	DI
pms198:		Mov	AL,0Ah
		Cmp	ES:[DI],AL
		JZ	pms199
		Or	DI,DI
		JZ	pms200
		Dec	DI
		Jmp	Short pms198

pms199:		Inc	DI
pms200:		Mov	UpperLeft,DI
pms201:		Pop	DI
		Pop	ES
		Pop	AX
		Ret

CtrlLeft:	Push	AX
		Push	SI
		Push	ES
		Mov	ES,EditBufSeg
pms202:		Mov	SI,UpToCursorPtr
		Or	SI,SI
		JNZ	pms203
		Jmp	Short pms208
; - - - - - - - - - - - - - -
ChkAlphaNum:	Cmp	Byte Ptr ES:[SI],'0'
		JB	NotAlphaNum
		Cmp	Byte Ptr ES:[SI],'9'
		JBE	IsAlphaNum
		Cmp	Byte Ptr ES:[SI],'A'
		JB	NotAlphaNum
		Cmp	Byte Ptr ES:[SI],'Z'
		JBE	IsAlphaNum
		Cmp	Byte Ptr ES:[SI],'a'
		JB	NotAlphaNum
		Cmp	Byte Ptr ES:[SI],'z'
		JBE	IsAlphaNum
NotAlphaNum:	STC
		Ret

IsAlphaNum:	STC
		CMC
		Ret
; - - - - - - - - - - - - - -
pms203:		Dec	SI
		Or	SI,SI
		JZ	pms207
		Call	ChkAlphaNum		;Carry if not
		JC	pms205
pms204:		Call	LeftArrow
		Jmp	Short pms202

pms205:		Dec	SI
		Or	SI,SI
		JZ	pms206
		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms204
		Cmp	Byte Ptr ES:[SI],' '
		JZ	pms204
		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms204
		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms206
		Dec	SI
		Or	SI,SI
		JZ	pms206
		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms204
		Cmp	Byte Ptr ES:[SI],' '
		JZ	pms204
		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms204
pms206:		Call	LeftArrow
pms207:		Call	LeftArrow
pms208:		Pop	ES
		Pop	SI
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - -
BlockToggle:	Push	AX
		Cmp	BlockFlag,0
		JZ	pms210
		Mov	BlockFlag,0
		Mov	AX,UpToCursorPtr
		Cmp	AX,BlockStart
		JBE	pms209
		Call	RightArrow
pms209:		Call	PaintUnlessBlock
		Jmp	Short ToglDone
pms210:		Mov	BlockFlag,1
		Mov	AX,UpperLeft
		Mov	OrigUprLeft,AX
		Mov	AL,CursorLine
		Mov	OrigScrnLine,AL
		Mov	AL,CursorCol
		Mov	OrigScrnCol,AL
		Mov	AX,DocLineNo
		Mov	OrigEditLnNo,AX
		Mov	AX,ColumnOffset
		Mov	OrigColOffset,AX
ToglDone:	Mov	AX,UpToCursorPtr
		Mov	BlockStart,AX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - -
BlockCopy:	Push	AX			;3 calls, copy block into buffer
		Push	CX
		Push	DI
		Push	DX
		Push	ES
		Push	SI
		Cmp	BlockFlag,1
		JZ	CopyBlockExists
		Mov	DX,Offset NoBlockStr
		Call	ShowErrMsg
		Jmp	CopyBlockDone

CopyBlockExists:MOV	ES,EditBufSeg
		Mov	AX,BytesInBuf
		Mov	TempBytesInBuf,AX
		Mov	CX,BlockStart
		Cmp	CX,UpToCursorPtr
		JNB	CopyBackward
		Mov	CX,UpToCursorPtr
		Sub	CX,BlockStart
		Inc	CX
		Jmp	Short pms211

CopyBackward:	Sub	CX,UpToCursorPtr
pms211:		Inc	CX
		Mov	AX,CursorUpPointer
		Add	AX,TempBytesInBuf
		Sub	AX,UpToCursorPtr
		Cmp	AX,CX
		JA	NotTooLg
		Mov	DX,Offset TooLgForBufMsg
		Call	ShowErrMsg
		Jmp	CopyBlockDone

NotTooLg:	Mov	CX,BlockStart
		Cmp	UpToCursorPtr,CX
		JB	CpyBkw
CpyFwd:		Mov	CX,UpToCursorPtr
		Sub	CX,BlockStart
		Mov	FwdFlag,1
		Jmp	Short pms221

CpyBkw:		Mov	CX,BlockStart
		Sub	CX,UpToCursorPtr
		Mov	FwdFlag,0
pms221:		Call	CopyFwdOrBk
		Mov	AX,TotalInverse
		Mov	BytesInBuf,AX
CopyBlockDone:	Call	ShowInsOvrtype
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DI
		Pop	CX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - - -
CopyFwdOrBk:	Inc	CX
		Inc	CX
		Mov	TotalInverse,CX
		Mov	CX,TempBytesInBuf
		Cmp	TotalInverse,CX
		JB	pms217
		JZ	pms218
		Mov	DI,CursorUpPointer
		Cmp	FwdFlag,1
		JE	RevOrder
		Sub	DI,TotalInverse		;***is rollover possible,
		Add	DI,TempBytesInBuf	; or can both be same ??
		Jmp	Short EndOrder

RevOrder:	Add	DI,TempBytesInBuf
		Sub	DI,TotalInverse
EndOrder:	Dec	DI
		Mov	SI,CursorUpPointer
		Mov	CX,EOFpointer
		Sub	CX,CursorUpPointer
		Inc	CX
		Push	DS
		Mov	DS,EditBufSeg
		Rep	MovsB
		Pop	DS
		Dec	DI
		Mov	EOFpointer,DI
		Mov	CX,CursorUpPointer
		Sub	CX,TotalInverse
		Add	CX,TempBytesInBuf
		Dec	CX
		Mov	CursorUpPointer,CX
		Jmp	Short pms218

pms217:		Mov	SI,EOFpointer
		Mov	DI,EditBytesToRead
		Sub	DI,TotalInverse
		Dec	DI
		Mov	CX,EOFpointer
		Sub	CX,CursorUpPointer
		Inc	CX
		Push	DS
		Mov	DS,EditBufSeg
		STD
		Rep	MovsB
		CLD
		Pop	DS
		Inc	DI
		Mov	CursorUpPointer,DI
		Mov	CX,EditBytesToRead
		Dec	CX
		Sub	CX,TotalInverse
		Mov	EOFpointer,CX
pms218:		Mov	SI,CursorUpPointer
		Cmp	FwdFlag,1
		JNE	BsCu
		Mov	SI,BlockStart
BsCu:		Mov	DI,EOFpointer
		Inc	DI
		Mov	CX,TotalInverse
		Dec	CX
		Dec	CX
		Push	DS
		Mov	DS,EditBufSeg
		Rep	MovsB
		Pop	DS
		Cmp	FwdFlag,1
		JNE	NoCu
		Mov	SI,CursorUpPointer
NoCu:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms219
		Dec	TotalInverse
		Dec	TotalInverse
		Jmp	Short CFBret

pms219:		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	Byte Ptr ES:[SI],CR
		JZ	pms220
		Dec	TotalInverse
		Jmp	Short CFBret

pms220:		Inc	SI
		Inc	DI
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
CFBret:		Ret
;
BlockInsert:	Push	AX			;2 calls
		Push	CX
		Push	DI
		Push	DX
		Push	ES
		Push	SI
		Mov	ES,EditBufSeg
		Cmp	BytesInBuf,0
		JNZ	pms222
		Mov	DX,Offset BufferEmptyMsg
		Call	ShowErrMsg
		Jmp	Short pms224

pms222:		Mov	CX,CursorUpPointer
		Sub	CX,UpToCursorPtr
		Cmp	CX,BytesInBuf
		JA	pms223
		Mov	DX,Offset TooLgToInsMsg
		Call	ShowErrMsg
		Jmp	Short pms224

pms223:		Mov	SI,EOFpointer
		Add	SI,BytesInBuf
		Mov	DI,CursorUpPointer
		Dec	DI
		Mov	CX,BytesInBuf
		Push	DS
		Mov	DS,EditBufSeg
		Std
		Rep	MovsB
		Cld
		Pop	DS
		Inc	DI
		Mov	CursorUpPointer,DI
		Mov	CX,FileLength
		Add	CX,BytesInBuf
		Mov	FileLength,CX
		Call	PaintUnlessBlock
pms224:		Jmp	pms231

BlockDel:	Push	AX			;2 calls
		Push	CX
		Push	DI
		Push	DX
		Push	ES
		Push	SI
		Mov	ES,EditBufSeg
		Cmp	BlockFlag,1
		JZ	pms225
		Mov	DX,Offset NoBlockStr
		Call	ShowErrMsg
		Jmp	pms231

pms225:		Mov	AX,BytesInBuf
		Mov	TempBytesInBuf,AX
		Mov	CX,BlockStart
		Cmp	CX,UpToCursorPtr
		JNB	pms226
		Mov	CX,UpToCursorPtr
		Sub	CX,BlockStart
		Inc	CX
		Inc	CX
		Jmp	Short pms227

pms226:		Sub	CX,UpToCursorPtr
		Inc	CX
pms227:		Mov	AX,CursorUpPointer
		Add	AX,TempBytesInBuf
		Sub	AX,UpToCursorPtr
		Cmp	AX,CX
		JA	pms228
		Mov	DX,Offset TooLgForBufMsg
		Call	ShowErrMsg
		Jmp	pms231

pms228:		Call	BlockCopy
		Mov	CX,UpToCursorPtr
		Cmp	BlockStart,CX
		JA	pms229
		Mov	CX,FileLength
		Sub	CX,BytesInBuf
		Mov	FileLength,CX
		Mov	AX,OrigUprLeft
		Mov	UpperLeft,AX
		Mov	AL,OrigScrnLine
		Mov	CursorLine,AL
		Mov	AL,OrigScrnCol
		Mov	CursorCol,AL
		Mov	AX,OrigEditLnNo
		Mov	DocLineNo,AX
		Mov	AX,OrigColOffset
		Mov	ColumnOffset,AX
		Mov	BlockFlag,0
		Mov	CX,BlockStart
		Mov	UpToCursorPtr,CX
		Mov	SI,CursorUpPointer
		Cmp	Byte Ptr ES:[SI],EOF
		JZ	pms230
		Inc	CursorUpPointer
		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms230
		Inc	CursorUpPointer
		Jmp	Short pms230
pms229:		Mov	SI,CursorUpPointer
		Add	SI,BytesInBuf
		Mov	CursorUpPointer,SI
		Mov	CX,FileLength
		Sub	CX,BytesInBuf
		Mov	FileLength,CX
		Mov	BlockFlag,0
pms230:		Call	PaintUnlessBlock
pms231:		Mov	FileChangedFlag,1
		Call	ShowInsOvrtype
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DI
		Pop	CX
		Pop	AX
		Ret

; - - - - - - - - - - - - - - - - - -
;called from PaintUnlessBlock and twice when Editor sets up, at TextEntry,
; usually w/DH=23d
PaintTextScreen:PUSH	AX
		Push	BX
		Push	BP
		Push	CX
		Push	DX
		Push	DI
		Push	SI
		Push	ES
		Mov	CH,TopLineNo
		Xor	CL,CL
		Xor	BP,BP
		Mov	DX,ColumnOffset
		Add	DX,80
		Mov	AX,UpToCursorPtr
		Cmp	AX,BlockStart
		JNB	PulledAhead
	;the cursor is BEFORE the start of the block
		Mov	AX,CursorUpPointer
		Mov	BlockPaintPtr,AX
		Mov	AX,BlockStart
		Sub	AX,UpToCursorPtr
		Inc	AX
		Add	BlockPaintPtr,AX
		Jmp	Short pms232

PulledAhead:	Mov	AX,BlockStart
		Mov	BlockPaintPtr,AX
pms232:		Mov	AX,160
		Mul	CH
		Xchg	AX,DI
		Mov	BlockAttribFlag,0
		Mov	AL,TextAttrib
		Mov	CurrAttrib,AL
		Mov	SI,UpperLeft
		Cmp	SI,BlockPaintPtr
		JBE	pms233
		Call	SetCurrAttrib
pms233:		Mov	ES,EditBufSeg
pms234:		Xor	BX,BX
		Cmp	ColumnOffset,0
		JNZ	pms236
pms235:		Jmp	pms245

pms236:		Cmp	SI,BlockPaintPtr
		JNZ	pms237
		Call	SetCurrAttrib
pms237:		Cmp	SI,UpToCursorPtr
		JNZ	pms238
		Call	SetCurrAttrib
		Mov	SI,CursorUpPointer
pms238:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms239
		Mov	BX,ColumnOffset
		Mov	BP,1
		Jmp	pms263

pms239:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms240
		Mov	BX,ColumnOffset
		Mov	CL,1
		Jmp	pms258

pms240:		Cmp	Byte Ptr ES:[SI],Tab
		JNZ	pms241
		Push	AX
		Push	CX
		Push	DX
		Mov	AX,BX
		CWD
		Mov	CX,TabsSetting		;always 8
		IDIV	CX
		Sub	CX,DX
		Add	BX,CX
		Pop	DX
		Pop	CX
		Pop	AX
		Cmp	BX,ColumnOffset
		JNB	pms242
		Dec	BX
pms241:		Inc	SI
		Inc	BX
		Cmp	BX,ColumnOffset
		JZ	pms245
		Jmp	Short pms236

pms242:		Sub	BX,ColumnOffset
		Mov	AX,BX
		Push	ES
		Mov	ES,VideoSeg
pms243:		Or	AX,AX
		JZ	pms244
		Mov	Byte Ptr ES:[DI],' '
		Inc	DI
		Mov	CL,CurrAttrib
		Mov	ES:[DI],CL
		Inc	DI
		Dec	AX
		Jmp	Short pms243

pms244:		Pop	ES
		Add	BX,ColumnOffset
		Inc	SI
pms245:		Cmp	SI,BlockPaintPtr
		JNZ	pms246
		Call	SetCurrAttrib
pms246:		Cmp	SI,UpToCursorPtr
		JNZ	pms247
		Call	SetCurrAttrib
		Mov	SI,CursorUpPointer
pms247:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms248
		Jmp	pms263

pms248:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms249
		Xor	CL,CL
		Jmp	pms258

pms249:		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms251
		Cmp	BX,DX
		JNB	pms254
		Mov	AL,ES:[SI]
		Push	ES
		Mov	ES,VideoSeg
		Mov	ES:[DI],AL
		Inc	DI
		Mov	AL,CurrAttrib
		Mov	ES:[DI],AL
		Pop	ES
		Inc	BX
		Inc	DI
pms250:		Inc	SI
		Jmp	Short pms245

pms251:		Push	AX
		Push	CX
		Push	DX
		Mov	AX,BX
		CWD
		Mov	CX,TabsSetting
		IDIV	CX
		Sub	CX,DX
		Pop	DX
		Mov	AX,CX
		Push	ES
		Mov	ES,VideoSeg
pms252:		Or	AX,AX
		JZ	pms253
		Cmp	BX,DX
		JZ	pms253
		Mov	Byte Ptr ES:[DI],' '
		Inc	DI
		Mov	CL,CurrAttrib
		Mov	ES:[DI],CL
		Inc	DI
		Inc	BX
		Dec	AX
		Jmp	Short pms252

pms253:		Pop	ES
		Pop	CX
		Pop	AX
		Jmp	Short pms250

pms254:		Inc	SI
		Cmp	SI,UpToCursorPtr
		JNZ	pms255
		Mov	SI,CursorUpPointer
pms255:		Cmp	SI,BlockPaintPtr
		JNZ	pms256
		Call	SetCurrAttrib
pms256:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms257
		Mov	BP,1
		Jmp	Short pms263

pms257:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms254
		Inc	SI
		Inc	SI
		Jmp	pms268

pms258:		Mov	AX,DX
		Sub	AX,BX
		Cmp	CL,1
		JZ	pms261
		Or	AX,AX
		JNZ	pms260
		Inc	SI
		Cmp	SI,BlockPaintPtr
		JNZ	pms259
		Call	SetCurrAttrib
pms259:		Inc	SI
		Jmp	Short pms268

pms260:		Push	ES
		Mov	ES,VideoSeg
		Mov	Byte Ptr ES:[DI],' '
		Inc	DI
		Mov	CL,CurrAttrib
		Mov	ES:[DI],CL
		Inc	DI
		Pop	ES
		Dec	AX
pms261:		Inc	SI
		Cmp	SI,BlockPaintPtr
		JNZ	pms262
		Call	SetCurrAttrib
pms262:		Inc	SI
		Jmp	Short pms266

pms263:		Mov	AX,DX
		Sub	AX,BX
		Cmp	BP,1
		JZ	pms265
		Or	AX,AX
		JNZ	pms264
		Mov	BP,1
		Jmp	Short pms268

pms264:		Push	ES
		Mov	ES,VideoSeg
		Mov	Byte Ptr ES:[DI],4	;'', marks EOF on screen only
		Inc	DI
		Mov	CL,CurrAttrib
		Mov	ES:[DI],CL
		Inc	DI
		Pop	ES
		Dec	AX
pms265:		Mov	BP,1
pms266:		Push	ES
		Mov	ES,VideoSeg
BlankLoop1:	Or	AX,AX
		JZ	pms267
		Mov	Byte Ptr ES:[DI],' '
		Inc	DI
		Mov	CL,TextAttrib
		Mov	ES:[DI],CL
		Inc	DI
		Dec	AX
		Jmp	Short BlankLoop1

pms267:		Pop	ES
pms268:		Inc	CH
		Cmp	CH,23
		JZ	pms269
		Mov	AX,160			;one row
		Mul	CH
		Mov	DI,AX
		Jmp	pms234

pms269:		Mov	AL,BlockFlag
		Push	AX
		Mov	BlockFlag,0
		Call	ShowCursor
		Pop	AX
		Mov	BlockFlag,AL
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BP
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
SetCurrAttrib:	Push	AX
		Cmp	BlockFlag,0
		JZ	SetDone
		Cmp	BlockAttribFlag,1
		JZ	pms270
		Mov	BlockAttribFlag,1
		Mov	AL,BlockAttrib
		Jmp	Short SetIt

pms270:		Mov	BlockAttribFlag,0
		Mov	AL,TextAttrib
SetIt:		Mov	CurrAttrib,AL
SetDone:	Pop	AX
		Ret
; - - - - - - - - - - - - - - -
CrsrUp:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	ES
		Push	DI
		Push	SI
		Call	Un_Cursor
		Cmp	CursorLine,0
		JNZ	pms272
		Cmp	UpperLeft,0
		JNZ	pms271
		Jmp	pms286

pms271:		Call	pms197
		Call	PaintUnlessBlock
		Call	Un_Cursor
		Jmp	Short pms273

pms272:		Dec	CursorLine
pms273:		Mov	SI,UpToCursorPtr
pms274:		Dec	SI
		Cmp	Byte Ptr ES:[SI],LF
		JNZ	pms274
pms275:		Dec	SI
		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms276
		Or	SI,SI
		JZ	pms277
		Jmp	Short pms275

pms276:		Inc	SI
pms277:		Xor	CX,CX
pms278:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms279
		Mov	BX,CX
		Jmp	Short pms282

pms279:		Cmp	Byte Ptr ES:[SI],Tab
		JNZ	pms280
		Mov	BX,CX
		Call	CXupToTab
		Mov	AL,CursorCol
		Xor	AH,AH
		Add	AX,ColumnOffset
		Cmp	CX,AX
		JA	pms282
		Inc	SI
		Jmp	Short pms278

pms280:		Mov	AL,CursorCol
		Xor	AH,AH
		Add	AX,ColumnOffset
		Cmp	CX,AX
		JNZ	pms281
		Mov	BX,CX
		Jmp	Short pms282

pms281:		Inc	CX
		Inc	SI
		Jmp	Short pms278

pms282:		Cmp	BX,ColumnOffset
		JNB	pms283
		Mov	AX,BX
		CWD
		Mov	CX,0Ah
		IDIV	CX
		Mul	CX
		Mov	ColumnOffset,AX
		Sub	BX,ColumnOffset
		Mov	CursorCol,BL
		Call	PaintUnlessBlock
		Call	Un_Cursor
		Jmp	Short pms284

pms283:		Sub	BX,ColumnOffset
		Mov	CursorCol,BL
pms284:		Mov	DI,CursorUpPointer
		Mov	BX,SI
		Mov	SI,UpToCursorPtr
pms285:		Dec	DI
		Dec	SI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	SI,BX
		JNZ	pms285
		Dec	DocLineNo
pms286:		Call	ShowCursor
		Pop	SI
		Pop	DI
		Pop	ES
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

CrsrDn:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	ES
		Push	DI
		Push	SI
		Call	Un_Cursor
		Mov	SI,CursorUpPointer
pms287:		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms289
		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms288
		Jmp	pms301

pms288:		Inc	SI
		Jmp	Short pms287

pms289:		Inc	SI
		Mov	DH,23
		Mov	DL,TopLineNo
		Sub	DH,DL
		Dec	DH
		Cmp	CursorLine,DH
		JNZ	pms290
		Call	pms169
		Call	PaintUnlessBlock
		Call	Un_Cursor
		Jmp	Short pms291

pms290:		Inc	CursorLine
pms291:		Xor	CX,CX
pms292:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms293
		Mov	BX,CX
		Jmp	Short pms297

pms293:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms294
		Mov	BX,CX
		Jmp	Short pms297

pms294:		Cmp	Byte Ptr ES:[SI],Tab
		JNZ	pms295
		Mov	BX,CX
		Call	CXupToTab
		Mov	AL,CursorCol
		Xor	AH,AH
		Add	AX,ColumnOffset
		Cmp	CX,AX
		JA	pms297
		Inc	SI
		Jmp	Short pms292

pms295:		Mov	AL,CursorCol
		Xor	AH,AH
		Add	AX,ColumnOffset
		Cmp	CX,AX
		JNZ	pms296
		Mov	BX,CX
		Jmp	Short pms297

pms296:		Inc	CX
		Inc	SI
		Jmp	Short pms292

pms297:		Cmp	BX,ColumnOffset
		JNB	pms298
		Mov	AX,BX
		CWD
		Mov	CX,0Ah
		IDIV	CX
		Mul	CX
		Mov	ColumnOffset,AX
		Sub	BX,ColumnOffset
		Mov	CursorCol,BL
		Call	PaintUnlessBlock
		Jmp	Short pms299

pms298:		Sub	BX,ColumnOffset
		Mov	CursorCol,BL
pms299:		Inc	DocLineNo
		Mov	BX,SI
		Mov	DI,UpToCursorPtr
		Mov	SI,CursorUpPointer
pms300:		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	SI,BX
		JZ	pms301
		Inc	SI
		Inc	DI
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Jmp	Short pms300

pms301:		Call	ShowCursor
		Pop	SI
		Pop	DI
		Pop	ES
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

Home:		Push	AX
		Push	DI
		Push	SI
		Push	ES
		Mov	ES,EditBufSeg
		Call	Un_Cursor
		Mov	SI,UpToCursorPtr
		Or	SI,SI
		JZ	HomeExit
		Mov	DI,CursorUpPointer
pms302:		Dec	SI
		Cmp	Byte Ptr ES:[SI],LF
		JZ	HomeDone
		Or	SI,SI
		JZ	pms303
		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Jmp	Short pms302
pms303:		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
HomeDone:	Mov	CursorCol,0
		Mov	ColumnOffset,0
		Call	PaintUnlessBlock
HomeExit:	Call	ShowCursor
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	AX
		Ret

EndKey:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Push	SI
		Call	Un_Cursor
		Mov	ES,EditBufSeg
		Mov	DI,UpToCursorPtr
		Mov	SI,CursorUpPointer
		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms304
		Jmp	EndDone

pms304:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms305
		Jmp	EndDone

pms305:		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Inc	SI
		Inc	DI
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Cmp	Byte Ptr ES:[SI],EOF
		JZ	pms306
		Cmp	Byte Ptr ES:[SI],CR
		JZ	pms306
		Jmp	Short pms305

pms306:		Dec	DI
pms307:		Or	DI,DI
		JZ	pms309
		Cmp	Byte Ptr ES:[DI],LF
		JZ	pms308
		Dec	DI
		Jmp	Short pms307

pms308:		Inc	DI
pms309:		Xor	CX,CX
pms310:		Cmp	DI,UpToCursorPtr
		JNB	EndFoundCrsr
		Cmp	Byte Ptr ES:[DI],Tab
		JNZ	pms311
		Call	CXupToTab
		Inc	DI
		Jmp	Short pms310

pms311:		Inc	CX
		Inc	DI
		Jmp	Short pms310

EndFoundCrsr:	Mov	DX,80
		Cmp	CX,DX
		JB	pms312
		Push	CX
		Xchg	AX,CX
		Sub	AX,DX
		CWD
		Mov	CX,0Ah
		IDIV	CX
		Inc	AX
		Mul	CX
		Mov	ColumnOffset,AX
		Pop	CX
pms312:		Sub	CX,ColumnOffset
		Mov	CursorCol,CL
		Call	PaintUnlessBlock
EndDone:	Call	ShowCursor
		Pop	SI
		Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

CtrlRight:	Push	AX
		Push	SI
		Push	ES
		Mov	ES,EditBufSeg
pms313:		Mov	SI,CursorUpPointer
		Cmp	Byte Ptr ES:[SI],EOF
		JZ	pms317
		Call	ChkAlphaNum		;Carry if not
		JC	pms315
pms314:		Call	RightArrow
		Jmp	Short pms313

pms315:		Inc	SI
		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms314
		Cmp	Byte Ptr ES:[SI],' '
		JZ	pms314
		Cmp	Byte Ptr ES:[SI],CR
		JZ	pms314
		Cmp	Byte Ptr ES:[SI],LF
		JNZ	pms316
		Inc	SI
		Cmp	Byte Ptr ES:[SI],EOF
		JZ	pms316
		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms314
		Cmp	Byte Ptr ES:[SI],' '
		JZ	pms314
		Cmp	Byte Ptr ES:[SI],CR
		JZ	pms314
pms316:		Call	RightArrow
pms317:		Pop	ES
		Pop	SI
		Pop	AX
		Ret

HorizBar:	Mov	AL,0C4h			; <Alt-Minus> = Horiz bar char
		Jmp	Short TypeIt

Approx:		Mov	AX,0F7h			; <Alt-Equals> = Approximately
		Jmp	Short TypeIt

Square:		Mov	AL,0FDh			; <Alt-2> = Superscript 2
		Jmp	Short TypeIt

Pi:		Mov	AL,0E3h
		Jmp	Short TypeIt

Cent:		Mov	AL,9Bh
		Jmp	Short TypeIt

Degree:		Mov	AL,0F8h			;<Alt-d>
		Jmp	Short TypeIt

PlsMinus:	Mov	AL,0F1h			;<Alt-p>
TypeIt:		Call	TextKey
		Ret

; - - - - - - - - - - - - - - -
;Main loop of the working editor.  The file is split at the cursor.
TextEntry:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Mov	ES,EditBufSeg
		Call	PaintEditScreen		;Does bottom, NOT top 2 rows
		Call	ClsTop2
		Call	ShowInsOvrtype
		Call	PaintUnlessBlock
NextKey:	Cmp	BlockFlag,1
		JNZ	NotBlock
		Call	PaintTextScreen		;paint IF block
NotBlock:	Call	PaintTopLine		;only call
		Xor	AH,AH			;no flush kbd buffr or use mouse
		Call	WaitKey			; (only call NOT to use mouse)
		Cmp	AL,7Fh			;check for <Ctrl-Bksp>
		JE	ControlKey		;if so, treat as ctrl code
		Cmp	AL,1Fh			;check for ctrl or extended code
		JBE	ControlKey		;if it is
DoTextKey:	Call	TextKey
		Jmp	Short NextKey

ControlKey:	Or	AL,AL			;AL=0 means Extended Key (in AH)
		JZ	ExtendedKey		;if extended key
		Cmp	AL,Esc_			;if <Esc>,
		JE	EditorESC		; go to Editor Menu
		Mov	AH,AL			;else put control key code in AH
		Or	AH,0E0h			;and add E0h (224) for lookup
ExtendedKey:	Push 	ES
		Push	DS			;set ES to DS
		Pop	ES
		LEA	DI,KeyList		;list of extended/ctrl codes
		Mov	CX,KeyListLen		;length of KeyList
		Xchg	AL,AH			;key to look for in AL
		RepNE	ScasB			;Look up the key code
		Pop	ES
		JE	ExtKeyFound		;if found, Call proper routine
		Xchg	AL,AH			;if not found, restore AL
		Or	AL,AL			;check extended or control
		JZ	NextKey			;ignore if extended key
		Jmp	Short DoTextKey		;consider as text if control key

ExtKeyFound:	Sub	DI,Offset KeyList+1	;adjust DI after ScaS
		ShL	DI,1			;make it a word offset
		Call	[SubList+DI]		;call subroutine for this key
		Jmp	Short NextKey

EditorESC:	Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

; - - - - - - - - - - - - - - -
TextKey:	Push	AX			;add char in AL to the document
		Push	CX
		Push	DI
		Push	ES
		Cmp	BlockFlag,1
		JNZ	pms319
		Call	BlockToggle		;turn off block if text key hit
pms319:		Mov	CX,UpToCursorPtr
		Cmp	CX,CursorUpPointer
		JNZ	pms320
		Mov	DX,Offset TextBufFullStr
		Call	ShowErrMsg
		Jmp	Short pms321
pms320:		Or	AL,AL
		JZ	pms321			;can't have a 0 in the doc
		Push	AX
		Mov	ES,EditBufSeg
		Cmp	InsertFlag,0
		JNZ	InsAndOver
		Mov	DI,CursorUpPointer
		Cmp	Byte Ptr ES:[DI],EOF
		JZ	InsAndOver
		Cmp	Byte Ptr ES:[DI],CR
		JZ	InsAndOver
	;for Overtype, not at end of line or EOF:
		Inc	CursorUpPointer
		Dec	FileLength
InsAndOver:	Dec	CursorUpPointer
		Inc	FileLength
		Pop	AX			;AL has the text byte
		Mov	DI,CursorUpPointer
		Mov	ES:[DI],AL
		Call	RightArrow
		Call	pms338
pms321:		Mov	FileChangedFlag,1
		Pop	ES
		Pop	DI
		Pop	CX
		Pop	AX
		Ret

NewLine:	Push	AX
		Push	CX
		Push	DX
		Push	DI
		Push	SI
		Push	ES
		Cmp	BlockFlag,1
		JNZ	pms322
		Call	BlockToggle		;turn off block
pms322:		Mov	CX,UpToCursorPtr
		Cmp	CX,CursorUpPointer
		JNZ	pms323
		Mov	DX,Offset TextBufFullStr
		Call	ShowErrMsg
		Jmp	Short NewLineDone

pms323:		Mov	CX,UpToCursorPtr
		Inc	CX
		Cmp	CX,CursorUpPointer
		JNZ	pms324
		Mov	DX,Offset TextBufFullStr
		Call	ShowErrMsg
		Jmp	Short NewLineDone

pms324:		Mov	ES,EditBufSeg
		Add	FileLength,2
		Dec	CursorUpPointer
		Mov	DI,CursorUpPointer
		Mov	Byte Ptr ES:[DI],LF
		Dec	CursorUpPointer
		Dec	DI
		Mov	Byte Ptr ES:[DI],CR
		Call	RightArrow
		Cmp	AutoIndentFlag,0
		JZ	NewLineDone
		Mov	SI,UpToCursorPtr
		Dec	SI
		Dec	SI
pms325:		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms326
		Or	SI,SI
		JZ	pms327
		Dec	SI
		Jmp	Short pms325

pms326:		Inc	SI
pms327:		Cmp	Byte Ptr ES:[SI],Tab
		JZ	pms328
		Cmp	Byte Ptr ES:[SI],' '
		JZ	pms328
		Jmp	Short NewLineDone

pms328:		Mov	AL,ES:[SI]
		Call	TextKey
		Inc	SI
		Jmp	Short pms327

NewLineDone:	Mov	FileChangedFlag,1
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	AX
		Ret

BackSpace:	Push	CX
		Push	SI
		Push	DX
		Push	ES
		Push	AX
		Mov	ES,EditBufSeg
		Cmp	BlockFlag,1
		JNZ	pms329
		Call	BlockToggle		;turn off block
pms329:		Cmp	UpToCursorPtr,0
		JZ	pms331
		Call	LeftArrow
		Mov	SI,CursorUpPointer
		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms330
		Inc	CursorUpPointer
		Dec	FileLength
		Inc	CursorUpPointer
		Dec	FileLength
		Call	PaintUnlessBlock
		Jmp	Short pms331

pms330:		Inc	CursorUpPointer
		Call	pms338
		Dec	FileLength
pms331:		Mov	FileChangedFlag,1
		Pop	AX
		Pop	ES
		Pop	DX
		Pop	SI
		Pop	CX
		Ret

DeleteChar:	Push	ES
		Push	CX
		Push	DX
		Push	DI
		Push	AX
		Cmp	BlockFlag,1
		JNZ	pms332
		Call	BlockToggle		;turn off block
pms332:		Mov	ES,EditBufSeg
		Mov	DI,CursorUpPointer
		Cmp	Byte Ptr ES:[DI],EOF
		JZ	pms334
		Cmp	Byte Ptr ES:[DI],CR
		JNZ	pms333
		Inc	CursorUpPointer
		Dec	FileLength
		Inc	CursorUpPointer
		Dec	FileLength
		Call	PaintUnlessBlock
		Jmp	Short pms334

pms333:		Inc	CursorUpPointer
		Call	pms338
		Dec	FileLength
pms334:		Mov	FileChangedFlag,1
		Pop	AX
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	ES
		Ret
; - - - - - - - - - - - - - -
ToggleInsert:	Xor	InsertFlag,1
ShowInsOvrtype:	Push	BX
		Push	CX
		Push	DX
		Mov	BL,InvMenuAttrib
		Mov	DX,Offset InsertStr
		Cmp	InsertFlag,0
		JNZ	pms337
		Mov	DX,Offset OvrtypeStr
pms337:		Mov	CX,046h			;Row 0, Col 70
		Call	DisplayZ
		Call	ShowCursor
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - -
;copy last part of CurrentPath to [DI]
FileOrDirToDI:	Push	AX
		Push	CX
		Push	DI
		Push	ES
		Mov	CX,CS
		Mov	ES,CX
		Mov	DS,CX
		Mov	DI,Offset CurrentPath
	;find the last '\'
		Mov	CX,51h
		Xor	AL,AL
		RepNZ	ScasB			;find the end
		Dec	DI			;point to the 0
		Mov	CX,0Fh
		Mov	AL,'\'
		STD				;go backwards
		RepNZ	ScasB			;look 15 bytes back for a '\'
		CLD				;go forwards
		Mov	AX,0Fh
		Sub	AX,CX
		Xchg	AX,CX
		Dec	CX
		Dec	CX			;do not copy the 0
		Inc	DI
		Inc	DI
		Mov	SI,DI
		Pop	ES
		Pop	DI
		Rep	MovsB			;copy the file name [DI]
		Pop	CX
		Pop	AX
		Ret
; - - - - - - - - - - - - - -
PaintTopLine:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	SI
		Push	ES
		Xor	AH,AH
		Mov	AL,CursorCol
		Add	AX,ColumnOffset
		Mov	ColumnShown,AX
		Push	CS
		Pop	ES
	;clear the buffer
		Mov	DI,Offset StatsAndCopyPath
		Mov	AL,' '
		Mov	CX,50h
		RepZ	StosB
	;paint blank 2nd line
		Mov	CX,100h			;Row 1, Col 0
		Mov	BL,MenuAttrib
		Mov	DX,Offset StatsAndCopyPath
		Call	DisplayZ
	;copy the file name
		Mov	DI,Offset StatsAndCopyPath
		Call	FileOrDirToDI
		Mov	DI,Offset StatsAndCopyPath
		Add	DI,0Fh
		Mov	SI,Offset LineStr
		Mov	CX,5
		Rep	MovsB
		Mov	AX,DocLineNo
		Inc	AX
		Call	ShowAXatDI
		Add	DI,5
		Mov	SI,Offset ColumnStr
		Mov	CX,9
		Rep	MovsB
		Mov	AX,ColumnShown		;ColumnOffset + CursorCol
		Inc	AX
		Call	ShowAXatDI
		Add	DI,5
		Mov	SI,Offset PositionStr
		Mov	CX,0Bh
		Rep	MovsB
		Mov	AX,UpToCursorPtr
		Call	ShowAXatDI
		Add	DI,5
		Mov	SI,Offset OfStr
		Mov	CX,5
		Rep	MovsB
		Mov	AX,FileLength
		Call	ShowAXatDI
		Add	DI,5
		Mov	Byte Ptr [DI],0
		Xor	CX,CX			;row 0, col 0
		Mov	BL,MenuAttrib
		Mov	DX,Offset StatsAndCopyPath
		Call	DisplayZ
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - -
ShowAXatDI:	Push	AX
		Push	CX
		Push	DI
	;clear the destination area
		Mov	CX,5
pms335:		Mov	Byte Ptr [DI],' '
		Inc	DI
		Loop	pms335
	;convert to ASCII & display, lo digit first
		Mov	CX,0Ah
pms336:		Xor	DX,DX
		Div	CX
		Add	DX,30h			;make ASCII
		Dec	DI
		Mov	[DI],DL
		Or	AX,AX
		JNZ	pms336
		Pop	DI
		Pop	CX
		Pop	AX
		Ret

ReSearch:	Xor	AX,AX			;not repeat search
		Call	DoFind
		Ret

ReReplace:	Xor	AX,AX			;not repeat replace
		Call	DoReplace
Ignore:		Ret

F5:		Call	BlockCopy
		Mov	BlockFlag,0
		Call	PaintUnlessBlock
		Ret

F7:		Mov	AX,1
		Call	DoReplace
		Ret

F8:		Mov	AX,1
		Call	DoFind
		Ret

F10:		Mov	AL,Esc_	
		Call	TextKey
		Ret

	;Delete to End-of-line <Ctrl-E>
DeleteEOL:	Cmp	BlockFlag,0		; If block is on, forget it
		JNE	NoDel
		Call	BlockToggle		; Turn on block
		Call	EndKey			; Mark to end of line
		Call	LeftArrow		; but not the <CR>
		Call	BlockDel		; and delete the block
NoDel:		Ret

	;Delete the current line <Ctrl-Bksp>
DeleteLine:	Cmp	BlockFlag,0		; If block is on, forget it
		JNE	NoDel
		Call	Home
		Call	BlockToggle		; Turn on block
		Call	EndKey			; Mark to end of line
		Call	BlockDel		; and delete the block
		Ret

; - - - - - - - - - - - - - - - - - - -
PaintUnlessBlock: Cmp	BlockFlag,0
		JNZ	IfRET
		Call	PaintTextScreen
IfRET:		Ret
; - - - - - - - - - - - - - - - - - - -
;called by Bksp, Del, text char entry
pms338:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	DI
		Push	SI
		Push	ES
		Push	DS
		Mov	CH,TopLineNo
		Add	CH,CursorLine
		Xor	CL,CL
		Mov	DH,CursorLine
		Inc	DH
		Mov	DL,80
		Mov	AX,160			;bytes in 1 line
		Mul	CH			;CH * AL -> AX
		Xchg	AX,DI
		Mov	ES,EditBufSeg
		Mov	SI,UpToCursorPtr
		Or	SI,SI
		JZ	pms341
		Dec	SI
		Mov	AL,LF
pms339:		Cmp	ES:[SI],AL
		JZ	pms340
		Or	SI,SI
		JZ	pms341
		Dec	SI
		Jmp	Short pms339

pms340:		Inc	SI
pms341:		Mov	DX,ColumnOffset
		Add	DX,80
		Xor	BX,BX
		Cmp	ColumnOffset,0
		JNZ	pms342
		Jmp	Short pms348

pms342:		Cmp	SI,UpToCursorPtr
		JNZ	pms343
		Mov	SI,CursorUpPointer
pms343:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms344
		Mov	BX,ColumnOffset
		Jmp	pms355

pms344:		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms345
		Mov	BX,ColumnOffset
		Jmp	pms355

pms345:		Cmp	Byte Ptr ES:[SI],Tab
		JNZ	pms347
		Push	AX
		Push	CX
		Push	DX
		Mov	AX,BX
		CWD
		Mov	CX,TabsSetting
		IDIV	CX
		Sub	CX,DX
		Add	BX,CX
		Pop	DX
		Pop	CX
		Pop	AX
		Cmp	BX,ColumnOffset
		JNB	TabSpaces
		Dec	BX
		Jmp	Short pms347

TabSpaces:	Sub	BX,ColumnOffset
		Mov	AX,BX
TabSpaceLoop:	Or	AX,AX
		JZ	pms346
		Push	ES
		Mov	ES,VideoSeg
		Mov	Byte Ptr ES:[DI],' '
		Pop	ES
		Inc	DI
		Inc	DI
		Dec	AX
		Jmp	Short TabSpaceLoop

pms346:		Add	BX,ColumnOffset
		Inc	SI
		Jmp	Short pms348

pms347:		Inc	SI
		Inc	BX
		Cmp	BX,ColumnOffset
		JNZ	pms342
pms348:		Cmp	SI,UpToCursorPtr
		JNZ	pms349
		Mov	SI,CursorUpPointer
pms349:		Cmp	Byte Ptr ES:[SI],EOF
		JNZ	pms350
		Cmp	BX,DX
		JNB	pms355
		Push	ES
		Mov	ES,VideoSeg
		Mov	Byte Ptr ES:[DI],4	;the diamond EOF marker
		Pop	ES
		Inc	BX
		Inc	DI
		Inc	DI
		Jmp	Short pms355

pms350:		Cmp	Byte Ptr ES:[SI],CR
		JZ	pms355
		Cmp	Byte Ptr ES:[SI],Tab
		JZ	ExpandTab
		Cmp	BX,DX
		JNB	pms355
		Mov	AL,ES:[SI]
		Push	ES
		Mov	ES,VideoSeg
		Mov	ES:[DI],AL
		Pop	ES
		Inc	BX
		Inc	DI
		Inc	DI
pms351:		Inc	SI
		Jmp	Short pms348

ExpandTab:	Push	AX
		Push	CX
		Push	DX
		Mov	AX,BX
		CWD
		Mov	CX,TabsSetting		;always 8
		IDIV	CX
		Sub	CX,DX
		Pop	DX
		Mov	AX,CX
pms352:		Or	AX,AX
		JZ	pms353
		Cmp	BX,DX
		JZ	pms353
		Push	ES
		Mov	ES,VideoSeg
		Mov	Byte Ptr ES:[DI],' '
		Pop	ES
		Inc	DI
		Inc	DI
		Inc	BX
		Dec	AX
		Jmp	Short pms352

pms353:		Pop	CX
		Pop	AX
		Jmp	Short pms351

pms354:		Inc	SI
		Cmp	Byte Ptr ES:[SI],EOF
		JZ	pms357
		Cmp	Byte Ptr ES:[SI],CR
		JNZ	pms354
pms355:		Mov	AX,DX
		Sub	AX,BX
pms356:		Or	AX,AX
		JZ	pms357
		Push	ES
		Mov	ES,VideoSeg
		Mov	Byte Ptr ES:[DI],' '
		Pop	ES
		Inc	DI
		Inc	DI
		Dec	AX
		Jmp	Short pms356

pms357:		Call	ShowCursor
		Pop	DS
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

;these are called whenever the cursor moves
ShowCursor:	Push	CX
		Mov	CL,BlockAttrib
		Cmp	InsertFlag,1
		JZ	ChgCursor
		Mov	CL,InverseAttrib	;attrib for overtype
		Jmp	Short ChgCursor

Un_Cursor:	Push	CX
		Mov	CL,TextAttrib
ChgCursor:	Push	AX
		Push	DI
		Push	DX
		Push	ES
		Cmp	BlockFlag,1
		JZ	ChgCrsrDone
pms358:		Mov	ES,VideoSeg
		Mov	AL,TopLineNo
		Xor	AH,AH
		Add	AL,CursorLine
		Mov	DX,160			;bytes in 1 line
		Mul	DX
		Mov	DL,CursorCol
		Mov	DH,0
		Add	AX,DX
		Add	AX,DX
		Inc	AX			;point to cursor char attr byte
		Xchg	AX,DI
		Mov	ES:[DI],CL		;has Normal or BlockAttrib
ChgCrsrDone:	Pop	ES
		Pop	DX
		Pop	DI
		Pop	AX
		Pop	CX
		Ret
; - - - - - - - - - - - - - - - - -
	;if file is hidden or read-only, ask if OK to update
FileUpdate:	Mov	AX,4300h		;get file attrib
		Mov	DX,Offset CurrentPath
		Int	21h
		JC	ChkSpace		;new file doesn't exist yet
		Test	CL,3			;hidden or R-O ?
		JZ	ChkSpace
	;the file is hidden or R-O, and this is the 1st save attempt
		Mov	HidROattrib,CL
		Call	MakeBeepIf
		Push	BX
		Push	CX
		Push	BP
		Push	DX
		Mov	BX,1
		Mov	BP,Offset EdHiddenMenu
ShowEdHidMenu:	Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Update anyhow
		JNZ	TryNo
	;change the file's attribute to normal until exit
		Mov	CX,20h			;normal file
		Mov	AX,4301h		;set file attrib
		Mov	DX,Offset CurrentPath
		Int	21h
		Pop	DX
		Pop	BP
		Pop	CX
		Pop	BX
		Jmp	Short ChkSpace

TryNo:		Cmp	CX,2
		JNZ	ChkEsc
		Xor	AL,AL
		Jmp	Short EdRtn
ChkEsc:		Cmp	AL,Esc_
		JNZ	ShowEdHidMenu
EdRtn:		Pop	DX
		Pop	BP
		Pop	CX
		Pop	BX
		Ret

ChkSpace:	Push	AX
		Push	BP
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	SI
		Push	DS
		Push	ES
	;check if enough space
		Mov	AX,OrigFileLen		;Calc orig clusters
		Dec	AX
		Add	AX,Cluster
		JC	AccessOK		;if more than 64K
		Xor	DX,DX
		Div	Cluster
		Add	AX,FreeSpace		;Free + orig file clusters
		Xchg	AX,BX
		Xor	DX,DX			;calc req'd clusters
		Mov	AX,FileLength
		Dec	AX
		Add	AX,Cluster
		JNC	ChkSpace2
		Inc 	DX
ChkSpace2:	Div	Cluster
		Cmp	BX,AX
		JAE	AccessOK		;if it will fit
		Mov	DX,Offset NoSpaceDestStr ;else err msg
		Call	ShowErrMsg
		Jmp	FileUpdRtn

AccessOK:	Call	ShowWait
	;create a new file with same name (overwrites old)
		Cmp	FileLength,0
		JNZ	UpdNotDone
		Jmp	UpdateDone

UpdNotDone:	Call	CurToWritePath
		Call	CreateWritePath
		JC	UpdateDone
		Mov	CX,UpToCursorPtr	;bytes to write
		JCXZ	UpdBfrEnd		;if cursor at BOF
		Xor	DX,DX			;points to data buffer to write
		Call	EditBufWrite
		JC	UpdateDone		;if error writing
UpdBfrEnd:	Mov	CX,EOFpointer
		Sub	CX,CursorUpPointer	;bytes to write
		JCXZ	pms359
		Mov	DX,CursorUpPointer	;points data to write
		Call	EditBufWrite
		JC	UpdateDone		;if error writing
pms359:		Mov	AH,3Eh			;close file
		Mov	BX,WriteHandle
		Int	21h
		Mov	DX,Offset CurrentPath
		Call	AddToFilesList	;calls EntryToList, updates len & attrs
UpdateDone:	Mov	FileChangedFlag,0
FileUpdRtn:	Call	ShowInsOvrtype
		Pop	ES
		Pop	DS
		Pop	SI
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	BP
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
EditBufWrite:	Cmp	PutPrinterFlag,1
		JNZ	ToDisk
		Or	CX,CX
		JZ	PrtEx			;ret w/carry if 0 bytes in CX
		Mov	DI,DX
PrtChar:	Cmp	EscFlag,1
		JNE	PCCtnu
		Call	ResetPrinter
		Jmp	Short PrtEx

PCCtnu:		Mov	DL,ES:[DI]
		Mov	AH,5			;print char in DL
		Int	21h
		Inc	DI
		Loop	PrtChar
	;send a final CR to printer, in case block does not end with CR
		Mov	DL,CR
		Mov	AH,5
		Int	21h
		Or	AL,AL			;clear Carry
		Ret

ToDisk:		Mov	BX,WriteHandle
		Mov	DS,EditBufSeg
		Mov	AH,40h			;write to file
		Int	21h
		Push	CS
		Pop	DS
		JNC	EBWdone			;if no error
		Mov	DX,Offset ErrWritingMsg
		Call	ShowErrMsg
		Mov	AH,3Eh			;close file
		Mov	BX,WriteHandle
		Int	21h
PrtEx:		STC				;Set carry & close file if error
EBWdone:	Ret				;AX=bytes written if no error
; - - - - - - - - - - - - - - -
;CX=2 for Printer, 1 for File
BlockPut:	Push	AX
		Push	BP
		Push	BX
		Push	CX
		Push	DI
		Push	DX
		Push	DS
		Push	ES
		Push	SI
		Cmp	BlockFlag,0
		JNZ	pms360
		Mov	DX,Offset NoBlockStr
		Call	ShowErrMsg
		Jmp	PutErrExit

pms360:		Cmp	CX,2
		JZ	PutToPrinter
	;put to file
		Mov	PutPrinterFlag,0
		Push	CS
		Pop	ES
		Call	CurToWritePath
	;find the last '\' in WritePath
		Mov	CX,50h
		Mov	AL,'\'
		STD
		RepNZ	ScasB
		CLD
		Inc	DI
		Inc	DI
		Call	ClsTop2
		Xor	CX,CX
		Mov	BL,TextAttrib
		Mov	DX,Offset TypeFname
		Call	DisplayZ
		Inc	CH			;to row 1
		Mov	Byte Ptr [DI],0
		Sub	DI,Offset WritePath
		Mov	CursorLocn,DI
		Mov	DX,Offset WritePath
		Mov	BH,79
		Mov	SI,Offset PathChars
		Call	InputBHchars		;rtns AL=1 if <Esc> or no entry
		Cmp	AL,1
		JNZ	pms361
ToPutDone:	Jmp	PutDone

pms361:		Call	CreateWritePath
		JC	ToPutDone
		Jmp	Short pms362

PutToPrinter:	Call	SetupPrinter		;print PrinterStr setup string
		Mov	PutPrinterFlag,1
	;for both printer and file
pms362:		Call	ShowWait
		Mov	ES,EditBufSeg
		Mov	CX,UpToCursorPtr
		Cmp	CX,BlockStart
		JNB	ForwardBlock
BackwardBlock:	Mov	CX,BlockStart
		Sub	CX,UpToCursorPtr
		Mov	DI,CX
		Add	DI,CursorUpPointer
		Cmp	Byte Ptr ES:[DI],EOF
		JZ	pms363
		Inc	CX
		Cmp	Byte Ptr ES:[DI],CR
		JNZ	pms363
		Inc	CX			;bytes to write
pms363:		Mov	DX,CursorUpPointer	;points buffer to write
;***(when block stuff fixed, must INC DX not to print cursor char)
		Call	EditBufWrite		;Prints if PutPrinterFlag
		Jmp	Short PrinterDone

ForwardBlock:	Sub	CX,BlockStart		;CX has UpToCursorPtr bytes
		Mov	DX,BlockStart		;points to data to write
		Call	EditBufWrite
		JC	PrinterDone
;Put the byte the cursor is on (eliminate when change block handling)
		Mov	DI,CursorUpPointer
		Cmp	Byte Ptr ES:[DI],EOF
		JZ	PrinterDone
		Mov	CX,1
		Cmp	Byte Ptr ES:[DI],CR	;Put the CR and the LF
		JNZ	pms364
		Inc	CX			;bytes to write
pms364:		Mov	DX,CursorUpPointer	;points buffer to write
		Call	EditBufWrite
PrinterDone:	Cmp	PutPrinterFlag,1
		JZ	PutDone
	;for Put to File only
		Mov	AH,3Eh			;close file
		Mov	BX,WriteHandle
		Int	21h
		Mov	DX,Offset WritePath
		Call	AddToFilesList
PutDone:	Call	BlockToggle		;turn off the block
PutErrExit:	Mov	PutPrinterFlag,0
		Call	ShowInsOvrtype
		Pop	SI
		Pop	ES
		Pop	DS
		Pop	DX
		Pop	DI
		Pop	CX
		Pop	BX
		Pop	BP
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - -
GetNameAndOpenFile: 				;used only by the Editor
		Push	BP
		Push	BX
		Push	CX
		Push	DI
		Push	DX
		Push	ES
		Push	SI
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Call	CopyAsFullPath
		Cmp	AX,1			;Path too long ?
		JNZ	PathLenOK
		Jmp	pms367

PathLenOK:	Push	CS
		Pop	ES
	;get CurrentPath ready for the file name
		Mov	DI,Offset CurrentPath
		Xor	AL,AL
		Mov	CX,50h
		RepNZ	ScasB
		Mov	Byte Ptr [DI-1],'\'
		Call	ClsTop2
		Xor	CX,CX			;row & col 0
		Mov	BL,TextAttrib
		Mov	DX,Offset TypeFname
		Call	DisplayZ
		Call	EnterFName		;DI=dest for filename to enter
		JNC	pms365
		Mov	AX,1
		Jmp	pms367

pms365:		Mov	AH,4Eh			;find first file
		Mov	DX,Offset CurrentPath
		Mov	CX,20h
		Int	21h
		JC	pms366
		Mov	DX,Offset AlreadyExMsg
		Call	ShowErrMsg
		Mov	AX,1
		Jmp	Short pms367

pms366:		Mov	ES,EditBufSeg
		Mov	DI,EditBytesToRead
		Mov	Byte Ptr ES:[DI],EOF
		Mov	UpperLeft,0
		Mov	UpToCursorPtr,0
		Mov	BX,EditBytesToRead
		Mov	CursorUpPointer,BX
		Mov	EOFpointer,BX
		Mov	DocLineNo,0
		Mov	ColumnShown,0
		Mov	CursorCol,0
		Mov	CursorLine,0
		Mov	FileLength,0
pms367:		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DI
		Pop	CX
		Pop	BX
		Pop	BP
		Ret
; - - - - - - - - - - - - -
;used only in the Editor for InsertPath & File Get
GetAndPath:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	SI
		Push	ES
		Push	DS
		Mov	AX,CS
		Mov	DS,AX
		Mov	ES,AX
		Mov	AX,HilitedEntry
		Mov	OldHilited,AX
		Call	CurToWritePath		;save CurrentPath
		Mov	Sub1Drv2Root3,0FFh	;no pips in MarkTheFiles
		Mov	NumberMarked,1		;so ENTER works
		Call	PaintBlankScreen
		Call	PaintStatusOrDateScrn
		Mov	BX,Offset HiliteGetStr
		Call	MarkTheFiles
		Mov	Sub1Drv2Root3,0
		Mov	NumberMarked,0
		Cmp	AH,1			;<Esc> hit ?
		JZ	GetMarkOK
		Jmp	GetESC

GetMarkOK:	Mov	BP,HilitedEntry
		Call	CopyAsFullPath
		Call	ShowWait
		Mov	ES,EditBufSeg
		Cmp	PathFlag,1
		JNZ	FileGet
		Mov	SI,Offset CurrentPath
		Mov	DI,UpToCursorPtr
		Call	CopyUpTo0
		Jmp	ToEndOfGap

FileGet:	Mov	AH,4Eh			;find first file
		Xor	CX,CX			;attribute
		Mov	DX,Offset CurrentPath
		Int	21h
		JNC	pms368
		Mov	DX,Offset NotExMsg
		Call	ShowErrMsg
		Jmp	GetESC

pms368:		Mov	AH,3Dh			;open file
		Xor	AL,AL
		Mov	DX,Offset CurrentPath
		Int	21h
		JNC	pms369
		Mov	DX,Offset OpenErrMsg
		Call	ShowErrMsg
		Jmp	GetESC

pms369:		Mov	ReadHandle,AX
		Mov	AH,42h			;move file pointer
		Xor	CX,CX
		Xor	DX,DX			;start of file
		Mov	BX,ReadHandle
		Mov	AL,2			;move to EOF + CX:DX
		Int	21h
		JNC	pms370
		Mov	DX,Offset ErrReadingMsg
		Call	ShowErrMsg
		Jmp	pms373

pms370:		Cmp	DX,0
		JA	TooBig
		Mov	CX,CursorUpPointer
		Sub	CX,UpToCursorPtr	;CX is space between file halves
		Cmp	CX,AX
		JA	pms371
TooBig:		Mov	DX,Offset TooLgToReadMsg
		Call	ShowErrMsg
		Jmp	pms373

pms371:		Mov	GetLength,AX
		Mov	AH,42h			;move file pointer
		Xor	AL,AL			;to CX:DX
		Mov	BX,ReadHandle
		Xor	CX,CX
		Xor	DX,DX			;start of file
		Int	21h
		JNC	InsertIt
		Mov	DX,Offset ErrReadingMsg
		Call	ShowErrMsg
		Jmp	Short pms373

;read in the file at the start of the gap, check for EOF, move it up to the end
; of the gap, then move the cursor to start of file read in.
InsertIt:	Mov	AH,3Fh			;read from file
		Mov	BX,ReadHandle
		Mov	CX,GetLength		;bytes to read
		Mov	DX,UpToCursorPtr	;put after 1st half of file
		Push	DS			;  just before crsr
		Push	ES
		Pop	DS
		Int	21h
		Pop	DS
		JNC	pms372
		Mov	DX,Offset ErrReadingMsg
		Call	ShowErrMsg
		Jmp	Short pms373

pms372:		Mov	DI,UpToCursorPtr	;start of stuff just read in
		Mov	CX,GetLength		;bytes just read in
		Mov	AL,EOF
FixEOFloop:	Cmp	AL,ES:[DI]
		JNZ	OKbyte
		Mov	Byte Ptr ES:[DI],4	;the  marker
OKbyte:		Inc	DI
		Loop	FixEOFloop
ToEndOfGap:	Dec	DI			;back to last byte read in
		Mov	SI,DI
		Mov	CX,DI
		Sub	CX,UpToCursorPtr
		Inc	CX
		Add	FileLength,CX
		Mov	DI,CursorUpPointer
		Dec	DI
		Push	DS
		Push	ES
		Pop	DS
		STD				;go BACKwards
		Rep	MovsB
		CLD
		Pop	DS
		Inc	DI
		Mov	CursorUpPointer,DI
		Mov	FileChangedFlag,1
		Cmp	PathFlag,1
		JZ	PathSkip
pms373:		Mov	AH,3Eh			;close file
		Mov	BX,ReadHandle
		Int	21h
PathSkip:	Mov	GoEntryFlag,1		;changed HilitedEntry, etc
GetESC:		Call	ShowInsOvrtype
		Call	WriteToCurPath	;restore CurrentPath, in case new file
		Mov	AX,OldHilited
		Mov	HilitedEntry,AX
		Pop	DS
		Pop	ES
		Pop	SI
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
;called when editor creates, puts, or updates.  Puts new file in CURRENT dir,
; cannot use for move, copy, etc.
AddToFilesList:	Push	AX
		Push	BP
		Push	BX
		Push	CX
		Push	DI
		Push	DS
		Push	DX
		Push	SI
		Push	ES
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Call	AX11DirWithFiles
		Or	AH,AH
		JNZ	ThisIsDir
		Mov	BP,HilitedEntry
		Mov	AH,ES:[BP+22]
PrevEntryLoop:	Sub	BP,EntryLen23		;to start of previous entry
		Cmp	AH,ES:[BP+22]
		JBE	PrevEntryLoop
		Jmp	Short ThisIsFile
ThisIsDir:	Or	AL,AL
		JZ	pms374			;if Dir has NO files & not Root
ThisIsFile:	Call	ChkFileAndSort
pms374:		Pop	ES
		Pop	SI
		Pop	DX
		Pop	DS
		Pop	DI
		Pop	CX
		Pop	BX
		Pop	BP
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
DoFind:		Push	AX
		Push	BX
		Push	CX
		Push	DI
		Push	DX
		Push	ES
		Push	SI
		Mov	LinesSearched,-1
		Cmp	AX,1
		JZ	pms375
		Call	ClsTop2
		Xor	CX,CX
		Mov	DX,Offset TypeToSearchStr
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,SBcursor
		Mov	CursorLocn,DX
		Mov	DX,Offset SearchBuf
		Mov	AllCharsFlag,1
		Inc	CH			;row 1, 2nd row
		Xor	CL,CL			;column 0
		Mov	BH,25			;chars to input
		Call	InputBHchars		;rtns AL=1 if <Esc> or no entry
		Mov	CX,CursorLocn
		Mov	SBcursor,CX
		Cmp	AL,1
		JNZ	pms375
		Jmp	ExitFind

pms375:		Push	DS			; Get len of search string ...
		Pop	ES
		Mov	DI,Offset SearchBuf
		Mov	CX,26
		Mov	AL,0
		RepNZ	ScasB
		Sub	CX,25
		Neg	CX
		Mov	FindCharCount,CX
		Mov	FoundPointer,0
		Call	FindText
		JC	ExitFind
		Mov	DI,CursorUpPointer
		Mov	SI,UpToCursorPtr
		Or	SI,SI
		JZ	pms383
		Xor	CX,CX
pms381:		Dec	SI
		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Inc	CX
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms382
		Or	SI,SI
		JZ	pms383
		Jmp	Short pms381

pms382:		Inc	SI
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Dec	CX
pms383:		Mov	UpperLeft,SI
		Mov	ColumnOffset,0
		Mov	CursorLine,0
		Mov	CursorCol,0
pms384:		JCXZ	pms385
		Call	RightArrow
		Dec	CX
		Jmp	Short pms384

pms385:		Mov	CX,LinesSearched
		Add	DocLineNo,CX
		Call	PaintUnlessBlock

ExitFind:	Call	ShowInsOvrtype
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DI
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
FindText:	Mov	ES,EditBufSeg		; FindText uses: AX,CX,SI,DI,ES
		Mov	DI,CursorUpPointer
		Mov	CX,EOFpointer
		Sub	CX,DI
		Mov	AL,SearchBuf

FindString:	RepNZ	ScaSB			; Search for 1st char ...
		JZ	Found1stChar
		Mov	DX,Offset NotFoundStr	; If not found
		Call	ShowErrMsg
		STC				; Set carry to indicate error
		Ret

Found1stChar:	Push	DI			; Found 1st char
		Push	CX
		Dec	DI			; Check there for string ...
		Mov	SI,Offset SearchBuf
		Mov	CX,FindCharCount
		RepE	CmpsB
		Pop	CX
		Pop	DI
		JNE	FindString
		Dec	DI			; Search String Found ...
		Add	DI,FindCharCount
		Add	FoundPointer,DI
		Mov	CX,DI			; Calc lines searched ...
		Mov	DI,CursorUpPointer
		Sub	CX,DI
		Mov	AL,LF
CalcLines:	Inc	LinesSearched
		RepNZ	ScasB
		JZ	CalcLines
		Mov	DI,UpToCursorPtr	; Adj text bfr and cursor ...
		Mov	SI,CursorUpPointer
		Mov	CX,FoundPointer
		Mov	AX,CX
		Sub	CX,CursorUpPointer
		Add	UpToCursorPtr,CX
		Mov	CursorUpPointer,AX
		Push	DS
		Push	ES			; Set DS to EditBufSeg
		Pop	DS
		RepZ	MovsB
		Pop	DS
		CLC
		Ret
; - - - - - - - - - - - - - - -
DoReplace:	Push	AX			;2 calls
		Push	BX
		Push	CX
		Push	DI
		Push	DX
		Push	ES
		Push	SI
		Mov	LinesSearched,0
		Cmp	AX,1
		JNZ	pms386
		Jmp	pms393

pms386:		Call	ClsTop2
		Xor	CX,CX
		Mov	DX,Offset TypeTextStr
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	CH,1
		Mov	CL,1Bh
		Mov	DX,Offset WithStr
		Call	DisplayZ
		Mov	DX,SBcursor
		Mov	CursorLocn,DX
		Mov	DX,Offset SearchBuf
		Mov	AllCharsFlag,1
		Mov	CH,1
		Xor	CL,CL
		Mov	BH,19h
		Call	InputBHchars
		Mov	CX,CursorLocn
		Mov	SBcursor,CX
		Cmp	AL,1
		JNZ	pms387
pms410$:	Jmp	pms410

pms387:		Mov	DI,Offset SearchBuf
		Xor	CX,CX
pms388:		Cmp	Byte Ptr [DI],0
		JZ	pms389
		Inc	DI
		Inc	CX
		Jmp	Short pms388

pms389:		Mov	FindCharCount,CX
		Mov	DX,RBcursor
		Mov	CursorLocn,DX
		Mov	DX,Offset ReplBuf
		Mov	AllCharsFlag,1
		Mov	CH,1
		Mov	CL,23h
		Mov	BH,19h
		Call	InputBHchars
		Mov	CX,CursorLocn
		Mov	RBcursor,CX
		Cmp	AL,1
		JZ	pms410$
pms390:		Mov	DI,Offset ReplBuf
		Xor	CX,CX
pms391:		Cmp	Byte Ptr [DI],0
		JZ	pms392
		Inc	DI
		Inc	CX
		Jmp	Short pms391

pms392:		Mov	var002,CX
pms393:		Mov	DI,Offset ReplBuf
		Cmp	Byte Ptr [DI],0
		JNZ	pms395
pms394:		Mov	DX,Offset ReplNSpecStr
		Call	ShowErrMsg
		Jmp	pms410

pms395:		Mov	FoundPointer,-1
		Call	FindText
		JC	pms410$
		Mov	CX,UpToCursorPtr
		Sub	CX,FindCharCount
		Add	CX,var002
		Cmp	CX,CursorUpPointer
		JB	pms402
		Mov	DX,Offset NoMemReplStr
		Call	ShowErrMsg
		Jmp	Short pms404

pms402:		Mov	UpToCursorPtr,CX
		Inc	CursorUpPointer
		Inc	UpToCursorPtr
		Sub	CX,var002
		Mov	DI,CX
		Inc	DI
		Mov	SI,Offset ReplBuf
		Mov	CX,var002
		Rep	MovsB
		Mov	CX,FindCharCount
		Cmp	CX,var002
		JBE	pms403
		Mov	CX,FindCharCount
		Sub	CX,var002
		Sub	FileLength,CX
		Jmp	Short pms404

pms403:		Mov	CX,var002
		Sub	CX,FindCharCount
		Add	FileLength,CX
pms404:		Mov	DI,CursorUpPointer
		Mov	SI,UpToCursorPtr
		Or	SI,SI
		JZ	pms407
		Xor	CX,CX
pms405:		Dec	SI
		Dec	DI
		Dec	UpToCursorPtr
		Dec	CursorUpPointer
		Inc	CX
		Mov	AL,ES:[SI]
		Mov	ES:[DI],AL
		Cmp	Byte Ptr ES:[SI],LF
		JZ	pms406
		Or	SI,SI
		JZ	pms407
		Jmp	Short pms405

pms406:		Inc	SI
		Inc	UpToCursorPtr
		Inc	CursorUpPointer
		Dec	CX
pms407:		Mov	UpperLeft,SI
		Mov	ColumnOffset,0
		Mov	CursorLine,0
		Mov	CursorCol,0
pms408:		JCXZ	pms409
		Call	RightArrow
		Dec	CX
		Jmp	Short pms408

pms409:		Mov	CX,LinesSearched
		Add	DocLineNo,CX
		Call	PaintUnlessBlock
		Mov	FileChangedFlag,1
pms410:		Call	ShowInsOvrtype
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DI
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

GoDirectory:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
pms411:		Mov	BP,Offset DirMenu
		Call	ShowMenuAndWaitKey
		Or	CX,CX
		JNZ	pms412
		Cmp	AL,Esc_
		JZ	pms416
		Jmp	Short pms411

pms412:		Cmp	CX,1			;Open
		JNZ	pms413
		Call	OpenDir
		Jmp	Short pms416

pms413:		Cmp	CX,2			;Close
		JNZ	pms414
		Call	CloseDir
		Jmp	Short pms416

pms414:		Cmp	CX,3			;Make
		JNZ	pms415
		Call	MakeDir
		Jmp	Short pms416

pms415:		Cmp	CX,4			;Erase
		JNZ	DRen
		Call	EraseDir
		Jmp	Short pms416

DRen:		Cmp	CX,5			;Rename
		JNZ	DSrt
		Xor	AX,AX			;signal Dir, not File
		Call	Rename
		Jmp	Short pms416

DSrt:		Cmp	CX,6			;Sort
		JNZ	pms416
		Call	SetSort

;Quit omitted, not needed

pms416:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
;-------------------------------
SetSort:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
pms417:		Mov	BP,Offset SortMenu
		Call	ShowMenuAndWaitKey
		Cmp	AL,Esc_
		JZ	pms418
		Cmp	CX,4
		JA	pms418
		Or	CX,CX
		JNZ	DoSet
		Jmp	Short pms417

DoSet:		Mov	SortType,CL
		Mov	BP,HilitedEntry
		Call	CopyAsFullPath		;to CurrentPath
		Mov	GoEntryFlag,1
		Call	PaintMainScrn
pms418:		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
;-------------------------------
PaintMainScrn:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DS
		Push	ES
		Push	BP
		Push	SI
		Push	DI
		Mov	ES,WorkingSeg
		Mov	BP,17h			;start with 2nd entry
		Mov	DI,Nine
		Mov	SI,Offset RootDirStr
	;copy till the end
pms419:		Mov	AH,[SI]
		Mov	ES:[BP+DI],AH
		Inc	SI
		Inc	DI
		Or	AH,AH
		JNZ	pms419
		Mov	WORD PTR ES:[BP+22],0	;the last (23rd) byte
		Mov	Byte Ptr ES:[BP],10h	;mark it as a Dir
		Add	BP,23
		Mov	PastLastEntry,BP
		Sub	BP,23			;back to the 'Root Dir' entry
		Mov	HilitedEntry,BP
		Xor	CX,CX
		Mov	DX,Offset CurrDrvLtr	;'d:\*.*',0
		Call	GetVolAndFreeSpace	;Crit Error here if drive empty
		Call	GetTheDir		;get Root dir
	;go to proper CurrentPath if GoEntryFlag is set
		Cmp	GoEntryFlag,0
		JNZ	GoToEnt
		Jmp	PaintDone

GoToEnt:	Mov	GoEntryFlag,0
		Mov	AL,CurrDrvNo
		Cmp	AL,OldDrvNo
		JZ	SameDrive		;only ref
	;drive has changed, fill CurrentPath from xPath for this drive
		Cmp	AL,4
		JBE	HaveBuf
		Jmp	PaintDone

HaveBuf:	Mov	SI,Offset APath
		Xor	AH,AH
		Mov	DX,81
		Mul	DX
		Add	SI,AX
		Mov	DI,Offset CurrentPath
		Call	PathMov
;find the top-level entry in CurrentPath.
;Has D:[\path]\fname.ext,0,0...
;On Root, has D:,0,0...,  in Root, has D:\fname.ext,0,0...
SameDrive:	Mov	SI,Offset CurrentPath
		Add	SI,2			;point past the 'D:'
		Cmp	WORD PTR [SI],0		;TWO 0's means on Root dir
		JZ	PaintDone
		Inc	SI
FirstLoop:	Mov	DI,9
		Mov	AL,[SI]
		Add	BP,23
		Cmp	BP,PastLastEntry
		JZ	PaintDone
		Cmp	AL,ES:[BP+DI]		;compare 1st char
		JNZ	FirstLoop
	;1st char matches
		Push	SI
RestLoop:	Inc	SI
		Inc	DI
		Mov	AL,[SI]
		Cmp	AL,'\'
		JZ	ChkMatch
		Or	AL,AL
		JZ	ChkMatch
		Cmp	AL,ES:[BP+DI]
		JZ	RestLoop
		Pop	SI
		Jmp	Short FirstLoop

ChkMatch:	Pop	SI			;ptr to char after '\',this part
		Cmp	Byte Ptr ES:[BP+DI],0	;at end of entry in files list ?
		JNZ	FirstLoop
		Mov	HilitedEntry,BP
	;is this the last part to find ?
ChkLast:	LodsB
		Or	AL,AL
		JZ	PaintDone
		Cmp	AL,'\'
		JNZ	ChkLast
	;open the Dir
		Push	ES			;now SI > 1st char after the '\'
		Push	DS
		Pop	ES
		Push	SI
		Call	CurToWritePath		;save CurrentPath
		Pop	DI			;was SI
		Push	DI
		Mov	SI,Offset StarDotStar
		Mov	CX,4
		Rep	MovsB
		Mov	DX,Offset CurrentPath
		Call	GetTheDir
		Call	WriteToCurPath		;restore CurrentPath
		Pop	SI
		Pop	ES
		Or	AX,AX			;any files ?
		JZ	PaintDone
		Jmp	FirstLoop

PaintDone:	Call	GetAvailAndUsedRAM
		Call	PaintStatusData
		Call	ShowFilesList
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	ES
		Pop	DS
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - -
FilesUp:	Push	AX			;cursor DOWN
		Mov	AX,HilitedEntry
		Add	AX,EntryLen23
		Cmp	AX,PastLastEntry
		JB	pms420
		Sub	AX,EntryLen23
		Jmp	Short pms420

FilesDown:	Push	AX			;cursor UP
		Mov	AX,HilitedEntry
		Sub	AX,EntryLen23
		Cmp	AX,0
		JA	pms420
		Add	AX,EntryLen23
pms420:		Mov	HilitedEntry,AX
		Call	ShowFilesList
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - -
FilesPgUp:	Push	AX
		Push	CX
		Mov	CX,Nine
pms421:		Mov	AX,HilitedEntry
		JCXZ	PgUpDnDone
		Sub	AX,EntryLen23
		Or	AX,AX
		JZ	PgUpDnDone
		Mov	HilitedEntry,AX
		Dec	CX
		Jmp	Short pms421

FilesPgDn:	Push	AX
		Push	CX
		Mov	CX,Nine
pms422:		Mov	AX,HilitedEntry
		JCXZ	PgUpDnDone
		Add	AX,EntryLen23
		Cmp	AX,PastLastEntry
		JNB	PgUpDnDone
		Mov	HilitedEntry,AX
		Dec	CX
		Jmp	Short pms422

PgUpDnDone:	Call	ShowFilesList
		Pop	CX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - -
PrevDir:	Push	AX
		Push	BX
		Push	ES
		Mov	ES,WorkingSeg
		Mov	BX,HilitedEntry
PrevDirLoop:	Sub	BX,EntryLen23
		Cmp	BX,0
		JZ	PlusMinusDone
		Test	Byte Ptr ES:[BX],10h	;a Dir ?
		JZ	PrevDirLoop
		Mov	HilitedEntry,BX
		Jmp	Short PlusMinusDone

NextDir:	Push	AX
		Push	BX
		Push	ES
		Mov	ES,WorkingSeg
		Mov	BX,HilitedEntry
NextDirLoop:	Add	BX,EntryLen23
		Cmp	BX,PastLastEntry
		JNB	PlusMinusDone
		Mov	AL,ES:[BX]
		And	AL,10h
		Cmp	AL,10h			;a Dir ?
		JNZ	NextDirLoop
		Mov	HilitedEntry,BX
PlusMinusDone:	Call	ShowFilesList
		Pop	ES
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - -
FilesHome:	Push	AX
		Xor	AX,AX
		Add	AX,EntryLen23
		Jmp	Short HomeEndDone

FilesEnd:	Push	AX
		Mov	AX,PastLastEntry
		Sub	AX,EntryLen23
HomeEndDone:	Mov	HilitedEntry,AX
		Call	ShowFilesList
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - -
OpenDir:	Push	BX
		Push	CX
		Push	DX
		Push	SI
		Push	DI
		Push	BP
		Push	ES
		Mov	BX,AX
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Cmp	BP,EntryLen23
		JNZ	OKnotRoot
		Mov	DX,Offset RootDirStr
		Call	ErrIfNovice
		Jmp	Short OpenDone

OKnotRoot:	Call	AX11DirWithFiles
		Cmp	AH,1
		JZ	OKisDir
		Mov	DX,Offset NotaDirStr	;only ref
		Call	ErrIfNovice
		Jmp	Short OpenDone

OKisDir:	Cmp	AL,1
		JNZ	pms423
		Mov	DX,Offset AlreadyOpenMsg
		Cmp	BL,2			; From mouse click?
		JNE	OKisDir2		; No: Give err msg if Novice
		Mov	AX,5302h		; Yes: Close the dir
		Jmp	Short OPenDone
OKisDIr2:	Call	ErrIfNovice
		Jmp	Short OpenDone

pms423:		Call	ClsTop2
		Mov	DX,Offset OpeningStr
		Xor	CX,CX
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Call	ShowWait
		Call	CopyAsFullPath		;to CurrentPath
		Cmp	AX,1
		JZ	OpenDone		;if path too long
		Mov	DI,Offset CurrentPath
	;find the end
pms424:		Cmp	Byte Ptr [DI],0
		JZ	pms425
		Inc	DI
		Jmp	Short pms424

pms425:		Mov	AH,BkSlash		;in bfr so sw char could change
		Mov	Byte Ptr [DI],AH
		Inc	DI
		Push	CS
		Pop	ES
		Mov	SI,Offset StarDotStar
		Mov	CX,4
		Rep	MovsB
pms426:		Mov	DX,Offset CurrentPath
		Call	GetTheDir
		Or	AX,AX			;FilesCount
		JNZ	OpenDone
		Mov	DX,Offset EmptyDirStr
		Call	ErrIfNovice

OpenDone:	Call	GetAvailAndUsedRAM
		Call	PaintStatusData
		Call	ShowFilesList
		Pop	ES
		Pop	BP
		Pop	DI
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - - - - -
CloseDir:	Push	AX
		Push	BX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
		Cmp	HilitedEntry,23		;can't close root dir
		JA	pms427
AtRoot:		Call	MakeBeepIf
		Jmp	Short CloseDone

pms427:		Call	ClsTop2
		Mov	DX,Offset ClosingStr
		Xor	CX,CX
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Call	ShowWait
		Mov	BP,HilitedEntry
	;if not on a Dir, go back 'till we are
CloseFindLoop:	Test	Byte Ptr ES:[BP],10h	;a Dir ?
		JNZ	OnOneNow
		Sub	BP,EntryLen23
		Cmp	BP,EntryLen23		;at root ?
		JNA	AtRoot
		Jmp	Short CloseFindLoop

	;delete entries with greater Indent level than this
OnOneNow:	Mov	HilitedEntry,BP
		Mov	AH,ES:[BP+22]		;indent level of hilited dir
		And	AH,00111111b		;strip the Pip & marked dir flgs
		Add	BP,EntryLen23
pms428:		Cmp	BP,PastLastEntry
		JNB	CloseDone
		Mov	AL,ES:[BP+22]
		And	AL,00111111b
		Cmp	AL,AH
		JBE	CloseDone
		Call	DeleteEntry
		Jmp	Short pms428

CloseDone:	Call	ShowFilesList
		Call	GetAvailAndUsedRAM
		Call	PaintStatusData
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - -
;call with BP pointing to entry.  Returns AX=1 if path is too long.
;The path always ends WITHOUT a '\', so root gives d:,0
CopyAsFullPath:	Push	BX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Push	DS
		Mov	AX,CS
		Mov	DS,AX
		Mov	ES,AX
	;first, clear CurrentPath
		Mov	DI,Offset CurrentPath
		Mov	AL,0
		Mov	CX,80
		Rep	StosB
		Mov	ES,WorkingSeg
		Mov	CL,ES:[BP+22]		;indent & Pip flag byte
		Mov	CH,0
		Push	CX
		And	CL,00111111b		;filter out the Pip flags
		Mov	DI,Offset CurrentPath
		Mov	AH,CurrDrvNo
		Add	AH,'A'
		Mov	[DI],AH
		Inc	DI
		Mov	Byte Ptr [DI],':'
		Inc	DI
		Mov	DL,1
		Or	CL,CL			;indent level of this entry
		JNZ	EachLevelLoop
		Jmp	Short CopyPathDone

EachLevelLoop:	Mov	BX,BP			;Starting with this file,
pms429:		Mov	AH,ES:[BX+22]
		And	AH,00111111b		;get Indent (no. of '\' reqd)
		Cmp	AH,DL			;starts at 1
		JZ	ThisLevel
		Sub	BX,EntryLen23		;move to Dir at DL indent lvl
		Jmp	Short pms429

ThisLevel:	Mov	Byte Ptr [DI],'\'	;and copy to CurrentPath.
		Inc	DI
		Mov	SI,Nine			;to start of file/dir name
CopyNameLoop:	Mov	AH,ES:[BX+SI]
		Mov	[DI],AH
		Or	AH,AH
		JZ	NextLevel
		Inc	SI
		Inc	DI
		Jmp	Short CopyNameLoop

NextLevel:	Cmp	CL,DL
		JZ	CopyPathDone
		Call	ChkLen
		Cmp	AX,1
		JZ	CopyPathExit
		Inc	DL			;next indent level
		Jmp	Short EachLevelLoop

	;if we're on a file, don't check after last level
CopyPathDone:	Xor	AX,AX
		Test	Byte Ptr ES:[BP],10h	;on a Dir ?
		JZ	CopyPathExit
		Call	ChkLen
CopyPathExit:	Mov	Byte Ptr [DI],0
		Pop	CX			;CL has Pip & indent byte
		Pop	DS
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	BX
		Ret

ChkLen:		Xor	AX,AX
		Cmp	DI,Offset CurrentPath+65  ;max chars in d:\path,
		JNA	LenRET			  ;  including the final 0.
		Mov	DX,Offset PathTooLongMsg  ;only ref
		Call	ShowErrMsg
		Mov	AX,1
LenRET:		Ret

; - - - - - - - - - - - - - - - -
;at entry, DX>path string, BP>HilitedEntry
GetTheDir:	Push	BX		;called from OpenDir & PaintMainScrn (2)
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	FilesCount,0
		Push	DX
		Mov	DX,Offset DirDTA	;DS:DX points new DTA
		Mov	AH,1Ah			;set DTA
		Int	21h
		Mov	ES,WorkingSeg
		Mov	CL,ES:[BP+22]
		Inc	CL
		Mov	DTA_Indent,CL		;one PAST DirDTA. Only label ref
		Mov	CL,AttribToShow		;15h, or 17h to show hidden
		Xor	CH,CH
		Pop	DX			;pointer to path string
		Mov	AH,4Eh			;find first file
		Int	21h
		JC	FindFileExit
FindNextLoop:	Mov	SI,Offset DirDTA
		Add	SI,15h
		Add	SI,Nine			;to 1st byte of entry name
		Cmp	Byte Ptr [SI],2Eh	;entry is '.', parent dir
		JZ	SkipParent
		Mov	BX,Offset AttributeByte
		Call	EntryToList		;enters it in the files list
		Inc	FilesCount
SkipParent:	Mov	AH,4Fh			;find next file
		Int	21h
		JNC	FindNextLoop
FindFileExit:	Mov	AX,FilesCount
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - -
;enter w/BP > start of entry
DeleteEntry:	Push	AX
		Push	DI
		Push	SI
		Mov	SI,BP
		Mov	DI,BP
		Add	SI,EntryLen23
MoveDownLoop:	Mov	AH,ES:[SI]		;from next,
		Mov	ES:[DI],AH		; to current entry
		Cmp	SI,PastLastEntry
		JNB	AdjustEnd
		Inc	SI
		Inc	DI
		Jmp	Short MoveDownLoop

AdjustEnd:	Mov	AX,PastLastEntry
		Sub	AX,EntryLen23
		Mov	PastLastEntry,AX
		Cmp	AX,HilitedEntry
		JA	pms430
		Sub	AX,EntryLen23
		Mov	HilitedEntry,AX
pms430:		Pop	SI
		Pop	DI
		Pop	AX
		Ret
; - - - - - - - - - - - - - -
;returns AH=1 if on a Dir, AL bit 0 => Dir has files, bit 7 => Root Dir
AX11DirWithFiles:
		Push	BX
		Push	DX
		Push	BP
		Push	SI
		Push	ES
		Mov	ES,WorkingSeg
		Mov	AH,1			;a Dir until proven otherwise
		Mov	AL,1			;has files until disproven
		Mov	DH,ES:[BP]
		And	DH,DirFileAttrib
		Cmp	DH,DirFileAttrib
		JZ	ItsAdir
		Xor	AH,AH			;signal NOT a Dir
		Jmp	Short pms431

ItsAdir:	Mov	DH,ES:[BP+22]
		And	DH,00111111b	;get Indent (0=Root,1=1st-lvl-sub, etc)
		Or	DH,DH
		JNZ	NotRoot
		Or	AL,80h			;this is the Root Dir
NotRoot:	Add	BP,EntryLen23
		Cmp	BP,PastLastEntry
		JNB	pms431
	;this Dir is not the last entry showing
		Mov	DL,ES:[BP+22]
		And	DL,00111111b		;indent lvl of nxt entry showing
		Cmp	DL,DH
		JA	pms432
pms431:		And	AL,80h			;if Dir has NO files/is closed
pms432:		Pop	ES
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	BX
		Ret
; - - - - - - - - - - - - - -
ChkFileAndSort:	Push	BX
		Push	CX
		Push	DX
		Push	ES
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
		Mov	CL,DirFileAttrib
		Xor	CH,CH
		Mov	AH,4Eh			;find 1st file, DX=string-ptr
		Int	21h
		JNC	pms433
		Mov	AH,1
		Jmp	Short pms434

pms433:		Mov	BX,Offset AttributeByte
		Mov	AH,ES:[BP+22]		;the indent byte
		Inc	AH
		Mov	[BX+22],AH		;1 PAST end of DirDTA,DTA_Indent
		Call	EntryToList
		Xor	AH,AH
pms434:		Pop	ES
		Pop	DI
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	CX
		Pop	BX
		Ret				;w/AH=1 if error
; - - - - - - - - - - - - - -
;at entry, BX > the Attribute (1st) byte of the 23-byte entry, usually at
; DirDTA + indent level.
; BP points to Dir in list to start looking for place for this entry
;This searches, on average, half the list every time an entry is added.

EntryToList:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
		Mov	AH,ES:[BP+22]
		Mov	DirIndent,AH
		Push	BP
		Mov	DX,BX
		Add	DX,Nine
		Call	GetStrLenPerDXtoAX
		Mov	DX,AX
SameNameLoop:	Add	BP,EntryLen23
		Cmp	BP,PastLastEntry
		JNB	EntryInsert
		Mov	AH,ES:[BP+22]		;the 23rd (last, indent) byte
		And	AH,00111111b		;strip the Pip flags
		Dec	AH
		Cmp	AH,DirIndent
		JB	EntryInsert		;equal or below the Dir
		JA	SameNameLoop		;2 or more above
;1 above Dir, => a file.  Filter out same name as existing, for Move or Copy.
		Mov	SI,BX
		Add	SI,Nine
		Mov	DI,BP
		Add	DI,Nine
		Mov	CX,DX			;string length
		Push	DX
		Push	DS
		Push	ES
		Pop	DS
		Mov	DX,DI
		Call	GetStrLenPerDXtoAX
		Pop	DS
		Pop	DX
		Cmp	CX,AX			;string len - new string len
		JNB	pms435
		Mov	CX,AX			;CX = shorter length
pms435:		Inc	CX
		RepZ	CmpsB
		Or	CX,CX
		JNZ	SameNameLoop
	;names are the same, overwrite current entry
		Pop	SI
		Jmp	Short ChkAndCopy

EntryInsert:	Pop	BP			;start again at top of Dir
		Add	BP,EntryLen23
		Mov	AH,[BX]
		And	AH,10h
		Mov	NewEntryAttrib,AH
		Cmp	AH,10h
		JNZ	PutItIn
	;the new entry is a Directory
DirPlaceLoop:	Cmp	BP,PastLastEntry
		JNB	PutItIn
		Mov	AH,ES:[BP+22]
		Cmp	AH,DirIndent
		JBE	PutItIn			;if at < or = indent
		Test	Byte Ptr ES:[BP],10h
		JNZ	PutItIn			;if at any Dir
		Add	BP,EntryLen23
		Jmp	Short DirPlaceLoop

PutItIn:	Cmp	SortType,4	;usually, BP now > 1st entry after dir
		JZ	PostSort
Sorted:		Call	AllSorts		;only call
PostSort:	Mov	SI,PastLastEntry
		Mov	DI,SI
		Add	DI,EntryLen23
		Cmp	DI,WorkSegLength
		JNB	ChkAndCopy		;if no room
		Mov	PastLastEntry,DI
MoveUpLoop:	Mov	AH,ES:[SI]
		Mov	ES:[DI],AH
		Cmp	SI,BP		;back to start place for new entry?
		JZ	ChkAndCopy
		Dec	SI
		Dec	DI
		Jmp	Short MoveUpLoop

ChkAndCopy:	Mov	SI,BX
		Mov	DI,BP
		Mov	CX,EntryLen23
	;if updating a hidden or R-O file, don't change the attrib
		Mov	AL,HidROattrib
		Or	AL,AL
		JZ	CopyEntry
		Or	AL,20h			;set un-archived bit
		Mov	[SI],AL
CopyEntry:	Rep	MovsB
		Mov	AH,DirIndent
		Inc	AH
		Mov	ES:[BP+22],AH
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

AllSorts:	Cmp	BP,PastLastEntry
		JNB	PlaceFound
		Mov	CH,ES:[BP+22]		;get indent level
		And	CH,00111111b		;strip the Pips
		Cmp	CH,DirIndent
		JBE	PlaceFound
		Dec	CH
		Cmp	CH,DirIndent
		JA	pms437
		Cmp	NewEntryAttrib,10h
		JZ	pms436
		Test	Byte Ptr ES:[BP],10h
		JNZ	PlaceFound		;jmp if attrib = a Dir
pms436:		Mov	SI,BX
		Mov	DI,BP
		Add	SI,Nine
		Add	DI,Nine
		Mov	CX,12
		Cmp	SortType,2		;by .EXT
		JNZ	TryTy3
FindNewExtLoop:	LodsB				;find 1st dot or 0 in new entry
		Or	AL,AL
		JZ	PlaceFound		;no .ext goes first
		Cmp	AL,'.'
		JZ	ListDotLoop
		Jmp	Short FindNewExtLoop

;new entry has an .ext, SI points 1 past the dot, now find .ext of file in list
ListDotLoop:	Mov	AL,ES:[DI]
		Inc	DI
		Or	AL,AL
		JZ	pms437
		Cmp	AL,'.'
		JNZ	ListDotLoop
		Mov	CX,3
		Jmp	Short DoSort

TryTy3:		Cmp	SortType,3		;by Time
		JNZ	DoSort
		Sub	SI,6
		Sub	DI,6		;point to 2nd of time/date words = BP+3
		Mov	CX,2
		STD
		RepZ	CMPSW
		CLD
		Jmp	Short TimeSorted

DoSort:		RepZ	CmpsB
TimeSorted:	JBE	PlaceFound
pms437:		Add	BP,EntryLen23
		Jmp	Short AllSorts

PlaceFound:	Ret
; - - - - - - - - - - - - - - - -
ShowFilesList:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	DS
		Push	ES
	;show the hilited file first
		Mov	DX,HilitedEntry
pms438:		Call	EntryToLineBuf
		Mov	BL,HilitFileAttrib
		And	DL,10h
		Cmp	DL,10h			;a Dir ?
		JNZ	pms439
		Mov	BL,HilitDirAttrib
pms439:		Mov	DX,Offset FileLineBuf
		Mov	CX,0D01h		;Row 13, Col 1: Middle of screen
		Call	DisplayZ
		Mov	SI,HilitedEntry
PrevLine:	Sub	SI,EntryLen23
		Or	SI,SI
		JZ	BlanksAbove
		Dec	CH
		Cmp	CH,3
		JZ	pms442
		Mov	DX,SI
		Call	EntryToLineBuf
		Mov	BL,FileAttrib
		And	DL,10h
		Cmp	DL,10h			;a Dir ?
		JNZ	pms440
		Mov	BL,DirAttrib
pms440:		Mov	DX,Offset FileLineBuf
		Call	DisplayZ
		Jmp	Short PrevLine

BlanksAbove:	Dec	CH
		Cmp	CH,3
		JZ	pms442
		Mov	DX,Offset HalfBlankLine
		Cmp	ViewFlag,1		;1 => Date/Time
		JNZ	pms441
		Mov	DX,Offset FullBlankLine
pms441:		Mov	BL,FileAttrib
		Call	DisplayZ
		Jmp	Short BlanksAbove

pms442:		Mov	SI,HilitedEntry
		Mov	CH,0Dh
pms443:		Add	SI,EntryLen23
		Cmp	SI,PastLastEntry
		JNB	BlanksBelow
		Inc	CH
		Cmp	CH,LastLine23
		JZ	ShowDone
		Mov	DX,SI
		Call	EntryToLineBuf
		Mov	BL,FileAttrib
		And	DL,10h
		Cmp	DL,10h
		JNZ	pms444
		Mov	BL,DirAttrib
pms444:		Mov	DX,Offset FileLineBuf
		Call	DisplayZ
		Jmp	Short pms443

BlanksBelow:	Inc	CH
		Cmp	CH,LastLine23
		JZ	ShowDone
		Mov	DX,Offset HalfBlankLine
		Cmp	ViewFlag,1		;1 => Date/Time
		JNZ	pms445
		Mov	DX,Offset FullBlankLine
pms445:		Mov	BL,FileAttrib
		Call	DisplayZ
		Jmp	Short BlanksBelow

ShowDone:	Pop	ES
		Pop	DS
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - -
EntryToLineBuf:	Push	AX			;DX holds pointer to entry
		Push	BX
		Push	CX
		Push	SI
		Push	DI
		Push	DS
		Push	ES
		Mov	BX,DX			;pointer to entry
		Push	DS
		Pop	ES
		Mov	DI,Offset FileLineBuf
	;clear the buffer
		Mov	AL,' '
		Mov	CX,4Eh
		Rep	StosB
		Mov	ES,WorkingSeg
		Mov	DI,Offset FileLineBuf
		Mov	AH,AL
	;check Pip flag
		Test	Byte Ptr ES:[BX+22],80h	;BX was DX, points to entry
		JZ	pms446
		Mov	AH,PipChar	;DI=0, 2nd col on scrn, just past bar
pms446:		Mov	DS:[DI],AH		; even with the 'R' in Root Dir
		Inc	DI			;to 3rd col, one past vert bar
		Mov	CH,0
		Mov	CL,ES:[BX+22]
		And	CL,00111111b		;strip the Pips
		Cmp	CL,8
		JBE	pms447
		Mov	CL,8			;max indent is 8 (16 chars)
		Mov	Byte Ptr DS:[DI],'N'	;marks Dir's too deep to indent
pms447:		Add	DI,CX			;indent is
		Add	DI,CX			; (CX * 2) - 1
		Sub	DI,1			;'Root Dir' starts at DI=0
		Test	Byte Ptr ES:[BX],2	;is file hidden ?
		JZ	HidChkd
		Mov	Byte Ptr DS:[DI-1],'('
HidChkd:	Mov	SI,Nine
pms448:		Cmp	Byte Ptr ES:[BX+SI],0
		JZ	pms451
		Cmp	Byte Ptr ES:[BX+SI],'.'
		JZ	pms449
		Mov	AH,ES:[BX+SI]
		Mov	DS:[DI],AH
		Inc	SI
		Inc	DI
		Jmp	Short pms448

pms449:		Mov	DI,Offset FileLineBuf+19h
		Inc	SI
	;copy the .EXT
pms450:		Cmp	Byte Ptr ES:[BX+SI],0
		JZ	pms451
		Mov	AH,ES:[BX+SI]
		Mov	DS:[DI],AH
		Inc	SI
		Inc	DI
		Jmp	Short pms450

pms451:		Test	Byte Ptr ES:[BX],2	;is file hidden ?
		JZ	HidChkd2
		Mov	Byte Ptr DS:[DI],')'
HidChkd2:	Test	Byte Ptr ES:[BX],10h	;attrib of a Dir
		JZ	pms452
	;this is a dir
		Mov	DI,Offset FileLineBuf+1Ch
		Mov	CX,0Ah			;bytes to move
		Mov	SI,Offset DirectoryStr
		Push	ES
		Push	DS
		Pop	ES
		Rep	MovsB
		Pop	ES
		Jmp	Short pms453

pms452:		Mov	BufDest,Offset FileLineBuf+29
		Push	BX
		Push	DX
		Push	SI
		Mov	SI,ES:[BX+5]		;file size lo word
		Mov	DI,ES:[BX+7]		;hi word
		Mov	FileSizeFlag,1
		Call	DwordToBuf
		Mov	FileSizeFlag,0
		Pop	SI
		Pop	DX
		Pop	BX
		Mov	DI,Offset FileLineBuf+38
pms453:		Mov	Byte Ptr DS:[DI],' '
		Inc	DI
		Cmp	ViewFlag,1		;1 => Date/Time
		JZ	pms454
		Jmp	pms460

pms454:		Cmp	BX,EntryLen23
		JA	DoDateAndTime
		Jmp	pms459

DoDateAndTime:	Mov	DI,Offset FileLineBuf+41
		Mov	AX,ES:[BX+3]
		Push	AX
		And	AX,1E0h
		Mov	CL,5
		ShR	AX,CL
		Mov	BP,0
		Call	AXtoNosAtBPplusDI	;month
		Mov	Byte Ptr DS:[DI],'-'
		Pop	AX
		Inc	DI
		Push	AX
		And	AX,1Fh
		Call	AXtoBPplusDIwithZeros	;day
		Mov	Byte Ptr DS:[DI],'-'
		Pop	AX
		Inc	DI
		Push	AX
		And	AX,0FE00h
		Mov	CL,9
		ShR	AX,CL
		Add	AX,50h
		Cmp	AX,99
		JA	Century21
		Mov	Byte Ptr DS:[DI],'1'
		Inc	DI
		Mov	Byte Ptr DS:[DI],'9'
		Inc	DI
		Jmp	Short pms455

Century21:	Mov	Byte Ptr DS:[DI],'2'
		Inc	DI
		Mov	Byte Ptr DS:[DI],'0'
		Inc	DI
		Sub	AX,100
pms455:		Call	AXtoBPplusDIwithZeros
		Pop	AX
		Mov	DI,TimeLocn		;only ref
		Add	DI,Offset FileLineBuf
		Mov	AX,ES:[BX+1]
		Push	AX
		And	AX,0F800h
		Mov	CL,11
		ShR	AX,CL
		Cmp	AX,0
		JA	pms456
		Add	AX,12
pms456:		Cmp	AX,13
		JB	pms457
		Sub	AX,12
pms457:		Call	AXtoNosAtBPplusDI	;hour
		Mov	Byte Ptr DS:[DI],':'
		Pop	AX
		Inc	DI
		Push	AX
		And	AX,07E0h
		Mov	CL,5
		ShR	AX,CL
		Call	AXtoBPplusDIwithZeros	;minutes
		Pop	AX
		And	AX,0F800h
		Mov	CL,11
		ShR	AX,CL
		Cmp	AX,12
		JNB	pms458
		Mov	Byte Ptr DS:[DI],'a'
		Jmp	Short pms459

pms458:		Mov	Byte Ptr DS:[DI],'p'
pms459:		Mov	AL,ES:[BX]		;the file attrib byte
		Test	AL,10h			;a dir ?
		JNZ	AttribsDone
		Mov	SI,Offset ROstr
		Add	DI,3
		Xor	AL,00100000b		;archive bit ON => NOT archived
		Test	AL,00100111b
		JZ	AttribsDone
		Push	ES
		Push	DS
		Pop	ES
		Mov	CX,4
AttribLoop:	Cmp	CX,1
		JNZ	NotLast
		ShR	AL,1
		ShR	AL,1
NotLast:	ShR	AL,1			;shifts lo bit into Carry
		JNC	NextAttrib
		Push	CX
		Push	SI
		Mov	CX,3
		Rep	MovsB
		Pop	SI
		Pop	CX
		Inc	DI
NextAttrib:	Add	SI,3
		Loop	AttribLoop
		Pop	ES
AttribsDone:	Mov	DI,Offset FileLineBuf+4Eh
pms460:		Mov	Byte Ptr DS:[DI],0	;mark the end of the string
		Mov	DL,ES:[BX]		;the file attrib byte
		Xor	DH,DH
		Pop	ES
		Pop	DS
		Pop	DI
		Pop	SI
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

ROstr	DB	'R-O'
		DB	'Hid'
		DB	'Sys'
		DB	'Arc'
; - - - - - - - - - - - - - - - - -
DX_AXtoBuf:	Mov	DI,DX			;hi word
		Mov	SI,AX			;lo word
		Call	DwordToBuf
		Mov	DI,BufDest
		Add	DI,11
		Mov	Byte Ptr DS:[DI],0
		Ret

;Output is 9 digits + 2 commas, unless FileSizeFlag=1 for the Files List,
; omits commas & is only 9 chars.  Input is DI:SI, writes last digit 1st.
DwordToBuf:	Push	BP
		Push	CX
		Mov	CH,0			;initialize character counter
		Mov	BP,BufDest
		Add	BP,10
		Cmp	FileSizeFlag,1
		JNZ	DigitLoop
		Dec	BP
		Dec	BP
DigitLoop:	Mov	bx,10
		Xchg	AX,DI			;  Divide the
		Xor	dx,dx			;  registers to display by 10d
		Div	bx			;  for each digit.
		Xchg	AX,DI			;save high word quotent
		Xchg	AX,SI
		Div	bx
		Xchg	AX,SI			;save low word quotent
		Mov	ax,dx			;get remainder of division
		Or	ax,30h			;make ASCII
		Call	SpitBkwd		;display digit, going backwards
	;done if we are up to a leading zero or 11 (or 9) chars done
		JZ	NumDun
		Mov	AX,DI
		Or	AX,SI
		JNZ	NextDigit
	;pad with spaces
		Mov	AL,' '
PadSps:		Call	SpitBkwd
		JNZ	PadSps
NumDun:		Pop	CX
		Pop	BP
		Ret				;SI & DI are 0, Min 1 zero shows

;insert comma if 3 or 7 characters now done, unless FileSizeFlag is set
NextDigit:	Cmp	FileSizeFlag,1
		JZ	DigitLoop
		Mov	AL,CH
		And	AL,3
		Cmp	AL,3
		JNZ	DigitLoop
		Mov	AL,','
		Call	SpitBkwd
		Jmp	DigitLoop

SpitBkwd:	Mov	DS:[BP],AL
		Dec	BP
		Inc	CH			;characters done
		Cmp	FileSizeFlag,1
		JZ	NineChars
		Cmp	CH,11
		Ret				;w/Z set if CH=11 chars done

NineChars:	Cmp	CH,9
		Ret				;w/Z set if CH=9 chars done
; - - - - - - - - - - - - - - - - - -
AXtoBPplusDIwithZeros:
		Push	AX
		AAM
		Or	AX,3030h
		Jmp	Short pms461

AXtoNosAtBPplusDI:
		Push	AX
		AAM
		Or	AX,3030h		;change to ASCII
		Cmp	AH,'0'			;suppress leading zero
		JNZ	pms461
		Mov	AH,' '
pms461:		Mov	DS:[BP+DI],AH
		Inc	DI
		Mov	DS:[BP+DI],AL
		Inc	DI
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - -
;enter w/BX pointing to prompt line and BP pointing to 'Erase', Move', or 'Copy'
MarkTheFiles:	Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
		Mov	bufBX,BX
		Mov	bufBP,BP
pms462:		Call	ClsTop2
		Mov	BL,MenuAttrib
		Cmp	Sub1Drv2Root3,0FFh	;pointing dest in Copy
						;  or file to Get?
		JZ	DrvSkip1
		Mov	DX,Offset MarkEntriesStr ;'Mark entries to '
		Xor	CX,CX
		Call	DisplayZ
		Mov	DX,bufBP		;'Erase', 'Move', or 'Copy'
		Mov	CL,16			;col
		Call	DisplayZ
DrvSkip1:	Mov	DX,bufBX
		Mov	CX,100h
		Call	DisplayZ
		Call	ShowMarkedInfo
		Call	ShowFilesList
AwaitMarkKey:	Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey
		Cmp	AH,0FFh			; 0FFh is a mouse click
		JNZ	NoMarkClick		; If not a click
		Mov	AH,1			; signal marking mode
		Call	MouseClick		; Process the click
		Cmp	AL,2			; Was it a file mark?
		JE	SpaceMarkM		; Yes: mark it
NoMarkClick:	Or	AL,AL			;special key ?
		JNZ	TryMarkMinus

pms463:		Cmp	AH,52h			;Ins
		JNZ	pms464
		Call	OpenDir
		Jmp	Short pms462

pms464:		Cmp	AH,48h			;Up Arrow
		JNZ	pms465
		Call	FilesDown
		Jmp	Short AwaitMarkKey

pms465:		Cmp	AH,50h			;Down Arrow
		JNZ	pms466
		Call	FilesUp
		Jmp	Short AwaitMarkKey

pms466:		Cmp	AH,49h			;PgUp
		JNZ	pms467
		Call	FilesPgUp
		Jmp	Short AwaitMarkKey

pms467:		Cmp	AH,51h			;PgDn
		JNZ	pms468
		Call	FilesPgDn
		Jmp	Short AwaitMarkKey

pms468:		Cmp	AH,47h			;Home
		JNZ	pms469
		Call	FilesHome
		Jmp	Short AwaitMarkKey

pms469:		Cmp	AH,4Fh			;End
		JNZ	TryMarkMinus
		Call	FilesEnd
		Jmp	Short AwaitMarkKey

TryMarkMinus:	Cmp	AH,4Ah			;Gray -
		JE	MinusMark
		Cmp	AH,43h			;F9 same as Gray -
		JNZ	TryPlusMark
MinusMark:	Call	PrevDir
		Jmp	AwaitMarkKey

TryPlusMark:	Cmp	AH,4Eh			;Gray +
		JE	PlusMark
		Cmp	AH,44h			;F10 same as Gray +
		JNZ	pms470
PlusMark:	Call	NextDir
		Jmp	AwaitMarkKey

pms470:		Cmp	Sub1Drv2Root3,0FFh
		JNZ	ChkSpc
		Jmp	pms472

ChkSpc:		Cmp	AL,' '			;Space Bar
		JZ	SpaceMark
		Jmp	pms472

SpaceMark:	Mov	BX,HilitedEntry
SpaceMarkM:	Mov	DH,ES:[BX]		;the attribute byte
		Cmp	DH,DirFileAttrib
		JNZ	ToggleOne
		Push	BX			;-- toggle entire Dir --
		Mov	DH,ES:[BX+22]	;the Indent & Pip flag byte of the Dir
		Xor	DH,01000000b		;toggle bit 6
		Mov	ES:[BX+22],DH
ToggleLoop:	Add	BX,EntryLen23
		Cmp	BX,PastLastEntry
		JNB	ToggleDirDone
		Test	Byte Ptr ES:[BX],10h	;a Dir ?
		JNZ	ToggleDirDone
		Mov	HilitedEntry,BX
		Test	DH,01000000b
		JZ	RemoveIt
		Test	Byte Ptr ES:[BX+22],10000000b	;already marked ?
		JNZ	ToggleLoop
		Or	Byte Ptr ES:[BX+22],10000000b	;if not, set the Pip flg
		Call	AddOne
		Jmp	Short ToggleLoop

RemoveIt:	Test	Byte Ptr ES:[BX+22],10000000b	;already marked ?
		JZ	ToggleLoop
		And	Byte Ptr ES:[BX+22],01111111b	;reset the Pip if so
		Call	RemoveOne
		Jmp	Short ToggleLoop

ToggleDirDone:	Pop	BX
		Mov	HilitedEntry,BX
		Jmp	Short pms471

ToggleOne:	Xor	Byte Ptr ES:[BX+22],80h	;toggle bit 7 of Indent/Pip flg
		Test	Byte Ptr ES:[BX+22],80h
		JNZ	AddThisOne
	;the pip bit is NOT set, and has just changed, so remove this pip
		Call	RemoveOne
		Jmp	Short pms471

AddThisOne:	Call	AddOne
pms471:		Call	ShowFilesList
		Call	ShowMarkedInfo
		Jmp	AwaitMarkKey

RemoveOne:	Push	DX
		Dec	NumberMarked
		Mov	AX,ES:[BX+5]		;lo word, file size
		Mov	DX,ES:[BX+7]		;hi word
		Sub	BytesMarkedLo,AX
		SBB	BytesMarkedHi,DX
		Pop	DX
		Ret

AddOne:		Push	DX
		Inc	NumberMarked
		Mov	AX,ES:[BX+5]		;lo word, file size
		Mov	DX,ES:[BX+7]		;hi word
		Add	BytesMarkedLo,AX
		ADC	BytesMarkedHi,DX
		Pop	DX
		Ret

pms472:		Cmp	AL,CR
		JNZ	pms473
		Cmp	NumberMarked,0
		JNZ	MarkedOK
		Mov	DX,Offset NoneMarkedStr
		Call	ShowErrMsg
		Jmp	pms462

pms473:		Cmp	AL,Esc_
		JNZ	pms474
		Cmp	Sub1Drv2Root3,0FFh	;pointing dest in Copy
						;  or file to Get?
		JZ	JustEsc
		Call	PipsOff
JustEsc:	Xor	AH,AH
		Jmp	Short MarkDone

pms474:		Jmp	AwaitMarkKey

MarkedOK:	Mov	AH,1
MarkDone:	Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - -
PipsOff:	Push	BX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
		Xor	BP,BP
		Xor	DI,DI
pms475:		Cmp	BP,PastLastEntry
		JNB	PipsOffDone
		Add	BP,EntryLen23
		And	Byte Ptr ES:[BP+22],00111111b	;reset all Pips
		Jmp	Short pms475

PipsOffDone:	Mov	BytesMarkedHi,0
		Mov	BytesMarkedLo,0
		Mov	NumberMarked,0
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	BX
		Call	ShowFilesList

ShowMarkedInfo:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	SI
		Push	DI
		Push	BP
		Mov	BufDest,Offset MarkedInfoBuf
		Mov	DI,BytesMarkedHi
		Mov	SI,BytesMarkedLo
		Call	DwordToBuf
		Mov	BufDest,Offset MarkedNumber
		Xor	DI,DI
		Mov	SI,NumberMarked
		Call	DwordToBuf
		Mov	DX,Offset MarkedInfoBuf
		Mov	CX,1800h		;Row 24, Col 0
		Mov	BL,TextAttrib
		Call	DisplayZ
		Pop	BP
		Pop	DI
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - -
EraseDir:	Push	AX
		Push	BX
		Push	DX
		Push	ES
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Test	Byte Ptr ES:[BP],10h
		JNZ	pms476
		Mov	DX,Offset UseFileEraseMsg
		Call	ErrIfNovice
		Jmp	Short ErDirExit

pms476:		Call	CopyAsFullPath
		Cmp	AX,1
		JZ	ErDirExit
		Call	YesNoIf
		Cmp	AX,1
		JNZ	ErDirExit
		Mov	AH,0Eh			;select drive
		Mov	DL,CurrDrvNo		;0=A:, 1=B:, etc
		Int	21h
		Mov	AH,3Bh			;change dir
		Mov	DX,Offset BkSlash	;path
		Int	21h
		Mov	AH,3Ah			;remove dir
		Mov	DX,Offset CurrentPath
		Int	21h
		JNB	pms478
		Cmp	AX,5
		JNZ	pms477
		Mov	DX,Offset NotEmptyMsg
		Call	ErrIfNovice
		Jmp	Short ErDirExit

pms477:		Mov	DX,Offset DiskChgMsg
		Call	ShowErrMsg
		Jmp	Short ErDirExit

pms478:		Call	DeleteEntry
ErDirExit:	Call	GetAvailAndUsedRAM
		Call	GetVolAndFreeSpace
		Call	PaintStatusData
		Call	ShowFilesList
		Pop	ES
		Pop	DX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
MakeDir:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Call	CopyAsFullPath
		Cmp	AX,1
		JNZ	LenOK2
		Jmp	pms482

LenOK2:		Call	AX11DirWithFiles
		Cmp	AH,1
		JZ	pms479			;jmp if this IS a dir
		Mov	DX,Offset NotaSubDirMsg
		Jmp	ErrJmp

pms479:		Mov	MakeShowFlag,AL	  ;bit 0 => has files showing, 7=> root
		Push	ES
		Push	CS
		Pop	ES
		Call	CurToWritePath
	;make sure path ends with '\'
		Mov	DI,Offset WritePath
		Xor	AL,AL
		Mov	CX,50h
		RepNZ	ScasB
		Mov	Byte Ptr [DI-1],'\'
		Pop	ES
		Call	ClsTop2
		Mov	DX,Offset EntNewDirMsg
		Xor	CL,CL
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,Offset EscExitsStr
		Inc	CH
		Mov	CL,0Eh
		Call	DisplayZ
		Call	EnterFName		;DI > dest in WritePath
		JC	pms482
		Mov	AH,39h			;create dir
		Mov	DX,Offset WritePath
		Int	21h
		JNC	DirMade
		Cmp	AX,3
		JZ	DCjmp
pms480:		Cmp	AX,5			;Access Denied, if path NFG
		JNZ	DirMade
		Mov	DX,Offset AccessOrPathMsg
		Jmp	Short ErrJmp

DirMade:	Test	MakeShowFlag,10000001b	;files showing or root ?
		JZ	pms482		;Dir is closed, can't show new SubDir
;***Above will not show new subDir on an EMPTY dir, really ought to...
		Mov	DX,Offset WritePath
		Call	ChkFileAndSort
		Cmp	AH,1			;1 => error, file not found
		JNZ	pms481
DCjmp:		Mov	DX,Offset DiskChgMsg
ErrJmp:		Call	ErrIfNovice
pms481:		Call	ShowFilesList
pms482:		Call	GetAvailAndUsedRAM
		Call	GetVolAndFreeSpace
		Call	PaintStatusData
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
GoFile:		Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
ShowFileMenu:	Push	BX
		Call	ShowBottomLine
		Pop	BX
		Mov	BP,Offset FileMenu
		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Copy
		JNZ	TryPrt
		Call	DoFileCopy
		Jmp	Short RoutineESC

TryPrt:		Cmp	CX,2			;Print
		JNZ	TryRen
		Call	DoFilePrint
		Jmp	Short pms486

TryRen:		Cmp	CX,3			;Rename
		JNZ	pms483
		Mov	AX,1			;signal File, not Dir
		Call	Rename
		Jmp	Short pms486

pms483:		Cmp	CX,4			;Move
		JNZ	pms484
		Call	DoFileMove		;only call
		Jmp	Short pms486

pms484:		Cmp	CX,5			;Erase
		JNZ	pms485
		Push	BX
		Mov	BP,Offset EraseStr
		Mov	BX,Offset SpaceMarkStr
		Call	MarkTheFiles
		Pop	BX
		Cmp	AH,1
		JNZ	pms486
		Call	EraseMarkedFiles	;only call
		Jmp	Short pms486

pms485:		Cmp	CX,6			;Attrib
		JNZ	TryBak
		Call	DoFileAttrib
		Jmp	Short RoutineESC

TryBak:		Cmp	CX,7			;Bak
		JNZ	TryQut
		Call	DoBak

RoutineESC:	Cmp	AL,Esc_
		JZ	ShowFileMenu
		Jmp	Short pms486

TryQut:		Cmp	CX,8			;Quit
		JZ	pms486
		Cmp	AL,Esc_
		JNZ	ShowFileMenu
pms486:		Call	ShowBottomLine
		Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
DoBak:		Push	DS
		Push	ES
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Test	Byte Ptr ES:[BP],10h
		JZ	IsBakFile
		Mov	DX,Offset IsaDirMsg
		Call	ShowErrMsg
		Jmp	Short BakDone

IsBakFile:	Mov	AX,CS
		Mov	ES,AX
		Mov	DS,AX
		Call	CopyAsFullPath
		Call	CurToWritePath
		Mov	DI,Offset WritePath
		Mov	CX,51h			;-- find the end of the name --
		Xor	AL,AL
		RepNZ	ScasB			;find the end
		Dec	DI			;point to the 0
		Mov	SI,DI			;save end pointer
		Mov	CX,4
LookDotLoop:	Dec	DI			;look back for a '.'
		Cmp	Byte Ptr [DI],'.'
		JZ	YesExt
		Loop	LookDotLoop

		Mov	DI,SI
YesExt:		Mov	SI,Offset DotBak
		Mov	CX,5
		Rep	MovsB
		Dec	DI			;point to the 0
		Call	ClsTop2
		Xor	CX,CX
		Mov	BL,TextAttrib
		Mov	DX,Offset TypeFname
		Call	DisplayZ
		Inc	CH			;to row 1
		Mov	Byte Ptr [DI],0
		Sub	DI,Offset WritePath
		Mov	CursorLocn,DI
		Mov	DX,Offset WritePath
		Mov	BH,79
		Mov	SI,Offset PathChars
		Call	InputBHchars
		Cmp	AL,1
		JZ	BakDone
		Call	ShowWait
		Call	CopyOneFile		;CurrentPath=src, WritePath=dest
BakDone:	Mov	DX,Offset WritePath
		Mov	GoEntryFlag,1
		Call	PaintMainScrn
		Pop	ES
		Pop	DS
		Ret

DotBak		DB	'.BAK',0
; - - - - - - - - - - - - - - -
ToAexit:	Mov	AL,Esc_
		Jmp	Aexit

DoFileAttrib:	Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
ShowFAttrMenu:	Mov	BP,Offset FAttribMenu
		Call	ShowMenuAndWaitKey
		Cmp	AL,Esc_
		JZ	ToAexit
		Or	CX,CX
		JZ	ShowFAttrMenu
		Cmp	CX,7			;Quit
		JZ	ToAexit
		JA	ShowFAttrMenu
	;now CX = 1 thru 6, for Hide, Reveal, Protect, Deprot, Arc, Unarc
		Push	CX
		Dec	CX			;start with 0 for Hide
		Mov	FAttribFunc,CX
		Mov	BX,Offset ChangePointers
		Add	CX,CX
		Add	BX,CX
		Mov	BP,[BX]			;MarkTheFiles shows this
		Mov	BX,Offset SpaceMarkStr
		Call	MarkTheFiles
		Pop	BX			;so same item hilited if <Esc>
		Cmp	AH,1			;<Esc> hit ?
		JZ	AMarked
		Jmp	ShowFattrMenu

AMarked:	Mov	AX,HilitedEntry
		Mov	EntryPtr3,AX
		Call	YesNoIf
		Cmp	AX,1
		JZ	A_yes
		Jmp	Adone			;so PaintMainScrn erases pips

A_yes:		Call	ClsTop2
		Mov	DX,Offset ChangingStr
		Xor	CX,CX
		Mov	BL,TextAttrib
		Call	DisplayZ
		Call	ShowWait
ChangeOneFile:	Mov	AX,EntryLen23
		Mov	HilitedEntry,AX
		Cmp	AX,PastLastEntry
		JAE	Short Adone		;in case of empty dir
		Call	GoNextAndCopyName	;shows files list
		Cmp	AL,1			;reached end of entries ?
		JZ	Adone
		Mov	DX,Offset CurrentPath
		Mov	AX,4300h		;get file attrib to CL
		Int	21h
		Mov	BP,HilitedEntry
		JNC	GotOld
		Mov	DX,Offset DiskChgMsg
		Call	ShowErrMsg
		Mov	EntryPtr3,BP
		Jmp	Short Adone

GotOld:		Mov	BX,Offset Fattrs
		Xor	CL,20h			;flip the archive bit
		Xor	AX,AX
		Mov	AX,FAttribFunc		;0-5 Hid,Rev,Prot,Dep,Arc,Unarc
		ShR	AL,1			;divide by 2, carry if odd
		PushF
		Add	BX,AX
		Mov	AL,[BX]			;get byte to OR or AND
		PopF
		JC	OffIt
		Or	CL,AL
		Jmp	Short ChangeIt

OffIt:		Not	AL
		And	CL,AL
ChangeIt:	Xor	CL,20h			;flip the damn archive bit back
		Mov	AX,4301h		;set file attrib per CL
		Int	21h
		Push	ES
		Mov	ES,WorkingSeg
		And	Byte Ptr ES:[BP+22],0011111b	;turn off the pip
		Pop	ES
		Jmp	Short ChangeOneFile

Adone:		Mov	GoEntryFlag,1		;CurrentPath, last marked file
		Call	PaintMainScrn
Aexit:		Call	PipsOff
		Pop	BP
		Pop	CX
		Pop	BX
		Ret

Fattrs		DB	2,1,20h
ChangePointers	DW	Offset HideStr
		DW	Offset RevStr
		DW	Offset ProtStr
		DW	Offset DeprStr
		DW	Offset ArcStr
		DW	Offset UnarStr
; - - - - - - - - - - - - - - -
SetupPrinter:	Push	DI
		Push	DX
		Mov	DI,Offset PrinterStr
ASCIIZtoPrn:	Mov	DL,DS:[DI]
		Or	DL,DL
		JNZ	PrintIt
		Pop	DX
		Pop	DI
		Ret

PrintIt:	Mov	AH,5			;print char
		Int	21h
		Inc	DI
		Jmp	Short ASCIIZtoPrn
; - - - - - - - - - - - - - - -
DoFilePrint:	Push	ES
		Mov	ES,WorkingSeg
		Mov	DI,HilitedEntry
		Test	Byte Ptr ES:[DI],10h	;attribute byte
		Pop	ES
		JZ	GetCC
	;the cursor bar is on a directory
		Mov	DX,Offset IsaDirMsg
		Call	ShowErrMsg
		Ret

GetCC:		Call	ClsTop2
		Mov	DX,Offset CCmsg
		Xor	CX,CX			;row 0, col 0
		Call	DisplayZ
		Inc	CH
		Call	GetDecToAL		;only call
		Mov	CopiesToPrint,AL
		Cmp	AH,0FFh			;<Esc> hit ?
		JZ	ToFPRet
		Or	AL,AL
		JNZ	PrintTheDoc
ToFPRet:	Ret

PrintTheDoc:	Mov	BP,HilitedEntry
		Call	CopyAsFullPath
		Cmp	AX,1			;path too long ?
		JZ	FPRet
		Call	OpenCurrPath
		Cmp	AX,1			;error opening file ?
		JZ	FPRet
		Mov	ReadHandle,AX
		Call	ShowWait
		Call	SetupPrinter		;send the Printer Setup string
PrintBunch:	Mov	BX,ReadHandle
		Mov	CX,1024			;get 1K of file to Editor bfr
		Push	DS
		Mov	DS,EditBufSeg
		Xor	DX,DX			;DS:DX points to read buffer
		Mov	AH,3Fh			;read from file
		Int	21h
	;print a 1K block
		Or	AX,AX			;bytes read
		JZ	LastCR
		Push	AX
		Xchg	AX,CX
		Xor	DI,DI
PrintChar:	Cmp	CS:EscFlag,1
		JZ	KillPrint
		Mov	DL,DS:[DI]
		Mov	AH,5			;print char in DL
		Int	21h
		Inc	DI
		Loop	PrintChar
		Pop	AX
		Pop	DS
		Cmp	AX,1024			;printed a whole block ?
		JZ	PrintBunch		;if so, do another
	;send a final CR to printer, in case file does not end with CR
LastCR:		Mov	DL,CR
		Mov	AH,5
		Int	21h
KillExit:	Mov	BX,ReadHandle
		Mov	AH,3Eh			;close file
		Int	21h
		Dec	CopiesToPrint
		JNZ	PrintTheDoc
FPRet:		Ret

KillPrint:	Pop	AX
		Pop	DS
		Call	ResetPrinter
		Mov	CopiesToPrint,1		;so it will Dec to 0
		Jmp	Short KillExit
; - - - - - - - - - - - - - - -
EraseMarkedFiles:
		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Mov	AX,HilitedEntry
		Mov	EntryPtr3,AX
		Call	YesNoIf
		Cmp	AX,1
		JNE	pms491
		Call	ClsTop2
		Mov	DX,Offset ErasingStr
		Xor	CX,CX
		Mov	BL,TextAttrib
		Call	DisplayZ
		Call	ShowWait
EraseOneFile:	Mov	AX,HilitedEntry
		Mov	EntryPtr3,AX
		Mov	AX,EntryLen23
		Mov	HilitedEntry,AX
		Cmp	AX,PastLastEntry
		JAE	pms491
		Call	GoNextAndCopyName
		Cmp	AL,1			;reached end of entries ?
		JNZ	pms489
		Mov	AX,EntryLen23
		Add	EntryPtr3,AX
		Jmp	Short pms491

pms489:		Mov	DX,Offset CurrentPath
		Mov	AH,41h			;delete file
		Int	21h
		JNC	FileDeleted
		Mov	DX,Offset FileIsROmsg
		Call	ShowErrMsg
		Mov	BP,HilitedEntry
		Mov	EntryPtr3,BP
		Jmp	Short pms491

FileDeleted:	Mov	BP,HilitedEntry
		Call	DeleteEntry
		Sub	BP,EntryLen23
		Cmp	BP,PastLastEntry
		JNB	pms490
		Call	GetAvailAndUsedRAM
		Call	GetVolAndFreeSpace
		Call	PaintStatusData
		Mov	HilitedEntry,BP
		Jmp	Short EraseOneFile

pms490:		Mov	HilitedEntry,BP
		Call	ShowFilesList
		Jmp	Short EraseOneFile

pms491:		Mov	BP,EntryPtr3
		Mov	HilitedEntry,BP
		Cmp	BP,PastLastEntry
		JB	pms492
		Mov	BP,PastLastEntry
		Sub	BP,EntryLen23
		Mov	HilitedEntry,BP
pms492:		Call	PipsOff
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - -
DoFileMove:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Mov	ES,WorkingSeg
pms493:		Mov	BP,Offset MoveStr
		Mov	BX,Offset HiliteDestStr
		Call	MarkTheFiles
		Cmp	AH,1
		JZ	pms494
		Mov	AX,HilitedEntry		;<Esc> was hit
		Mov	EntryPtr2,AX
		Mov	PrevHilitEntry,AX
		Jmp	ShowPrevAndRet

pms494:		Mov	BP,HilitedEntry
		Test	Byte Ptr ES:[BP],10h
		JNZ	pms495
		Mov	DX,Offset DestNotDirStr
		Call	ErrIfNovice
		Jmp	Short pms493

pms495:		Call	YesNoIf
		Cmp	AX,1
		JZ	pms496
		Mov	AX,HilitedEntry
		Mov	PrevHilitEntry,AX
		Jmp	ShowPrevAndRet

pms496:		Mov	BP,HilitedEntry
		Mov	EntryPtr2,BP
		Call	CopyAsFullPath		;dest dir to CurrentPath
		Cmp	AX,1
		JNZ	LenOK4
		Jmp	Short pms493

LenOK4:		Call	CurToWritePath		;copy dest dir to WritePath
		Mov	MovMorIndented,1
		Mov	AH,ES:[BP+22]
		Add	BP,EntryLen23		;move to next entry
		Cmp	BP,PastLastEntry
		JNB	pms497
		Mov	AL,ES:[BP+22]
		And	AL,00111111b		;strip the Pips
		Cmp	AL,AH
		JA	pms498			;jump if this one > previous
pms497:		Mov	MovMorIndented,0
pms498:		Call	ClsTop2
		Mov	DX,Offset MovingStr
		Mov	CX,0
		Mov	BL,TextAttrib
		Call	DisplayZ
		Call	ShowWait
MovNxtFile:	Mov	AX,HilitedEntry
		Mov	PrevHilitEntry,AX
		Mov	AX,EntryLen23
		Mov	HilitedEntry,AX
		Cmp	AX,PastLastEntry
		JNB	ToShowPrevAndRet
pms499:		Call	GoNextAndCopyName
		Mov	CX,HilitedEntry
		Mov	MarkedEntryPtr,CX
		Cmp	AL,1			;reached end of entries ?
		JNZ	pms500
ToShowPrevAndRet:Jmp	ShowPrevAndRet

pms500:		Push	ES
		Push	DS
		Pop	ES
		Mov	SI,Offset WritePath
		Mov	DI,Offset StatsAndCopyPath
		Mov	CX,50h
		Rep	MovsB
		Mov	DI,Offset StatsAndCopyPath   ;dest dir
		Xor	AL,AL
		Mov	CX,50h
		RepNZ	ScasB
		Dec	DI
		Mov	SI,DI			;> end of dest
		Mov	DI,Offset CurrentPath	;source dir
		Xor	AL,AL
		Mov	CX,50h
		RepNZ	ScasB
		Mov	DX,DI			;> end of source path
		Mov	AL,'\'
		Mov	CX,50h
		STD
		RepNZ	ScasB			;back to last '\'
		CLD
		Inc	DI
		Mov	CX,DX
		Sub	CX,DI			;end source - last '\'
		Xchg	SI,DI
	;now DI > end of dest, SI > filename in source
		RepZ	MovsB
	;check if filenames are the same
MoveIt:		Mov	SI,Offset CurrentPath	     ;old Path\name
		Mov	DI,Offset StatsAndCopyPath   ;new Path\name
		Mov	DX,DI
		Call	GetStrLenPerDXtoAX
		Mov	CX,AX
		Mov	DX,SI
		Call	GetStrLenPerDXtoAX
		Cmp	CX,AX			;same length ?
		JNZ	NamesDiffo
		RepZ	CmpsB
		JNZ	NamesDiffo
		Mov	DX,Offset NoCopyItselfMsg
		Call	ShowErrMsg
		Pop	ES
		Jmp	MSameSkip

	;save each path - so goes to last xPath if change to same drive
NamesDiffo:	Mov	SI,Offset StatsAndCopyPath   ;new Path\name
		Call	SetXpath
		Mov	DI,Offset StatsAndCopyPath   ;new Path\name
		Mov	DX,Offset CurrentPath	     ;old Path\name
		Mov	AH,56h			     ;rename file or dir
		Int	21h
		Pop	ES
		JNC	pms503
	;handle errors
		Cmp	AX,3			;path not found
		JNZ	pms501
		Mov	DX,Offset DiskChgMsg
		Call	ShowErrMsg
		Mov	BP,HilitedEntry
		Mov	PrevHilitEntry,BP
		Jmp	ShowPrevAndRet

pms501:		Cmp	AX,5			;access denied
		JNZ	pms502
		Call	MakeBeepIf
		Push	BX
		Push	CX
		Push	BP
		Push	DX
		Mov	BX,1
		Mov	BP,Offset MoveSameMenu
ShowMoveSameMenu: Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Overwrite anyhow
		JNZ	MTryNo
	;delete file in destination dir
		Mov	AH,41h			;delete file
		Mov	DX,Offset StatsAndCopyPath
		Int	21h
		Pop	DX
		Pop	BP
		Pop	CX
		Pop	BX
		Push	ES
		Push	DS
		Pop	ES
		Jmp	Short MoveIt		;try again

MTryNo:		Cmp	CX,2			;No
		JZ	MSkip
		Cmp	AL,Esc_
		JNZ	ShowMoveSameMenu
MSkip:		Pop	DX
		Pop	BP
		Pop	CX
		Pop	BX
MSameSkip:	Mov	BP,MarkedEntryPtr
		And	Byte Ptr ES:[BP+22],00111111b	;turn off the Pips
		Call	ShowFilesList
		Jmp	Short ShowAndMoveNext

pms502:		Cmp	AX,11h			;not same device
		JZ	ShowAndMoveNext
pms503:		Cmp	MovMorIndented,1
		JNZ	pms506
		Mov	BP,MarkedEntryPtr
		And	Byte Ptr ES:[BP+22],00111111b	;strip the Pips
		Mov	SI,MarkedEntryPtr
		Mov	DI,Offset StatsAndCopyPath
		Mov	CX,EntryLen23
pms504:		Mov	AH,ES:[SI]
		Mov	[DI],AH
		Inc	SI
		Inc	DI
		Loop	pms504

		Mov	BP,MarkedEntryPtr
		Call	DeleteEntry
		Cmp	BP,EntryPtr2
		JA	pms505
		Mov	AX,EntryLen23
		Sub	EntryPtr2,AX
pms505:		Mov	BX,Offset StatsAndCopyPath
		Mov	BP,EntryPtr2
		Call	EntryToList
		Jmp	Short ShowAndMoveNext

pms506:		Mov	BP,MarkedEntryPtr
		Call	DeleteEntry
		Cmp	BP,EntryPtr2
		JA	ShowAndMoveNext
		Mov	AX,EntryLen23
		Sub	EntryPtr2,AX
ShowAndMoveNext:Call	GetVolAndFreeSpace
		Call	PaintStatusData
		Jmp	MovNxtFile

ShowPrevAndRet:	Mov	AX,PrevHilitEntry
		Mov	HilitedEntry,AX
		Call	PipsOff
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - -
DoFileCopy:	Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
ShowCopyMenu:	Mov	BP,Offset CopyMenu
		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;1=Subdir, 2=Drive, 3=Root
		JB	ChkFCesc
		Cmp	CX,3
		JA	ChkFCesc
		Call	CopyEm
		Jmp	Short Cdone

ChkFCesc:	Cmp	CX,4			;Quit
		JNZ	Cesc
		Mov	AL,Esc_			;so goes to prev, not Main menu
Cesc:		Cmp	AL,Esc_
		JNZ	ShowCopyMenu
Cdone:		Pop	BP
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - -
SwitchToSource:	Push	AX			;used below
		Push	DX
		Mov	DL,ErrDrvNo		;the source drive no.
		Mov	CurrDrvNo,DL
		Mov	AH,0Eh			;select drive in DL
		Int	21h
		Mov	AX,SourceHilitedEntry
		Mov	HilitedEntry,AX
		Mov	AX,OrigWkSeg
		Mov	WorkingSeg,AX
		Mov	AX,SourceEntEnd
		Mov	PastLastEntry,AX
		Call	ShowFilesList
		Call	GetVolAndFreeSpace
		Call	GetAvailAndUsedRAM
		Call	PaintStatusData
		Pop	DX
		Pop	AX
		Ret
; - - - - - - - - - - - - - -
;CX=1 for Subdir, 2 for Drive, 3 for Root
CopyEm:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	ES
		Mov	DestBkslashName,0
		Mov	Sub1Drv2Root3,CL
		Mov	ES,WorkingSeg
ShowMarkEm:	Mov	BP,Offset CopyStr
		Mov	BX,Offset SpaceMarkStr
		Cmp	Sub1Drv2Root3,1
		JNZ	MarkEm
		Mov	BX,Offset HiliteDestStr
MarkEm:		Call	MarkTheFiles
		Cmp	AH,1			;1 => ENTER was hit, 0 => <Esc>
		JNZ	ToPOE
		Cmp	Sub1Drv2Root3,1
		JNZ	DriveOrRoot
		Jmp	ToSubdir

DriveOrRoot:	Call	SelectDriveToAH
		Cmp	AL,Esc_
		JZ	ToPOE
		Cmp	AH,CurrDrvNo
		JNZ	DoDrvAndRoot
		Mov	DX,Offset UseFCSameMsg
		Call	ShowErrMsg
ToPOE:		Jmp	PipsOffAndExit

DoDrvAndRoot:	Cmp	Sub1Drv2Root3,2
		JZ	DoDrive
		Jmp	DoRoot

DoDrive:	Mov	CX,HilitedEntry
		Mov	SourceHilitedEntry,CX
		Mov	CX,PastLastEntry
		Mov	SourceEntEnd,CX
		Call	GoDrive		;AH=dest drv, Sets WorkingSeg=EditBufSeg
		Mov	ES,EditBufSeg
PointDest:	Mov	BX,Offset HilDestDirStr
		Mov	BP,Offset HalfBlankLine
		Mov	Sub1Drv2Root3,0FFh	;so MarkTheFiles won't add pips
		Call	MarkTheFiles
		Mov	Sub1Drv2Root3,1
		Cmp	AH,1			;1 => ENTER was hit, 0 => <Esc>
		JZ	PointNoEsc
	;<Esc> hit: restore source drive w/pips showing & "Mark files to copy"
		Mov	Sub1Drv2Root3,2		;restore for MarkTheFiles
		Call	SwitchToSource		;just above
		Jmp	ShowMarkEm

PointNoEsc:	Mov	BP,HilitedEntry
		Test	Byte Ptr ES:[BP],10h
		JNZ	Lynif
		Mov	DX,Offset DestNotDirStr
		Call	ErrIfNovice
		Jmp	Short PointDest

Lynif:		Call	CopyAsFullPath
		Call	CurToWritePath		;WritePath is dest path
		Call	YesNoIf
		Or	AX,AX
		JZ	PointDest		;if 'No' or <Esc>
		Call	SwitchToSource		;just above
		Jmp	StartCopying		;'Yes'

DoRoot:		Mov	SI,Offset WritePath
		Add	AH,'A'			;AH has dest drive no.
		Mov	[SI],AH
		Inc	SI
		Mov	Byte Ptr [SI],':'
		Inc	SI
		Mov	Byte Ptr [SI],0
		Jmp	Short StartCopying

ToSubdir:	Call	YesNoIf
		Cmp	AX,1
		JZ	pms509
		Jmp	PipsOffAndExit

pms509:		Mov	BP,HilitedEntry
		Call	AX11DirWithFiles
		Cmp	AH,1
		JZ	pms510
		Mov	DX,Offset DestNotDirStr
		Call	ShowErrMsg
		Mov	BP,Offset CopyStr
		Mov	BX,Offset HiliteDestStr
		Jmp	MarkEm

pms510:		Mov	AX,HilitedEntry
		Mov	DestDirPtr,AX
		Call	CopyAsFullPath
		Cmp	AX,1
		JNZ	LenOK5
		Jmp	CopyOneOK

LenOK5:		Call	CurToWritePath
StartCopying:	Call	ClsTop2
		Mov	DX,Offset CopyingStr
		Xor	CX,CX
		Mov	BL,TextAttrib
		Call	DisplayZ
		Call	ShowWait
CopyNextFile:	Mov	AX,HilitedEntry
		Mov	TempHilitEntry,AX
		Mov	AX,EntryLen23
		Mov	HilitedEntry,AX		;start at 1st entry
		Cmp	AX,PastLastEntry
		JB	pms511
		Jmp	CopyEmDone

pms511:		Call	GoNextAndCopyName	;CopyAsFullPath to CurrentPath
		Cmp	AL,1			;reached end of entries ?
		JNZ	pms512
		Jmp	CopyEmDone

pms512:		Cmp	AH,1			;path too long ?
		JNZ	LenOK6
		Jmp	CopyOneOK

LenOK6:		Push	ES
		Push	DS
		Pop	ES
		Xor	AL,AL
		Mov	DI,Offset CurrentPath
		Mov	CX,50h
		RepNZ	ScasB			;find the end
		Dec	DI
		Mov	AL,BkSlash
		Mov	CX,50h
		STD				;go backwards
 		RepNZ	ScasB
		CLD				;go forwards
		Inc	DI
		Mov	SI,DI			;SI > '\fname.ext' of source
	;find end of dest path at the \fname.ext (1st time, will be at 0)
		Cmp	DestBkslashName,0
		JNZ	GotDestPath
		Mov	DI,Offset WritePath	;has dest
		Mov	CX,50h
		Xor	AL,AL
		RepNZ	ScasB
		Dec	DI
		Mov	DestBkslashName,DI
GotDestPath:	Mov	DI,DestBkslashName
		Mov	CX,50h
		Rep	MovsB
		Pop	ES
		Call	ShowFilesList
		Mov	SI,Offset WritePath	;show bytes free on dest drive
		Mov	DL,[SI]
		Sub	DL,40h			;drive no, A = 1, etc
		Mov	AH,36h			;get drive space
		Int	21h
		Mul	CX
		Mul	BX
		Mov	BufDest,Offset DestFree
		Mov	DI,DX
		Mov	SI,AX
		Call	DwordToBuf		;doesn't add a 0 at end
		Mov	DX,Offset DestFree
		Mov	CX,1838h		;Bottom Row, Col 56
		Mov	BL,TextAttrib
		Call	DisplayZ
		Call	CopyOneFile
		Cmp	AH,1			;error ?
		JNZ	CopyOneOK
		Jmp	Short PipsOffAndExit

CopyOneOK:	Mov	BP,HilitedEntry
		And	Byte Ptr ES:[BP+22],00111111b	;reset Pip flag
		Cmp	Sub1Drv2Root3,3		;to Root ?
		JZ	ToCopyNextFile
		Mov	BP,DestDirPtr
		Call	AX11DirWithFiles
		And	AL,1			;filter out the Root Dir bit
		JZ	ToCopyNextFile		;jmp if this Dir has NO files
		Mov	SI,HilitedEntry
		Mov	DI,Offset StatsAndCopyPath
		Mov	CX,EntryLen23
pms514:		Mov	AH,ES:[SI]
		Mov	[DI],AH
		Inc	SI
		Inc	DI
		Loop	pms514

		Mov	BP,DestDirPtr
		Push	BX
		Mov	BX,Offset StatsAndCopyPath
		Call	EntryToList
		Pop	BX
ToCopyNextFile:	Jmp	CopyNextFile

PipsOffAndExit:	Mov	AX,HilitedEntry
		Mov	TempHilitEntry,AX
CopyEmDone:	Mov	Sub1Drv2Root3,0
		Mov	AX,TempHilitEntry
		Mov	HilitedEntry,AX
		Call	PipsOff
		Pop	ES
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - 
;called in File Copy and Bak, copies CurrentPath to WritePath
CopyOneFile:	Push	BX
		Push	CX
		Push	DX
		Push	SI
		Push	DI
		Push	BP
		Push	ES
		Push	DS
		Mov	AX,CS
		Mov	DS,AX
		Mov	ES,AX
	;check if filenames are the same
		Mov	SI,Offset CurrentPath
		Mov	DI,Offset WritePath
		Mov	DX,DI
		Call	GetStrLenPerDXtoAX
		Mov	CX,AX
		Mov	DX,SI
		Call	GetStrLenPerDXtoAX
		Cmp	CX,AX			;same length ?
		JZ	pms513
		Jmp	Short NamesDif

pms513:		RepZ	CmpsB
		JNZ	NamesDif
		Mov	DX,Offset NoCopyItselfMsg
		Call	ShowErrMsg
		Jmp	CopyErrExit

NamesDif:	Mov	AH,3Dh			;open file
		Xor	AL,AL
		Mov	DX,Offset CurrentPath	;the existing file
		Int	21h
		JNC	pms517
		Mov	DX,Offset DiskChgMsg
		Call	ShowErrMsg
		Jmp	CopySigErrExit

pms517:		Mov	ReadHandle,AX
		Call	CreateWritePath
		JC	CopyErrExit
ReadSome:	Mov	AH,3Fh			;read from file
		Mov	BX,ReadHandle
		Mov	CX,EditBytesToRead	;usually 64K
		Push	DS
		Mov	DS,EditBufSeg		;seg and
		Xor	DX,DX			; offset of buffer for data read
		Int	21h
		Pop	DS
		JC	CopyErrExit		;****NOT HANDLED
		Cmp	EscFlag,1
		JE	CopyErrExit
		Mov	CopyBytesRead,AX
		Mov	CX,AX
		Xor	DX,DX
		Call	EditBufWrite
		JC	CopyErrExit		;****NOT HANDLED
		Cmp	EscFlag,1
		JE	CopyErrExit
pms518:		Cmp	AX,CopyBytesRead
		JB	OutaSpace
		Mov	AX,CopyBytesRead
		Cmp	AX,EditBytesToRead
		JZ	ReadSome
		Mov	AH,3Eh			;close file
		Mov	BX,ReadHandle
		Int	21h
		Mov	AH,3Eh			;close file
		Mov	BX,WriteHandle
		Int	21h
		Mov	SI,Offset WritePath
		Call	SetXpath		;save for change to dest drive
		Xor	AH,AH			;signal no errors
		Jmp	Short CopyExit

OutaSpace:	Mov	DX,Offset NoSpaceDestStr
		Call	ShowErrMsg
CopyErrExit:	Mov	AH,3Eh			;close file
		Mov	BX,ReadHandle
		Int	21h
		Mov	AH,3Eh			;close file
		Mov	BX,WriteHandle
		Int	21h
		Mov	AH,41h			;delete file
		Mov	DX,DI
		Int	21h
CopySigErrExit:	Mov	AH,1
CopyExit:	Pop	DS
		Pop	ES
		Pop	BP
		Pop	DI
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Ret		;w/AH=1 if error, AL has lo byte DOS error
; - - - - - - - - - - - - - - -
CreateWritePath:Push	CS
		Pop	DS
		Mov	DX,Offset WritePath	;DS:DX > new file ASCIIZ
		Mov	CX,20h			;CL is File Attribute
		Mov	AH,3Ch			;create file
		Int	21h
		JC	CreateErr
		Mov	WriteHandle,AX
		Ret

CreateErr:	Push	AX
		Mov	DX,Offset AccessOrPathMsg
		Cmp	AL,5		;Access denied, file name same as Dir
		JZ	CreateErrExit
		Mov	DX,Offset DiskChgMsg
CreateErrExit:	Call	ShowErrMsg
		Pop	AX			;save error code
		STC
		Ret				;w/Carry set

; - - - - - - - - - - - - - - -
Rename:		Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	BP
		Push	SI
		Push	DI
		Push	ES
		Push	AX			;has 0 for Dir, 1 for File
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Call	CopyAsFullPath		;to CurrentPath
		Cmp	AX,1
		Pop	AX
		JNZ	LenOK7
		Jmp	RenameExit

LenOK7:		Or	AX,AX
		JZ	RenDir			;renaming a file
		Test	Byte Ptr ES:[BP],10h	;Z if a file, NZ if a Dir
		JZ	RenameOK
		Mov	DX,Offset RenDirMsg
		Call	ErrIfNovice
		Jmp	RenameExit

RenDir:		Test	Byte Ptr ES:[BP],10h	;Z if a file, NZ if a Dir
		JNZ	RenameOK
		Mov	DX,Offset NotaSubDirMsg
		Call	ErrIfNovice
		Jmp	RenameExit

RenameOK:	Push	ES
		Push	DS
		Pop	ES
		Call	CurToWritePath
		Mov	DI,Offset WritePath	;-- find the last '\' --
		Xor	AL,AL
		Mov	CX,50h
		RepNZ	ScasB
		Mov	AL,'\'
		Mov	CX,50h
		STD
		RepNZ	ScasB
		CLD
		Inc	DI
		Inc	DI
		Pop	ES
		Call	ClsTop2
		Mov	DX,Offset NewNameStr
		Xor	CX,CX
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,Offset EscExitsStr
		Inc	CH
		Mov	CL,0Eh
		Call	DisplayZ
		Call	EnterFName		;to [DI]
		JNC	pms519
		Jmp	RenameExit

pms519:		Push	ES
		Push	DI
		Push	DS
		Pop	ES
		Mov	DX,Offset CurrentPath	;old
		Mov	DI,Offset WritePath	;new
		Mov	AH,56h			;rename file or dir
		Int	21h
		Pop	DI
		Pop	ES
		JNC	FRenOK
		Cmp	AX,3
		JZ	Err3and11
		Cmp	AX,11h
		JNZ	pms520
Err3and11:	Mov	DX,Offset DiskChgMsg
		Call	ShowErrMsg
		Jmp	Short RenameExit

pms520:		Cmp	AX,5
		JNZ	pms521
		Mov	DX,Offset HasSameNameStr
		Call	ErrIfNovice
		Jmp	Short RenameExit

pms521:		Call	MakeBeepIf
		Jmp	Short RenameExit

FRenOK:		Call	WriteToCurPath		;new \path[\name] to CurrentPath
		Mov	GoEntryFlag,1		;go to CurrentPath
		Call	PaintMainScrn
RenameExit:	Pop	ES
		Pop	DI
		Pop	SI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - -
GoNextAndCopyName:
		Push	CX			;call w/HilitedEntry=23d
		Push	BP			;  start of list
		Push	SI
		Mov	ES,WorkingSeg
		Mov	BP,HilitedEntry
		Mov	CX,EntryLen23
pms522:		Add	BP,CX
		Cmp	BP,PastLastEntry
		Mov	AX,1
		JNB	pms523
		Mov	HilitedEntry,BP
		Test	Byte Ptr ES:[BP+22],80h	;Pip set ?
		JZ	pms522
		Call	ShowFilesList		;the Pip is on
		Call	CopyAsFullPath
		Cmp	AX,1			;path too long ?
		Mov	AX,0
		JNZ	pms523
		Mov	AH,1
pms523:		Pop	SI
		Pop	BP
		Pop	CX			;AH=1 if path too long
		Ret				;AL=1 if end
; - - - - - - - - - - - - - -
GoOptions:	Push	AX
		Push	BX
		Push	CX
		Push	BP
ShowOptMenu:	Mov	BX,1
		Mov	BP,Offset OptionsMenu
		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Drive
		JNZ	pms524
		Call	GoDrive
		Mov	AL,CurrDrvNo
		Mov	ErrDrvNo,AL
		Jmp	NoAskExit		;don't check for changes

pms524:		Cmp	CX,2			;toggle Beeps
		JNZ	TryColor
		Xor	BeepFlag,1
		Cmp	BeepFlag,1
		JNZ	ToEO
		Call	MakeBeepIf
ToEO:		Jmp	ExitOptions

TryColor:	Cmp	CX,3
		JNZ	TryUser
		Call	GoOptColor
		Jmp	Short ExitOptions

TryUser:	Cmp	CX,4			;User
		JNZ	ChkHid
		Call	GoUser
		Cmp	AL,Esc_			;<Esc> goes to Options
		JZ	ShowOptMenu
		Jmp	Short ExitOptions

ChkHid:		Cmp	CX,5			;Hidden
		JNZ	pms527
		Call	GoHidden
		Cmp	AL,Esc_			;<Esc> from goes to Options
		JZ	ShowOptMenu
		Jmp	Short ExitOptions

pms527:		Cmp	CX,6			;Status
		JNZ	TryOptPS
		Call	ShowStatus
		Jmp	Short NoAskExit

TryOptPS:	Cmp	CX,7			;Printer setup string
		JNZ	TryOptRCL
		Call	PrintSetup
		Cmp	AL,1			;<Esc> or EnterBHchars empty?
		JNZ	ExitOptions
		Cmp	PrinterStr,0		;was AL=1 due no chars ?
		JNZ	NoAskExit
		Jmp	Short ExitOptions	;do AskSave if no chars

TryOptRCL:	Cmp	CX,8			;Run command line
		JNZ	TryOptQ
		Call	GoRCL
		Jmp	Short ExitOptions

TryOptQ:	Cmp	CX,9			;Quit
		JZ	NoAskExit
		Cmp	AL,Esc_
		JZ	NoAskExit
		Jmp	ShowOptMenu

ExitOptions:	Call	AskWriteIf		;see if any changes made
NoAskExit:	Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret				;back to Main menu
; - - - - - - - - - - - - - -
;called exiting Editor Options and after Option
AskWriteIf:	Call	CompareCNFs
		JZ	AskRet
AskIt:		Mov	NoClsTop2Flag,0		;do clear both lines
		Mov	BX,1
		Mov	BP,Offset SaveOptMenu
ShowSaveOptMenu:CALL	ShowMenuAndWaitKey
		Cmp	CX,1			;Yes, save
		JNZ	AskRet
		Call	GoWrite
AskRet:		Ret

CompareCNFs:	Push	ES
		Push	SI
		Push	CS
		Pop	ES
		Mov	SI,Offset WorkingCNF
		Mov	DI,Offset SavedCNF
		Mov	CX,CNFlength
		RepZ	CmpsB
		JZ	CompRet
		Cmp	VideoSeg,0B000h		;on Mono screen ?
		JNZ	CompRet
		Mov	SI,Offset WorkingCNF	;Yes
		Mov	DI,Offset MonoAttrib
		Mov	CX,(Offset BeepFlag-Offset TextAttrib)
		RepZ	CmpsB
		JNZ	CompRet
		Mov	CX,(Offset SavedCNF-Offset BeepFlag)
		Mov	SI,Offset BeepFlag
		Mov	DI,Offset SavedBeep
		RepZ	CmpsB
CompRet:	Pop	SI
		Pop	ES
		Ret

; - - - - - - - - - - - - - -
GoUser:		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset OptUserMenu
pms528:		Call	ShowMenuAndWaitKey
		Cmp	CX,1
		JNZ	pms529
		Mov	NoviceFlag,1
		Jmp	Short pms532

pms529:		Cmp	CX,2
		JNZ	pms530
		Mov	NoviceFlag,0
		Jmp	Short pms532

pms530:		Cmp	CX,3			;Quit
		JNZ	pms531
		Mov	AL,Esc_			;to Options, not Main menu
pms531:		Cmp	AL,Esc_
		JNZ	pms528
pms532:		Pop	BP
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - -
GoHidden:	Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset OptHidMenu
ShowHidMenu:	Call	ShowMenuAndWaitKey
		Cmp	CX,1			;Show
		JNZ	Hid2
		Mov	AttribToSHow,17h
		Jmp	Short pms532

Hid2:		Cmp	CX,2			;Hide
		JNZ	Hid3
		Mov	AttribToShow,15h
		Jmp	Short pms532

Hid3:		Cmp	CX,3			;Quit
		JNZ	ChkHidEsc
		Mov	AL,Esc_			;to Options, not Main menu
ChkHidEsc:	Cmp	AL,Esc_
		JNZ	ShowHidMenu
		Jmp	pms532
; - - - - - - - - - - - - - -
GoRCL:		Push	BX			;Run with Command Line
		Push	CX
		Push	BP
		Mov	BX,1
		Mov	BP,Offset OptRCLmenu
ShowRCLmenu:	Call	ShowMenuAndWaitKey
		Cmp	CX,1
		JNZ	TryRCLyes
		Mov	RunCmdFlag,0
		Jmp	pms532

TryRCLyes:	Cmp	CX,2
		JNZ	Rclq
		Mov	RunCmdFlag,1
		Jmp	pms532

Rclq:		Cmp	CX,3			;Quit
		JNZ	Rclq2
		Mov	AL,Esc_			;to Options, not Main menu
Rclq2:		Cmp	AL,Esc_
		JNZ	ShowRCLmenu
		Jmp	pms532
; - - - - - - - - - - - - - -
GoDrive:	Push	BP
		Push	SI
		Push	AX
		Push	CX
		Push	DX
		Push	AX			;Copy/Ctrl-Drv: AH=dest-drv#
		Mov	AX,HilitedEntry
		Mov	OldHilited,AX
		Mov	AX,PastLastEntry
		Mov	OldEntryEnd,AX	;so file list works after ODA w/o disk
		Mov	AL,CurrDrvNo
		Mov	OldDrvNo,AL
		Mov	ErrDrvNo,AL		;save for Critical Error
	;copy current path to appropriate xPath buffer
		Mov	BP,HilitedEntry
		Call	CopyAsFullPath
		Mov	SI,Offset CurrentPath
		Call	SetXpath
		Pop	AX			;Copy/Ctrl-Drv: AH=dest drv no.
		Cmp	Sub1Drv2Root3,2		;doing File Copy Drive ?
		JNZ	NormalDrv
		Mov	DX,EditBufSeg
		Mov	WorkingSeg,DX		;to save source drive files list
		Jmp	Short DrvSkip

NormalDrv:	Cmp	CtrlFlag,0
		JNZ	DrvSkip			;AH already has drive
		Call	SelectDriveToAH
		Cmp	AL,Esc_
		JZ	pms533
DrvSkip:	Mov	DL,AH			;drive no.
		Mov	CurrDrvNo,AH
		Mov	AH,0Eh			;select drive
		Push	AX
		Int	21h			;this does NOT operate the drive
		Pop	AX
		Mov	GoEntryFlag,1		;go to CurrentPath or xPath
		Call	PaintMainScrn	;drive is accessed at GetVolAndFreeSpace
		Mov	AL,CurrDrvNo
		Mov	OldDrvNo,AL		;no Crit Err changing drive
pms533:		Pop	DX
		Pop	CX
		Pop	AX
		Pop	SI
		Pop	BP
		Ret

;call with SI > source path
SetXpath:	Mov	AL,[SI]
		Sub	AL,41h			;convert drive letter to no.
		Cmp	AL,4			;only have buffers for A:-E:
		JA	XpRet
		Mov	DI,Offset APath
		Xor	AH,AH
		Mov	DX,81
		Mul	DX
		Add	DI,AX
PathMov:	Mov	CX,80
		Push	ES
		Push	CS
		Pop	ES
		Rep	MovsB
		Pop	ES
XpRet:		Ret
; - - - - - - - - - - - - - - -
CurToWritePath:	Mov	SI,Offset CurrentPath
		Mov	DI,Offset WritePath
		Jmp	Short PathMov

WriteToCurPath:	Mov	SI,Offset WritePath
		Mov	DI,Offset CurrentPath
		Jmp	Short PathMov
; - - - - - - - - - - - - -
SelectDriveToAH:PUSH	BX			;2 calls
		Push	CX
		Push	DX
		Push	BP
		Push	DI
		Push	SI
		Mov	AH,0Eh			;select drive
		Mov	DL,CurrDrvNo
		Int	21h			;returns LASTDRIV in AL
		Mul	DLength			;must match list
		Add	AX,Offset DrivesList
		Mov	SI,AX
		Mov	AH,[SI]
		Mov	LastDrvPlus1,AH
		Mov	Byte Ptr [SI],0FFh	;display only up to LASTDRIV
		Mov	BX,1
pms534:		Mov	BP,Offset SelDriveMenu
		Call	ShowMenuAndWaitKey
		Cmp	AL,Esc_
		JZ	NotDriveB
		Or	CX,CX			;invalid letter hit ?
		JZ	pms534
		Mov	AH,LastDrvPlus1
		Mov	[SI],AH			;replace the end marker
		Mov	AH,CL			;menu item no.
		Sub	AH,1			;drive no, 0=A:
		Cmp	AH,1			;drive B: ?
		JNZ	NotDriveB
		Push	AX
		Int	11h			;get equip. list
		And	AX,0C0h			;bits 7 & 6, no of floppies
		Or	AX,AX
		Pop	AX
		JNZ	NotDriveB
		Mov	DX,Offset NoDrvBmsg
		Call	ShowErrMsg
		Jmp	Short pms534

NotDriveB:	Pop	SI
		Pop	DI
		Pop	BP
		Pop	DX
		Pop	CX
		Pop	BX
		Ret				;w/AH = drive no. (0=A:)
; - - - - - - - - - - - -
GoOptColor:	Push	AX
		Push	BX
		Push	CX
		Push	BP
		Mov	BX,1
pms535:		Mov	BP,Offset ColorsMenu
		Call	ShowMenuAndWaitKey
		Cmp	CL,1
		JB	pms536
		Cmp	CL,11
		JE	RestoreOrig
		JA	pms536
		Call	GetAttrib		;with CX = which attrib
		Jmp	Short pms536

RestoreOrig:	Push	SI			;-- restore Default colors --
		Push	DI			;store colors to CNFbuf's and
		Push	ES			; .COM file.  This will also
		Push	DS			;  save any temporary options
		Pop	ES
		Cld
		Mov	DI,Offset WorkingCNF
		Mov	SI,Offset ColorAttrib	;only ref
		Mov	CX,(Offset BeepFlag-Offset WorkingCNF)
		Cmp	VideoSeg,0B000h		;Mono ?
		JNZ	StoreColors
		Mov	SI,OFFSET MonoAttrib
StoreColors:	REP	MovsB
		Call	GoWrite			;copy WorkingCNF to SavedCNF
		Pop	ES
		Pop	DI
		Pop	SI
		Call	QuickPaint
		Jmp	Short OptColorExit

pms536:		Cmp	AL,Esc_
		JNZ	pms535
OptColorExit:	Pop	BP
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

; - - - - - - - - - - - - - - - - - - - -
PrintSetup:	Push	BX
		Push	CX
		Push	DX
		Push	SI
		Call	ClsTop2
		Xor	CX,CX
		Mov	DX,Offset PrintSetStr
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,PScursor
		Mov	CursorLocn,DX
		Mov	DX,Offset PrinterStr
		Inc	CH			;row 1, 2nd row
		Xor	CL,CL			;column 0
		Mov	BH,12			;chars to input
		Mov	InputFlag,2		;F10=<Esc>, accept any char
		Mov	AllCharsFlag,1
		Call	InputBHchars
		Mov	InputFlag,0
		Mov	CX,CursorLocn
		Mov	PScursor,CX
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Ret				;w/AL=1 if <Esc> hit or no chars
; - - - - - - - - - - - - - - - - - - - -
ShowStatusScreen:
		Push	BX
		Push	CX
		Push	DX
		Push	ES
		Mov	ViewFlag,0
		Call	VertLine		;only call
		Call	ClsRightHalf
		Mov	DX,Offset SysStatus
		Mov	BL,InverseAttrib
		Mov	CX,329h			;Row 3, Col 41
		Call	DisplayZ
		Mov	DX,Offset DrvStatus
		Mov	CH,7
		Call	DisplayZ
		Mov	DX,Offset MemStatusStr
		Mov	CH,13
		Call	DisplayZ
		Mov	DX,Offset VolLbl
		Mov	CX,82Ah			;Row 8,Col 42
		Mov	BL,FileAttrib
		Call	DisplayZ
		Mov	DX,Offset StorgTotal
		Mov	CH,9
		Call	DisplayZ
		Mov	DX,Offset StorgUsed
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset StorgFree
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset SizeCluster
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset RAMtotlStr
		Mov	CH,14			;row
		Call	DisplayZ
		Mov	DX,Offset RAMusedStr
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset RAMfreeStr
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset ExtTotStr
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset XMSfreeStr
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset EMStotStr
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset EMSfreeStr
		Inc	CH
		Call	DisplayZ
		Mov	DX,Offset RAMdrvStr
		Inc	CH
		Call	DisplayZ
		Call	PaintStatusData
		Pop	ES
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - - -
ShowDateScreen:	Push	BX
		Push	CX
		Push	DX
		Mov	DX,Offset HorBar	;single '', only ref
		Mov	BL,MenuAttrib
		Mov	CX,1728h			;Row 23, Col 40
		Call	DisplayZ
		Mov	DX,Offset DateTimeHeader	;only ref
		Mov	CH,3
		Mov	BL,InverseAttrib
		Call	DisplayZ
		Mov	ViewFlag,1
		Call	ShowFilesList
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - - -
ShowStatus:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	ES
		Push	CS
		Pop	ES
		Mov	SI,Offset ShownStr
		Cmp	AttribToShow,17h
		JZ	pms538
		Mov	SI,Offset HidStr
pms538:		Mov	DI,Offset HideOrShow
		Mov	CX,6
		Rep	MovsB
		Mov	SI,Offset OFFstr
		Cmp	BeepFlag,0
		JZ	pms539
		Mov	SI,Offset ONstr
pms539:		Mov	DI,Offset SoundOnOff
		Mov	CX,3
		Rep	MovsB
		Mov	SI,Offset Expert
		Cmp	NoviceFlag,0
		JZ	pms540
		Mov	SI,Offset Novice
pms540:		Mov	DI,Offset NovOrExp
		Mov	CX,6
		Rep	MovsB
		Mov	SI,Offset SavedYes
		Call	CompareCNFs
		JZ	pms541
		Mov	SI,Offset SavedNo
pms541:		Mov	DI,Offset SavedYesNo
		Mov	CX,3
		Rep	MovsB
		Mov	SI,Offset EightySpaces
		Mov	CX,7
		Rep	MovsB
		Mov	SI,Offset PrinterStr
		Mov	CX,13
		Rep	MovsB
		Call	ClsTop2
		Mov	DX,Offset StatusHeader
		Xor	CL,CL
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,Offset HideOrShow
		Mov	BL,TextAttrib
		Inc	CH
		Call	DisplayZ
		Mov	AH,3			;do kbd buffer flush, use mouse
		Call	WaitKey			;wait for any key
		Pop	ES
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - -
GoWrite:	Push	AX			;save config in the .COM file
		Push	BX
		Push	CX
		Push	DX
		Push	SI
		Push	DI
		Push	ES
		Push	CS
		Pop	ES
		Mov	DI,Offset SavedCNF
		Mov	SI,Offset WorkingCNF
		Mov	CX,CNFlength
		Rep	MovsB
		Call	FindEnvPath
		Mov	DX,DI			;DS:DX points to path string
		Mov	AH,3Dh			;open file
		Mov	AL,1			;write only
		Int	21h
		Push	AX			;the handle
		Xchg	AX,BX
		Mov	AX,4200h		;move file pointer to CX:DX
		Xor	CX,CX
		Mov	DX,Offset WorkingCNF
		Sub	DX,100h
		Int	21h
		Pop	BX
		Push	BX			;the handle
		Push	CS
		Pop	DS
		Mov	CX,CNFlength
		ShL	CX,1			;write both working & saved bfrs
		Mov	DX,Offset WorkingCNF	;DS:DX points to data to write
		Mov	AH,40h			;write to file
		Int	21h
		Mov	AH,3Eh			;close file
		Pop	BX			;handle
		Int	21h
		Pop	ES
		Pop	DI
		Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - - - -
;This is the only ref to these 3 box chars
VertLine:	Push	BX
		Push	CX
		Push	DX
		Mov	DX,Offset TopTee
		Mov	CX,328h			;Row 3, Col 40
		Mov	BL,MenuAttrib
pms543:		Call	DisplayZ
		Mov	DX,Offset VertBar
		Mov	BL,MenuAttrib
		Cmp	CH,23
		JNB	pms544
		Cmp	CH,12
		JNZ	SameVert
		Mov	BL,HilitDirAttrib
		Mov	DX,Offset DnArrow
SameVert:	Inc	CH
		Jmp	Short pms543

pms544:		Mov	DX,Offset BottomTee
		Call	DisplayZ
		Pop	DX
		Pop	CX
		Pop	BX
		Ret
; - - - - - - - - - - - - - - - - - -
GetAttrib:	Push	AX
		Push	BX
		Push	CX
		Push	DX
		Push	DI
		Push	ES
		Push	DS
		Pop	ES
		Mov	WhichAttrib,CX
	;point to attribute string by counting zeros
		Mov	CX,WhichAttrib
		Dec	CX			;starts at 1 for Text
		ShL	CX,1			;CX * 2
		Mov	DI,Offset ColorsMenu
		Inc	DI
		Mov	WhichColor,DI
		Or	CX,CX
		JZ	SetAttrib
		Xor	AL,AL
PointAtLoop:	Push	CX
		Mov	CX,1000
		RepNZ	ScasB
		Pop	CX
		Loop	PointAtLoop
		Mov	WhichColor,DI

SetAttrib:	Call	ClsTop2			;-- Display help msg --
		Xor	CX,CX			;at row 0 col 0
		Mov	BL,MenuAttrib
		Mov	DX,Offset UseArrowMsg
		Call	DisplayZ
		Mov	DI,(Offset TextAttrib-1);-- Get current attrib --
		Add	DI,WhichAttrib
		Mov	BL,DS:[DI]		;-Show string in current color-
		Mov	CX,0070			; at row 0 col 70
		Mov	DX,WhichColor
		Call	DisplayZ
		Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey
		Cmp	AH,0FFh			; 0FFh is a mouse click
		JNZ	SetAtKey		; If not a click
		Cmp	AL,1			; Check LB
		JNE	SetAtMB			; No: must be MB
		Mov	AX,4800h		; LB: simulate <Up>
		Jmp	Short SetAtKey
SetAtMB:	Mov	AX,4D00h		; MB: simulate <Right>
SetAtKey:	Or	AL,AL			;special key ?
		JZ	Recolor
		Cmp	AL,Esc_
		JZ	SetAtDone
		Cmp	AL,CR
		JNZ	SetAttrib
SetAtDone:	Pop	ES
		Pop	DI
		Pop	DX
		Pop	CX
		Pop	BX
		Pop	AX
		Ret

Recolor:	Mov	BL,DS:[DI]		;Get current attribute
		Mov	BH,BL
		And	BX,0F00Fh		;FG in BL, BG in BH
		Cmp	AH,50h			;<Down> arrow
		JNE	IncFG
		Sub	BL,1			;Prev FG color
		JNC	AttribRtns
		Mov	BL,0Fh
		Jmp	Short AttribRtns
IncFG:		Cmp	AH,48h			;<Up> arrow
		JNE	DecBG
		Inc	BL			;Next FG color
		Cmp	BL,10h
		JB	AttribRtns
		Xor	BL,BL
		Jmp	Short AttribRtns
DecBG:		Cmp	AH,4Bh			;<Left> arrow
		JNE	IncBG
		Sub	BH,10h			;Prev BG color
		JNC	AttribRtns
		Mov	BH,70h
		Jmp	Short AttribRtns
IncBG:		Cmp	AH,4Dh			;<Right> arrow
		JNE	ToggleBlink
		Add	BH,10h			;Next BG color
		Cmp	BH,80h
		JB	AttribRtns
		Xor	BH,BH
		Jmp	Short AttribRtns
ToggleBlink:	Cmp	AH,52h			;<Ins> key
		JNE	AttribRtns
		Xor	BH,80h			;Toggle blink on/off

AttribRtns:	Or	BL,BH			;Combine BG and FG
		Mov	DS:[DI],BL
		Call	QuickPaint
		Jmp	SetAttrib

; - - - - - - - - - - - - - -
QuickPaint:	Call	PaintBlankScreen
		Call	PaintStatusOrDateScrn
		Call	ShowFilesList
		Cmp	DS:ViewFlag,0		;0=Status screen
		JNZ	QRet
		Call	ShowStatusScreen
QRet:		Ret
; - - - - - - - - - - - - - -
GetDecToAL:	Push	BX
		Push	CX
		Push	DX
		Push	SI
		Mov	WORD PTR CCbuf,0031h	;'1',0
		Mov	CursorLocn,1
		Mov	DX,Offset CCbuf
		Mov	SI,Offset DecChars
		Mov	BH,2
		Mov	InputFlag,3		;1st char overwrites default '1'
		Call	InputBHchars
		Cmp	AH,0FFh			;<Esc> hit ?
		JZ	DecToDone
	;convert decimal to register byte
		Mov	AX,WORD PTR CCbuf	;bytes are backwards
		Or	AX,AX			;blank or zero entry ?
		JZ	DecToDone
		Or	AH,AH
		JNZ	TwoChars
		Xchg	AH,AL
		Mov	AL,'0'
TwoChars:	Sub	AX,3030h		;convert from ASCII
		Mov	CH,AH			;lo byte
		Xor	AH,AH
		Mov	BX,10
		Mul	BX
		Add	AL,CH
DecToDone:	Pop	SI
		Pop	DX
		Pop	CX
		Pop	BX
		Ret				;w/AH=1 if error, else AL=number
; - - - - - - - - - - - - - -
YesNoIf:	Cmp	NoviceFlag,1
		JZ	YesNo
		Mov	AX,1
		Ret

YesNo:		Push	BX
		Push	CX
		Push	BP
pms545:		Mov	BP,Offset ConfirmMenu
		Mov	BX,1
		Call	ShowMenuAndWaitKey
		Cmp	CX,1			;No
		JZ	pms546
		Cmp	CX,2			;Yes
		JZ	pms546
		Mov	CX,1
		Cmp	AL,Esc_
		JZ	pms546
		Call	MakeBeepIf
		Jmp	Short pms545

pms546:		Xchg	AX,CX
		Dec	AX
pms547:		Pop	BP
		Pop	CX
		Pop	BX
		Ret				;w/AX=0 for No/<Esc>, 1 for Yes
; - - - - - - - - - - - - -
;Called 3 times, by Run, CmndDOS and Ap Menu routines. Uses INT 2Eh.
;RunFlag=1 for Run, 0 for all others
;DirFlag=0 for Ap w/squiggly on 2nd line, 1 w/dir given, 2 w/empty 2nd line
;ApFlag is non-0 for all Ap items.
;The Dir-To-Be-In is [the 1st part of] WritePath for all 5 possibilities.
;When run, DI points to the length byte in front of the command line.
; DI=>ApBuf for Ap items & Run w/cmd line, CmdDOSbufn, or in WritePath for Run.
RunPgm:		Mov	CS:RunFlag,1
		Jmp	Short GoRun
RunDOS:		Mov	CS:RunFlag,0
GoRun:		Push	AX
		Push	BX
		Push	BP
		Push	CX
		Push	DI
		Push	DS
		Push	DX
		Push	ES
		Push	SI
		Push	CS
		Pop	DS
		Mov	ES,WorkingSeg
		Mov	AL,CurrDrvNo
		Mov	OldDrvNo,AL	;so returns at CurrentPath, not xPath
		Mov	BP,HilitedEntry
		Cmp	RunFlag,0		;1=Run, 0=CmdDOS or Ap item
		JZ	RunAndCmdDOS
		Test	Byte Ptr ES:[BP],10h	;trying to run a directory ?
		JZ	RunAndCmdDOS
		Jmp	ShowOnlyExeMsg

RunAndCmdDOS:	Call	CopyAsFullPath		;BP is HilitedEntry to CurrPath
		Cmp	AX,1
		JNZ	LenOK9
		Jmp	RunIsDone

LenOK9:		Cmp	DirFlag,0		;doing Ap item not FS ?
		JZ	UseHilitPath
	; DirFlag is 1 or 2, we are doing an Ap. WritePath has
	;  dir-to-be-in.  Check the drive
		Mov	DI,Offset WritePath
		Mov	DL,[DI]
		Inc	DI
		Cmp	Byte Ptr [DI],':'
		JNZ	OnADir
		And	DL,0DFh			;make upper-case
		Sub	DL,41h			;make drive no. (A:=0)
		Jmp	ApDir

UseHilitPath:	Call	CurToWritePath	;leave CurrentPath for return after run
		Test	Byte Ptr ES:[BP],10h
		JNZ	OnADir
	; find the end of WritePath
		Mov	DI,Offset WritePath-1
pms548:		Inc	DI
		Cmp	Byte Ptr [DI],0
		JNZ	pms548
		Mov	NameToRunEnd,DI
	;go back to the last backslash
pms549:		Dec	DI
		Cmp	Byte Ptr [DI],'\'
		JNZ	pms549
	; terminate WritePath at last backslash (or end, for Ap item)
		Mov	Byte Ptr [DI],0
OnADir:		Mov	DL,CurrDrvNo		;0=A:, 1=B:, etc
ApDir:		Mov	AH,0Eh			;select drive
		Int	21h
		Mov	AH,3Bh			;change dir
		Mov	DX,Offset BkSlash	;path to change to
		Int	21h
		Mov	AH,3Bh			;change dir
		Mov	DX,Offset WritePath
		Int	21h
		Cmp	RunFlag,0
		JNZ	RunOnly
		Cmp	ApFlag,0
		JNZ	UseApBuf	     ;skip manual entry for Applic-Run
		Jmp	CmdDosEntry

UseApBuf:	Mov	DI,Offset ApBuf
		Jmp	ApJmp

RunOnly:	Inc	DI
		Mov	NameToRunPtr,DI	  ;points in WritePath to 1st of pgm.ext
		Mov	DI,NameToRunEnd
		Call	CheckRunable
		JC	ShowOnlyExeMsg		; If not runable
		Cmp	RunCmdFlag,1
		JZ	RunWithCmd
		Mov	DI,NameToRunPtr		;points name in WritePath
		Dec	DI
		Jmp	ApJmp

RunWithCmd:	Push	ES		;first, copy pgm name.ext to ApBuf+1
		Push	CS
		Pop	ES
		Mov	SI,NameToRunPtr
		Mov	CX,NameToRunEnd
		Sub	CX,SI
		Mov	DI,Offset ApBuf+1
		Rep	MovsB
		Mov	AX,20h			;' ',0
		StosW
		Dec	DI		;now DI>just past pgm name.ext, space
		Push	DI			;to check for null entry
		Mov	MsgPtr,Offset ApBuf+1
		Call	ShowCmdLn		;rtns AL=1 if <Esc> or no entry
		Pop	CX			;orig. DI
		Pop	ES
		Cmp	AH,0FFh		;<Esc> hit in InputBHchars in ShowCmdLn?
		JZ	ToRDn
		Mov	DI,Offset ApBuf
		Jmp	ApJmp

ShowOnlyExeMsg:	Mov	DX,Offset OnlyEXEmsg
		Call	ShowErrMsg
ToRDn:		Jmp	RunIsDone
; - - - - - - - - - - - -
CheckRunable:	Push	CX			; DI points to end of FileName
		Push	ES
		Push	SI
		Push	CS			; ES = CS
		Pop	ES
CheckRunDot:	Dec	DI			;backup to the '.'
		Cmp	Byte Ptr [DI],'.'
		JNZ	CheckRunDot
		Inc	DI			;to char after the '.'
		Push	DI
		Mov	CX,3
CheckRunLoop:	Pop	SI			; Check for COM, EXE or BAT
		Push	SI			; Set SI to FileExt (from DI)
		Push	CX
		Mov	DI,Offset ComExeBat+12
		Shl	CX,1
		Shl	CX,1
		Sub	DI,CX
		Mov	CL,3
		RepE	CmpsB
		Pop	CX
		CLC
		JE	CheckRunRtn		; If Ext matches
		Loop	CheckRunLoop
		STC				; If not COM, EXE or BAT
CheckRunRtn:	Pop	DI
		Pop	SI
		Pop	ES
		Pop	CX
		Ret
; - - - - - - - - - - - -
CmdDosEntry:	Mov	InputFlag,1	;signal InputBHchars to check  keys
		Call	ClsTop2
		Xor	CX,CX
		Mov	DX,Offset TypeCmdMsg
		Mov	BL,MenuAttrib
		Call	DisplayZ
CDscroll:	Mov	BL,HilitDirAttrib
		Mov	DX,Offset CmdDOSbuf1+1
		Mov	CH,1
CDloop:		Cmp	CH,WhichCmd
		JNZ	NotThisCmd
		Mov	CmdPtr,DX
		Jmp	Short CDskip
	;fill the line with inverse blanks
NotThisCmd:	Push	ES
		Push	DX
		Push	CX
		Push	CS
		Pop	ES
		Mov	CX,79
		Mov	AL,' '
		Mov	DI,Offset StatsAndCopyPath
		Rep	StosB
		Mov	Byte Ptr [DI],''
		Inc	DI
		Mov	Byte Ptr [DI],0
		Pop	CX
		Mov	DX,Offset StatsAndCopyPath
		Call	DisplayZ
	;show the buffer
		Pop	DX
		Pop	ES
		Call	DisplayZ
CDskip:		Cmp	CH,3
		JZ	ShoAct
		Inc	CH
		Add	DX,82			;point to next buffer
		Jmp	CDloop

	;now show the active line
ShoAct:		Mov	BX,Offset CDcursor1
		Mov	AL,WhichCmd
		Dec	AL
		Xor	AH,AH
		ShL	AX,1			;AX=(WhichCmd-1) * 2
		Add	BX,AX
		Mov	AX,[BX]
		Mov	CursorLocn,AX
		Push	BX
		Mov	DX,CmdPtr
		Mov	AllCharsFlag,1
		Mov	CH,WhichCmd		;row
		Xor	CL,CL			;column 0
		Mov	BH,79			;no. of chars
		Call	InputBHchars
		Pop	BX
		Mov	DX,CursorLocn
		Mov	DS:[BX],DX
		Cmp	AL,1			;<Esc> hit, or no chars entered?
		JNZ	ChkScroll
		Call	PaintBlankScreen
		Call	PaintStatusOrDateScrn
		Call	ShowFilesList
		Jmp	RunIsDone

ChkScroll:	Cmp	AL,2
		JNZ	ChkUp
		Cmp	WhichCmd,3
		JNZ	NoCD2
		Jmp	CDscroll

NoCD2:		Inc	WhichCmd
		Jmp	CDscroll

ChkUp:		Cmp	AL,3
		JNZ	pms554
		Cmp	WhichCmd,1
		JNZ	NoCDs
		Jmp	CDscroll

NoCDs:		Dec	WhichCmd
		Jmp	CDscroll

pms554:		Mov	DI,CmdPtr
		Dec	DI
	;set up for Run, CmdDOS or Ap
ApJmp:		Push	DI			;points Length byte dest
		Inc	DI
		Xor	CX,CX			;get the length byte
pms555:		Cmp	Byte Ptr [DI],0
		JZ	pms556
		Inc	CX
		Inc	DI
		Jmp	Short pms555

pms556:		Mov	CmdDOS_EndPtr,DI	;save locn to replace the 0
		Mov	Byte Ptr [DI],CR ;req'd by DOS, but screws up editing
		Pop	DI			;CmdPtr or ApBuf
		Mov	[DI],CL			;length byte
		Mov	SI,DI			;point to len byte & cmd line
		Call	RestoreOldINT23and24
		Call	Cls
		Mov	AH,2			;set cursor position
		Xor	DX,DX
		Mov	BH,0
		Int	10h
		Mov	ES,MenuSeg
		Mov	AH,49h			;free allocated RAM
		Int	21h
		Mov	ES,EditBufSeg
		Mov	AH,49h			;free allocated RAM
		Int	21h
		Mov	ES,WorkingSeg
		Mov	AH,49h			;free allocated RAM
		Int	21h
		Mov	BufferSP,SP
		Mov	RunningFlag,1

		Int	2Eh			;'back door' to DOS

		Mov	CX,CS
		Mov	DS,CX
		Mov	SS,CX
		CLD
		Mov	RunningFlag,0
		Mov	SP,BufferSP
	;INT 2Eh does not return errors, and Func 59h doesn't work here either
		Cmp	HotFlag,1
		JNZ	NotHot
		Mov	HotFlag,0
		Call	HotBoot
NotHot:		Mov	DI,CmdDOS_EndPtr
		Mov	Byte Ptr [DI],0		;so field will edit normally
		Mov	AH,0Eh			;select drive
		Mov	DL,CurrDrvNo		;0=A:, 1=B:, etc
		Int	21h
;the files list has been overwritten, unlike when exiting the Editor.
;CurrentPath holds d:\path\path\fname.ext,0,0... of hilited entry
;On the Root dir, it holds d:,0,0...,  in the Root it holds d:\fname.ext,0,0...
		Mov	AH,3Bh			;change dir
		Mov	DX,Offset BkSlash
		Int	21h
	;this is the wait after run.
		Cmp	ApFlag,0
		JZ	RunWait
		Cmp	WaitFlag,0
		JZ	NoWait
RunWait:	Mov	AH,2			;set crsr position
		Mov	BH,0
		Mov	DH,25			;off the screen
		Int	10h
		Mov	CX,1800h		;Row 24, Col 0
		Mov	BL,InverseAttrib
		Mov	DX,Offset PressKeyMsg
		Call	DisplayZ
		Mov	NoClsTop2Flag,1		;keeps time from showing
		Mov	AH,2			;no kbd buffer flush, use mouse
		Call	WaitKey			;wait for any key
		Mov	NoClsTop2Flag,0
NoWait:		Call	AllocRAM
		Call	LoadMenu
		Call	SetNewINT23and24h
		Call	SetCrsrAndVideoSeg	;INT 10h does a Cls
		Call	PaintBlankScreen
		Mov	GoEntryFlag,1	   ;go back to CurrentPath (drv is same)
		Call	PaintMainScrn
		Call	PaintStatusOrDateScrn
		Call	InitMouse
RunIsDone:	Mov	InputFlag,0
		Pop	SI
		Pop	ES
		Pop	DX
		Pop	DS
		Pop	DI
		Pop	CX
		Pop	BP
		Pop	BX
		Pop	AX
		Ret
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ShowWait:	Push	BX
		Push	CX
		Push	DX
		Mov	CX,046h			;Row 0, Col 70
		Mov	DX,Offset ThreeBlanks
		Mov	BL,MenuAttrib
		Call	DisplayZ
		Mov	DX,Offset WaitMsg
		Mov	CL,73			;column
		Mov	BL,InvMenuAttrib
		Xor	BL,80h			;make it flash
		Call	DisplayZ
		Pop	DX
		Pop	CX
		Pop	BX
		Ret

EndPgm	DW	0

		CSEG	ENDS
END	Start
