{ Example for Fast Fourier Transform Unit PasFFT       }
{ (c)1994 by Alex Klimovitski                          }

{ This program reads some complex numbers from a
  text file, performs fast Fourier transform and writes
  the result in another text file.
  The text file format:

  <number of points>
  <real part 1> <imaginary part 1>
  <real part 2> <imaginary part 2>
  .......

  Check, wether it's really fast! You can use file
  FFTTEST.DAT with 64 complex points (numbers).        }

program FFTTest;

uses WinCrt, PasCmplx, PasFFT;
{ Delete 'WinCrt' if your target is DOS or DPMI }

function ReadFile(FName: PChar; var N: Integer; var X: PCmplxArr): Boolean;
var
  F: Text;
  I: Integer;
  A, B: Double;
begin
  ReadFile := false;
  X := nil;
  {$I-}
  Assign(F, FName);
  Reset(F);

  ReadLn(F, N);
  GetMem(X, N * SizeOf(Complex));

  for I := 1 to N do
  begin
    ReadLn(F, A, B);
    X^[I] := Cmplx(A, B);
  end;

  Close(F);
  {$I+}

  if IOResult = 0 then
    ReadFile := true
  else if X <> nil then
    FreeMem(X, N * SizeOf(Complex));
end;  { ReadFile }

function WriteFile(FName: PChar; N: Integer; X: PCmplxArr): Boolean;
var
  F: Text;
  I: Integer;
begin
  {$I-}
  Assign(F, FName);
  Rewrite(F);

  WriteLn(F, N);
  for I := 1 to N do
    WriteLn(F, CReal(X^[I]), ' ', CImag(X^[I]));

  Close(F);
  {$I+}

  if IOResult = 0 then ;
end;  { WriteFile }

var
  X: PCmplxArr;
  N: Integer;
  A: Char;
  FName: array[0..79] of Char;
begin
  Write('Filename for Input>');
  ReadLn(FName);
  if not ReadFile(FName, N, X) then
  begin
    WriteLn('Can''t read file ', FName);
    Halt(255);
  end;

  Write('Mode (D)irect/(I)nverse>');
  ReadLn(A);

  if not CFFT(N, (A = 'I') or (A = 'i'), X, 1.0) then
  begin
    WriteLn('Can''t perform FFT', FName);
    if X <> nil then
      FreeMem(X, N * SizeOf(Complex));
    CFFTClear;
    Halt(254);
  end;

  Write('Filename for Output>');
  ReadLn(FName);
  WriteFile(FName, N, X);

  FreeMem(X, N * SizeOf(Complex));
end.
