;
;  This is a program to inquire into the existence and, if found,
;  the status of any installed mouse in an MS-DOS computer.  As of
;  May, 1991 it is as up-to-date as possible in being able to detect
;  different types of mice and displaying all useful information about
;  their capabilities and configurations.  This is written in
;  Borland Turbo Assembler's "Ideal" mode and is designed as a .COM
;  program.  It could be designed as an .EXE program, but the
;  state buffer must be saved before the call to determine its
;  length can be determined.  Therefore, in the .COM version the
;  buffer can be placed at the end of the code, and may take whatever
;  memory it will, occupying no space in the mirror image disk file.
;  An .EXE program would have to reserve buffer space large enough
;  to accomodate the largest possible buffer, an unknown size.
;
;  It should be assembled with TASM and linked with the /T
;  switch, i.e. TLINK /T MOUSERPT.  The program first checks to
;  make sure the mouse interrupt is not pointing to a 'zero' vector
;  (which would cause a crash when called) and then saves its current
;  state, does a hardware reset, calls several inquiry functions,
;  resets the found state, checks the language, then issues the report.
;  If the mouse interrupt (33h) points to zero, or the check reports
;  no mouse, the program displays a 'no-mouse' message and quits.
;
;  Written by  Tom Gilbert - May, 1991
;  Send comments or inquiries to Rick Housh, CIS 72466,212
;
IDEAL
SEGMENT _TEXT
ASSUME  cs:_TEXT,ds:_TEXT,ss:_TEXT,es:NOTHING
ORG     100h
Begin:  jmp Start
        db 13,'Heart&Mind Mouse Report',26
Types   db 'Bus     Serial  InPort  PS-2    Hew-Pack'
M_Lang  db 'English   French    Dutch     German    Swedish   '
        db 'Finnish   Spanish   Portugese Italian   '
NoMouse db '...................Mouse not installed...................'
NewLine db 13,10,10 DUP(' ')    ; Col 11 + 57 = 68 right margin
TopLine db 'Ŀ'
        db '                   Mouse Information                   '
        db 'Ĵ'
ButLine db '     Buttons:                                          '
BufLine db '     Buffer:                                           '
HS_Line db '     Horizontal sensitivity:        mickeys/pixel      '
VS_Line db '     Vertical sensitivity:          mickeys/pixel      '
DstLine db '     Double speed threshold:        mickeys/second     '
DV_Line db '     Driver version:              .                    '
TypLine db '     IRQ used/Mouse type:         /Unknown             '
Tongue  db '     Mouse Language:           Unknown                 '
        db 'Ĵ'
        db '                     By Tom Gilbert                    '
BotLine db ''

NoFind: mov  dx,OFFSET NoMouse          ; Display "Mouse not
        mov  cx,1                       ; installed" message line
        jmp  ShoOff                     ; and Return to MS-DOS

Start:  mov  ax,3533h                   ; Get Mouse Interrupt Address
        int  21h
        mov  ax,es                      ; Copy Segment for Test
        or   ax,bx                      ; If address UNassigned
        jz   NoFind                     ; Then "Mouse not installed"
        push ds                         ; Else Restore Extra
        pop  es                         ; Segment to _TEXT
ASSUME  es:_TEXT
        mov  dx,OFFSET MS_Buff          ; Point es:dx to buffer
        mov  ax,16h                     ; Save Mouse
        int  33h                        ; Driver Status
        xor  ax,ax
        int  33h                        ; Reset Mouse Driver and
        inc  ax                         ; If NOT a Minus 1 Return
        jnz  NoFind                     ; Then "Mouse not installed"
        mov  ax,bx                      ; Else Store number of
        mov  bx,OFFSET ButLine + 34     ; Buttons on the mouse
        call StoreDigits
        mov  ax,15h                     ; Request Buffer Size
        int  33h
        mov  ax,bx                      ; Store Decimal
        mov  bx,OFFSET BufLine + 34     ; Buffer Size
        call StoreDigits
        mov  ax,1Bh                     ; Request Mickeys
        int  33h
        mov  ax,bx                      ; Store Number of
        mov  bx,OFFSET HS_Line + 34     ; Horizontal Mickeys
        call StoreDigits
        mov  ax,cx                      ; Store Number of
        mov  bx,OFFSET VS_Line + 34     ; Vertical Mickeys
        call StoreDigits
        mov  ax,dx                      ; Store Number of
        mov  bx,OFFSET DstLine + 34     ; Double Speed Threshold
        call StoreDigits                ; Mickeys/Second
        mov  ax,24h
        int  33h                        ; Request Driver Version
        push cx                         ; IRQ and Mouse Type
        mov  ax,bx
        push ax                         ; Save Minor Version Number
        mov  cx,8
        shr  ax,cl                      ; Isolate and
        mov  bx,OFFSET DV_Line + 34     ; Store Major
        call StoreDigits                ; Version Number
        pop  ax
        xor  ah,ah                      ; Isolate and
        mov  bx,OFFSET DV_Line + 36     ; Store Minor
        cmp  al,10                      ; Version Number
        jbe  Pos_Ok                     ; positioned for one
        inc  bx                         ; or two digits
Pos_Ok: call StoreDigits
        pop  ax                         ; Recover IRQ and Type
        or   al,al                      ; If Zero IRQ
        jz   DoType                     ; Then Leave Blank
        push ax                         ; Else Preserve Type
        xor  ah,ah                      ; Isolate IRQ
        mov  bx,OFFSET TypLine + 34     ; Store Number
        call StoreDigits                ; and recover
        pop  ax                         ; Zero based Type
DoType: shr  ax,cl                      ; Isolated in AX
        or   al,al                      ; If Zero
        jz   NoType                     ; Or If Above
        cmp  al,(M_Lang-Types) / 8      ; Known Type
        ja   NoType                     ; Then "Unknown"
        dec  al                         ; Else Make base 1
        mul  cl
        mov  si,OFFSET Types            ; Calculate Offset
        add  si,ax                      ; adjusted for type #
        mov  di,OFFSET TypLine + 36     ; and copy 8 type bytes
        rep  movsb
NoType: mov  ax,17h                     ; Restore Mouse
        mov  dx,OFFSET MS_Buff          ; Driver State
        int  33h
        mov  ax,23h                     ; Read Mouse
        int  33h                        ; Language Number
        cmp  bx,(NoMouse-10-M_Lang) /10 ; If Above Known
        ja   ShoIt                      ; Then "Unknown"
        mov  ax,bx                      ; Else
        mov  cx,10                      ; Calculate
        mul  cl                         ; Language
        mov  si,OFFSET M_Lang           ; String
        add  si,ax                      ; Offset
        mov  di,OFFSET Tongue + 32      ; Point to Language Line
        rep  movsb                      ; Copy Language Name String
ShoIt:  mov  cx,14                      ; Display Report Lines
        mov  dx,OFFSET TopLine          ; from Top to Bottom

ShoOff: mov  ah,40h                     ; Output to
        mov  bx,1                       ; Console Device
        push cx                         ; Preserve Number of Lines
        push dx                         ; Preserve Line Offset
        mov  cx,12                      ; Set Number of
        mov  dx,OFFSET NewLine          ; New Line Bytes
        int  21h                        ; Output NewLine
        pop  dx                         ; Recover Line Offset
        mov  cx,SIZE BotLine            ; Set Standard Line Length
        mov  ah,40h
        int  21h                        ; Output Selected Line
        add  dx,SIZE BotLine            ; Advance Offset Pointer
        pop  cx                         ; Recover Lines to Output
        loop ShoOff                     ; Loop Until Lines Output
        mov  ah,40h
        mov  cx,12                      ; End with bytes for
        mov  dx,OFFSET NewLine          ; Final New Line
        int  21h
        mov  ax,4C00h
        int  21h                        ; Return to MS-DOS
PROC    StoreDigits near
        push cx                         ; Preserve Register Used
        mov  cl,10                      ; Set Decimal Divisor
SDtest: or   ax,ax                      ; If NO value (left)
        jz   SDexit                     ; Then Exit (job done)
        div  cl                         ; Else Num MOD 10 = Place
        or   ah,'0'                     ; Make ASCII digit
        mov  [bx],ah                    ; Store decimal digit
        xor  ah,ah                      ; Remove remainder and
        dec  bx                         ; BackUp a decimal place
        jmp  SDtest                     ; Until Value down to zero
SDexit: pop  cx                         ; Recover Register used
        ret
ENDP
Label MS_Buff Byte                      ; driver state save buffer
ENDS
END     Begin
