;name: setkey,asm (setkey.com) by kevin m crenshaw
cseg    segment
assume  cs:cseg,ds:cseg
org     100h
;------ get typematic rate: a to z, [, \, ], ^, _, or '
start:  mov    si,81h          ;point to command line
        xor    bx,bx           ;set default
letter: lodsb                  ;get first non-space char
        cmp    al," "
        je     letter
        jb     send            ;end of line, use default
        dec    al
        and    al,0dfh         ;upper case
        sub    al,"@"          ;valid letter or symbol?
        jnb    lettr1          ;  maybe
        dec    si              ;  no, might be a digit
        jmp    short digit
lettr1: cmp    al,31           ;valid letter or symbol
        ja     error2          ;  no, error
        xchg   al,bl           ;  yes, save as typematic rate
;------ get delay value: 1 to 4
digit:  lodsb                  ;get next non-space character
        cmp    al," "
        je     digit
        jb     send            ;end of line, use what we have
        sub    al,"1"          ;valid digit?
        jb     error2          ;  no, error
        cmp    al,3            ;valid digit
        ja     error2          ;  no, error
        mov    cl,5            ;  yes, save as delay value
        shl    al,cl
        or     bl,al
;------ send values to keyboard
send:   mov    al,0f3h         ;set typematic/delay
        call   xmit            ;command accepted?
        jcxz   error1          ;  no, error
        xchg   al,bl           ;send typematic/delay values
        call   xmit            ;values accepted?
        jcxz   error1          ;  no, error
        int    20h             ;return to dos
;------ bad input
error1: mov    dx,offset error1$       ;hardware error
        jmp    short error
error2: mov    dx,offset error2$       ;bad input error
error:  mov    ah,9                    ;print message
        int    21h
        int    20h
error1$ db     "Hardware error",13,10,"$"
error2$ db     "Valid parameters are A-Z, then 1-4",13,10,"$"
;xmit - send data to keyboard
;in:    al     - data to send
;out:   ax     - destroyed
;       cx     - zero if error, nonzero otherwise
xmit    proc   near
        cli                    ;interrupts off
        xchg   al,ah           ;save command
        xor    cx,cx
xmtwt1: in     al,64h
        test   al,2            ;is data waiting for cntrlt?
        loopnz xmtwt1          ;  yes, wait
        jcxz   xmtret          ;error, cntrlr not reading data
        xchg   al,ah           ;get command back
        out    60h,al          ;send to keyboard
        xor    cx,cx
xmtwt2: in     al,64h
        test   al,2            ;has controller read data yet?
        loopnz xmtwt2          ;  no wait
        jcxz   xmtret          ;error, cntrlr not reading data
        xor    cx,cx
xmtwt3: in     al,64h
        test   al,1            ;did keyboard send ACK yet?
        loopz  xmtwt3          ;  no, wait for it
        jcxz   xmtret          ;  error, no response
        in     al,60h          ;get response
        cmp    al,0fah         ;was it ACK?
        je     xmtret          ;  yes
        xor    cx,cx           ;  no, error
xmtret: sti                    ;interrupts back on
        ret
xmit    endp
cseg    ends
        end    start
