;             BL5.ASM -- A PROGRAM FOR USE WITH QBasic 4.0 TO SAVE
;                        AND RESTORE SCREENS

;                           AUTHOR:  JOHN HICKMAN

;                   REQUIRES  MICROSOFT MASM 5.O TO ASSEMBLE
;    (BL5.QLB and BL5.LIB are included for those who do not have MASM 5.0)
;
;        Background:  When using data entry templates, it is often convenient 
;to design a BLOAD screen, load it and then enter whatever data is needed 
;through the template.  There is a disadvantage to this if you repeat this 
;process over and over..... it is slow, plus your disk gets beat to death with 
;all those BLOADs.   These disk accesses may be avoided by BLOADing the 
;template into an internal QB array then moving the array to the screen 
;whenever it is needed.  Alas, there is a problem with QBasic 4.0 that makes
;it difficult to BLOAD a screen into an internal array.  This program,
;BL5.ASM, is a "work-around" solution that allows you to save a screen in a 
;machine language buffer then restore it as needed.   To use, BLOAD your screen 
;the first time as usual & call SAVESCRN, then later, as needed, call RESTSCRN.

; EXAMPLE:               DEF SEG=&hB800
;                        BLOAD "XYZ.SCN"
;                        CALL SAVESCRN
;                             .
;                             .
;                             .  do your thing
;                             .
;                        CALL RESTSCRN
;                             .
;                             .
;---------------------------------------------------------------------------
;  WARNING --- THERE MAY BE A PROBLEM WITH MONO ADAPTERS.  IF SO, SEE
;              THE VIDEO_ENABLE SUB.   

;---------------------------------------------------------------------------
;  NEW MASM 5.0 STUFF
;---------------------------------------------------------------------------

   DOSSEG
  .MODEL medium
   PUBLIC SAVESCRN, RESTSCRN

   ASSUME DS:DGROUP, ES:DGROUP

;---------------------------------------------------------------------------
;                          DATA SEGMENT
;---------------------------------------------------------------------------

.DATA

BLBUF              DW     01020h   DUP(0)           ;THE BUFFER

STAT_REG_ADRS      DW     (?)         ;03DAh or 03BAh  as read by AD_TYPE

ADAPTER_ADRS       DW     (?)         ;B800h or B000h  as read by AD_TYPE

MODE_CTRL_REG      DW     (?)         ;03D8h or 03B8h  as read by AD_TYPE

DISPLAY_MODE       DW     (?)         ;whatever ...... as read by AD_TYPE

DISPLAY_TABLE      DB     2Dh,29h     ;used by VIDEO_ENABLE for CGA modes 2 & 3
                                      ;add others as needed
;---------------------------------------------------------------------------
;                         CODE SEGMENT
;---------------------------------------------------------------------------

.code

;-----------------------  SAVE SCREEN ---------------------------------
SAVESCRN      proc      far

              PUSH      BP                       ;save for BASIC
              MOV       BP,SP                    ;set up Base Pointer
              PUSH      DS                       ;save for BASIC
              PUSH      ES                       ;      "
              PUSH      SI                       ;      "
              PUSH      DI                       ;      "

              MOV       AX,DGROUP                ;set this program's DS
              MOV       DS,AX
              CALL      AD_TYPE
              LEA       SI, BLBUF
              XOR       DI,DI
              MOV       CX,02000                ;number of transfers to do
              MOV       AX,ADAPTER_ADRS         ;MONO OR CGA
              MOV       ES,AX                   ;PUT IT'S address in ES

              PUSH      ES                       ;exchange ES and DS registers
              PUSH      DS                       ;since we are moving data
              POP       ES                       ;from screen to array
              POP       DS                       ;using DS:SI=>ES:DI
                                                 ;     screen=>buffer
              XCHG      SI,DI                    ;exchange indices too

              CALL      MOVE_IT                  ;do transfer

              POP       DI                       ;prepare to return to BASIC
              POP       SI
              POP       ES
              POP       DS
              POP       BP
              CLD
              RET
SAVESCRN      ENDP

;-----------------------  RESTORE SCREEN -----------------------------------
RESTSCRN      PROC      FAR
              PUSH      BP                       ;save for BASIC
              MOV       BP,SP                    ;set up Base Pointer
              PUSH      DS
              PUSH      ES                       ;save for BASIC
              PUSH      SI
              PUSH      DI

              MOV       AX,DGROUP
              MOV       DS,AX
              CALL      AD_TYPE
              LEA       SI, BLBUF

              XOR       DI,DI
              MOV       CX,02000                ;number of transfers to do
              MOV       AX,ADAPTER_ADRS         ;MONO OR CGA
              MOV       ES,AX                   ;PUT IT'S address in ES
              CALL      VIDEO_DISABLE
              CALL      MOVE_IT                 ;do transfer
              CALL      VIDEO_ENABLE
              POP       DI
              POP       SI
              POP       ES                      ;prepare to return to BASIC
              POP       DS
              POP       BP
              CLD
              RET                               ;EXIT BACK TO BASIC

RESTSCRN      ENDP

;-------------------------  TRANSFER ---------------------------------

MOVE_IT       PROC      NEAR

MI1:          MOVSW                           ;move character and attribute
              loop      MI1                   ;do CX=2000 times
              ret                             ;DS:SI  & ES:DI
                                              ;srce     dest
MOVE_IT       endp


;---------------------------------------------------------------------------
;------------ DETERMINE ADAPTER TYPE MONO or GRAPHICS-----------------------
;---------------------------------------------------------------------------

AD_TYPE     PROC  NEAR

            MOV   AH,0Fh
            INT   10h
            XOR   AH,AH
            MOV   DISPLAY_MODE, AX
            CMP   AL,7
            JE    ITS_MONO

            MOV   DX,03DAh                  ;STATUS REG FOR CGA (FOR
            MOV   STAT_REG_ADRS, DX         ;USE IN VRETRACE RTN)
            MOV   DX,03D8h
            MOV   MODE_CTRL_REG, DX
            MOV   DX, 0B800h
            JMP   SETVID
 

ITS_MONO:   MOV   DX,03BAh                   ;STATUS REG FOR MONO (FOR USE
            MOV   STAT_REG_ADRS, DX          ;IN VRETRACE RTN)
            MOV   DX, 03B8h
            MOV   MODE_CTRL_REG,DX
            MOV   DX, 0B000h

SETVID:     MOV   ADAPTER_ADRS, DX
            RET

AD_TYPE     ENDP

;---------------------------------------------------------------------------
;VIDEO_ENABLE and VIDEO_DISABLE routines
;---------------------------------------------------------------------------

VIDEO_DISABLE PROC NEAR

              MOV DX,STAT_REG_ADRS          ;read CGA status port
DISABLE1:     IN AL,DX                      ;wait for vertical retrace to occur
              TEST AL,8                     ;is bit 3 set?
              JE DISABLE1                   ;no, wait until it is
              MOV DX,MODE_CTRL_REG          ;now disable the display
              MOV AL,25h                    ;by clearing bit 3 of the
              OUT DX,AL                     ;mode control register
              RET

VIDEO_DISABLE ENDP


VIDEO_ENABLE  PROC NEAR

              MOV DX,MODE_CTRL_REG        ;Mode Control Register (3D8h or 3B8h)
              MOV BX,DISPLAY_MODE         ;get value to re-enable display
              SUB BX,2
              MOV AL,DISPLAY_TABLE[BX]    ;029h for 80X25 16 color text
              OUT DX,AL                   ;and send it to the port
              RET                         ;note- there will probably be a
                                          ;problem with mono adapters, since
VIDEO_ENABLE  ENDP                        ;no DISPLAY_TABLE codes for mono

;----------------------------------------------------------------------------
           END

