BIN32    PROC     NEAR 
;*************************************************************
;                  converts an ASCII decimal string to a 
;                  signed 32-bit binary integer in DX:AX 
;                  input--DI points to end of string 
;                         SI points to start 
;                  output--CX if negative, number of digits
;                          right of decimal point 
;                          SI points to next unconverted char
;*************************************************************
         PUSH     BP 
         SUB      DX,DX 
;                            get sign 
         MOV      CX,DX           ;assume positive sign 
         MOV      AL,[SI]         ;put first char in AL 
         CMP      AL," "          ;is it blank? positive sign
         JE       BIN32A 
         CMP      AL,"+"          ;is it plus sign? 
         JE       BIN32A 
         CMP      AL,"-"          ;is it minus sign? 
         JNE      BIN32B 
         DEC      CX              ;sign negative-set flag in
CX 
BIN32A:  INC      SI              ;point to next char 
BIN32B:  PUSH     CX              ;save sign 
;                            convert string 
         MOV      AX,DX           ;0-initial NUMber in DX:AX
         MOV      CL,127          ;max 127 places left of decimal
                                  ;CL=COUNT places right of
decimal 
;                            get ASCII digit 
BIN32C:  MOV      CH,[SI]         ;next char in CH 
         CMP      CH,"9"          ;if CH > "9" not a digit 
         JA       BIN32H 
         SUB      CH,48           ;convert to binary 
         JB       BIN32H          ;if CH < "0" not a digit 
         DEC      CL              ;found digit--decrement COUNT
;                            multiply NUM * 10 
         MOV      BP,CX           ;save CX in BP 
         SUB      CX,CX           ;decimal 10 in CX:BX 
         MOV      BX,10 
         CALL     MUL32           ;MUL32 returns DX:AX:CX:BX
;                            check for overflow--over 2^31-1
         OR       AX,AX           ;if AL not zero, product
	 JNZ      BIN32I          ;is > or = 2^32-overflow 
         OR       CX,CX           ;if CX sign bit set, product
         JS       BIN32I          ;is > or = 2^31-overflow 
;                            add in this digit 
         XCHG     CX,BP           ;digit & COUNT in CX 
         MOV      AL,CH           ;this digit in DX:AX 
         ADD      AX,BX           ;add NUM*10 from CX:BX 
         ADC      DX,BP 
         JC       BIN32I          ;check for overflow again
;                            get next ASCII character 
BIN32D:  INC      SI              ;point to next char 
         CMP      SI,DI           ;is there another one? 
         JB       BIN32C          ;if so, go get it 
;                            set final decimal place count 
BIN32E:  XCHG     AX,CX           ;convert count in CL 
         CBW                      ;to word in AX 
         XCHG     AX,CX           ;put count back in CX 
         OR       CX,CX           ;there are no decimals 
         JS       BIN32F          ;if count in CX is positive,
         SUB      CX,CX           ;so make CX zero 
;                            restore sign 
BIN32F:  POP      BX 
         OR       BX,BX 
         JNS      BIN32G           ;if sign was negative 
         NOT      AX               ;negate NUM 
         NOT      DX 
         ADD      AX,1 
         ADC      DX,0 
;                            wrap up 
BIN32G:  SUB      BX,BX            ;BX=0  status ok 
         POP      BP 
         RET 
;                            found non-numeric character 
BIN32H:  CMP      CH,-2            ;is it decimal point (46-48)?
         JNE      BIN32E           ;if not, finish 
         SUB      CL,CL            ;decimal so,set COUNT to
zero 
         JMP      BIN32D           ;and get next char 
;                            overflow 
BIN32I:  POP      BX               ;remove sign from stack 
         POP      BP               ;restore BP 
         MOV      BX,1             ;BX=1 overflow flag 
         RET 
BIN32    ENDP 
