RN_F     PROC     NEAR
;********************************************************
;                      Rounds a floating point operand to
;                      the nearest integer value
;********************************************************
         PUSH     SI              ;save index registers
         PUSH     DI

         MOV      BX,CX           ;and BX
         MOV      DX,[DI]+2       ;get operand in DX:AX  
         MOV      AX,[DI]
;
         SUB      CX,CX           ;clear CX
         MOV      DI,10000000B    ;isolate sign in DI
         AND      DI,DX
         OR       DX,10000000B    ;restore leading one
;                             check range
         CMP      DH,128          ;exponent bias is 128
         JA       RN1
         JB       RN7             ;if exponent<0 round to zero
;                             exponent is zero
         CMP      DL,128          ;number >= .5 and < 1
         JBE      RN7             ;if fraction=0 round to zero
         MOV      DX,CX           ;round to +1-all zeros
         MOV      AX,CX
         MOV      BH,81H          ;and biased exponent of 1
         JMP      RN6             ;restore sign and exit
;
RN1:     MOV      BH,DH           ;exponent in BH in case we exit
         CMP      DH,152          ;if exponent>=24, already integer
         JAE      RN6             ;so restore sign and exit
;                             exponent is in range 1-23
         MOV      CL,DH           ;put unbiased exponent in CX
         SUB      CX,128
         NEG      CX              ;COUNT is CX - 24
         ADD      CX,24
;                             shift right COUNT bits
         SUB      DH,DH           ;clear DH
         MOV      BH,DH           ;and BH
RN2:     SHR      DL,1            ;shift it right
         RCR      AX,1
         RCR      DH,1            ;rotate fraction into DH:BX
         RCR      BX,1
         LOOP     RN2
;                             round
         OR       DH,DH           ;is guard bit on?
         JNS      RN4             ;if not, rounding not needed
         TEST     AX,1            ;if integer odd
         JNZ      RN3             ;round up
         CMP      DH,80H          ;if any trailing bits on
         JA       RN3             ;round up
         OR       BX,BX           
         JZ       RN4
RN3:     ADD      AX,1            ;round up
         ADC      DX,0
;                             normalize--shift left
RN4:     MOV      BH,152          ;set exponent to zero
RN5:     SHL      AX,1            ;shift left
         RCL      DL,1
         DEC      BH              ;increment exponent
         OR       DL,DL
         JNS      RN5             ;shift again if not normalized
;
RN6:     JMP      FINISH          ;restore sign and exit
RN7:     SUB      DX,DX           ;zero result
         MOV      AX,DX
         MOV      BX,DX
         JMP      EXIT
RN_F     ENDP