; LPT-2.asm
; Reverses initial LPT1 and LPT2 ports (ports 0378h and 0278h)
; Note: 0000:0408h begins port addresses, initially 78 03 78 02

jmp LPTS

LPTS:
   push ES           ; save registers being used
   push AX
   push DX
   push SI

   call CMDLINE      ; command line-> CMDLN    its length-> CMDLEN (not used)
   call DLCHAR       ; puts first non-blank in DL
   call LPT1         ; if DL = '1' ports 0378h and 0278h respectively
   call LPT2         ; if DL = '2' ports 0278h and 0378h respectively

ENDLPT:
   pop  SI           ; restore registers
   pop  DX
   pop  AX
   pop  ES
   int  20h

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;Procedure LPT1
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
LPT1 proc
   cmp  DL,'1'
   jne  RETLPT1
   xor  AX,AX        ; ES = 0000
   mov  ES,AX
   mov  AX,0378h     ; move 0378 (LPT1 port address) to 0000:0408
   mov  [ES:408H],AX
   mov  AX,0278h     ; move 0278 (LPT2 port address) to 0000:040A
   mov  [ES:40Ah],AX
RETLPT1:
   ret
LPT1 endp

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;Procedure LPT2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
LPT2 proc
   cmp  DL,'2'
   jne  RETLPT2
   xor  AX,AX        ; ES = 0000
   mov  ES,AX
   mov  AX,0278h     ; move 0278 (LPT2 port address) to 0000:0408
   mov  [ES:408H],AX
   mov  AX,0378h     ; move 0378 (LPT1 port address) to 0000:040A
   mov  [ES:40Ah],AX
RETLPT2:
   ret
LPT2 endp

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*  Procedure CMDLINE (from CMDLINE.asp)
;* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;*  Copies DOS command line to data storage area CMDLN, appending '$'
;*  Copies DOS command length to data storage area CMDLEN
;*
;*  Gets command line from the PSP (Program Segment Prefix)
;*     offset 128 : length of command line
;*     ofset  129 : beginning of commandline

CMDLINE  PROC

         JMP CMDSTART

; -----data storage area-------
CMDLEN   db  ?
CMDLN    db  127 dup(?)
         db  '$'

; -----code-------
CMDSTART:
; copy command line length to CMDLEN
       mov al,[ds:128]
       mov cmdlen,al
; copy command line
       mov  ax,129     ; command line offset in Program Segment Prefix
       mov  si,ax      ; ...into source index register
       lea  DI,CMDLN   ; command line storage area into destimation index reg
       xor  cx,cx      ; length of command line
       mov  cl,cmdlen  ; ...into cx register
       rep  movsb      ; move command line --> CMDLN
       mov  [di],'$'   ; append '$' at end

       ret
CMDLINE ENDP ; end of procedure CMDLINE

;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;* Procedure DLCHAR
;* strips leading blanks from CMDLINE
;* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DLCHAR proc
       lea SI, CMDLN
GETDLCHAR:
       mov DL, [SI]
       cmp DL, ' '
       jne RETDLCHAR
       cmp DL, '$'
       je  RETDLCHAR
       inc SI
       jmp GETDLCHAR
RETDLCHAR:
       ret
DLCHAR endp ; end procedure DLCHAR

end