DATA     SEGMENT     WORD PUBLIC
ENDS
 
CODE     SEGMENT     WORD PUBLIC
         ASSUME      CS:CODE, DS:DATA
         PUBLIC      IrqJmp
;-----------------------------------------------------------------------
; PROCEDURE IrqJmp(p:pointer);
; Effect  : Jumps to the address pointed to with p.
; Purpose : To guarantee the return of the program flow to the old
;           routine, when it has been intercepted by a self constructed
;           interrupt procedure. IrqJmp is called last in the interrupt
;           procedure, p must contain the interrupt vector of the original
;           interrupt routine.
 
IrqJmp  PROC    Near
 
taill       EQU   WORD Ptr[BP+04]
tailh       EQU   WORD Ptr[BP+06]
 
            PUSH BP
            MOV BP,SP         ; establish bp adressability
            MOV AX,tailh      ; get highpart of interrupt vector
            MOV cs:hirq,AX    ; store it at hi jumpaddress
            MOV AX,taill      ; get lopart of intvec
            MOV cs:lirq,AX    ; store it at lo jump address
            MOV SP,BP
            POP BP
            POP AX ;dummy pop to remove return address of irqjmp from stack.
 
                   ; the following part is the exact reversal of the entry
                   ; code of the (calling) interrupt procedure generated by
                   ; TP.
 
            MOV SP,BP
            POP BP
            POP ES
            POP DS
            POP DI
            POP SI
            POP DX
            POP CX
            POP BX
            POP AX
                    ; to return to original/intercepted interrupt routine
jump        DB 0EAh ;jmp [p]
 
lirq        DW ?
hirq        DW ?
 
IrqJmp  ENDP
 
CODE     ENDS              ; End of CODE segment
         END               ; End of text.
 
Comments:

It can be assembled with either TASM or a86 (an excellent shareware
assembler written by eric isaacson, which can be downloaded from any
selfrespecting bbs)
 
C>TASM irqjmp.asm
C>A86 irqjmp.asm irqjmp.obj
 
I've tested it with both tasm and a86 and it works though I got one hangup
with the version with the tasm generated object file. After checking it
with td there didn't seem to be any difference between the versions
generated by a86 and tasm, so I assume one of the MANY other TSR's in my
memory are responsible for this behavior. 8-(
Ah well, have fun with it.
 
Met Vriendelijke Groeten,
 
               Wiebe Wiersema.
