        name    getenv
        page    55,132
        title   GETENV get environment string

;
; GETENV --- Return address and length of variable
;            portion of environment string.
;
; (C) 1987 ZD, by Ray Duncan
;
; Call with:    DS:SI = ASCIIZ env. variable name
;               ES    = segment of environment
;
; Returns:      ES:DI = address of env. variable
;               AX    = length (0 = not found)
;

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        public  getenv          ; make visible to Linker

getenv  proc    near            ; return address and length
                                ;   of environment variable

        push    cx              ; save registers
        push    si

        mov     cx,8000h        ; assume max env. = 32 KB       
        xor     di,di           ; initial env. offset
        xor     ax,ax           ; default length result 

get1:                           ; check for end of environment
        cmp     byte ptr es:[di],0
        je      get4            ; end reached, return AX = 0

        pop     si              ; initialize address of target
        push    si              ;   variable to be found

        repe cmpsb              ; compare target and env. strings
        cmp     byte ptr [si-1],0       
        jne     get2            ; jump if incomplete match
        cmp     byte ptr es:[di-1],'='
        je      get3            ; jump if match was complete

get2:                           ; match was incomplete
        repne scasb             ; scan for end of env. string
        jmp     get1            ; and try again to match

get3:   push    di              ; save address after = sign
        repne scasb             ; look for end of this string
        pop     ax              ; get back starting address 
        xchg    di,ax           ; find string length
        sub     ax,di
        dec     ax              ; don't include null byte

get4:                           ; common exit point
        pop     si              ; restore registers
        pop     cx
        ret                     ; return to caller

getenv  endp

_TEXT   ends

        end
