;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM30_C.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   return_OS_access_key                                    ;
;                                                                             ;
;      DESCRIPTION:   This function provides an OS/E with the ability to      ;
;                     return the access key to the memory manager.  Returning ;
;                     the access key to the memory manager places the memory  ;
;                     manager in the state it is in at installation time      ;
;                     (regarding the use of the OS/E function set and the     ;
;                     access key).  That is, access to the OS/E function set  ;
;                     is enabled.  Upon execution of the next enable/disable  ;
;                     OS/E function set function, the access key will once    ;
;                     again be returned.                                      ;
;                                                                             ;
;                     The OS/E (Operating System) functions which are         ;
;                     affected by this function are:                          ;
;                        get_hw_info               enable_DMA_reg_set         ;
;                        get_alt_reg_set           disable_DMA_reg_set        ;
;                        set_alt_reg_set           dealloc_DMA_reg_set        ;
;                        get_alt_context_size      enable_OS_fcns             ;
;                        alloc_alt_reg_set         disable_OS_fcns            ;
;                        dealloc_alt_reg_set       return_OS_access_key       ;
;                        alloc_DMA_reg_set                                    ;
;                                                                             ;
;           PASSED:   &access_key:                                            ;
;                        is a far pointer to an EMM initialized access key    ;
;                        which was returned by the first function invocation  ;
;                        of the enable or disable functions.                  ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int  status;                                   ;
;                     unsigned long access_key;                               ;
;                                                                             ;
;                     status = return_OS_access_key (&access_key);            ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

return_OS_access_key	PROC	                                              \
                        USES DI,                                              \
			ptr_access_key:FAR PTR DWORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   return the "access key" owned by the OS back to EMM for       ;
	;   .   EMMs future use;                                              ;
	;---------------------------------------------------------------------;
	MOVE		AX, return_access_key_fcn
        MOVE            ES:DI, ptr_access_key
        MOVE            BX:CX, ES:[DI]
	INT     	EMM_int

        ;---------------------------------------------------------------------;
        ;   .   pass the "access key" back to the OS;                         ;
        ;---------------------------------------------------------------------;
        MOVE            ES:[DI], BX:CX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

return_OS_access_key		ENDP

END
