;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM24_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   xchg_memory_region                                      ;
;                                                                             ;
;      DESCRIPTION:   This function exchanges a region of memory in any of    ;
;                     the following memory source/destination combinations.   ;
;                                                                             ;
;                        1. conventional memory to conventional memory        ;
;                        2. conventional memory to expanded memory            ;
;                        3. expanded memory to conventional memory            ;
;                        4. expanded memory to expanded memory                ;
;                                                                             ;
;                     The term expanded memory region refers only to the area ;
;                     of memory above 640K bytes (9FFFFh).  If a system       ;
;                     provides mappable conventional memory, this function    ;
;                     treats the mappable conventional memory regions as      ;
;                     ordinary conventional memory.  The contents of the      ;
;                     source region and the destination region are exchanged. ;
;                                                                             ;
;                     The exchange operation can be performed without having  ;
;                     to save and restore the expanded memory mapping         ;
;                     context.  The current mapping context is maintained     ;
;                     throughout this operation.  The length of the region is ;
;                     limited to the amount of expanded memory allocated to   ;
;                     the specified EMM handles.  A length of zero is not an  ;
;                     error however, no exchange will be performed.  A region ;
;                     length which exceeds 16K bytes is not an error.  In     ;
;                     this case the function assumes that a group of logical  ;
;                     pages is the target for the exchange.  The logical page ;
;                     specified represents the first logical page in which    ;
;                     the exchange will take place.  If the region length     ;
;                     exceeds 16K bytes, or if the region is less than 16K    ;
;                     bytes but spans logical pages, there must be sufficient ;
;                     logical pages remaining after the first logical page    ;
;                     for the entire region to fit.                           ;
;                                                                             ;
;                     If your application needs to exchange a region of       ;
;                     conventional memory with expanded memory, you can       ;
;                     simply exchange it with the region of interest without  ;
;                     having to perform a save or restore of the current      ;
;                     mapping context.  An exchange of up to 1M byte may be   ;
;                     performed, although practical lengths are obviously     ;
;                     below that value.  Checking is done before starting the ;
;                     exchange to prevent the possibility of overlap during   ;
;                     the exchange operation.  Overlapping source and         ;
;                     destination regions for a exchange are invalid, and the ;
;                     exchange will not take place.                           ;
;                                                                             ;
;           PASSED:   &xs:                                                    ;
;                        is a far pointer to a structure which contains the   ;
;                        source & destination information for the exchange.   ;
;                        The structure members are described here:            ;
;                                                                             ;
;                        xs.region_size:                                      ;
;                           is the length of the memory region to be          ;
;                           exchanged.                                        ;
;                                                                             ;
;                        xs.source_mem_type:                                  ;
;                           is the type of memory where the source region     ;
;                           resides.  A value of zero indicates that the      ;
;                           source region resides in conventional memory.     ;
;                           A value of one indicates that the source region   ;
;                           resides in expanded memory.                       ;
;                                                                             ;
;                        xs.source_handle:                                    ;
;                           if the source region resides in expanded memory,  ;
;                           it specifies the handle number associated with    ;
;                           the source memory region.  If the source region   ;
;                           resides in conventional memory, it has no meaning ;
;                           and should be set to zero for future              ;
;                           compatibility.                                    ;
;                                                                             ;
;                        xs.source_init_offset:                               ;
;                           is the offset within the source region at which   ;
;                           to begin the exchange.                            ;
;                                                                             ;
;                           If the source region resides in expanded memory,  ;
;                           it specifies an offset relative to the beginning  ;
;                           of the 16K-byte source page.  Because the offset  ;
;                           is relative to the beginning of a 16K-byte source ;
;                           expanded memory page, it may only take on values  ;
;                           between 0000h and 3FFFh.                          ;
;                                                                             ;
;                           If the source region resides in conventional      ;
;                           memory, it specifies an offset relative to the    ;
;                           beginning of the source segment.  Because the     ;
;                           offset is relative to the beginning of a 64K-byte ;
;                           conventional memory segment, it may only take on  ;
;                           values between 0000h and FFFFh.                   ;
;                                                                             ;
;                        xs.source_init_log_page_or_seg:                      ;
;                           is the initial segment or logical page number     ;
;                           within the source region at which to begin the    ;
;                           exchange.                                         ;
;                                                                             ;
;                           If the source region resides in expanded memory,  ;
;                           it specifies the logical page within the source   ;
;                           region at which to begin the exchange.            ;
;                                                                             ;
;                           If the source region resides in conventional      ;
;                           memory, it specifies the initial segment address  ;
;                           within conventional memory at which to begin      ;
;                           the exchange.                                     ;
;                                                                             ;
;                        xs.dest_mem_type:                                    ;
;                           is the type of memory where the destination       ;
;                           region resides.  A value of zero indicates that   ;
;                           the destination region resides in conventional    ;
;                           memory (excluding the page frame segment).  A     ;
;                           value of one indicates that the destination       ;
;                           region resides in expanded memory.                ;
;                                                                             ;
;                        xs.dest_handle:                                      ;
;                           if the destination region resides in expanded     ;
;                           memory, it specifies the handle number associated ;
;                           with the destination memory region.  If the       ;
;                           destination region resides in conventional, it    ;
;                           has no meaning and should be set to zero for      ;
;                           future compatibility.                             ;
;                                                                             ;
;                        xs.dest_init_offset:                                 ;
;                           is the offset within the destination region at    ;
;                           which to begin the exchange.                      ;
;                                                                             ;
;                           If the destination region resides in expanded     ;
;                           memory, it specifies an offset relative to the    ;
;                           beginning of the 16K-byte destination page.       ;
;                           Because the offset is relative to the beginning   ;
;                           of a 16K-byte source expanded memory page, it may ;
;                           only take on values between 0000h and 3FFFh.      ;
;                                                                             ;
;                           If the destination region resides in conventional ;
;                           memory, it specifies the offset, relative to the  ;
;                           beginning of the destination segment, to begin    ;
;                           the exchange at.  Because the offset is relative  ;
;                           to the beginning of a 64K-byte conventional       ;
;                           memory segment, it may only take on values        ;
;                           between 0000h and FFFFh.                          ;
;                                                                             ;
;                        xs.dest_init_log_page_or_seg:                        ;
;                           is the initial segment or logical page number     ;
;                           within the destination region at which to begin   ;
;                           the exchange.                                     ;
;                                                                             ;
;                           If the destination region resides in expanded     ;
;                           memory, it specifies the logical page within the  ;
;                           destination region at which to begin the          ;
;                           exchange.                                         ;
;                                                                             ;
;                           If the destination region resides in conventional ;
;                           memory, it specifies the initial segment address  ;
;                           within conventional memory at which to begin      ;
;                           the exchange.                                     ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     The SOURCE memory region described by:                  ;
;                           xs.source_handle                                  ;
;                           xs.source_init_offset                             ;
;                           xs.source_init_log_page_or_seg                    ;
;                       is EXCHANGED with the DESTINATION memory region:      ;
;                           xs.dest_handle                                    ;
;                           xs.dest_init_offset                               ;
;                           xs.dest_init_log_page_or_seg                      ;
;                                                                             ;
; C USE CONVENTION:   unsigned int     status;                                ;
;                     MOVE_XCHG_STRUCT xs;                                    ;
;                                                                             ;
;                     xs.region_size                 = 640 * 1024;            ;
;                     xs.source_mem_type             = EXP_MEM;               ;
;                     xs.source_handle               = 1;                     ;
;                     xs.source_init_log_page_or_seg = 0;                     ;
;                     xs.source_init_offset          = 0x0000;                ;
;                     xs.dest_mem_type               = CONV_MEM;              ;
;                     xs.des_handle                  = 0;                     ;
;                     xs.dest_init_log_page_or_seg   = 0x0000;                ;
;                     xs.dest_init_offset            = 0x0000;                ;
;                                                                             ;
;                     status = xchg_memory_region (&xs);                      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

xchg_memory_region	PROC                                                  \
			USES DS SI,                                           \
			ptr_xchg_struct:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   exchange the contents of a source memory region and a         ;
	;   .   destination memory region;                                    ;
	;---------------------------------------------------------------------;
	MOVE		AX, exchange_memory_fcn
	MOVE		DS:SI, ptr_xchg_struct
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

xchg_memory_region	ENDP

END
