;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM23_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_alter_map_call_stack_size                           ;
;                                                                             ;
;      DESCRIPTION:   This function returns the number of bytes of            ;
;                     information the alter_map_call function pushes onto the ;
;                     stack each time it is invoked.                          ;
;                                                                             ;
;           PASSED:   &call_stack_space_size:                                 ;
;                        is a far pointer to the number of bytes which the    ;
;                        alter_map_call function will require.                ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     call_stack_space_size:                                  ;
;                        is the number of bytes which the alter_map_call      ;
;                        function will require.  In other words, it is the    ;
;                        number (including the return address) which has to   ;
;                        be added to the stack pointer to remove all elements ;
;                        from the stack.                                      ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int call_stack_space_size;                     ;
;                                                                             ;
;                     status = get_alter_map_call_stack_size                  ;
;                                                      (&call_stack_space);   ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_alter_map_call_stack_size	PROC                                          \
				ptr_stack_space_count:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the amount of stack space allocated by the alter_map_call ;
	;   .   function during its execution;                                ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_page_map_stack_space_size_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the count of the stack space allocated by the            ;
	;   .   alter_map_call back to the caller;                            ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_stack_space_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_alter_map_call_stack_size	ENDP

END
