;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM13_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_handle_pages                                        ;
;                                                                             ;
;      DESCRIPTION:   This function returns the number of pages allocated to  ;
;                     a specific EMM handle.                                  ;
;                                                                             ;
;           PASSED:   &pages_alloc_to_handle:                                 ;
;                        is a far pointer to the number of logical pages      ;
;                        allocated  to the specified EMM handle.              ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     pages_alloc_to_handle:                                  ;
;                        is the number of logical pages allocated to the      ;
;                        specified EMM handle.  This number never exceeds     ;
;                        2048 because the memory manager allows a maximum of  ;
;                        2048 pages (32M bytes) of expanded memory.           ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int pages_alloc_to_handle;                     ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = get_handle_pages (&pages_alloc_to_handle,      ;
;                                                handle);                     ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_handle_pages	PROC                                                  \
			ptr_pages_alloc_to_handle:FAR PTR WORD,                   \
			handle:WORD                                           

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the number of pages allocated to the handle;              ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_handle_pages_fcn
	MOVE		DX, handle
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the number of pages allocated to the handle back to      ;
	;   .   the caller;                                                   ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_pages_alloc_to_handle
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_handle_pages	ENDP

END
