;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM12_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_handle_count                                        ;
;                                                                             ;
;      DESCRIPTION:   This function returns the number of open EMM handles    ;
;                     (including the operating system handle 0) in the        ;
;                     system.                                                 ;
;                                                                             ;
;           PASSED:   &handle_count:                                          ;
;                        is a far pointer to the number of open EMM           ;
;                        handles.                                             ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     handle_count:                                           ;
;                        is the number of open EMM handles [including the     ;
;                        operating system handle (0)].  This number will not  ;
;                        exceed 255.                                          ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int handle_count;                              ;
;                                                                             ;
;                     status = get_handle_count (&handle_count);              ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_handle_count	PROC                                                  \
			ptr_handle_count:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the number of active handles from EMM;                    ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_handle_count_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the number of active handles back to the caller;         ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_handle_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_handle_count	ENDP

END
