;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM04_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   alloc_pages                                             ;
;                                                                             ;
;      DESCRIPTION:   This function allocates the number of pages requested   ;
;                     and assigns a unique EMM handle to these pages.  The    ;
;                     EMM handle owns these pages until the application       ;
;                     deallocates them.                                       ;
;                                                                             ;
;                     Handles which are assigned using this function will     ;
;                     have 16K-byte pages, the size of a standard expanded    ;
;                     memory page.  If the expanded memory board hardware     ;
;                     isn't able to supply 16K-byte pages, it will emulate    ;
;                     them by combining multiple non-standard size pages to   ;
;                     form a single 16K-byte page.  All application programs  ;
;                     and functions that use the handles this function        ;
;                     returns will deal with 16K-byte pages.                  ;
;                                                                             ;
;                     The numeric values of the handles the EMM returns are in;
;                     the range of 1 to 254 decimal.  The OS handle (handle   ;
;                     value 0) is never returned by the alloc_pages function. ;
;                     A memory manager should be able to supply up to 255     ;
;                     handles, including the OS handle.  An application can   ;
;                     use the get_total_handles function to find out how many ;
;                     handles an EMM supports.                                ;
;                                                                             ;
;                     You can't allocate zero pages to a handle with the      ;
;                     alloc_pages function.  If your application needs to     ;
;                     allocate zero pages to a handle, use the                ;
;                     alloc_std_pages function provided for this purpose.     ;
;                                                                             ;
;           PASSED:   pages:                                                  ;
;                        is the number of pages you want your program to      ;
;                        allocate.                                            ;
;                                                                             ;
;                     &handle:                                                ;
;                        is a far pointer to a unique EMM handle.             ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     handle:                                                 ;
;                        is a unique EMM handle.  Your program must use this  ;
;                        EMM handle (as a parameter) in any function that     ;
;                        requires it.  You can use up to 255 handles.         ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int pages;                                     ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = alloc_pages (pages,                            ;
;                                           &handle);                         ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

alloc_pages		PROC                                                  \
			pages:WORD,                                           \
			ptr_handle:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   allocate the number of pages requested from EMM;              ;
	;---------------------------------------------------------------------;
	MOVE		AH, allocate_pages_fcn
	MOVE		BX, pages
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the EMM handle back to the caller;                       ;
	;---------------------------------------------------------------------;
	MOVE		ES:BX, ptr_handle
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

alloc_pages		ENDP

END
