;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM28_B.ASM                                             ;
;                                                                             ;
; OS FUNCTION NAME:   set_alt_reg_set                                         ;
;                                                                             ;
;      DESCRIPTION:   The function does one of two things, depending on the   ;
;                     map register set specified:                             ;
;                                                                             ;
;                     1. If the alternate map register set specified is zero, ;
;                        map register set zero is activated.  If the map      ;
;                        register context restore area far pointer is not     ;
;                        null, the contents of the restore area pointed to by ;
;                        the far pointer &alt_context are copied into         ;
;                        register set zero on the expanded memory hardware in ;
;                        the system.  If the pointer is null, the contents    ;
;                        are not copied.                                      ;
;                                                                             ;
;                        Regardless of its value, the map register context    ;
;                        restore area pointer is saved within the memory      ;
;                        manager.  It will be used during the get_alt_reg_set ;
;                        function.                                            ;
;                                                                             ;
;                        The operating system must supply the far pointer to  ;
;                        the area.  This function is intended to simulate     ;
;                        setting an alternate map register set.  Note that    ;
;                        the operating system must allocate the space for     ;
;                        the context.  The memory manager saves the context   ;
;                        save area far pointer internally.                    ;
;                                                                             ;
;                     2. If the alternate map register set specified is not   ;
;                        zero, the alternate map register set specified is    ;
;                        activated.  The restore area, which the operating    ;
;                        system is pointing to, is not used.                  ;
;                                                                             ;
;           PASSED:   alt_reg_set:                                            ;
;                        is the number of the alternate map register set      ;
;                        which is to be activated.                            ;
;                                                                             ;
;                     &alt_context:                                           ;
;                        is a far pointer to an OS/E supplied map register    ;
;                        context restore area.  This far pointer must always  ;
;                        be passed if the expanded memory hardware does not   ;
;                        supply alternate mapping register sets.              ;
;                                                                             ;
;                        The memory manager must save this pointer whenever   ;
;                        the OS/E invokes this function.  The OS/E must have  ;
;                        allocated the space for the restore area.            ;
;                        Additionally, the contents of this restore area must ;
;                        have been initialized by the memory manager before   ;
;                        it will contain any useful information.  The OS/E    ;
;                        initializes the restore area it has allocated by     ;
;                        invoking the get_context function.  After the OS/E   ;
;                        has done this, the restore area will contain the     ;
;                        state of the mapping hardware in the system, and any ;
;                        additional information necessary to restore the      ;
;                        hardware to its original state when the operating    ;
;                        system invokes a set_alt_reg_set function.           ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     alt_context:                                            ;
;                        If alt_reg_set is not equal to zero:                 ;
;                           The alternate map register set is activated.  A   ;
;                           far pointer to a map register context restore     ;
;                           area is not required.                             ;
;                                                                             ;
;                        If alt_reg_set is equal to zero:                     ;
;                           The far pointer &alt_context points to an area    ;
;                           which contains the state of all the mapping       ;
;                           hardware in the system, and any additional        ;
;                           information necessary to restore the hardware to  ;
;                           its original state.                               ;
;                                                                             ;
; C USE CONVENTION:   unsigned int          status;                           ;
;                     unsigned int          alt_reg_set;                      ;
;                     static CONTEXT_STRUCT alt_context;                      ;
;                                                                             ;
;                     status = set_alt_reg_set (alt_reg_set,                  ;
;                                               &alt_context);                ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

set_alt_reg_set		PROC                                                  \
			USES DI,                                              \
			alt_reg_set:WORD,                                     \
			far_ptr_alt_context:FAR PTR DWORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   set the current active alternate map register set or the      ;
	;   .   current mapping context if alternate map register sets are    ;
	;   .   not supported;                                                ;
	;---------------------------------------------------------------------;
	MOVE		AX, set_alt_map_reg_set_fcn 
	MOVE		BX, alt_reg_set
	MOVE		ES:DI, far_ptr_alt_context
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

set_alt_reg_set		ENDP

END
