;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM18_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   realloc_pages                                           ;
;                                                                             ;
;      DESCRIPTION:   This function allows an application program to increase ;
;                     or decrease (reallocate) the number of logical pages    ;
;                     allocated to an EMM handle.  There are four             ;
;                     reallocation cases of interest:                         ;
;                                                                             ;
;                     1. A reallocation count of zero.  The handle assigned   ;
;                        to the application remains assigned and is still     ;
;                        available for use by the application.  The memory    ;
;                        manager won't reassign the handle to any other       ;
;                        application.  However, the handle will return to the ;
;                        memory manager any currently allocated pages.        ;
;                        The application must invoke the dealloc_pages        ;
;                        function before returning to DOS.  If it doesn't,    ;
;                        the handle will remain assigned and no other         ;
;                        application will be able to use it.                  ;
;                                                                             ;
;                     2. A reallocation count equal to the current            ;
;                        allocation count.  This is not an error; it          ;
;                        returns a successful status.                         ;
;                                                                             ;
;                     3. A reallocation count greater than the current        ;
;                        allocation count.  The memory manager will attempt   ;
;                        to add new pages to those pages already allocated to ;
;                        the specified EMM handle.  The number of new pages   ;
;                        added is the difference between the reallocation     ;
;                        count and the current allocation count.  The         ;
;                        sequence of logical pages allocated to the EMM       ;
;                        handle remains continuous after this operation.  The ;
;                        newly allocated pages have logical page numbers      ;
;                        which begin where the previously allocated pages     ;
;                        ended, and continue in ascending sequence.           ;
;                                                                             ;
;                     4. A reallocation count less than the current           ;
;                        allocation count.  The memory manager will attempt   ;
;                        to subtract some of the currently allocated pages    ;
;                        and return them to the memory manager.  The number   ;
;                        of old pages subtracted is the difference between    ;
;                        the current allocation count and the re-allocation   ;
;                        count.  The pages are subtracted from the end of the ;
;                        sequence of pages currently allocated to the         ;
;                        specified EMM handle.  The sequence of logical pages ;
;                        allocated to the EMM handle remains continuous after ;
;                        this operation.                                      ;
;                                                                             ;
;                     The handle determines what type of logical pages are    ;
;                     being reallocated.  Logical pages which were originally ;
;                     allocated with the alloc_pages or alloc_std_pages       ;
;                     function are called pages and are 16K bytes long.       ;
;                     Logical pages which were allocated with the             ;
;                     alloc_raw_pages function are called raw pages and might ;
;                     not be the same size as pages allocated with the        ;
;                     alloc_pages or alloc_std_pages functions.               ;
;                                                                             ;
;           PASSED:   &pages:                                                 ;
;                        is a far pointer to the total number of pages this   ;
;                        handle should have allocated to it after this        ;
;                        function is invoked.                                 ;
;                                                                             ;
;                     handle:                                                 ;
;                        is an open EMM handle.                               ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     pages:                                                  ;
;                        is the number of pages now allocated to the EMM      ;
;                        handle after the pages have been added or            ;
;                        subtracted.  If the status returned is not zero,     ;
;                        pages is equal to the number of pages allocated to   ;
;                        the handle prior to the invocation of this function. ;
;                        This information can be used to verify that the      ;
;                        request generated the expected results.              ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int pages;                                     ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = realloc_pages (&pages,                         ;
;                                             handle);                        ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

realloc_pages		PROC                                                  \
			ptr_pages:FAR PTR WORD,                                   \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   reallocate the number of pages currently allocated to the     ;
	;   .   specified handle;                                             ;
	;---------------------------------------------------------------------;
	MOVE		AH, realloc_fcn
	MOVE		DX, handle
	MOVE		ES:BX, ptr_pages
	MOVE		BX, ES:[BX]
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   pass the number of pages now allocated to the handle back to  ;
	;   .   the caller;                                                   ;
	;---------------------------------------------------------------------;
	MOVE		DX, BX
	MOVE		ES:BX, ptr_pages
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

realloc_pages		ENDP

END
