;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM16_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   set_partial_context                                     ;
;                                                                             ;
;      DESCRIPTION:   This function provides a mechanism for restoring the    ;
;                     mapping context for specific mappable memory regions    ;
;                     in a system.  Because this function restores only a     ;
;                     subset of the mapping context (not the entire system's  ;
;                     mapping context), it uses much less memory for the save ;
;                     structure and is potentially faster than set_context.   ;
;                     The function copies the contents of the source          ;
;                     structure to selected mapping hardware on each          ;
;                     expanded memory board.  The application passes a        ;
;                     far pointer to the source structure.                    ;
;                                                                             ;
;                     Use this function instead of save_context &             ;
;                     restore_context if you need to save or restore the      ;
;                     mapping context but don't want to (or have to) use a    ;
;                     handle.                                                 ;
;                                                                             ;
;           PASSED:   &source_context:                                        ;
;                        is a far pointer to the source structure of the      ;
;                        mapping context to be restored.                      ;
;                        The structure member is described here:              ;
;                                                                             ;
;                        source_context.reserved:                             ;
;                           is a character array which is reserved for use by ;
;                           the memory manager.  In this instance it contains ;
;                           the data for the mapping hardware state.          ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int   status;                                  ;
;                     CONTEXT_STRUCT source_context;                          ;
;                                                                             ;
;                     status = set_partial_context (&source_context);         ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

set_partial_context	PROC                                                  \
			USES DS SI,                                           \
			ptr_context:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   set the partial mapping context from the app to EMM;          ;
	;---------------------------------------------------------------------;
	MOVE		AX, set_partial_page_map_fcn
	MOVE		DS:SI, ptr_context
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

set_partial_context	ENDP

END
