;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM15_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_context                                             ;
;                                                                             ;
;      DESCRIPTION:   This function saves the mapping context for all         ;
;                     mappable memory regions (conventional and expanded) by  ;
;                     copying the contents of the mapping hardware from each  ;
;                     expanded memory board to a destination structure.  The  ;
;                     application must pass a pointer to the destination      ;
;                     structure.  This function doesn't require an EMM        ;
;                     handle.                                                 ;
;                                                                             ;
;                     Use this function instead of save_context &             ;
;                     restore_context if you need to save or restore the      ;
;                     mapping context but don't want to (or have to) use a    ;
;                     handle.                                                 ;
;                                                                             ;
;           PASSED:   &dest_context:                                          ;
;                        is a far pointer to the destination structure of the ;
;                        mapping context to be saved.                         ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     dest_context:                                           ;
;                        is a structure containing the state of all the       ;
;                        mapping hardware on all boards in the system.  It    ;
;                        also contains any additional information necessary   ;
;                        to restore the boards to their original state when   ;
;                        the program invokes a set_context or get_set_context ;
;                        function.                                            ;
;                        The structure member is described here:              ;
;                                                                             ;
;                        dest_context.reserved:                               ;
;                           is a character array that is used to store the    ;
;                           state.                                            ;
;                                                                             ;
; C USE CONVENTION:   unsigned int   status;                                  ;
;                     CONTEXT_STRUCT dest_context;                            ;
;                                                                             ;
;                     status = get_context (&dest_context);                   ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_context		PROC                                                  \
			USES DI,                                              \
			ptr_dest_context:FAR PTR BYTE

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get the current memory mapping context from EMM;              ;
	;---------------------------------------------------------------------;
	MOVE		AX, get_page_map_fcn
	MOVE		ES:DI, ptr_dest_context
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_context		ENDP

END
