;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM03_B.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   get_alloc_page_count                                    ;
;                                                                             ;
;      DESCRIPTION:   This function returns the number of allocated           ;
;                     expanded memory pages.                                  ;
;                                                                             ;
;           PASSED:   &alloc_page_count:                                      ;
;                        is a far pointer to the allocated page count.        ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
;                     alloc_page_count:                                       ;
;                        is the number of expanded memory pages currently     ;
;                        unavailable (allocated).                             ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int alloc_page_count;                          ;
;                                                                             ;
;                     status = get_alloc_page_count (&alloc_page_count);      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

get_alloc_page_count	PROC                                                  \
			ptr_alloc_page_count:FAR PTR WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   get total & unallocated page counts from EMM;                 ;
	;---------------------------------------------------------------------;
	MOVE		AH, get_unalloc_page_cnt_fcn
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   allocated page count = total pages - unallocated pages;       ;
	;   .   pass allocated page count back to the caller;                 ;
	;---------------------------------------------------------------------;
	SUB		DX, BX
	MOVE		ES:BX, ptr_alloc_page_count
	MOVE		ES:[BX], DX

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

get_alloc_page_count	ENDP

PAGE
END
