;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM09_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   restore_context                                         ;
;                                                                             ;
;      DESCRIPTION:   This function restores the mapping context of the       ;
;                     LIM 3.X page frame.  This function restores the mapping ;
;                     context of the four 16K pages defined by the page frame ;
;                     after a call to save_context.  (The caller MUST have    ;
;                     previously allocated a handle and saved a context in    ;
;                     order to restore this context from within EMM.          ;
;                                                                             ;
;                     restore_context restores the page mapping hardware      ;
;                     contents on the expanded memory boards for a particular ;
;                     EMM handle.  This function lets your program restore    ;
;                     the contents of the mapping hardware its EMM handle     ;
;                     saved. (See save_context for the save operation.)       ;
;                                                                             ;
;                     If you're writing a resident program, an interrupt      ;
;                     service routine, or a device driver that uses expanded  ;
;                     memory, you must restore the mapping hardware to the    ;
;                     state it was in before your program took over.  You     ;
;                     must save this state because application software using ;
;                     expanded memory might have been running when your       ;
;                     program was invoked.                                    ;
;                                                                             ;
;                     The restore_context function requires the EMM handle    ;
;                     that was assigned to your resident program, interrupt   ;
;                     service routine, or device driver at the time it was    ;
;                     initialized.  This is not the EMM handle that the       ;
;                     application software was using when your software       ;
;                     interrupted it.                                         ;
;                                                                             ;
;                     The restore_context function restores the state of the  ;
;                     map hardware for only the 64K-byte page frame defined   ;
;                     in versions 3.x of this specification.  Since all       ;
;                     applications written to LIM versions 3.x require        ;
;                     restoring the map hardware state of only this 64K-byte  ;
;                     page frame, restoring the entire mapping state for a    ;
;                     large number of mappable pages would be inefficient use ;
;                     of memory.  Applications that use a mappable memory     ;
;                     region outside the LIM 3.x page frame should use the    ;
;                     get_context, set_context, get_set_context,              ;
;                     get_partial_context, and set_partial_context functions  ;
;                     to save and restore the state of the map hardware.      ;
;                                                                             ;
;           PASSED:   handle:                                                 ;
;                        is the EMM handle assigned to the interrupt service  ;
;                        routine that's servicing the software or hardware    ;
;                        interrupt.  The interrupt service routine needs to   ;
;                        restore the state of the page mapping hardware.      ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = restore_context (handle);                      ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

restore_context		PROC                                                  \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   restore the LIM 3.X mapping context saved within EMM;         ;
	;---------------------------------------------------------------------;
	MOVE		AH, restore_page_map_fcn
	MOVE		DX, handle
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

restore_context		ENDP

END
