;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM08_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   save_context                                            ;
;                                                                             ;
;      DESCRIPTION:   This function saves the contents of the page mapping    ;
;                     hardware on all expanded memory boards.  (The contents  ;
;                     are saved in a memory manager internal save area.)      ;
;                     The function is typically used to save the memory       ;
;                     mapping context of the EMM handle that was active when  ;
;                     a software or hardware interrupt occurred.  (See        ;
;                     restore_context for the restore operation.)             ;
;                                                                             ;
;                     If you're writing a resident program, an interrupt      ;
;                     service routine, or a device driver that uses expanded  ;
;                     memory, you must save the state of the mapping          ;
;                     hardware.  You must save this state because application ;
;                     software using expanded memory may be running when your ;
;                     program is invoked by a hardware interrupt, a software  ;
;                     interrupt, or DOS.                                      ;
;                                                                             ;
;                     The save_context function requires the EMM handle that  ;
;                     was assigned to your resident program, interrupt        ;
;                     service routine, or device driver at the time it was    ;
;                     initialized.  This is not the EMM handle that the       ;
;                     application software was using when your software       ;
;                     interrupted it.                                         ;
;                                                                             ;
;                     The save_context function saves the state of the map    ;
;                     hardware for only the 64K-byte page frame defined in    ;
;                     versions 3.x of this specification.  Since all          ;
;                     applications written to LIM versions 3.x require saving ;
;                     the map hardware state of only this 64K-byte page       ;
;                     frame, saving the entire mapping state for a large      ;
;                     number of mappable pages would be inefficient use of    ;
;                     memory.  Applications that use a mappable memory region ;
;                     outside the LIM 3.x page frame should use the           ;
;                     get_context, set_context, get_set_context,              ;
;                     get_partial_context, set_partial_context functions to   ;
;                     save and restore the state of the map hardware.         ;
;                                                                             ;
;           PASSED:   handle:                                                 ;
;                        is the EMM handle assigned to the interrupt service  ;
;                        routine that's servicing the software or hardware    ;
;                        interrupt.  The interrupt service routine needs to   ;
;                        save the state of the page mapping hardware before   ;
;                        mapping any pages.                                   ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = save_context (handle);                         ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

save_context		PROC                                                  \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   save the LIM 3.X mapping context within EMM;                  ;
	;---------------------------------------------------------------------;
	MOVE		AH, save_page_map_fcn
	MOVE		DX, handle
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

save_context		ENDP

END
