;-----------------------------------------------------------------------------;
;      MODULE NAME:   EMM05_A.ASM                                             ;
;                                                                             ;
;    FUNCTION NAME:   map_unmap_page                                          ;
;                                                                             ;
;      DESCRIPTION:   This function maps a logical page at a specific         ;
;                     physical page anywhere in the mappable regions of       ;
;                     system memory.    The lowest-valued physical page       ;
;                     numbers are associated with regions of memory outside   ;
;                     the conventional memory range.  Use the                 ;
;                     get_mappable_regions function to determine which        ;
;                     physical pages within a system are mappable, and to     ;
;                     determine which segment addresses correspond to which   ;
;                     specific physical page number.  The get_mappable_region ;
;                     function provides a cross reference between physical    ;
;                     page numbers and segment addresses.                     ;
;                                                                             ;
;                     This function can also unmap physical pages, making     ;
;                     them inaccessible for reading or writing.  You unmap a  ;
;                     physical page by setting its associated logical page to ;
;                     -1.  For example, you might unmap an entire set of      ;
;                     mapped pages before loading and executing a program.    ;
;                     Doing so ensures that if the loaded program accesses    ;
;                     expanded memory, it won't access the pages your program ;
;                     has mapped.  However, you must save the mapping context ;
;                     before you unmap the physical pages.  Saving the        ;
;                     context enables you to restore it later so you can      ;
;                     access the memory you mapped there.  To save the        ;
;                     mapping context, use the save_context, get_context, and ;
;                     get_partial_context functions.  To restore the mapping  ;
;                     context, use the restore_context, set_context,          ;
;                     get_set_context, and set_partial_context_functions.     ;
;                                                                             ;
;                     The handle determines what type of pages are being      ;
;                     mapped.  Logical pages allocated by the alloc_pages and ;
;                     alloc_std_pages functions are referred to as pages and  ;
;                     are 16K bytes long.  Logical pages allocated by the     ;
;                     alloc_raw_pages function are referred to as raw pages   ;
;                     and might not be the same size as logical pages.        ;
;                                                                             ;
;           PASSED:   phys_page:                                              ;
;                        is the number of the physical page into which the    ;
;                        logical page number is to be mapped.  Physical pages ;
;                        are numbered relative to zero.                       ;
;                                                                             ;
;                     log_page:                                               ;
;                        is the number of the logical page to be mapped at    ;
;                        the physical page within the page frame.  Logical    ;
;                        pages are numbered relative to zero.  The logical    ;
;                        page must be in the range zero through (number of    ;
;                        pages allocated to the EMM handle - 1).  However,    ;
;                        if log_page is -1, the physical page specified by    ;
;                        phys_page will be unmapped (be made inaccessible     ;
;                        for reading or writing).                             ;
;                                                                             ;
;                     handle:                                                 ;
;                        is the EMM handle returned by the alloc_pages,       ;
;                        alloc_std_pages, or alloc_raw_pages functions.       ;
;                                                                             ;
;         RETURNED:   status:                                                 ;
;                        is the status EMM returns from the call.  All other  ;
;                        returned results are valid only if the status        ;
;                        returned is zero.  Otherwise they are undefined.     ;
;                                                                             ;
; C USE CONVENTION:   unsigned int status;                                    ;
;                     unsigned int phys_page;                                 ;
;                     unsigned int log_page;                                  ;
;                     unsigned int handle;                                    ;
;                                                                             ;
;                     status = map_unmap_page (phys_page,                     ;
;                                              log_page,                      ;
;                                              handle);                       ;
;-----------------------------------------------------------------------------;
.XLIST
PAGE	60,132

IFDEF SMALL
   .MODEL SMALL, C
ENDIF
IFDEF MEDIUM
   .MODEL MEDIUM, C
ENDIF
IFDEF LARGE
   .MODEL LARGE, C
ENDIF
IFDEF COMPACT
   .MODEL COMPACT, C
ENDIF
IFDEF HUGE
   .MODEL HUGE, C
ENDIF

INCLUDE emmlib.equ
INCLUDE emmlib.str
INCLUDE emmlib.mac
.LIST
.CODE

map_unmap_page		PROC                                                  \
			phys_page:BYTE,                                       \
			log_page:WORD,                                        \
			handle:WORD

	;---------------------------------------------------------------------;
	;   do;                                                               ;
	;   .   map a logical page owned by a handle at a physical page;      ;
	;---------------------------------------------------------------------;
	MOVE		AH, map_page_fcn
	MOVE		AL, phys_page
	MOVE		BX, log_page
	MOVE		DX, handle
	INT     	EMM_int

	;---------------------------------------------------------------------;
	;   .   return (EMM status);                                          ;
	;   end;                                                              ;
	;---------------------------------------------------------------------;
	RET_EMM_STAT	AH

map_unmap_page		ENDP

END
